/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CDgui;
import culturalDynamics.CommonData;
import culturalDynamics.Connection;
import culturalDynamics.ConnectionData;
import culturalDynamics.Event;
import culturalDynamics.EventData;
import culturalDynamics.Filter;
import culturalDynamics.FilterEditor;
import culturalDynamics.SavedFilterData;
import culturalDynamics.Segment;
import culturalDynamics.SegmentList;
import culturalDynamics.Utils;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileNameExtensionFilter;

class ReportSummary
extends JFrame {
    private static final long serialVersionUID = 1L;
    private CDgui ourGUI;
    private JFrame summaryFrame;
    private String buffer;
    private String head = "<html><head><meta charset=\"UTF-8\">\n<title>Cultural Dynamics Summary Report</title>";
    private String body = "<body style=\"font-size:10pt;\">";
    private String headerIntroduction = "Introduction";
    private String headerUntimed = "Untimed Events";
    private String headerTimelines = "Timelines";
    private String headerEvents = "Events";
    private String headerConnections = "Connections";
    private String headerFilters = "Saved Filters";
    private String headerStatistics = "Statistics";
    private FlowLayout flowLayoutCenter = new FlowLayout(1);
    private int numUntimed = 0;
    private int numTimelines = 0;
    private int numEvents = 0;
    private int numConnections = 0;
    private JButton exportButton = new JButton("Export");
    private String exportButtonTip = "Export report to an html file.";
    private JButton printButton = new JButton("Print");
    private String printButtonTip = "Print the summary report. Note the number of pages is not available in the print dialog.";
    private JButton closeButton = new JButton("Close");
    private String closeButtonTip = "Close the summary.";
    private String currentExportDir = "";
    private BufferedWriter outBuffer = null;
    private String newOverwriteDialog = "New output file already exists. Do you want to overwrite it?";

    ReportSummary(CDgui mainGUI) {
        this.ourGUI = mainGUI;
        this.summaryFrame = this;
        this.summaryFrame.setTitle("Summary Report of " + this.ourGUI.getOpenFile());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                ReportSummary.this.ourGUI.getWindowManager().closeWindow();
            }
        });
        this.buffer = this.getSummaryHTML();
        final JEditorPane htmlPane = new JEditorPane("text/html", this.buffer);
        htmlPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hle) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                    String ref = hle.getDescription();
                    if (ref != null && ref.startsWith("#")) {
                        ref = ref.substring(1);
                        htmlPane.scrollToReference(ref);
                    } else {
                        try {
                            Desktop desktop = Desktop.getDesktop();
                            desktop.browse(hle.getURL().toURI());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        });
        JScrollPane summaryScrollPane = new JScrollPane(htmlPane);
        htmlPane.setCaretPosition(0);
        htmlPane.setEditable(false);
        JPanel buttonPanel = new JPanel(this.flowLayoutCenter);
        this.printButton.setToolTipText(this.printButtonTip);
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent print) {
                try {
                    htmlPane.print(null, new MessageFormat("Page - {0}"));
                }
                catch (PrinterException e) {
                    e.printStackTrace();
                }
            }
        });
        this.exportButton.setToolTipText(this.exportButtonTip);
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int newOverwriteSelection;
                if (ReportSummary.this.currentExportDir == "") {
                    ReportSummary.this.currentExportDir = System.getProperty("user.home");
                }
                JFileChooser expChooser = new JFileChooser(ReportSummary.this.currentExportDir);
                expChooser.setDialogTitle("Save Report to HTML File");
                expChooser.setMultiSelectionEnabled(false);
                expChooser.setFileSelectionMode(2);
                FileNameExtensionFilter filter = new FileNameExtensionFilter("HTML files", "htm", "html");
                expChooser.setFileFilter(filter);
                expChooser.setFileHidingEnabled(true);
                int expChoice = expChooser.showSaveDialog(ReportSummary.this.ourGUI);
                if (expChoice != 0) {
                    return;
                }
                File saveFile = expChooser.getSelectedFile();
                ReportSummary.this.currentExportDir = saveFile.getParent();
                if (saveFile.exists() && (newOverwriteSelection = JOptionPane.showConfirmDialog(ReportSummary.this.ourGUI, ReportSummary.this.newOverwriteDialog, "That File Already Exists - overwrite it?", 0, 3)) == 1) {
                    return;
                }
                try {
                    saveFile.createNewFile();
                    String path = saveFile.getAbsolutePath();
                    BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), StandardCharsets.UTF_8));
                    ReportSummary.this.outBuffer = new BufferedWriter(outWriter);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(ReportSummary.this.ourGUI, "Output File: IO Exception opening file for write" + ex.getMessage());
                    return;
                }
                try {
                    ReportSummary.this.outBuffer.write(ReportSummary.this.buffer);
                    ReportSummary.this.outBuffer.flush();
                    ReportSummary.this.outBuffer.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.closeButton.setToolTipText(this.closeButtonTip);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent close) {
                ReportSummary.this.ourGUI.getWindowManager().closeWindow();
                ReportSummary.this.summaryFrame.dispose();
            }
        });
        Box overallPanel = Box.createVerticalBox();
        buttonPanel.add(this.exportButton);
        buttonPanel.add(this.printButton);
        buttonPanel.add(this.closeButton);
        overallPanel.add(summaryScrollPane);
        overallPanel.add(buttonPanel);
        this.add(overallPanel);
        this.setVisible(true);
        this.setSize(600, 600);
    }

    public String getSummaryHTML() {
        Object htmlBuffer = "";
        htmlBuffer = (String)htmlBuffer + this.head;
        htmlBuffer = (String)htmlBuffer + Utils.getHTMLstyles();
        htmlBuffer = (String)htmlBuffer + "</head>";
        htmlBuffer = (String)htmlBuffer + this.body;
        String tmpTimestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + " with " + this.ourGUI.getProgramName() + " version " + this.ourGUI.getProgramVersion();
        htmlBuffer = (String)htmlBuffer + Utils.makeH1("Summary Report");
        htmlBuffer = (String)htmlBuffer + "For file " + this.ourGUI.getOpenFile() + "<br>";
        htmlBuffer = (String)htmlBuffer + "File written at " + tmpTimestamp + "<br>";
        String currentFilter = "";
        if (this.ourGUI.getPreferences().getSummaryFilter()) {
            currentFilter = this.ourGUI.getFilterEditor().getActiveFilter().getName();
        }
        htmlBuffer = (String)htmlBuffer + "Settings: Introduction: " + Utils.makeHTMLCheckbox(this.ourGUI.getPreferences().getSummaryIntro()) + " Description: " + Utils.makeHTMLCheckbox(this.ourGUI.getPreferences().getSummaryDescription()) + " Untimed Events: " + Utils.makeHTMLCheckbox(this.ourGUI.getPreferences().getSummaryUntimed()) + " Links: " + Utils.makeHTMLCheckbox(this.ourGUI.getPreferences().getSummaryLinks()) + " Tags: " + Utils.makeHTMLCheckbox(this.ourGUI.getPreferences().getSummaryTags()) + " Icons: " + Utils.makeHTMLCheckbox(this.ourGUI.getPreferences().getSummaryIcons()) + " Timeline Event List: " + Utils.makeHTMLCheckbox(this.ourGUI.getPreferences().getSummaryTlEventList()) + " Connections: " + Utils.makeHTMLCheckbox(this.ourGUI.getPreferences().getSummaryConnections()) + " Statistics: " + Utils.makeHTMLCheckbox(this.ourGUI.getPreferences().getSummaryStats()) + " Omit Emtpy Titles: " + Utils.makeHTMLCheckbox(this.ourGUI.getPreferences().getSummaryOmitEmpty()) + " Apply Filter: " + Utils.makeHTMLCheckbox(this.ourGUI.getPreferences().getSummaryFilter()) + " " + currentFilter + "<br>";
        EventData allEvents = this.ourGUI.getInput().getEventData();
        List<Event> untimedList = allEvents.getListOfShownUntimedEvents(true);
        htmlBuffer = (String)htmlBuffer + Utils.makeH2("Contents");
        if (this.ourGUI.getPreferences().getSummaryIntro() && (!this.ourGUI.getIntroText().equals("") || this.ourGUI.getIntroText().equals("") && !this.ourGUI.getPreferences().getSummaryOmitEmpty())) {
            htmlBuffer = (String)htmlBuffer + Utils.makeIntLink("toc_" + Utils.noSpace(this.headerIntroduction), this.headerIntroduction) + "<br>\n";
        }
        if (untimedList.size() != 0) {
            htmlBuffer = (String)htmlBuffer + Utils.makeIntLink("toc_" + Utils.noSpace(this.headerUntimed), this.headerUntimed) + "<br>\n";
        }
        htmlBuffer = (String)htmlBuffer + Utils.makeIntLink("toc_" + Utils.noSpace(this.headerTimelines), this.headerTimelines) + "<br>\n";
        htmlBuffer = (String)htmlBuffer + Utils.makeIntLink("toc_" + Utils.noSpace(this.headerEvents), this.headerEvents) + "<br>\n";
        htmlBuffer = (String)htmlBuffer + Utils.makeIntLink("toc_" + Utils.noSpace(this.headerConnections), this.headerConnections) + "<br>\n";
        htmlBuffer = (String)htmlBuffer + Utils.makeIntLink("toc_" + Utils.noSpace(this.headerFilters), this.headerFilters) + "<br>\n";
        htmlBuffer = (String)htmlBuffer + Utils.makeIntLink("toc_" + Utils.noSpace(this.headerStatistics), this.headerStatistics) + "<br>\n";
        if (this.ourGUI.getPreferences().getSummaryIntro() && (!this.ourGUI.getIntroText().equals("") || this.ourGUI.getIntroText().equals("") && !this.ourGUI.getPreferences().getSummaryOmitEmpty())) {
            htmlBuffer = (String)htmlBuffer + Utils.makeH2("Introduction");
            String tmp = Utils.decodeEscapes(this.ourGUI.getIntroText());
            tmp = tmp.replace("\n", "<br>");
            htmlBuffer = (String)htmlBuffer + tmp;
        }
        if (untimedList.size() != 0) {
            htmlBuffer = (String)htmlBuffer + Utils.makeH2("Untimed Events");
            EventData.sortEventsBySequence(untimedList);
            this.numUntimed = untimedList.size();
            int i = 0;
            while (i < untimedList.size()) {
                Event ourEv = untimedList.get(i);
                if (ourEv.isShown() || !this.ourGUI.getPreferences().getSummaryFilter()) {
                    htmlBuffer = (String)htmlBuffer + Utils.makeH3("Untimed: " + Utils.makeAnchor("ev_", ourEv.getName()));
                    if (this.ourGUI.getPreferences().getSummaryDescription() && (!ourEv.getDescription().equals("") || ourEv.getDescription().equals("") && !this.ourGUI.getPreferences().getSummaryOmitEmpty())) {
                        String tmp = Utils.decodeEscapes(ourEv.getDescription());
                        tmp = tmp.replace("\n", "<br>");
                        htmlBuffer = (String)htmlBuffer + Utils.makeH4("Description");
                        htmlBuffer = (String)htmlBuffer + Utils.makeP(tmp);
                    }
                    if (this.ourGUI.getPreferences().getSummaryLinks() && (ourEv.getLinks().size() != 0 || ourEv.getLinks().size() == 0 && !this.ourGUI.getPreferences().getSummaryOmitEmpty())) {
                        htmlBuffer = (String)htmlBuffer + Utils.makeH4("Links");
                        int j = 0;
                        while (j < ourEv.getLinks().size()) {
                            htmlBuffer = (String)htmlBuffer + Utils.makeP("Text: " + ourEv.getLinks().get(j).getText());
                            htmlBuffer = (String)htmlBuffer + Utils.makeP("URL:" + Utils.makeExtLink(ourEv.getLinks().get(j).getURL(), ourEv.getLinks().get(j).getURL()));
                            ++j;
                        }
                    }
                    if (this.ourGUI.getPreferences().getSummaryTags() && (ourEv.getTags().getSize() != 0 || ourEv.getTags().getSize() == 0 && !this.ourGUI.getPreferences().getSummaryOmitEmpty())) {
                        htmlBuffer = (String)htmlBuffer + Utils.makeH4("Tags");
                        String[] tagsArray = ourEv.getTags().getTagsAsArray();
                        Object tmp = "";
                        int j = 0;
                        while (j < tagsArray.length) {
                            tmp = (String)tmp + " " + tagsArray[j];
                            ++j;
                        }
                        htmlBuffer = (String)htmlBuffer + Utils.makeP((String)tmp);
                    }
                    if (this.ourGUI.getPreferences().getSummaryConnections()) {
                        Connection ourCn;
                        int k;
                        ConnectionData connections = this.ourGUI.getInput().getConnections();
                        int numConnections = 0;
                        if (this.ourGUI.getPreferences().getSummaryOmitEmpty()) {
                            k = 0;
                            while (k < connections.getNumberOfConnections()) {
                                ourCn = connections.getConnection(k);
                                if (ourCn.getDestEvent().getName().equals(ourEv.getName()) || ourCn.getSourceEvent().getName().equals(ourEv.getName())) {
                                    ++numConnections;
                                }
                                ++k;
                            }
                        }
                        if (!this.ourGUI.getPreferences().getSummaryOmitEmpty() || numConnections != 0) {
                            htmlBuffer = (String)htmlBuffer + Utils.makeH4("Connections");
                            connections.sortConnectionsByName();
                            k = 0;
                            while (k < connections.getNumberOfConnections()) {
                                ourCn = connections.getConnection(k);
                                if (ourCn.getSourceEvent().equals(ourEv)) {
                                    htmlBuffer = (String)htmlBuffer + this.makeConnectionEntry(ourCn, "To");
                                }
                                if (ourCn.getDestEvent().equals(ourEv)) {
                                    htmlBuffer = (String)htmlBuffer + this.makeConnectionEntry(ourCn, "From");
                                }
                                ++k;
                            }
                        }
                    }
                }
                ++i;
            }
        }
        htmlBuffer = (String)htmlBuffer + Utils.makeH2("Timelines");
        List<Event> timelineList = allEvents.getListOfTimelines(true);
        this.numTimelines = timelineList.size();
        int i = 0;
        while (i < this.numTimelines) {
            Event ourTl = timelineList.get(i);
            if (ourTl.isShown() || !this.ourGUI.getPreferences().getSummaryFilter()) {
                htmlBuffer = (String)htmlBuffer + Utils.makeH3("Timeline: " + Utils.makeAnchor("ev_", ourTl.getName()));
                htmlBuffer = ourTl.getDates().getLateStartDate() == null ? (String)htmlBuffer + Utils.makeP("Start: " + Utils.dayFormatter.format(ourTl.getDates().getEarlyStartDate())) : (String)htmlBuffer + Utils.makeP("Earliest Start: " + Utils.dayFormatter.format(ourTl.getDates().getEarlyStartDate()) + " Latest Start: " + Utils.dayFormatter.format(ourTl.getDates().getLateStartDate()));
                htmlBuffer = ourTl.getDates().getLateEndDate() == null ? (String)htmlBuffer + Utils.makeP("End:" + Utils.dayFormatter.format(ourTl.getDates().getEarlyEndDate())) : (String)htmlBuffer + Utils.makeP("Earliest End: " + Utils.dayFormatter.format(ourTl.getDates().getEarlyEndDate()) + " Latest End: " + Utils.dayFormatter.format(ourTl.getDates().getLateEndDate()));
                if (ourTl.getTlSegmentList() != null) {
                    htmlBuffer = (String)htmlBuffer + Utils.makeH3("Segments: ");
                    SegmentList ourSegs = ourTl.getTlSegmentList();
                    int j = 0;
                    while (j < ourSegs.getNumberOfSegments()) {
                        Segment seg = ourSegs.getASegment(j);
                        htmlBuffer = (String)htmlBuffer + Utils.makeP(seg.getText());
                        htmlBuffer = seg.getDates().getLateStartDate() == null ? (String)htmlBuffer + Utils.makePindent("Start: " + Utils.dayFormatter.format(seg.getDates().getEarlyStartDate())) : (String)htmlBuffer + Utils.makePindent("Earliest Start: " + Utils.dayFormatter.format(seg.getDates().getEarlyStartDate()) + " Latest Start: " + Utils.dayFormatter.format(seg.getDates().getLateStartDate()));
                        htmlBuffer = seg.getDates().getLateEndDate() == null ? (String)htmlBuffer + Utils.makePindent("End:" + Utils.dayFormatter.format(seg.getDates().getEarlyEndDate())) : (String)htmlBuffer + Utils.makePindent("Earliest End: " + Utils.dayFormatter.format(seg.getDates().getEarlyEndDate()) + " Latest End: " + Utils.dayFormatter.format(seg.getDates().getLateEndDate()));
                        ++j;
                    }
                }
                if (this.ourGUI.getPreferences().getSummaryDescription() && (!ourTl.getDescription().equals("") || ourTl.getDescription().equals("") && !this.ourGUI.getPreferences().getSummaryOmitEmpty())) {
                    String tmp = Utils.decodeEscapes(ourTl.getDescription());
                    tmp = tmp.replace("\n", "<br>");
                    htmlBuffer = (String)htmlBuffer + Utils.makeH4("Description");
                    htmlBuffer = (String)htmlBuffer + Utils.makeP(tmp);
                }
                if (this.ourGUI.getPreferences().getSummaryLinks() && (ourTl.getLinks().size() != 0 || ourTl.getLinks().size() == 0 && !this.ourGUI.getPreferences().getSummaryOmitEmpty())) {
                    htmlBuffer = (String)htmlBuffer + Utils.makeH4("Links");
                    int j = 0;
                    while (j < ourTl.getLinks().size()) {
                        htmlBuffer = (String)htmlBuffer + Utils.makeP("Text: " + ourTl.getLinks().get(j).getText());
                        htmlBuffer = (String)htmlBuffer + Utils.makeP("URL:" + Utils.makeExtLink(ourTl.getLinks().get(j).getURL(), ourTl.getLinks().get(j).getURL()));
                        ++j;
                    }
                }
                if (this.ourGUI.getPreferences().getSummaryIcons() && (ourTl.getIcon() != null || ourTl.getEndIcon() != null) || ourTl.getIcon() == null && ourTl.getEndIcon() == null && !this.ourGUI.getPreferences().getSummaryOmitEmpty()) {
                    htmlBuffer = (String)htmlBuffer + Utils.makeH4("Icons");
                    if (ourTl.getIcon() != null) {
                        htmlBuffer = (String)htmlBuffer + Utils.makeP("Start: " + ourTl.getIcon().getDescription());
                    }
                    if (ourTl.getEndIcon() != null) {
                        htmlBuffer = (String)htmlBuffer + Utils.makeP("End: " + ourTl.getEndIcon().getDescription());
                    }
                }
                if (this.ourGUI.getPreferences().getSummaryTags() && (ourTl.getTags().getSize() != 0 || ourTl.getTags().getSize() == 0 && !this.ourGUI.getPreferences().getSummaryOmitEmpty())) {
                    htmlBuffer = (String)htmlBuffer + Utils.makeH4("Tags");
                    String[] tagsArray = ourTl.getTags().getTagsAsArray();
                    Object tmp = "";
                    int j = 0;
                    while (j < tagsArray.length) {
                        tmp = (String)tmp + " " + tagsArray[j];
                        ++j;
                    }
                    htmlBuffer = (String)htmlBuffer + Utils.makeP((String)tmp);
                }
                if (this.ourGUI.getPreferences().getSummaryTlEventList() && (!this.ourGUI.getPreferences().getSummaryOmitEmpty() || ourTl.getTlEventList() != null && ourTl.getTlEventList().getNumberOfEventsOnly() != 0)) {
                    htmlBuffer = (String)htmlBuffer + Utils.makeH4("Timeline Events");
                    if (ourTl.getTlEventList() != null) {
                        int j = 0;
                        while (j < ourTl.getTlEventList().getNumberOfEventsOnly()) {
                            Event ourEv = ourTl.getTlEventList().getEventByIndex(j);
                            String dstName = ourEv.getName();
                            String dstTarget = "ev_" + Utils.noSpace(dstName);
                            htmlBuffer = (String)htmlBuffer + Utils.makeP(Utils.makeIntLink(dstTarget, dstName));
                            ++j;
                        }
                    }
                }
                if (this.ourGUI.getPreferences().getSummaryConnections()) {
                    Connection ourCn;
                    ConnectionData connections = this.ourGUI.getInput().getConnections();
                    int numConnections = 0;
                    if (this.ourGUI.getPreferences().getSummaryOmitEmpty()) {
                        int j = 0;
                        while (j < connections.getNumberOfConnections()) {
                            ourCn = connections.getConnection(j);
                            if (ourCn.getDestEvent().getName().equals(ourTl.getName()) || ourCn.getSourceEvent().getName().equals(ourTl.getName())) {
                                ++numConnections;
                            }
                            ++j;
                        }
                    }
                    if (!this.ourGUI.getPreferences().getSummaryOmitEmpty() || numConnections != 0) {
                        htmlBuffer = (String)htmlBuffer + Utils.makeH4("Connections");
                        connections.sortConnectionsByName();
                        int j = 0;
                        while (j < connections.getNumberOfConnections()) {
                            ourCn = connections.getConnection(j);
                            if (ourCn.getSourceEvent().equals(ourTl)) {
                                htmlBuffer = (String)htmlBuffer + this.makeConnectionEntry(ourCn, "To");
                            }
                            if (ourCn.getDestEvent().equals(ourTl)) {
                                htmlBuffer = (String)htmlBuffer + this.makeConnectionEntry(ourCn, "From");
                            }
                            ++j;
                        }
                    }
                }
            }
            ++i;
        }
        htmlBuffer = (String)htmlBuffer + Utils.makeH2("Events");
        List<Event> eventsList = allEvents.getListOfEventsOnly(true);
        this.numEvents = eventsList.size();
        int i2 = 0;
        while (i2 < this.numEvents) {
            Event ourEv = eventsList.get(i2);
            if (ourEv.isShown() || !this.ourGUI.getPreferences().getSummaryFilter()) {
                Object parentTimeline = "";
                if (ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE_EVENT)) {
                    String srcName = ourEv.getEventTimeline().getName();
                    String srcTarget = "ev_" + srcName;
                    parentTimeline = " in Timeline  " + Utils.makeIntLink(Utils.noSpace(srcTarget), srcName);
                }
                htmlBuffer = (String)htmlBuffer + Utils.makeH3(ourEv.getEventTypeAsName() + ": " + Utils.makeAnchor("ev_", ourEv.getName())) + (String)parentTimeline;
                htmlBuffer = ourEv.getDates().getLateStartDate() == null ? (String)htmlBuffer + Utils.makeP("Start: " + Utils.dayFormatter.format(ourEv.getDates().getEarlyStartDate())) : (String)htmlBuffer + Utils.makeP("Earliest Start: " + Utils.dayFormatter.format(ourEv.getDates().getEarlyStartDate()) + " Latest Start: " + Utils.dayFormatter.format(ourEv.getDates().getLateStartDate()));
                if (ourEv.getDates().getEarlyEndDate() != null) {
                    htmlBuffer = ourEv.getDates().getLateEndDate() == null ? (String)htmlBuffer + Utils.makeP("End:" + Utils.dayFormatter.format(ourEv.getDates().getEarlyEndDate())) : (String)htmlBuffer + Utils.makeP("Earliest End: " + Utils.dayFormatter.format(ourEv.getDates().getEarlyEndDate()) + " Latest End: " + Utils.dayFormatter.format(ourEv.getDates().getLateEndDate()));
                }
                if (this.ourGUI.getPreferences().getSummaryIcons() && (ourEv.getIcon() != null || ourEv.getIcon() == null && !this.ourGUI.getPreferences().getSummaryOmitEmpty())) {
                    htmlBuffer = (String)htmlBuffer + Utils.makeH4("Icon");
                    if (ourEv.getIcon() != null) {
                        htmlBuffer = (String)htmlBuffer + Utils.makeP("Start: " + ourEv.getIcon().getDescription());
                    }
                }
                if (this.ourGUI.getPreferences().getSummaryTags() && (ourEv.getTags().getSize() != 0 || ourEv.getTags().getSize() == 0 && !this.ourGUI.getPreferences().getSummaryOmitEmpty())) {
                    htmlBuffer = (String)htmlBuffer + Utils.makeH4("Tags");
                    String[] tagsArray = ourEv.getTags().getTagsAsArray();
                    Object tmp = "";
                    int j = 0;
                    while (j < tagsArray.length) {
                        tmp = (String)tmp + " " + tagsArray[j];
                        ++j;
                    }
                    htmlBuffer = (String)htmlBuffer + Utils.makeP((String)tmp);
                }
                if (this.ourGUI.getPreferences().getSummaryDescription() && (!ourEv.getDescription().equals("") || ourEv.getDescription().equals("") && !this.ourGUI.getPreferences().getSummaryOmitEmpty())) {
                    String tmp = Utils.decodeEscapes(ourEv.getDescription());
                    tmp = tmp.replace("\n", "<br>");
                    htmlBuffer = (String)htmlBuffer + Utils.makeH4("Description");
                    htmlBuffer = (String)htmlBuffer + Utils.makeP(tmp);
                }
                if (this.ourGUI.getPreferences().getSummaryLinks() && (ourEv.getLinks().size() != 0 || ourEv.getLinks().size() == 0 && !this.ourGUI.getPreferences().getSummaryOmitEmpty())) {
                    htmlBuffer = (String)htmlBuffer + Utils.makeH4("Links");
                    int j = 0;
                    while (j < ourEv.getLinks().size()) {
                        htmlBuffer = (String)htmlBuffer + Utils.makeP("Text: " + ourEv.getLinks().get(j).getText());
                        htmlBuffer = (String)htmlBuffer + Utils.makeP("URL: " + Utils.makeExtLink(ourEv.getLinks().get(j).getURL(), ourEv.getLinks().get(j).getURL()));
                        ++j;
                    }
                }
                if (this.ourGUI.getPreferences().getSummaryConnections()) {
                    Connection ourCn;
                    int k;
                    ConnectionData connections = this.ourGUI.getInput().getConnections();
                    int numConnections = 0;
                    if (this.ourGUI.getPreferences().getSummaryOmitEmpty()) {
                        k = 0;
                        while (k < connections.getNumberOfConnections()) {
                            ourCn = connections.getConnection(k);
                            if (ourCn.getDestEvent().getName().equals(ourEv.getName()) || ourCn.getSourceEvent().getName().equals(ourEv.getName())) {
                                ++numConnections;
                            }
                            ++k;
                        }
                    }
                    if (!this.ourGUI.getPreferences().getSummaryOmitEmpty() || numConnections != 0) {
                        htmlBuffer = (String)htmlBuffer + Utils.makeH4("Connections");
                        connections.sortConnectionsByName();
                        k = 0;
                        while (k < connections.getNumberOfConnections()) {
                            ourCn = connections.getConnection(k);
                            if (ourCn.getSourceEvent().equals(ourEv)) {
                                htmlBuffer = (String)htmlBuffer + this.makeConnectionEntry(ourCn, "To");
                            }
                            if (ourCn.getDestEvent().equals(ourEv)) {
                                htmlBuffer = (String)htmlBuffer + this.makeConnectionEntry(ourCn, "From");
                            }
                            ++k;
                        }
                    }
                }
            }
            ++i2;
        }
        htmlBuffer = (String)htmlBuffer + Utils.makeH2("Connections");
        ConnectionData connections = this.ourGUI.getInput().getConnections();
        connections.sortConnectionsByID();
        this.numConnections = connections.getNumberOfConnections();
        int i3 = 0;
        while (i3 < this.numConnections) {
            Connection ourCn = connections.getConnection(i3);
            if (ourCn.isShown() || !this.ourGUI.getPreferences().getSummaryFilter()) {
                Object anchor = "cn_";
                anchor = (String)anchor + ourCn.getID();
                htmlBuffer = (String)htmlBuffer + Utils.makeH3("Connection: " + Utils.makeCnAnchor((String)anchor, ourCn.getNiceID()));
                if (ourCn.getName() != "" || !this.ourGUI.getPreferences().getSummaryOmitEmpty()) {
                    htmlBuffer = (String)htmlBuffer + "Name: " + Utils.flatline(ourCn.getName());
                }
                String sourceText = ourCn.getSourceEvent().getEventTypeAsName() + ": " + Utils.makeIntLink("ev_" + ourCn.getSourceEvent().getName().replaceAll("\\s+", ""), ourCn.getSourceEvent().getName());
                htmlBuffer = (String)htmlBuffer + Utils.makeP("From: " + sourceText);
                if (ourCn.getSourceEvent().getEventType().equals((Object)CommonData.EventType.TIMELINE) && ourCn.getSourceTimelinePoint() == 1) {
                    htmlBuffer = ourCn.getDates().getSrcLateDate() == null ? (String)htmlBuffer + Utils.makeP("Date: " + Utils.dayFormatter.format(ourCn.getDates().getSrcEarlyDate())) : (String)htmlBuffer + Utils.makeP("Earliest Start: " + Utils.dayFormatter.format(ourCn.getDates().getSrcEarlyDate()) + " Latest Start: " + Utils.dayFormatter.format(ourCn.getDates().getSrcLateDate()));
                }
                String destinationText = ourCn.getDestEvent().getEventTypeAsName() + ": " + Utils.makeIntLink("ev_" + ourCn.getDestEvent().getName().replaceAll("\\s+", ""), ourCn.getDestEvent().getName());
                htmlBuffer = (String)htmlBuffer + Utils.makeP("To: " + destinationText);
                if (ourCn.getDestEvent().getEventType().equals((Object)CommonData.EventType.TIMELINE) && ourCn.getDestTimelinePoint() == 1) {
                    htmlBuffer = ourCn.getDates().getDstLateDate() == null ? (String)htmlBuffer + Utils.makeP("Date: " + Utils.dayFormatter.format(ourCn.getDates().getDstEarlyDate())) : (String)htmlBuffer + Utils.makeP("Earliest Start: " + Utils.dayFormatter.format(ourCn.getDates().getDstEarlyDate()) + " Latest Start: " + Utils.dayFormatter.format(ourCn.getDates().getDstLateDate()));
                }
                if (this.ourGUI.getPreferences().getSummaryTags() && (ourCn.getTags().getSize() != 0 || ourCn.getTags().getSize() == 0 && !this.ourGUI.getPreferences().getSummaryOmitEmpty())) {
                    htmlBuffer = (String)htmlBuffer + Utils.makeH4("Tags");
                    String[] tagsArray = ourCn.getTags().getTagsAsArray();
                    Object tmp = "";
                    int j = 0;
                    while (j < tagsArray.length) {
                        tmp = (String)tmp + " " + tagsArray[j];
                        ++j;
                    }
                    htmlBuffer = (String)htmlBuffer + Utils.makeP((String)tmp);
                }
                if (this.ourGUI.getPreferences().getSummaryDescription() && (!ourCn.getDescription().equals("") || ourCn.getDescription().equals("") && !this.ourGUI.getPreferences().getSummaryOmitEmpty())) {
                    String tmp = Utils.decodeEscapes(ourCn.getDescription());
                    tmp = tmp.replace("\n", "<br>");
                    htmlBuffer = (String)htmlBuffer + Utils.makeH4("Description");
                    htmlBuffer = (String)htmlBuffer + Utils.makeP(tmp);
                }
                if (this.ourGUI.getPreferences().getSummaryLinks() && (ourCn.getLinks().size() != 0 || ourCn.getLinks().size() == 0 && !this.ourGUI.getPreferences().getSummaryOmitEmpty())) {
                    htmlBuffer = (String)htmlBuffer + Utils.makeH4("Links");
                    int j = 0;
                    while (j < ourCn.getLinks().size()) {
                        htmlBuffer = (String)htmlBuffer + Utils.makeP("Text: " + ourCn.getLinks().get(j).getText());
                        htmlBuffer = (String)htmlBuffer + Utils.makeP("URL: " + Utils.makeExtLink(ourCn.getLinks().get(j).getURL(), ourCn.getLinks().get(j).getURL()));
                        ++j;
                    }
                }
            }
            ++i3;
        }
        SavedFilterData ourFilters = this.ourGUI.getSavedFilterData();
        htmlBuffer = (String)htmlBuffer + Utils.makeH2(this.headerFilters);
        int i4 = 0;
        while (i4 < ourFilters.getNumFilters()) {
            Filter filter = ourFilters.getSavedFilterByIndex(i4);
            String name = filter.getName();
            htmlBuffer = (String)htmlBuffer + Utils.makeH3(Utils.makeAnchor("fil_", name));
            int j = 0;
            while (j < filter.getNumFilterStages()) {
                String logic = String.valueOf((Object)filter.getLogic(j));
                if (logic == "NOP") {
                    logic = "";
                }
                FilterEditor.Operation op = filter.getOperation(j);
                htmlBuffer = (String)htmlBuffer + " " + logic + " " + String.valueOf((Object)op);
                String[] tagsArray = filter.getFilterStageSaved(j).getTags().getTagsAsArray();
                int k = 0;
                while (k < tagsArray.length) {
                    htmlBuffer = (String)htmlBuffer + " " + Utils.makeIntLink("tag_" + tagsArray[k], tagsArray[k]);
                    ++k;
                }
                ++j;
            }
            ++i4;
        }
        if (this.ourGUI.getPreferences().getSummaryStats()) {
            htmlBuffer = (String)htmlBuffer + Utils.makeH2("Statistics");
            if (this.ourGUI.getPreferences().getSummaryFilter()) {
                htmlBuffer = (String)htmlBuffer + "Note: numbers are unfiltered.<br>\n";
            }
            htmlBuffer = (String)htmlBuffer + this.numUntimed + " untimed events.<br>\n";
            htmlBuffer = (String)htmlBuffer + this.numTimelines + " timelines.<br>\n";
            htmlBuffer = (String)htmlBuffer + this.numEvents + " events.<br>\n";
            htmlBuffer = (String)htmlBuffer + connections.getNumberOfConnections() + " connections.<br>\n";
            htmlBuffer = (String)htmlBuffer + ourFilters.getNumFilters() + " filters.<br>\n";
        }
        htmlBuffer = (String)htmlBuffer + Utils.makeH2("End of Summary Report");
        htmlBuffer = (String)htmlBuffer + "</body></html>";
        return htmlBuffer;
    }

    private String makeConnectionEntry(Connection ourCn, String direction) {
        String srcName = ourCn.getSourceEvent().getName();
        String dstName = ourCn.getDestEvent().getName();
        Object cnName = "";
        Object result = "";
        String cnTarget = "cn_" + ourCn.getID();
        if (!ourCn.getName().equals("") && !ourCn.getName().isEmpty()) {
            cnName = "\"" + Utils.flatline(ourCn.getName()) + "\"";
        }
        switch (direction) {
            case "To": {
                String dstTarget = "ev_" + dstName;
                result = Utils.makeP(Utils.makeIntLink(Utils.noSpace(cnTarget), ourCn.getNiceID()) + (String)cnName + " To " + ourCn.getDestEvent().getEventTypeAsName() + ": " + Utils.makeIntLink(Utils.noSpace(dstTarget), Utils.flatline(dstName)));
                break;
            }
            case "From": {
                String srcTarget = "ev_" + srcName;
                result = Utils.makeP(Utils.makeIntLink(Utils.noSpace(cnTarget), ourCn.getNiceID()) + " From " + ourCn.getSourceEvent().getEventTypeAsName() + ": " + Utils.makeIntLink(Utils.noSpace(srcTarget), Utils.flatline(srcName)));
                break;
            }
            default: {
                result = "*** ReportSummary makeConnectionEntry() called with bad direction: " + direction;
                System.out.println("*** ReportSummary makeConnectionEntry() called with bad direction: " + direction);
            }
        }
        return result;
    }
}

