/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CDgui;
import culturalDynamics.CommonData;
import culturalDynamics.Connection;
import culturalDynamics.ConnectionData;
import culturalDynamics.Event;
import culturalDynamics.EventData;
import culturalDynamics.Palette;
import culturalDynamics.RowData;
import culturalDynamics.Segment;
import culturalDynamics.SegmentList;
import culturalDynamics.Utils;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileNameExtensionFilter;

class ReportMissing
extends JFrame {
    private static final long serialVersionUID = 1L;
    private CDgui ourGUI;
    private JFrame missingFrame;
    private String buffer;
    private String head = "<html><head><meta charset=\"UTF-8\"><title>Cultural Dynamics Missing Meta-Data Report</title>";
    private String styles = "<style type=\"text/css\">\n\tp{margin: 0px 0px 0px 0px; padding: 0px 0px 0px 0px;}\n\t.indent{margin: 0px 0px 0px 30px;}\nh1{margin: 12pt 0px 0px 0px; padding: 0px 0px 0px 0px; font-size:24pt;}\nh2{margin:  9pt 0px 0px 0px; padding: 0px 0px 0px 0px; font-size:18pt;}\nh3{margin:  7pt 0px 0px 0px; padding: 0px 0px 0px 0px; font-size:14pt;}\nh4(margin:  6pt 0px 0px 0px; padding: 0px 0px 0px 0px; font-size:12pt;)\n</style>";
    private String body = "<body style=\"font-size:10pt;\">";
    private String headerUntimed = "Untimed Events";
    private String headerTimelines = "Timelines";
    private String headerEvents = "Events";
    private String headerConnections = "Connections";
    private String headerColors = "Unused Colors";
    private String headerRows = "Empty Rows";
    private String headerStatistics = "Statistics";
    private JButton exportButton = new JButton("Export");
    private String exportButtonTip = "Export report to an html file.";
    private JButton printButton = new JButton("Print");
    private String printButtonTip = "Print the summary report. Note the number of pages is not available in the print dialog.";
    private JButton closeButton = new JButton("Close");
    private String closeButtonTip = "Close the summary.";
    private FlowLayout flowLayoutCenter = new FlowLayout(1);
    private String currentExportDir = "";
    private BufferedWriter outBuffer = null;
    private String newOverwriteDialog = "New output file already exists. Do you want to overwrite it?";
    private int numUntimed;
    private int numTimelines;
    private int numEvents;
    private int numConnections;

    ReportMissing(CDgui mainGUI) {
        Object result;
        boolean oneMissing;
        this.ourGUI = mainGUI;
        this.missingFrame = this;
        this.setTitle("Missing Meta-Data Report of " + this.ourGUI.getOpenFile());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                ReportMissing.this.ourGUI.getWindowManager().closeWindow();
            }
        });
        this.buffer = "";
        this.appendString(this.head);
        this.appendString(this.styles);
        this.appendString("</head>");
        this.appendString(this.body);
        String tmpTimestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + " with " + this.ourGUI.getProgramName() + " version " + this.ourGUI.getProgramVersion();
        this.appendString(Utils.makeH1("Missing MetaData Report"));
        this.appendString("For file " + this.ourGUI.getOpenFile() + "<br>");
        this.appendString("File written at " + tmpTimestamp + "<br>");
        this.appendString("Settings: Description: " + Utils.makeHTMLCheckbox(this.ourGUI.getPreferences().getMissingDescription()) + " Links: " + Utils.makeHTMLCheckbox(this.ourGUI.getPreferences().getMissingLinks()) + " Tags: " + Utils.makeHTMLCheckbox(this.ourGUI.getPreferences().getMissingTags()) + " Connection Name: " + Utils.makeHTMLCheckbox(this.ourGUI.getPreferences().getMissingCnName()) + " Connection with &lt " + this.ourGUI.getPreferences().getMissingCnTags() + " Tags Empty Rows: " + Utils.makeHTMLCheckbox(this.ourGUI.getPreferences().getMissingEmptyRows()) + " Statistics: " + Utils.makeHTMLCheckbox(this.ourGUI.getPreferences().getMissingStats()) + "<br>");
        this.appendString(Utils.makeH2("Contents"));
        this.appendString(Utils.makeIntLink("toc_" + Utils.noSpace(this.headerUntimed), this.headerUntimed) + "<br>\n");
        this.appendString(Utils.makeIntLink("toc_" + Utils.noSpace(this.headerTimelines), this.headerTimelines) + "<br>\n");
        this.appendString(Utils.makeIntLink("toc_" + Utils.noSpace(this.headerEvents), this.headerEvents) + "<br>\n");
        this.appendString(Utils.makeIntLink("toc_" + Utils.noSpace(this.headerConnections), this.headerConnections) + "<br>\n");
        this.appendString(Utils.makeIntLink("toc_" + Utils.noSpace(this.headerColors), this.headerColors) + "<br>\n");
        if (this.ourGUI.getPreferences().getMissingEmptyRows()) {
            this.appendString(Utils.makeIntLink("toc_" + Utils.noSpace(this.headerRows), this.headerRows) + "<br>\n");
        }
        if (this.ourGUI.getPreferences().getMissingStats()) {
            this.appendString(Utils.makeIntLink("toc_" + Utils.noSpace(this.headerStatistics), this.headerStatistics) + "<br>\n");
        }
        this.appendString(Utils.makeH2("Untimed"));
        List<Event> untimedList = this.ourGUI.getInput().getEventData().getListOfUntimedEvents(false);
        EventData.sortEventsBySequence(untimedList);
        this.numUntimed = untimedList.size();
        int i = 0;
        while (i < untimedList.size()) {
            Event ourEv = untimedList.get(i);
            Object result2 = "";
            oneMissing = false;
            if (this.ourGUI.getPreferences().getMissingDescription() && (ourEv.getDescription() == null || ourEv.getDescription().isEmpty())) {
                result2 = (String)result2 + "Description<br>\n";
                oneMissing = true;
            }
            if (this.ourGUI.getPreferences().getMissingLinks() && ourEv.getLinks().size() == 0) {
                result2 = (String)result2 + "Links<br>\n";
                oneMissing = true;
            }
            if (this.ourGUI.getPreferences().getMissingTags() && ourEv.getTags().getSize() == 0) {
                result2 = (String)result2 + "Tags<br>\n";
                oneMissing = true;
            }
            if (oneMissing) {
                this.appendString(Utils.makeH3(Utils.flatline(ourEv.getName())));
                this.appendString((String)result2);
                ++this.numEvents;
            }
            ++i;
        }
        this.appendString(Utils.makeH2("Timelines"));
        EventData allEvents = this.ourGUI.getInput().getEventData();
        this.numTimelines = 0;
        List<Event> timelineList = allEvents.getListOfTimelines(true);
        int i2 = 0;
        while (i2 < timelineList.size()) {
            oneMissing = false;
            Event ourTl = timelineList.get(i2);
            result = "";
            if (this.ourGUI.getPreferences().getMissingDescription() && (ourTl.getDescription() == null || ourTl.getDescription().isEmpty())) {
                result = (String)result + "Description<br>\n";
                oneMissing = true;
            }
            if (this.ourGUI.getPreferences().getMissingLinks() && ourTl.getLinks().size() == 0) {
                result = (String)result + "Links<br>\n";
                oneMissing = true;
            }
            if (this.ourGUI.getPreferences().getMissingTags() && ourTl.getTags().getSize() == 0) {
                result = (String)result + "Tags<br>\n";
                oneMissing = true;
            }
            if (oneMissing) {
                ++this.numTimelines;
                this.appendString(Utils.makeH3(Utils.flatline(ourTl.getName())));
                this.appendString((String)result);
            }
            ++i2;
        }
        List<Event> events = allEvents.getListOfEventsOnly(true);
        this.numEvents = 0;
        this.appendString(Utils.makeH2("Events"));
        int i3 = 0;
        while (i3 < events.size()) {
            Event ourEv = events.get(i3);
            result = "";
            boolean oneMissing2 = false;
            if (this.ourGUI.getPreferences().getMissingDescription() && (ourEv.getDescription() == null || ourEv.getDescription().isEmpty())) {
                result = (String)result + "Description<br>\n";
                oneMissing2 = true;
            }
            if (this.ourGUI.getPreferences().getMissingLinks() && ourEv.getLinks().size() == 0) {
                result = (String)result + "Links<br>\n";
                oneMissing2 = true;
            }
            if (this.ourGUI.getPreferences().getMissingTags() && ourEv.getTags().getSize() == 0) {
                result = (String)result + "Tags<br>\n";
                oneMissing2 = true;
            }
            if (oneMissing2) {
                this.appendString(Utils.makeH3(Utils.flatline(ourEv.getName())));
                this.appendString((String)result);
                ++this.numEvents;
            }
            ++i3;
        }
        this.numConnections = 0;
        this.appendString(Utils.makeH2("Connections"));
        ConnectionData connections = this.ourGUI.getInput().getConnections();
        connections.sortConnectionsByName();
        int i4 = 0;
        while (i4 < connections.getNumberOfConnections()) {
            boolean oneMissing3 = false;
            Connection ourCn = connections.getConnection(i4);
            Object result3 = "";
            if (this.ourGUI.getPreferences().getMissingCnName() && (ourCn.getName() == null || ourCn.getName().isEmpty())) {
                result3 = (String)result3 + "Name<br>\n";
                oneMissing3 = true;
            }
            if (this.ourGUI.getPreferences().getMissingDescription() && (ourCn.getDescription() == null || ourCn.getDescription().isEmpty())) {
                result3 = (String)result3 + "Description<br>\n";
                oneMissing3 = true;
            }
            if (this.ourGUI.getPreferences().getMissingLinks() && ourCn.getLinks().size() == 0) {
                result3 = (String)result3 + "Links<br>\n";
                oneMissing3 = true;
            }
            if (this.ourGUI.getPreferences().getMissingTags() && ourCn.getTags().getSize() < this.ourGUI.getPreferences().getMissingCnTags()) {
                result3 = (String)result3 + "Less than " + this.ourGUI.getPreferences().getMissingCnTags() + " Tags: " + ourCn.getTags().getTagsAsString() + "<br>\n";
                oneMissing3 = true;
            }
            if (oneMissing3) {
                this.appendString(Utils.makeH3(ourCn.getNiceID()));
                this.appendString((String)result3);
                ++this.numConnections;
            }
            ++i4;
        }
        this.appendString(Utils.makeH2(this.headerColors));
        Palette ourPalette = this.ourGUI.getPreferences().getPalette();
        String currentColor = "";
        int i5 = 0;
        while (i5 < ourPalette.getSize()) {
            currentColor = ourPalette.getColorName(i5);
            boolean currentFound = false;
            int j = 0;
            while (j < allEvents.getTotalNumberOfEvents()) {
                Event ourEv = allEvents.getEventByIndex(j);
                if (ourEv.getColor().equals(currentColor)) {
                    currentFound = true;
                    break;
                }
                if (ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE) && ourEv.getTlSegmentList() != null) {
                    SegmentList ourSegs = ourEv.getTlSegmentList();
                    int k = 0;
                    while (k < ourSegs.getNumberOfSegments()) {
                        Segment seg = ourSegs.getASegment(k);
                        if (seg.getColorFG().equals(currentColor) || seg.getColorOuterStart().equals(currentColor) || seg.getColorOuterEnd().equals(currentColor) || seg.getColorInner().equals(currentColor)) {
                            currentFound = true;
                            break;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            if (!currentFound) {
                j = 0;
                while (j < connections.getNumberOfConnections()) {
                    Connection ourCn = connections.getConnection(j);
                    if (ourCn.getColor().equals(currentColor)) {
                        currentFound = true;
                        break;
                    }
                    ++j;
                }
            }
            if (!currentFound) {
                this.appendString(Utils.makeP(currentColor));
            }
            ++i5;
        }
        if (this.ourGUI.getPreferences().getMissingEmptyRows()) {
            this.appendString(Utils.makeH2(this.headerRows));
            this.appendString("<span style=color:\"green\"> Green if \"Keep Row Empty\" is set, </span> <span style=color:\"red\">otherwise red</span>.<br>\n");
            RowData rows = this.ourGUI.getRowData();
            Object emptyRows = "";
            int i6 = 0;
            while (i6 < rows.getSize()) {
                if (rows.getRowByIndex(i6).isRowEmpty()) {
                    String color = "red";
                    if (rows.getRowByIndex(i6).getKeepRowEmpty()) {
                        color = "green";
                    }
                    emptyRows = (String)emptyRows + "<span style=color:\"" + color + "\">" + (i6 + 1) + "</span> ";
                }
                ++i6;
            }
            this.appendString((String)emptyRows);
        }
        if (this.ourGUI.getPreferences().getMissingStats()) {
            this.appendString(Utils.makeH2(this.headerStatistics));
            this.appendString(this.numUntimed + " untimed events.<br>\n");
            this.appendString(this.numTimelines + " timelines.<br>\n");
            this.appendString(this.numEvents + " events.<br>\n");
            this.appendString(this.numConnections + " connections.<br>\n");
        }
        this.appendString("</body></html>");
        final JEditorPane htmlPane = new JEditorPane("text/html", this.buffer);
        htmlPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hle) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                    String ref = hle.getDescription();
                    if (ref != null && ref.startsWith("#")) {
                        ref = ref.substring(1);
                        htmlPane.scrollToReference(ref);
                    } else {
                        try {
                            Desktop desktop = Desktop.getDesktop();
                            desktop.browse(hle.getURL().toURI());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        });
        JScrollPane missingScrollPane = new JScrollPane(htmlPane);
        htmlPane.setCaretPosition(0);
        htmlPane.setEditable(false);
        this.add(missingScrollPane);
        JPanel buttonPanel = new JPanel(this.flowLayoutCenter);
        this.printButton.setToolTipText(this.printButtonTip);
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent print) {
                try {
                    htmlPane.print(null, new MessageFormat("Page - {0}"));
                }
                catch (PrinterException e) {
                    e.printStackTrace();
                }
            }
        });
        this.exportButton.setToolTipText(this.exportButtonTip);
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int newOverwriteSelection;
                if (ReportMissing.this.currentExportDir == "") {
                    ReportMissing.this.currentExportDir = System.getProperty("user.home");
                }
                JFileChooser expChooser = new JFileChooser(ReportMissing.this.currentExportDir);
                expChooser.setDialogTitle("Save Report to HTML File");
                expChooser.setMultiSelectionEnabled(false);
                expChooser.setFileSelectionMode(2);
                FileNameExtensionFilter filter = new FileNameExtensionFilter("HTML files", "htm", "html");
                expChooser.setFileFilter(filter);
                expChooser.setFileHidingEnabled(true);
                int expChoice = expChooser.showSaveDialog(ReportMissing.this.ourGUI);
                if (expChoice != 0) {
                    return;
                }
                File saveFile = expChooser.getSelectedFile();
                ReportMissing.this.currentExportDir = saveFile.getParent();
                if (saveFile.exists() && (newOverwriteSelection = JOptionPane.showConfirmDialog(ReportMissing.this.ourGUI, ReportMissing.this.newOverwriteDialog, "That File Already Exists - overwrite it?", 0, 3)) == 1) {
                    return;
                }
                try {
                    saveFile.createNewFile();
                    String path = saveFile.getAbsolutePath();
                    BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), StandardCharsets.UTF_8));
                    ReportMissing.this.outBuffer = new BufferedWriter(outWriter);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(ReportMissing.this.ourGUI, "Output File: IO Exception opening file for write" + ex.getMessage());
                    return;
                }
                try {
                    ReportMissing.this.outBuffer.write(ReportMissing.this.buffer);
                    ReportMissing.this.outBuffer.flush();
                    ReportMissing.this.outBuffer.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.closeButton.setToolTipText(this.closeButtonTip);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent close) {
                ReportMissing.this.ourGUI.getWindowManager().closeWindow();
                ReportMissing.this.missingFrame.dispose();
            }
        });
        Box overallPanel = Box.createVerticalBox();
        buttonPanel.add(this.exportButton);
        buttonPanel.add(this.printButton);
        buttonPanel.add(this.closeButton);
        overallPanel.add(missingScrollPane);
        overallPanel.add(buttonPanel);
        this.add(overallPanel);
        this.setVisible(true);
        this.setSize(600, 600);
    }

    private void appendString(String str) {
        this.buffer = this.buffer + str + "\n";
    }
}

