/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.Link;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

class LinkEditor
extends JDialog {
    private static final long serialVersionUID = 1L;
    private FlowLayout flowLayoutRight = new FlowLayout(2);
    private JDialog ourFrame;
    private JFrame ourTlEditor;
    private JPanel mainPanel = new JPanel(new GridLayout(0, 2));
    private int numLinks = 0;
    private List<JTextField> linkURLFields = new ArrayList<JTextField>();
    private List<JTextField> linkTextFields = new ArrayList<JTextField>();
    private JButton buttonNew = new JButton("New");
    private JButton buttonOK = new JButton("OK");
    private JButton buttonCancel = new JButton("Cancel");
    private JLabel textLabel = new JLabel("Text");
    private JLabel urlLabel = new JLabel("URL");
    private String result;

    LinkEditor(JFrame ourGUI, final ArrayList<Link> links) {
        super(ourGUI, "Link Editor", true);
        this.ourFrame = this;
        this.ourTlEditor = ourGUI;
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        int currentX = this.ourTlEditor.getX();
        int currentY = this.ourTlEditor.getY();
        this.setLocation(currentX - 200, currentY + 100);
        this.numLinks = links.size();
        this.mainPanel.add(this.textLabel);
        this.mainPanel.add(this.urlLabel);
        int i = 0;
        while (i < this.numLinks) {
            this.linkTextFields.add(new JTextField(30));
            this.linkTextFields.get(i).setText(links.get(i).getText());
            this.linkURLFields.add(new JTextField(30));
            this.linkURLFields.get(i).setText(links.get(i).getURL());
            this.mainPanel.add(this.linkTextFields.get(i));
            this.mainPanel.add(this.linkURLFields.get(i));
            ++i;
        }
        if (this.numLinks == 0) {
            ++this.numLinks;
            this.linkTextFields.add(new JTextField(30));
            this.linkTextFields.get(0).setToolTipText("Enter the text which will open the link when clicked");
            this.linkURLFields.add(new JTextField(30));
            this.linkURLFields.get(0).setText("http://www.");
            this.linkURLFields.get(0).setToolTipText("Enter the URL address, e.g. http://www.wikipedia.org");
            this.mainPanel.add(this.linkTextFields.get(0));
            this.mainPanel.add(this.linkURLFields.get(0));
        }
        this.buttonNew.setToolTipText("Add a new Link");
        this.buttonNew.setPreferredSize(new Dimension(100, 20));
        this.buttonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent n) {
                LinkEditor.this.result = "new";
                int idx = LinkEditor.this.numLinks++;
                LinkEditor.this.linkTextFields.add(new JTextField(30));
                LinkEditor.this.linkTextFields.get(idx).setToolTipText("Enter the text which will open the link when clicked");
                LinkEditor.this.linkURLFields.add(new JTextField(30));
                LinkEditor.this.linkURLFields.get(idx).setText("http://www.");
                LinkEditor.this.linkURLFields.get(idx).setToolTipText("Enter the URL address, e.g. http://www.wikipedia.org");
                LinkEditor.this.mainPanel.add(LinkEditor.this.linkTextFields.get(idx));
                LinkEditor.this.mainPanel.add(LinkEditor.this.linkURLFields.get(idx));
                LinkEditor.this.linkTextFields.get(idx).requestFocusInWindow();
                LinkEditor.this.ourFrame.pack();
            }
        });
        this.buttonOK.setToolTipText("Apply the edits and close the window");
        this.buttonOK.setPreferredSize(new Dimension(100, 20));
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ok) {
                int linkErrors = 0;
                int idx = 0;
                idx = 0;
                while (idx < LinkEditor.this.numLinks) {
                    if (!LinkEditor.this.linkURLFields.get(idx).getText().isEmpty() && LinkEditor.this.linkURLFields.get(idx).getText() != "") {
                        try {
                            URI testURI = new URI(LinkEditor.this.linkURLFields.get(idx).getText());
                            URL testURL = testURI.toURL();
                            testURI = testURL.toURI();
                        }
                        catch (URISyntaxException urie) {
                            JOptionPane.showMessageDialog(LinkEditor.this.ourFrame, "Link Editor: Invalid URI: " + String.valueOf(urie) + " in link " + LinkEditor.this.linkURLFields.get(idx).getText() + " with text: " + LinkEditor.this.linkTextFields.get(idx).getText() + "\nMust start with http://  or http://www. (also https)");
                            ++linkErrors;
                        }
                        catch (MalformedURLException urle) {
                            JOptionPane.showMessageDialog(LinkEditor.this.ourFrame, "Link Editor: Invalid URL: " + String.valueOf(urle) + " in link " + LinkEditor.this.linkURLFields.get(idx).getText() + " with text: " + LinkEditor.this.linkTextFields.get(idx).getText() + "\nMust start with http://  or http://www. (also https)");
                            ++linkErrors;
                        }
                    }
                    ++idx;
                }
                if (linkErrors == 0) {
                    links.clear();
                    int i = 0;
                    while (i < LinkEditor.this.numLinks) {
                        if (!LinkEditor.this.linkTextFields.get(i).getText().isEmpty() && LinkEditor.this.linkTextFields.get(i).getText() != "" && !LinkEditor.this.linkURLFields.get(i).getText().isEmpty() && LinkEditor.this.linkURLFields.get(i).getText() != "") {
                            links.add(new Link(LinkEditor.this.linkTextFields.get(i).getText(), LinkEditor.this.linkURLFields.get(i).getText()));
                        }
                        ++i;
                    }
                    LinkEditor.this.result = "OK";
                    LinkEditor.this.ourTlEditor.revalidate();
                    LinkEditor.this.ourTlEditor.repaint();
                    LinkEditor.this.ourFrame.dispose();
                }
            }
        });
        this.buttonCancel.setToolTipText("Close the window");
        this.buttonCancel.setPreferredSize(new Dimension(100, 20));
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent can) {
                LinkEditor.this.result = "Cancel";
                LinkEditor.this.ourFrame.dispose();
            }
        });
        JPanel buttonsPanel = new JPanel(this.flowLayoutRight);
        buttonsPanel.add(this.buttonNew);
        buttonsPanel.add(this.buttonOK);
        buttonsPanel.add(this.buttonCancel);
        JPanel allPane = new JPanel();
        JScrollPane allScroll = new JScrollPane(allPane);
        allPane.add((Component)this.mainPanel, "Center");
        this.add(allScroll);
        this.add((Component)buttonsPanel, "South");
        this.pack();
        this.setVisible(true);
    }

    public String getResult() {
        return this.result;
    }
}

