/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CDgui;
import culturalDynamics.CommonData;
import culturalDynamics.CommonEditor;
import culturalDynamics.Connection;
import culturalDynamics.ConnectionData;
import culturalDynamics.ConnectionEditor;
import culturalDynamics.Event;
import culturalDynamics.EventData;
import culturalDynamics.EventEditor;
import culturalDynamics.InputFileJSON;
import culturalDynamics.LogScrollPane;
import culturalDynamics.Row;
import culturalDynamics.RowData;
import culturalDynamics.Segment;
import culturalDynamics.TagList;
import culturalDynamics.WindowManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

class ImportSelector
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Dimension INITIAL_SIZE = new Dimension(500, 700);
    private static final Dimension INITIAL_SCROLL_SIZE = new Dimension(600, 600);
    private CDgui ourGUI;
    private JFrame ourFrame;
    private InputFileJSON ourImport;
    private EventData ourEvents;
    private ConnectionData ourConnections;
    private RowData ourRowData;
    private LogScrollPane loggingScrollPane;
    private int errorCount = 0;
    private int warningCount = 0;
    private JButton selectAll = new JButton("Select All");
    private String selectAllTip = "Check all the objects in the list to select for import.";
    private JButton clearAll = new JButton("Clear All");
    private String clearAllTip = "Uncheck all the objects in the list.";
    private JButton importButton = new JButton("Import");
    private String importButtonTip = "Start the import and show the log.";
    private JCheckBox includeTlEventsBox = new JCheckBox("Include Timelines' Timeline-Events");
    private String includeTlEventsBoxTip = "When selecting a timeline for import, automatically check and uncheck its timeline-events.";
    private JCheckBox includeTlSegmentsBox = new JCheckBox("Include Timeline Segments");
    private String includeTlSegmentsBoxxTip = "Check to include all of a timeline's segments in the import.";
    private JCheckBox openEditors = new JCheckBox("Open Editors");
    private String openEditorsTip = "Open editors for all objects after import. CAUTION: for many objects this is overwhelming!";
    private JLabel createLabel = new JLabel("Create missing:");
    private JCheckBox colorsBox = new JCheckBox("Colours");
    private String colorsBoxTip = "Check to create missing colours during import. If unchecked, a default colour is used.";
    private JCheckBox tagsBox = new JCheckBox("Tags");
    private String tagsBoxTip = "Check to create missing tags during import. If unchecked, missing tags are omitted.";
    private FlowLayout flowLayoutLeft = new FlowLayout(0);
    private LineBorder panelsBorder = new LineBorder(Color.lightGray, 3);
    private JScrollPane hScrollPane;
    private int nItems = 0;
    private String[] numbering;
    private JCheckBox[] checkBoxes;
    private String[] types;
    private String[] names;
    private JLabel labelImport = new JLabel("Import");
    private JLabel labelType = new JLabel("Type");
    private JLabel labelName = new JLabel("Name");
    private ActionListener selectListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            int index = Integer.parseInt(cmd);
            boolean check = ImportSelector.this.checkBoxes[index].isSelected();
            if (ImportSelector.this.types[index].equals("TIMELINE") && ImportSelector.this.includeTlEventsBox.isSelected()) {
                ++index;
                while (index < ImportSelector.this.nItems && ImportSelector.this.types[index].equals("TIMELINE_EVENT")) {
                    ImportSelector.this.checkBoxes[index].setSelected(check);
                    ++index;
                }
            }
        }
    };

    ImportSelector(CDgui mainGUI, final InputFileJSON importFileIn) {
        this.ourGUI = mainGUI;
        this.ourFrame = this;
        this.ourImport = importFileIn;
        this.setPreferredSize(INITIAL_SIZE);
        this.setTitle(importFileIn.getFileName());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                ImportSelector.this.ourGUI.getWindowManager().closeWindow();
            }
        });
        this.selectAll.setToolTipText(this.selectAllTip);
        this.clearAll.setToolTipText(this.clearAllTip);
        this.importButton.setToolTipText(this.importButtonTip);
        this.includeTlEventsBox.setToolTipText(this.includeTlEventsBoxTip);
        this.includeTlSegmentsBox.setToolTipText(this.includeTlSegmentsBoxxTip);
        this.openEditors.setToolTipText(this.openEditorsTip);
        this.colorsBox.setToolTipText(this.colorsBoxTip);
        this.tagsBox.setToolTipText(this.tagsBoxTip);
        this.includeTlEventsBox.setSelected(true);
        this.includeTlSegmentsBox.setSelected(true);
        final Box mainPanel = Box.createVerticalBox();
        JPanel buttonsPanel = new JPanel(this.flowLayoutLeft);
        buttonsPanel.add(this.selectAll);
        buttonsPanel.add(this.clearAll);
        buttonsPanel.add(this.importButton);
        JPanel includePanel = new JPanel(this.flowLayoutLeft);
        includePanel.add(this.includeTlEventsBox);
        includePanel.add(this.includeTlSegmentsBox);
        JPanel editorsPanel = new JPanel(this.flowLayoutLeft);
        editorsPanel.add(this.openEditors);
        Box groupPanel = Box.createVerticalBox();
        groupPanel.add(includePanel);
        groupPanel.add(editorsPanel);
        JPanel missingPanel = new JPanel(this.flowLayoutLeft);
        missingPanel.add(this.createLabel);
        missingPanel.add(this.colorsBox);
        missingPanel.add(this.tagsBox);
        Box topPanel = Box.createVerticalBox();
        TitledBorder topTitle = new TitledBorder(this.panelsBorder, "Import", 1, 2);
        topPanel.setBorder(topTitle);
        topPanel.add(groupPanel);
        topPanel.add(missingPanel);
        topPanel.add(buttonsPanel);
        mainPanel.add(topPanel);
        this.selectAll.setEnabled(false);
        this.clearAll.setEnabled(false);
        this.importButton.setEnabled(false);
        this.selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent selAll) {
                JCheckBox[] jCheckBoxArray = ImportSelector.this.checkBoxes;
                int n = ImportSelector.this.checkBoxes.length;
                int n2 = 0;
                while (n2 < n) {
                    JCheckBox chk = jCheckBoxArray[n2];
                    chk.setSelected(true);
                    ++n2;
                }
            }
        });
        this.clearAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent clear) {
                JCheckBox[] jCheckBoxArray = ImportSelector.this.checkBoxes;
                int n = ImportSelector.this.checkBoxes.length;
                int n2 = 0;
                while (n2 < n) {
                    JCheckBox chk = jCheckBoxArray[n2];
                    chk.setSelected(false);
                    ++n2;
                }
            }
        });
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent imp) {
                String tag;
                TagList eventTags;
                String newEventColor;
                Event newEvent;
                String readImportTitle = " for import";
                ImportSelector.this.loggingScrollPane = new LogScrollPane(ImportSelector.this.ourGUI, importFileIn.getFileName(), readImportTitle, true);
                ImportSelector.this.loggingScrollPane.setVisible(true);
                ImportSelector.this.loggingScrollPane.setSize(INITIAL_SCROLL_SIZE);
                ImportSelector.this.ourGUI.getWindowManager().positionWindow(ImportSelector.this.loggingScrollPane, WindowManager.ScreenSide.CASCADE_TR);
                ImportSelector.this.errorCount = 0;
                ImportSelector.this.warningCount = 0;
                ImportSelector.this.log(LogScrollPane.lineType.OK, "Importing from file " + importFileIn.getFileName() + " " + readImportTitle + "\n");
                TagList masterTags = ImportSelector.this.ourGUI.getMasterTags();
                int i = 0;
                while (i < ImportSelector.this.nItems) {
                    if (ImportSelector.this.types[i].equals("TIMELINE") && ImportSelector.this.checkBoxes[i].isSelected()) {
                        newEvent = ImportSelector.this.ourEvents.getEventByName(ImportSelector.this.names[i]);
                        if (ImportSelector.this.ourGUI.getInput().getEventData().getEventByName(ImportSelector.this.names[i]) != null) {
                            ImportSelector.this.log(LogScrollPane.lineType.ERROR, ImportSelector.this.numbering[i] + " ***  Timeline already exists: " + ImportSelector.this.names[i] + "\n");
                        } else {
                            if (!ImportSelector.this.includeTlSegmentsBox.isSelected()) {
                                newEvent.setTlSegmentList(null);
                            } else if (newEvent.getTlSegmentList() != null) {
                                int s = 0;
                                while (s < newEvent.getTlSegmentList().getNumberOfSegments()) {
                                    Segment seg = newEvent.getTlSegmentList().getASegment(s);
                                    String segCol = seg.getColorFG();
                                    if (!ImportSelector.this.ourGUI.getPreferences().getPalette().paletteColorExists(segCol)) {
                                        if (ImportSelector.this.colorsBox.isSelected()) {
                                            ImportSelector.this.ourGUI.getPreferences().getPalette().addColorToPalette(ImportSelector.this.ourImport.getPalette().getPaletteColorByName(segCol));
                                            ImportSelector.this.ourGUI.getPreferences().updatePaletteAfterRead();
                                            ImportSelector.this.log(LogScrollPane.lineType.WARNING, ImportSelector.this.numbering[i] + " *  Segment foreground color missing: " + segCol + " - added\n");
                                        } else {
                                            ImportSelector.this.log(LogScrollPane.lineType.WARNING, ImportSelector.this.numbering[i] + " *  Segment foreground color missing: " + segCol + " - using default\n");
                                        }
                                    }
                                    segCol = seg.getColorInner();
                                    if (!ImportSelector.this.ourGUI.getPreferences().getPalette().paletteColorExists(segCol)) {
                                        if (ImportSelector.this.colorsBox.isSelected()) {
                                            ImportSelector.this.ourGUI.getPreferences().getPalette().addColorToPalette(ImportSelector.this.ourImport.getPalette().getPaletteColorByName(segCol));
                                            ImportSelector.this.ourGUI.getPreferences().updatePaletteAfterRead();
                                            ImportSelector.this.log(LogScrollPane.lineType.WARNING, ImportSelector.this.numbering[i] + " *  Segment inner background color missing: " + segCol + " - added\n");
                                        } else {
                                            ImportSelector.this.log(LogScrollPane.lineType.WARNING, ImportSelector.this.numbering[i] + " *  Segment inner background color missing: " + segCol + " - using default\n");
                                        }
                                    }
                                    segCol = seg.getColorOuterStart();
                                    if (!ImportSelector.this.ourGUI.getPreferences().getPalette().paletteColorExists(segCol)) {
                                        if (ImportSelector.this.colorsBox.isSelected()) {
                                            ImportSelector.this.ourGUI.getPreferences().getPalette().addColorToPalette(ImportSelector.this.ourImport.getPalette().getPaletteColorByName(segCol));
                                            ImportSelector.this.log(LogScrollPane.lineType.WARNING, ImportSelector.this.numbering[i] + " *  Segment outer background start color missing: " + segCol + " - added\n");
                                        } else {
                                            ImportSelector.this.log(LogScrollPane.lineType.WARNING, ImportSelector.this.numbering[i] + " *  Segment outer background start color missing: " + segCol + " - using default\n");
                                        }
                                    }
                                    segCol = seg.getColorOuterEnd();
                                    if (!ImportSelector.this.ourGUI.getPreferences().getPalette().paletteColorExists(segCol)) {
                                        if (ImportSelector.this.colorsBox.isSelected()) {
                                            ImportSelector.this.ourGUI.getPreferences().getPalette().addColorToPalette(ImportSelector.this.ourImport.getPalette().getPaletteColorByName(segCol));
                                            ImportSelector.this.ourGUI.getPreferences().updatePaletteAfterRead();
                                            ImportSelector.this.log(LogScrollPane.lineType.WARNING, ImportSelector.this.numbering[i] + " *  Segment outer background end color missing: " + segCol + " - added\n");
                                        } else {
                                            ImportSelector.this.log(LogScrollPane.lineType.WARNING, ImportSelector.this.numbering[i] + " *  Segment outer background end color missing: " + segCol + " - using default\n");
                                        }
                                    }
                                    ++s;
                                }
                                ImportSelector.this.log(LogScrollPane.lineType.OK, ImportSelector.this.numbering[i] + " " + newEvent.getTlSegmentList().getNumberOfSegments() + " Segments of timeline: " + ImportSelector.this.names[i] + " imported\n");
                            }
                            newEventColor = newEvent.getColor();
                            if (!ImportSelector.this.ourGUI.getPreferences().getPalette().paletteColorExists(newEventColor)) {
                                if (ImportSelector.this.colorsBox.isSelected()) {
                                    ImportSelector.this.ourGUI.getPreferences().getPalette().addColorToPalette(ImportSelector.this.ourImport.getPalette().getPaletteColorByName(newEventColor));
                                    ImportSelector.this.ourGUI.getPreferences().updatePaletteAfterRead();
                                    ImportSelector.this.log(LogScrollPane.lineType.WARNING, ImportSelector.this.numbering[i] + " *  Timeline color missing: " + newEventColor + " - added\n");
                                } else {
                                    ImportSelector.this.log(LogScrollPane.lineType.WARNING, ImportSelector.this.numbering[i] + " *  Timeline color missing: " + newEventColor + " - using default\n");
                                }
                            }
                            if (!(eventTags = newEvent.getTags()).isEmpty()) {
                                int t = 0;
                                while (t < eventTags.getSize()) {
                                    tag = eventTags.getTagByIndex(t);
                                    if (!masterTags.tagExists(tag)) {
                                        if (ImportSelector.this.tagsBox.isSelected()) {
                                            masterTags.addTag(tag);
                                            ImportSelector.this.log(LogScrollPane.lineType.WARNING, ImportSelector.this.numbering[i] + " *  Timeline tag missing: " + tag + " - added\n");
                                        } else {
                                            newEvent.getTags().removeTagByName(tag);
                                            ImportSelector.this.log(LogScrollPane.lineType.WARNING, ImportSelector.this.numbering[i] + " *  Timeline tag missing: " + tag + " - removed\n");
                                        }
                                    }
                                    ++t;
                                }
                            }
                            newEvent.setFirstFit(false);
                            newEvent.setTlEventList(null);
                            ImportSelector.this.ourGUI.getInput().getEventData().addEvent(newEvent);
                            ImportSelector.this.ourRowData = ImportSelector.this.ourGUI.getRowData();
                            ImportSelector.this.ourRowData.appendRow(new Row());
                            int evRowIdx = ImportSelector.this.ourRowData.getSize() - 1;
                            ImportSelector.this.ourRowData.addEventToRow(newEvent, ImportSelector.this.ourGUI.getPreferences().getRowMinXGap(), evRowIdx);
                            ImportSelector.this.log(LogScrollPane.lineType.OK, ImportSelector.this.numbering[i] + " Timeline: " + ImportSelector.this.names[i] + " imported\n");
                        }
                    }
                    ++i;
                }
                i = 0;
                while (i < ImportSelector.this.nItems) {
                    if (ImportSelector.this.types[i].equals("TIMELINE_EVENT") && ImportSelector.this.checkBoxes[i].isSelected()) {
                        Event newTlEvent = ImportSelector.this.ourEvents.getEventByName(ImportSelector.this.names[i]);
                        if (ImportSelector.this.ourGUI.getInput().getEventData().getEventByName(ImportSelector.this.names[i]) != null) {
                            ImportSelector.this.log(LogScrollPane.lineType.ERROR, ImportSelector.this.numbering[i] + " ***  Timeline-Event already exists: " + ImportSelector.this.names[i] + "\n");
                        } else {
                            Event parentIm = newTlEvent.getEventTimeline();
                            if (ImportSelector.this.ourGUI.getInput().getEventData().getEventByName(parentIm.getName()) == null) {
                                ImportSelector.this.log(LogScrollPane.lineType.ERROR, ImportSelector.this.numbering[i] + " ***  Timeline-Event's parent timeline does not exist: " + ImportSelector.this.names[i] + "\n");
                            } else {
                                TagList tlEventTags;
                                Event parent = ImportSelector.this.ourGUI.getInput().getEventData().getEventByName(parentIm.getName());
                                String newTlEventColor = newTlEvent.getColor();
                                if (!ImportSelector.this.ourGUI.getPreferences().getPalette().paletteColorExists(newTlEventColor)) {
                                    if (ImportSelector.this.colorsBox.isSelected()) {
                                        ImportSelector.this.ourGUI.getPreferences().getPalette().addColorToPalette(ImportSelector.this.ourImport.getPalette().getPaletteColorByName(newTlEventColor));
                                        ImportSelector.this.ourGUI.getPreferences().updatePaletteAfterRead();
                                        ImportSelector.this.log(LogScrollPane.lineType.WARNING, ImportSelector.this.numbering[i] + " *  Timeline-Event color missing: " + newTlEventColor + " - added\n");
                                    } else {
                                        ImportSelector.this.log(LogScrollPane.lineType.WARNING, ImportSelector.this.numbering[i] + " *  Timeline-Event color missing: " + newTlEventColor + " - using default\n");
                                    }
                                }
                                if (!(tlEventTags = newTlEvent.getTags()).isEmpty()) {
                                    int t = 0;
                                    while (t < tlEventTags.getSize()) {
                                        String tag2 = tlEventTags.getTagByIndex(t);
                                        if (!masterTags.tagExists(tag2)) {
                                            if (ImportSelector.this.tagsBox.isSelected()) {
                                                masterTags.addTag(tag2);
                                                ImportSelector.this.log(LogScrollPane.lineType.WARNING, ImportSelector.this.numbering[i] + " *  Timeline-Event tag missing: " + tag2 + " - added\n");
                                            } else {
                                                newTlEvent.getTags().removeTagByName(tag2);
                                                ImportSelector.this.log(LogScrollPane.lineType.WARNING, ImportSelector.this.numbering[i] + " *  Timeline-Event tag missing: " + tag2 + " - removed\n");
                                            }
                                        }
                                        ++t;
                                    }
                                }
                                ImportSelector.this.ourGUI.getInput().getEventData().addEvent(newTlEvent);
                                if (parent.getTlEventList() == null) {
                                    parent.setTlEventList(new EventData());
                                }
                                parent.getTlEventList().addEvent(newTlEvent);
                                newTlEvent.setEventTimeline(parent);
                                ImportSelector.this.log(LogScrollPane.lineType.OK, ImportSelector.this.numbering[i] + " Timeline-Event: " + ImportSelector.this.names[i] + " imported\n");
                                if (ImportSelector.this.openEditors.isSelected()) {
                                    EventEditor newTlEventEditor = new EventEditor(ImportSelector.this.ourGUI, newTlEvent, ImportSelector.this.ourGUI.getTimePanel(), ImportSelector.this.ourGUI.getInput().getEventData(), ImportSelector.this.ourGUI.getInput().getConnections(), CommonEditor.NewObject.EXISTING);
                                    ImportSelector.this.ourGUI.getWindowManager().positionWindow(newTlEventEditor, WindowManager.ScreenSide.CASCADE_TR);
                                }
                            }
                        }
                    }
                    ++i;
                }
                i = 0;
                while (i < ImportSelector.this.nItems) {
                    if ((ImportSelector.this.types[i].equals("UNTIMED") || ImportSelector.this.types[i].equals("GENERAL_EVENT")) && ImportSelector.this.checkBoxes[i].isSelected()) {
                        newEvent = ImportSelector.this.ourEvents.getEventByName(ImportSelector.this.names[i]);
                        if (ImportSelector.this.ourGUI.getInput().getEventData().getEventByName(ImportSelector.this.names[i]) != null) {
                            ImportSelector.this.log(LogScrollPane.lineType.ERROR, ImportSelector.this.numbering[i] + " ***  Untimed or General Event already exists: " + ImportSelector.this.names[i] + "\n");
                        } else {
                            newEvent.setFirstFit(false);
                            newEventColor = newEvent.getColor();
                            if (!ImportSelector.this.ourGUI.getPreferences().getPalette().paletteColorExists(newEventColor)) {
                                if (ImportSelector.this.colorsBox.isSelected()) {
                                    ImportSelector.this.ourGUI.getPreferences().getPalette().addColorToPalette(ImportSelector.this.ourImport.getPalette().getPaletteColorByName(newEventColor));
                                    ImportSelector.this.ourGUI.getPreferences().updatePaletteAfterRead();
                                    ImportSelector.this.log(LogScrollPane.lineType.WARNING, ImportSelector.this.numbering[i] + " *  Untimed or General Event color missing: " + newEventColor + " - added\n");
                                } else {
                                    ImportSelector.this.log(LogScrollPane.lineType.WARNING, ImportSelector.this.numbering[i] + " *  Untimed or General Event color missing: " + newEventColor + " - using default\n");
                                }
                            }
                            if (!(eventTags = newEvent.getTags()).isEmpty()) {
                                int t = 0;
                                while (t < eventTags.getSize()) {
                                    tag = eventTags.getTagByIndex(t);
                                    if (!masterTags.tagExists(tag)) {
                                        if (ImportSelector.this.tagsBox.isSelected()) {
                                            masterTags.addTag(tag);
                                            ImportSelector.this.log(LogScrollPane.lineType.WARNING, ImportSelector.this.numbering[i] + " *  Untimed/General Event tag missing: " + tag + " - added\n");
                                        } else {
                                            newEvent.getTags().removeTagByName(tag);
                                            ImportSelector.this.log(LogScrollPane.lineType.WARNING, ImportSelector.this.numbering[i] + " *  Untimed/General Event tag missing: " + tag + " - removed\n");
                                        }
                                    }
                                    ++t;
                                }
                            }
                            ImportSelector.this.ourGUI.getInput().getEventData().addEvent(newEvent);
                            if (ImportSelector.this.types[i].equals("GENERAL_EVENT")) {
                                ImportSelector.this.log(LogScrollPane.lineType.OK, ImportSelector.this.numbering[i] + " General Event: " + ImportSelector.this.names[i] + " imported\n");
                            } else {
                                ImportSelector.this.log(LogScrollPane.lineType.OK, ImportSelector.this.numbering[i] + " Untimed Event: " + ImportSelector.this.names[i] + " imported\n");
                            }
                            if (ImportSelector.this.types[i].equals("GENERAL_EVENT")) {
                                ImportSelector.this.ourRowData = ImportSelector.this.ourGUI.getRowData();
                                ImportSelector.this.ourRowData.appendRow(new Row());
                                int evRowIdx = ImportSelector.this.ourRowData.getSize() - 1;
                                ImportSelector.this.ourRowData.addEventToRow(newEvent, ImportSelector.this.ourGUI.getPreferences().getRowMinXGap(), evRowIdx);
                            }
                            if (ImportSelector.this.openEditors.isSelected()) {
                                EventEditor newEventEditor = new EventEditor(ImportSelector.this.ourGUI, newEvent, ImportSelector.this.ourGUI.getTimePanel(), ImportSelector.this.ourGUI.getInput().getEventData(), ImportSelector.this.ourGUI.getInput().getConnections(), CommonEditor.NewObject.EXISTING);
                                ImportSelector.this.ourGUI.getWindowManager().positionWindow(newEventEditor, WindowManager.ScreenSide.CASCADE_TR);
                            }
                        }
                    }
                    ++i;
                }
                i = 0;
                while (i < ImportSelector.this.nItems) {
                    if (ImportSelector.this.types[i].equals("CONNECTION") && ImportSelector.this.checkBoxes[i].isSelected()) {
                        Connection newCn = ImportSelector.this.ourConnections.getConnectionByID(ImportSelector.this.names[i]);
                        if (newCn == null) {
                            System.out.println("Import - Connection not found in import" + ImportSelector.this.names[i]);
                        }
                        if (ImportSelector.this.ourGUI.getInput().getConnections().getConnectionByID(ImportSelector.this.names[i]) != null) {
                            ImportSelector.this.log(LogScrollPane.lineType.ERROR, ImportSelector.this.numbering[i] + " ***  Connection already exists: " + ImportSelector.this.names[i] + "\n");
                        } else if (ImportSelector.this.ourGUI.getInput().getEventData().getEventByName(newCn.getSourceEvent().getName()) == null) {
                            ImportSelector.this.log(LogScrollPane.lineType.ERROR, ImportSelector.this.numbering[i] + " ***  Connection source event not found in data or import: " + newCn.getSourceEvent().getName() + "\n");
                        } else {
                            newCn.setSourceEvent(ImportSelector.this.ourGUI.getInput().getEventData().getEventByName(newCn.getSourceEvent().getName()));
                            if (ImportSelector.this.ourGUI.getInput().getEventData().getEventByName(newCn.getDestEvent().getName()) == null) {
                                ImportSelector.this.log(LogScrollPane.lineType.ERROR, ImportSelector.this.numbering[i] + " ***  Connection destination event not found in data or import: " + newCn.getDestEvent().getName() + "\n");
                            } else {
                                TagList cnTags;
                                newCn.setSourceEvent(ImportSelector.this.ourGUI.getInput().getEventData().getEventByName(newCn.getSourceEvent().getName()));
                                String newCnColor = newCn.getColor();
                                if (!ImportSelector.this.ourGUI.getPreferences().getPalette().paletteColorExists(newCnColor)) {
                                    if (ImportSelector.this.colorsBox.isSelected()) {
                                        ImportSelector.this.ourGUI.getPreferences().getPalette().addColorToPalette(ImportSelector.this.ourImport.getPalette().getPaletteColorByName(newCnColor));
                                        ImportSelector.this.ourGUI.getPreferences().updatePaletteAfterRead();
                                        ImportSelector.this.log(LogScrollPane.lineType.WARNING, ImportSelector.this.numbering[i] + " *  Connection color missing: " + newCnColor + " - added\n");
                                    } else {
                                        ImportSelector.this.log(LogScrollPane.lineType.WARNING, ImportSelector.this.numbering[i] + " *  Connection color missing: " + newCnColor + " - using default\n");
                                    }
                                }
                                if (!(cnTags = newCn.getTags()).isEmpty()) {
                                    int t = 0;
                                    while (t < cnTags.getSize()) {
                                        tag = cnTags.getTagByIndex(t);
                                        if (!masterTags.tagExists(tag)) {
                                            if (ImportSelector.this.tagsBox.isSelected()) {
                                                masterTags.addTag(tag);
                                                ImportSelector.this.log(LogScrollPane.lineType.WARNING, ImportSelector.this.numbering[i] + " *  Connection tag missing: " + tag + " - added\n");
                                            } else {
                                                newCn.getTags().removeTagByName(tag);
                                                ImportSelector.this.log(LogScrollPane.lineType.WARNING, ImportSelector.this.numbering[i] + " *  Connection tag missing: " + tag + " - removed\n");
                                            }
                                        }
                                        ++t;
                                    }
                                }
                                ImportSelector.this.ourGUI.getInput().getConnections().addConnection(newCn);
                                ImportSelector.this.log(LogScrollPane.lineType.OK, ImportSelector.this.numbering[i] + " Connection: " + ImportSelector.this.names[i] + " imported\n");
                                if (ImportSelector.this.openEditors.isSelected()) {
                                    ConnectionEditor newCnEditor = new ConnectionEditor(ImportSelector.this.ourGUI, newCn, ImportSelector.this.ourGUI.getInput().getEventData(), ImportSelector.this.ourGUI.getInput().getConnections(), CommonEditor.NewObject.EXISTING);
                                    ImportSelector.this.ourGUI.getWindowManager().positionWindow(newCnEditor, WindowManager.ScreenSide.CASCADE_TR);
                                }
                            }
                        }
                    }
                    ++i;
                }
                ImportSelector.this.log(LogScrollPane.lineType.OK, "Completed with " + ImportSelector.this.errorCount + " errors and " + ImportSelector.this.warningCount + " warnings.\n");
                ImportSelector.this.loggingScrollPane.endLog();
                ImportSelector.this.loggingScrollPane.toFront();
                ImportSelector.this.ourGUI.setRange();
                ImportSelector.this.ourGUI.panLimits();
                ImportSelector.this.ourGUI.getTimePanel().repaint();
                ImportSelector.this.ourGUI.setFileSaved(false);
                ImportSelector.this.ourGUI.menusAfterImport();
            }
        });
        this.includeTlEventsBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent close) {
                mainPanel.remove(ImportSelector.this.hScrollPane);
                ImportSelector.this.createList();
                mainPanel.add(ImportSelector.this.hScrollPane);
                ImportSelector.this.ourFrame.revalidate();
            }
        });
        this.createList();
        mainPanel.add(this.hScrollPane);
        this.add(mainPanel);
        this.revalidate();
        this.selectAll.setEnabled(true);
        this.clearAll.setEnabled(true);
        this.importButton.setEnabled(true);
        this.pack();
    }

    private void createList() {
        this.ourEvents = this.ourImport.getEventData();
        this.ourConnections = this.ourImport.getConnections();
        this.nItems = this.ourEvents.getTotalNumberOfEvents() + this.ourConnections.getNumberOfConnections();
        this.numbering = new String[this.nItems];
        this.checkBoxes = new JCheckBox[this.nItems];
        this.types = new String[this.nItems];
        this.names = new String[this.nItems];
        List<Event> timelines = this.ourEvents.getListOfTimelines(true);
        int tableIdx = 0;
        int i = 0;
        while (i < timelines.size()) {
            Event ourTl = timelines.get(i);
            this.numbering[tableIdx] = String.valueOf(i);
            this.checkBoxes[tableIdx] = new JCheckBox();
            this.types[tableIdx] = ourTl.getEventTypeAsName();
            this.names[tableIdx] = ourTl.getName();
            ++tableIdx;
            List<Event> ourTlEvents = ourTl.getListOfTlEvents(true);
            if (ourTlEvents != null && ourTlEvents.size() > 0) {
                int j = 0;
                while (j < ourTlEvents.size()) {
                    this.numbering[tableIdx] = String.valueOf(i) + "." + String.valueOf(j);
                    this.checkBoxes[tableIdx] = new JCheckBox();
                    this.types[tableIdx] = ((Event)ourTlEvents.get(j)).getEventTypeAsName();
                    this.names[tableIdx] = ((Event)ourTlEvents.get(j)).getName();
                    ++tableIdx;
                    ++j;
                }
            }
            ++i;
        }
        List<Event> allEvents = this.ourEvents.getListOfAllEvents(true);
        for (Event event : allEvents) {
            if (event.getEventType().equals((Object)CommonData.EventType.TIMELINE) || event.getEventType().equals((Object)CommonData.EventType.TIMELINE_EVENT)) continue;
            this.numbering[tableIdx] = String.valueOf(tableIdx);
            this.checkBoxes[tableIdx] = new JCheckBox();
            this.types[tableIdx] = event.getEventTypeAsName();
            this.names[tableIdx] = event.getName();
            ++tableIdx;
        }
        this.ourConnections.sortConnectionsByName();
        List<Connection> allConnections = this.ourConnections.getConnections();
        for (Connection cn : allConnections) {
            this.numbering[tableIdx] = String.valueOf(tableIdx);
            this.checkBoxes[tableIdx] = new JCheckBox();
            this.types[tableIdx] = "CONNECTION";
            this.names[tableIdx] = cn.getID();
            ++tableIdx;
        }
        JPanel selectPanel = new JPanel();
        TitledBorder hListTitle = new TitledBorder(this.panelsBorder, "Select for Import", 1, 2);
        selectPanel.setBorder(hListTitle);
        GridBagLayout selectGrid = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 19;
        c.anchor = 17;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 2);
        selectPanel.setLayout(selectGrid);
        this.hScrollPane = new JScrollPane(selectPanel);
        this.hScrollPane.setVerticalScrollBarPolicy(20);
        this.hScrollPane.setHorizontalScrollBarPolicy(30);
        c.gridx = 1;
        c.gridy = 0;
        selectPanel.add((Component)this.labelImport, c);
        c.gridx = 2;
        c.gridy = 0;
        selectPanel.add((Component)this.labelType, c);
        c.gridx = 3;
        c.gridy = 0;
        selectPanel.add((Component)this.labelName, c);
        Dimension labelSize = new Dimension(40, 20);
        this.nItems = tableIdx - 1;
        int i2 = 0;
        while (i2 < this.nItems) {
            JLabel rowLabel = new JLabel(i2 + ":", 4);
            rowLabel.setPreferredSize(labelSize);
            c.gridx = 0;
            c.gridy = i2 + 1;
            selectPanel.add((Component)new JLabel(this.numbering[i2]), c);
            c.gridx = 1;
            c.gridy = i2 + 1;
            selectPanel.add((Component)this.checkBoxes[i2], c);
            this.checkBoxes[i2].setActionCommand(String.valueOf(i2));
            this.checkBoxes[i2].addActionListener(this.selectListener);
            c.gridx = 2;
            c.gridy = i2 + 1;
            selectPanel.add((Component)new JLabel(this.types[i2]), c);
            c.gridx = 3;
            c.gridy = i2 + 1;
            selectPanel.add((Component)new JLabel(this.names[i2]), c);
            ++i2;
        }
    }

    private void log(LogScrollPane.lineType error, String msg) {
        this.loggingScrollPane.logLine(error, msg);
        if (error.equals((Object)LogScrollPane.lineType.ERROR)) {
            ++this.errorCount;
        }
        if (error.equals((Object)LogScrollPane.lineType.WARNING)) {
            ++this.warningCount;
        }
    }
}

