/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CDgui;
import culturalDynamics.CommonData;
import culturalDynamics.CommonEditor;
import culturalDynamics.Connection;
import culturalDynamics.ConnectionData;
import culturalDynamics.ConnectionEditor;
import culturalDynamics.ConnectionsPanel;
import culturalDynamics.Dates;
import culturalDynamics.Event;
import culturalDynamics.EventData;
import culturalDynamics.InputFileJSON;
import culturalDynamics.Row;
import culturalDynamics.RowData;
import culturalDynamics.Segment;
import culturalDynamics.SegmentEditor;
import culturalDynamics.TagList;
import culturalDynamics.TimePanel;
import culturalDynamics.Utils;
import culturalDynamics.WindowManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.DateTimeParseException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

class EventEditor
extends CommonEditor {
    private static final long serialVersionUID = 1L;
    private JFrame evEditorFrame;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private CDgui ourGUI;
    private EventEditor evEditor;
    private TimePanel evDisplay;
    private EventData ourEventData;
    private List<Event> ourTimelineList;
    private ConnectionData ourConnectionData;
    private RowData rowData;
    private String evCorrectDate = "Use yyyy-mm-dd, yyyy-mm-dd CE, yyyy-mm-dd BCE.";
    private JLabel evCurrentRowLabel = new JLabel("Current:");
    private JLabel evCurrentRow = new JLabel("?");
    private JCheckBox evOptimiseRowBox = new JCheckBox("First fit");
    private JLabel evRowNewLabel = new JLabel("New:");
    private SpinnerModel evRowModel = new SpinnerNumberModel(1, 0, 1, 1);
    private JSpinner evRowSpinner = new JSpinner(this.evRowModel);
    private boolean rowChanges = false;
    private int evOldSeq;
    private int evNewSeq;
    private JLabel evCurrentSeqLabel = new JLabel("Current:");
    private JLabel evCurrentSeq = new JLabel("?");
    private JLabel evSeqNewLabel = new JLabel("New - before:");
    private SpinnerModel evSeqModel = new SpinnerNumberModel(1, 1, 1, 1);
    private JSpinner evSeqSpinner = new JSpinner(this.evSeqModel);
    private JComboBox<String> evTimelineField = new JComboBox();
    private Event evNewTimeline;
    private JPanel evDatesPanel = new JPanel();
    private JTextField evEarlyStartField = new JTextField(12);
    private JTextField evLateStartField = new JTextField(12);
    private JTextField evEarlyEndField = new JTextField(12);
    private JTextField evLateEndField = new JTextField(12);
    private LocalDate evNewEarlyStartDate;
    private LocalDate evNewLateStartDate;
    private LocalDate evNewEarlyEndDate;
    private LocalDate evNewLateEndDate;
    private int evOldRowIdx;
    private int evNewRowIdx;
    private Event evOldTimeline;
    private boolean evNewOptimiseRow;
    private Box evIconsPanel;
    private JLabel evIconLabel = new JLabel("Start Icon:", 4);
    private JTextField evIconField = new JTextField(30);
    private JLabel evIconLabelImage = new JLabel();
    private ImageIcon evNewIconImage;
    private String evOldIconPath = "";
    private JLabel evEndIconLabel = new JLabel("End Icon:", 4);
    private JTextField evEndIconField = new JTextField(30);
    private JLabel evEndIconLabelImage = new JLabel();
    private ImageIcon evNewEndIconImage;
    private String evOldEndIconPath = "";
    private ConnectionsPanel incomingPanel;
    private ConnectionsPanel outgoingPanel;
    private JButton newOutgoingButton = new JButton("New");
    private String newOutgoingTip = "Create a new connection with this as source.";
    private JButton newIncomingButton = new JButton("New");
    private String newIncomingTip = "Create a new connection with this event as destination.";
    private JButton deleteIncomingButton = new JButton("Delete");
    private String deleteTip = "Delete the selected connections.";
    private JButton deleteOutgoingButton = new JButton("Delete");
    private JButton buttonNewSeg = new JButton("New Segment");
    private JButton buttonNewTlEvent = new JButton("New Event");
    private LineBorder panelsBorder = new LineBorder(Color.lightGray, 3);

    EventEditor(CDgui mainGUI, final Event ourEv, TimePanel timepanel, final EventData events, ConnectionData ourConnections, CommonEditor.NewObject isNewEvent) {
        super(mainGUI, ourEv);
        JFormattedTextField tf;
        JComponent editor;
        this.evEditorFrame = this;
        this.evEditor = this;
        ourEv.setEditor(this);
        this.ourGUI = mainGUI;
        this.evDisplay = timepanel;
        this.ourEventData = events;
        this.ourTimelineList = this.ourEventData.getListOfTimelines(true);
        this.ourConnectionData = ourConnections;
        this.isNew = isNewEvent;
        this.rowData = this.ourGUI.getRowData();
        if (ourEv.getEventType().equals((Object)CommonData.EventType.UNTIMED)) {
            this.evOldSeq = ourEv.getSequenceNo();
        }
        if (ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
            this.nameField.setRows(1);
            this.nameScroll.setVerticalScrollBarPolicy(21);
            InputMap inputMap = this.nameField.getInputMap(0);
            ActionMap actionMap = this.nameField.getActionMap();
            KeyStroke enterStroke = KeyStroke.getKeyStroke(10, 0);
            inputMap.put(enterStroke, enterStroke.toString());
            actionMap.put(enterStroke.toString(), new AbstractAction(){
                static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                }
            });
        }
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                ourEv.setEditor(null);
                EventEditor.this.ourGUI.getWindowManager().closeWindow();
            }

            @Override
            public void windowActivated(WindowEvent wa) {
                if ((ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE) || ourEv.getEventType().equals((Object)CommonData.EventType.GENERAL_EVENT)) && (Integer)EventEditor.this.evRowSpinner.getValue() == EventEditor.this.evOldRowIdx + 1) {
                    EventEditor.this.evOldRowIdx = EventEditor.this.rowData.getRowOfEvent(ourEv);
                    EventEditor.this.evCurrentRow.setText(Integer.toString(EventEditor.this.evOldRowIdx + 1));
                    if (EventEditor.this.rowChanges) {
                        EventEditor.this.evRowSpinner.setValue(EventEditor.this.evOldRowIdx + 1);
                    }
                    ((SpinnerNumberModel)EventEditor.this.evRowModel).setMaximum(Integer.valueOf(EventEditor.this.rowData.getSize() + 1));
                    EventEditor.this.rowChanges = false;
                }
                if (ourEv.getEventType().equals((Object)CommonData.EventType.UNTIMED)) {
                    EventEditor.this.evOldSeq = ourEv.getSequenceNo();
                    EventEditor.this.evCurrentSeq.setText(Integer.toString(EventEditor.this.evOldSeq + 1));
                    ((SpinnerNumberModel)EventEditor.this.evSeqModel).setMaximum(Integer.valueOf(events.getNumberOfUntimed() + 1));
                }
                EventEditor.this.colorPanel.updatePaletteTable(EventEditor.this.ourGUI.getPreferences().getPalette(), true, EventEditor.this.colorPanel.getSelectedColorName());
                if (ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE_EVENT)) {
                    EventEditor.this.ourTimelineList = EventEditor.this.ourEventData.getListOfTimelines(true);
                    Event selectedTl = null;
                    selectedTl = EventEditor.this.evNewTimeline != null ? EventEditor.this.evNewTimeline : EventEditor.this.evOldTimeline;
                    Utils.updateCombos(EventEditor.this.ourTimelineList, selectedTl, EventEditor.this.evTimelineField);
                }
                EventEditor.this.mainTagsPanel.updateAvailableTags();
                EventEditor.this.incomingPanel.updateConnectionTable(EventEditor.this.ourGUI.getInput().getConnections(), true, ConnectionData.Direction.INCOMING, "");
                EventEditor.this.outgoingPanel.updateConnectionTable(EventEditor.this.ourGUI.getInput().getConnections(), true, ConnectionData.Direction.OUTGOING, "");
                EventEditor.this.ourEditorFrame.revalidate();
            }
        });
        this.errorCount = 0;
        LineBorder evPanelsBorder = new LineBorder(Color.lightGray, 3);
        FlowLayout flowLayoutRight = new FlowLayout(2);
        FlowLayout flowLayoutLeft = new FlowLayout(0);
        JPanel evRowPanel = new JPanel(flowLayoutLeft);
        if (ourEv.getEventType().equals((Object)CommonData.EventType.GENERAL_EVENT) || ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
            TitledBorder evRowTitle = new TitledBorder(evPanelsBorder, "Row", 1, 2);
            evRowPanel.setBorder(evRowTitle);
            this.evOldRowIdx = this.rowData.getRowOfEvent(ourEv);
            this.evCurrentRow.setText(Integer.toString(this.evOldRowIdx + 1));
            evRowPanel.add(this.evCurrentRowLabel);
            evRowPanel.add(this.evCurrentRow);
            boolean evOldOptimiseRow = this.isNew.equals((Object)CommonEditor.NewObject.NEW) ? this.ourGUI.getPreferences().getOptimiseRowsChoice() : ourEv.getFirstFit();
            this.evOptimiseRowBox.setSelected(evOldOptimiseRow);
            this.evRowSpinner.setValue(this.evOldRowIdx + 1);
            ((SpinnerNumberModel)this.evRowModel).setMaximum(Integer.valueOf(this.rowData.getSize() + 1));
            editor = this.evRowSpinner.getEditor();
            tf = ((JSpinner.DefaultEditor)editor).getTextField();
            tf.setColumns(3);
            this.evRowSpinner.setEnabled(false);
            if (!evOldOptimiseRow) {
                this.evRowSpinner.setEnabled(true);
            }
            evRowPanel.add(this.evOptimiseRowBox);
            evRowPanel.add(this.evRowNewLabel);
            evRowPanel.add(this.evRowSpinner);
            this.evOptimiseRowBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (EventEditor.this.evOptimiseRowBox.isSelected()) {
                        EventEditor.this.evRowSpinner.setEnabled(false);
                    } else {
                        EventEditor.this.evRowSpinner.setEnabled(true);
                    }
                }
            });
        }
        JPanel evSeqPanel = new JPanel(flowLayoutLeft);
        if (ourEv.getEventType().equals((Object)CommonData.EventType.UNTIMED)) {
            TitledBorder evRowTitle = new TitledBorder(evPanelsBorder, "Sequence Number", 1, 2);
            evSeqPanel.setBorder(evRowTitle);
            this.evCurrentSeq.setText(Integer.toString(this.evOldSeq + 1));
            evSeqPanel.add(this.evCurrentSeqLabel);
            evSeqPanel.add(this.evCurrentSeq);
            this.evSeqSpinner.setValue(this.evOldSeq + 1);
            ((SpinnerNumberModel)this.evSeqModel).setMaximum(Integer.valueOf(events.getNumberOfUntimed() + 1));
            editor = this.evSeqSpinner.getEditor();
            tf = ((JSpinner.DefaultEditor)editor).getTextField();
            tf.setColumns(3);
            this.evSeqSpinner.setEnabled(true);
            evSeqPanel.add(this.evSeqNewLabel);
            evSeqPanel.add(this.evSeqSpinner);
        }
        JPanel evTimelinePanel = new JPanel(flowLayoutLeft);
        if (ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE_EVENT)) {
            this.evOldTimeline = ourEv.getEventTimeline();
            TitledBorder evTimelinePanelTitle = new TitledBorder(evPanelsBorder, "Timeline", 1, 2);
            this.evNewTimeline = this.evOldTimeline;
            this.evTimelineField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int evNewTimelineIndex = EventEditor.this.evTimelineField.getSelectedIndex();
                    EventEditor.this.evNewTimeline = EventEditor.this.ourTimelineList.get(evNewTimelineIndex);
                }
            });
            evTimelinePanel.add(this.evTimelineField);
            evTimelinePanel.setBorder(evTimelinePanelTitle);
        }
        if (ourEv.getEventType() == CommonData.EventType.TIMELINE || ourEv.getEventType() == CommonData.EventType.TIMELINE_EVENT || ourEv.getEventType() == CommonData.EventType.GENERAL_EVENT) {
            JLabel evEarlyStartLabel = new JLabel("Earliest Start: ", 4);
            JLabel evLateStartLabel = new JLabel("Latest Start: ", 4);
            JLabel evEarlyEndLabel = new JLabel("Earliest End: ", 4);
            JLabel evLateEndLabel = new JLabel("Latest End: ", 4);
            LocalDate evOldEarlyStartDate = ourEv.getDates().getEarlyStartDate();
            LocalDate evOldLateStartDate = ourEv.getDates().getLateStartDate();
            LocalDate evOldEarlyEndDate = ourEv.getDates().getEarlyEndDate();
            LocalDate evOldLateEndDate = ourEv.getDates().getLateEndDate();
            String evOldEarlyStart = "";
            String evOldLateStart = "";
            String evOldEarlyEnd = "";
            String evOldLateEnd = "";
            if (evOldEarlyStartDate != null) {
                evOldEarlyStart = Utils.dayFormatter.format(evOldEarlyStartDate);
            }
            if (evOldLateStartDate != null) {
                evOldLateStart = Utils.dayFormatter.format(evOldLateStartDate);
            }
            if (evOldEarlyEndDate != null) {
                evOldEarlyEnd = Utils.dayFormatter.format(evOldEarlyEndDate);
            }
            if (evOldLateEndDate != null) {
                evOldLateEnd = Utils.dayFormatter.format(evOldLateEndDate);
            }
            this.evEarlyStartField.setText(evOldEarlyStart);
            this.evLateStartField.setText(evOldLateStart);
            this.evEarlyEndField.setText(evOldEarlyEnd);
            this.evLateEndField.setText(evOldLateEnd);
            JPanel evEStartPanel = new JPanel(flowLayoutLeft);
            evEStartPanel.add(evEarlyStartLabel);
            evEStartPanel.add(this.evEarlyStartField);
            JPanel evLStartPanel = new JPanel(flowLayoutLeft);
            evLStartPanel.add(evLateStartLabel);
            evLStartPanel.add(this.evLateStartField);
            JPanel evEEndPanel = new JPanel(flowLayoutLeft);
            evEEndPanel.add(evEarlyEndLabel);
            evEEndPanel.add(this.evEarlyEndField);
            JPanel evLEndPanel = new JPanel(flowLayoutLeft);
            evLEndPanel.add(evLateEndLabel);
            evLEndPanel.add(this.evLateEndField);
            this.evEarlyStartField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent f) {
                }

                @Override
                public void focusLost(FocusEvent f) {
                    String eStart = EventEditor.this.evEarlyStartField.getText();
                    String eStartYear = EventEditor.this.evEarlyStartField.getText();
                    if (!eStart.isEmpty() && eStart.matches("^[0-9]+[^-]") && EventEditor.this.evLateStartField.getText().isEmpty()) {
                        EventEditor.this.evEarlyStartField.setText(eStartYear + "-01-01");
                        EventEditor.this.evLateStartField.setText(eStartYear + "-12-31");
                    } else if (!eStart.isEmpty() && eStart.matches("^[0-9]+-[0-9]+$") && EventEditor.this.evLateStartField.getText().isEmpty()) {
                        String[] split = eStart.split("-");
                        eStartYear = split[0];
                        String eStartMonth = split[1];
                        int ultimo = 0;
                        try {
                            int y = Integer.parseInt(eStartYear);
                            int m = Integer.parseInt(eStartMonth);
                            YearMonth yearMonthObject = YearMonth.of(y, m);
                            ultimo = yearMonthObject.lengthOfMonth();
                        }
                        catch (NumberFormatException | DateTimeException n) {
                            JOptionPane.showMessageDialog(EventEditor.this.ourGUI, "Event Editor: invalid month or year in early start date field");
                        }
                        EventEditor.this.evEarlyStartField.setText(eStart + "-01");
                        EventEditor.this.evLateStartField.setText(eStart + "-" + String.valueOf(ultimo));
                    }
                }
            });
            this.evEarlyEndField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent f) {
                }

                @Override
                public void focusLost(FocusEvent f) {
                    String eEnd = EventEditor.this.evEarlyEndField.getText();
                    String eEndYear = EventEditor.this.evEarlyEndField.getText();
                    if (!eEnd.isEmpty() && eEnd.matches("^[0-9]+[^-]") && EventEditor.this.evLateEndField.getText().isEmpty()) {
                        EventEditor.this.evEarlyEndField.setText(eEndYear + "-01-01");
                        EventEditor.this.evLateEndField.setText(eEndYear + "-12-31");
                    } else if (!eEnd.isEmpty() && eEnd.matches("^[0-9]+-[0-9]+$") && EventEditor.this.evLateEndField.getText().isEmpty()) {
                        String[] split = eEnd.split("-");
                        eEndYear = split[0];
                        String eEndMonth = split[1];
                        int ultimo = 0;
                        try {
                            int y = Integer.parseInt(eEndYear);
                            int m = Integer.parseInt(eEndMonth);
                            YearMonth yearMonthObject = YearMonth.of(y, m);
                            ultimo = yearMonthObject.lengthOfMonth();
                        }
                        catch (NumberFormatException | DateTimeException n) {
                            JOptionPane.showMessageDialog(EventEditor.this.ourGUI, "Event Editor: invalid month or year in early end date field");
                        }
                        EventEditor.this.evEarlyEndField.setText(eEnd + "-01");
                        EventEditor.this.evLateEndField.setText(eEnd + "-" + String.valueOf(ultimo));
                    }
                }
            });
            this.evDatesPanel.setLayout(new GridLayout(0, 2));
            TitledBorder evDatesTitle = new TitledBorder(evPanelsBorder, "Dates", 1, 2);
            this.evDatesPanel.setBorder(evDatesTitle);
            this.evDatesPanel.add(evEStartPanel);
            this.evDatesPanel.add(evLStartPanel);
            this.evDatesPanel.add(evEEndPanel);
            this.evDatesPanel.add(evLEndPanel);
        }
        if (ourEv.getEventType() == CommonData.EventType.TIMELINE || ourEv.getEventType() == CommonData.EventType.TIMELINE_EVENT || ourEv.getEventType() == CommonData.EventType.GENERAL_EVENT) {
            if (ourEv.getIcon() != null) {
                Path evIconPath = Paths.get(ourEv.getIcon().toString(), new String[0]);
                this.evOldIconPath = evIconPath.toString();
                this.evIconField.setText(this.evOldIconPath);
            }
            if (ourEv.getIcon() != null) {
                this.evIconLabelImage.setIcon(ourEv.getIcon());
            }
            JButton evIconBrowse = new JButton("Browse");
            evIconBrowse.setPreferredSize(this.buttonLargeSize);
            evIconBrowse.setEnabled(true);
            evIconBrowse.setToolTipText("Find the new icon");
            evIconBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        File tmp;
                        Object evBrowsePath = EventEditor.this.evOldIconPath;
                        if (((String)evBrowsePath).equals("") && !(tmp = new File((String)(evBrowsePath = System.getProperty("user.home") + File.separator + "icons"))).exists()) {
                            evBrowsePath = System.getProperty("user.home");
                        }
                        JFileChooser evIconChooser = new JFileChooser((String)evBrowsePath);
                        evIconChooser.setDialogTitle("Choose an Icon");
                        int evIconChoice = evIconChooser.showOpenDialog(EventEditor.this.evEditorFrame);
                        if (evIconChoice == 0) {
                            File chosenFile = evIconChooser.getSelectedFile();
                            String evnewStartIconPath = chosenFile.getAbsolutePath();
                            EventEditor.this.evIconField.setText(evnewStartIconPath);
                            EventEditor.this.evIconLabelImage.setIcon(InputFileJSON.iconFromPathString(evnewStartIconPath));
                            EventEditor.this.evEditorFrame.pack();
                        }
                    }
                    catch (Throwable unforeseen) {
                        JOptionPane.showMessageDialog(EventEditor.this.ourGUI, "Unhandled Error!\n" + EventEditor.this.ourGUI.displayError(unforeseen));
                    }
                }
            });
            if (ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
                if (ourEv.getEndIcon() != null) {
                    this.evEndIconLabelImage.setIcon(ourEv.getEndIcon());
                }
                if (ourEv.getEndIcon() != null) {
                    Path evEndIconPath = Paths.get(ourEv.getEndIcon().toString(), new String[0]);
                    this.evOldEndIconPath = evEndIconPath.toString();
                    this.evEndIconField.setText(this.evOldEndIconPath);
                }
            }
            JButton evEndIconBrowse = new JButton("Browse");
            evEndIconBrowse.setPreferredSize(this.buttonLargeSize);
            evEndIconBrowse.setEnabled(true);
            evEndIconBrowse.setToolTipText("Find the new icon");
            evEndIconBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        File tmp;
                        Object evBrowsePath = EventEditor.this.evOldEndIconPath;
                        if (((String)evBrowsePath).equals("") && !(tmp = new File((String)(evBrowsePath = System.getProperty("user.home") + File.separator + "icons"))).exists()) {
                            evBrowsePath = System.getProperty("user.home");
                        }
                        JFileChooser evEndIconChooser = new JFileChooser((String)evBrowsePath);
                        evEndIconChooser.setDialogTitle("Choose an Icon");
                        int evEndIconChoice = evEndIconChooser.showOpenDialog(EventEditor.this.evEditorFrame);
                        if (evEndIconChoice == 0) {
                            File chosenFile = evEndIconChooser.getSelectedFile();
                            String evnewEndIconPath = chosenFile.getAbsolutePath();
                            EventEditor.this.evEndIconField.setText(evnewEndIconPath);
                            EventEditor.this.evEndIconLabelImage.setIcon(InputFileJSON.iconFromPathString(evnewEndIconPath));
                            EventEditor.this.evEndIconLabelImage.setVisible(true);
                            EventEditor.this.evEditorFrame.pack();
                        }
                    }
                    catch (Throwable unforeseen) {
                        JOptionPane.showMessageDialog(EventEditor.this.ourGUI, "Timeline Editor: Unhandled Error!\n" + EventEditor.this.ourGUI.displayError(unforeseen));
                    }
                }
            });
            TitledBorder evIconPanelTitle = new TitledBorder(evPanelsBorder, "Icon", 1, 2);
            JPanel evIconPanel = new JPanel(flowLayoutRight);
            JPanel evEndIconPanel = new JPanel(flowLayoutRight);
            evIconPanel.add(this.evIconLabel);
            evIconPanel.add(this.evIconField);
            evIconPanel.add(this.evIconLabelImage);
            evIconPanel.add(evIconBrowse);
            if (ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
                evEndIconPanel.add(this.evEndIconLabel);
                evEndIconPanel.add(this.evEndIconField);
                evEndIconPanel.add(this.evEndIconLabelImage);
                evEndIconPanel.add(evEndIconBrowse);
            }
            this.evIconsPanel = Box.createVerticalBox();
            this.evIconsPanel.setBorder(evIconPanelTitle);
            this.evIconsPanel.add(evIconPanel);
            if (ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
                this.evIconsPanel.add(evEndIconPanel);
            }
        }
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventEditor.this.okApply();
                EventEditor.this.okApply(ourEv);
                if (EventEditor.this.errorCount == 0) {
                    EventEditor.this.evEditorFrame.dispose();
                    ourEv.setEditor(null);
                    if (EventEditor.this.isNew.equals((Object)CommonEditor.NewObject.EXISTING)) {
                        EventEditor.this.ourGUI.getWindowManager().closeWindow();
                    }
                    EventEditor.this.ourGUI.setFileSaved(false);
                    EventEditor.this.ourGUI.getFilterEditor().doFilter();
                    EventEditor.this.ourGUI.setRange();
                    EventEditor.this.ourGUI.panLimits();
                    EventEditor.this.ourGUI.menuLogic();
                }
                EventEditor.this.evDisplay.repaint();
            }
        });
        this.buttonApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventEditor.this.okApply();
                EventEditor.this.okApply(ourEv);
                if (EventEditor.this.errorCount == 0) {
                    EventEditor.this.ourGUI.setFileSaved(false);
                    EventEditor.this.evEditor.setTitle(String.valueOf((Object)ourEv.getEventType()) + " Editor: " + Utils.flatline(EventEditor.this.newName));
                }
                EventEditor.this.ourGUI.getFilterEditor().doFilter();
                EventEditor.this.ourGUI.setRange();
                EventEditor.this.ourGUI.panLimits();
                EventEditor.this.ourGUI.menuLogic();
                EventEditor.this.evDisplay.repaint();
            }
        });
        if (this.isNew.equals((Object)CommonEditor.NewObject.NEW)) {
            this.buttonDelete.setEnabled(false);
        } else {
            this.buttonDelete.setEnabled(true);
        }
        this.buttonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent del) {
                String connectionsList = EventEditor.this.ourConnectionData.getConnectedEvTlNamesOfEvent(ourEv);
                if (!connectionsList.equals("")) {
                    JOptionPane.showMessageDialog(EventEditor.this.evEditorFrame, "Event Editor: You must delete or reroute the following connections before you can delete this event:\n" + connectionsList);
                } else {
                    if (!EventEditor.this.ourEventData.deleteEvent(ourEv)) {
                        JOptionPane.showMessageDialog(EventEditor.this.evEditorFrame, "Event Editor: Failed to remove event");
                    }
                    if (ourEv.getEventType() == CommonData.EventType.TIMELINE || ourEv.getEventType() == CommonData.EventType.GENERAL_EVENT) {
                        EventEditor.this.rowData.removeEventFromRow(ourEv, EventEditor.this.rowData.getRowOfEvent(ourEv));
                    }
                    if (ourEv.getEventType() == CommonData.EventType.TIMELINE_EVENT) {
                        EventData tmpTlEvents = ourEv.getEventTimeline().getTlEventList();
                        tmpTlEvents.deleteEvent(ourEv);
                    }
                    EventEditor.this.evEditorFrame.dispose();
                    ourEv.setEditor(null);
                    EventEditor.this.ourGUI.getWindowManager().closeWindow();
                    EventEditor.this.ourGUI.setRange();
                    EventEditor.this.ourGUI.panLimits();
                    EventEditor.this.evDisplay.repaint();
                    EventEditor.this.ourGUI.setFileSaved(false);
                    EventEditor.this.ourGUI.menuLogic();
                }
            }
        });
        if (ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
            this.buttonNewSeg.setToolTipText("Create new segment on this time line");
            if (this.isNew.equals((Object)CommonEditor.NewObject.NEW)) {
                this.buttonNewSeg.setEnabled(false);
            }
            this.buttonNewSeg.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Segment newSegment = new Segment(EventEditor.this.ourGUI.getPreferences(), ourEv, "Segment 1", EventEditor.this.ourGUI.getPreferences().defaultSegFG, EventEditor.this.ourGUI.getPreferences().defaultSegBGouterStart, EventEditor.this.ourGUI.getPreferences().defaultSegBGouterEnd, EventEditor.this.ourGUI.getPreferences().defaultBGinner, new Dates(null, null, null, null), 1);
                    SegmentEditor newSegmentEditor = new SegmentEditor(EventEditor.this.ourGUI, newSegment, ourEv, EventEditor.this.evDisplay, CommonEditor.NewObject.NEW);
                    EventEditor.this.ourGUI.getWindowManager().positionWindow(newSegmentEditor, WindowManager.ScreenSide.CASCADE_TR);
                }
            });
            this.buttonNewTlEvent.setToolTipText("Create a new timeline event on this timeline");
            if (this.isNew.equals((Object)CommonEditor.NewObject.NEW)) {
                this.buttonNewTlEvent.setEnabled(false);
            }
            this.buttonNewTlEvent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Event newEvent = new Event(CommonData.EventType.TIMELINE_EVENT, "New Event", EventEditor.this.ourGUI.getPreferences().getPalette().getColorName(0), 0, new Dates(null, null, null, null), null, null, ourEv);
                    EventEditor newEventEditor = new EventEditor(EventEditor.this.ourGUI, newEvent, EventEditor.this.ourGUI.getTimePanel(), EventEditor.this.ourGUI.getInput().getEventData(), EventEditor.this.ourGUI.getInput().getConnections(), CommonEditor.NewObject.NEW);
                    EventEditor.this.ourGUI.getWindowManager().positionWindow(newEventEditor, WindowManager.ScreenSide.CASCADE_TR);
                }
            });
        }
        Box generalTab = Box.createVerticalBox();
        generalTab.add(this.namePanel);
        if (ourEv.getEventType().equals((Object)CommonData.EventType.GENERAL_EVENT) || ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
            generalTab.add(evRowPanel);
        }
        if (ourEv.getEventType().equals((Object)CommonData.EventType.UNTIMED)) {
            generalTab.add(evSeqPanel);
        }
        if (ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE_EVENT)) {
            generalTab.add(evTimelinePanel);
        }
        if (ourEv.getEventType().equals((Object)CommonData.EventType.GENERAL_EVENT) || ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE_EVENT) || ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
            generalTab.add(this.evDatesPanel);
        }
        generalTab.add(this.colorPanel);
        if (ourEv.getEventType().equals((Object)CommonData.EventType.GENERAL_EVENT) || ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE_EVENT) || ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
            generalTab.add(this.evIconsPanel);
        }
        this.newOutgoingButton.setToolTipText(this.newOutgoingTip);
        this.newIncomingButton.setToolTipText(this.newIncomingTip);
        this.deleteIncomingButton.setToolTipText(this.deleteTip);
        this.deleteOutgoingButton.setToolTipText(this.deleteTip);
        JPanel incomingButtonsPanel = new JPanel(flowLayoutRight);
        incomingButtonsPanel.add(this.newIncomingButton);
        incomingButtonsPanel.add(this.deleteIncomingButton);
        Box incomingConnectionsPanel = Box.createVerticalBox();
        TitledBorder incomingTitle = new TitledBorder(this.panelsBorder, "Incoming Connections", 1, 2);
        incomingConnectionsPanel.setBorder(incomingTitle);
        this.incomingPanel = new ConnectionsPanel(this.ourGUI, this.evEditor, this.ourGUI.getInput().getConnections(), ourEv, ConnectionData.Direction.INCOMING);
        incomingConnectionsPanel.add(incomingButtonsPanel);
        incomingConnectionsPanel.add(this.incomingPanel);
        JPanel outgoingButtonsPanel = new JPanel(flowLayoutRight);
        outgoingButtonsPanel.add(this.newOutgoingButton);
        outgoingButtonsPanel.add(this.deleteOutgoingButton);
        Box outgoingConnectionsPanel = Box.createVerticalBox();
        TitledBorder outgoingTitle = new TitledBorder(this.panelsBorder, "Outgoing Connections", 1, 2);
        outgoingConnectionsPanel.setBorder(outgoingTitle);
        this.outgoingPanel = new ConnectionsPanel(this.ourGUI, this.evEditor, this.ourGUI.getInput().getConnections(), ourEv, ConnectionData.Direction.OUTGOING);
        outgoingConnectionsPanel.add(outgoingButtonsPanel);
        outgoingConnectionsPanel.add(this.outgoingPanel);
        this.connectionsPanel = Box.createVerticalBox();
        this.connectionsPanel.add(incomingConnectionsPanel);
        this.connectionsPanel.add(outgoingConnectionsPanel);
        this.newIncomingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cnIdx = EventEditor.this.makeUniqueIndex(EventEditor.this.ourGUI.getInput().getEventData().getEventByIndex(0), ourEv);
                Connection newConnection = new Connection(cnIdx, "", EventEditor.this.ourGUI.getPreferences().getPalette().getColorName(0), EventEditor.this.ourGUI.getInput().getEventData().getEventByIndex(0), null, null, ourEv, null, null, Connection.LineType.DIRECT, Connection.DashType.PLAIN, Connection.FwdArrow.NO_FWD_ARROW, Connection.BckArrow.NO_BCK_ARROW, Connection.Curve.STRAIGHT, EventEditor.this.ourGUI.getPreferences().getBezierCtrlX(), EventEditor.this.ourGUI.getPreferences().getBezierCtrlY(), Connection.ShowNameAtSrc.NO_NAME_AT_SRC, Connection.INITIAL_CON_NAME_SRC, Connection.ShowNameAtDst.NO_NAME_AT_DST, Connection.INITIAL_CON_NAME_DST);
                ConnectionEditor newConnectionEditor = new ConnectionEditor(EventEditor.this.ourGUI, newConnection, EventEditor.this.ourGUI.getInput().getEventData(), EventEditor.this.ourGUI.getInput().getConnections(), CommonEditor.NewObject.NEW);
                EventEditor.this.ourGUI.getWindowManager().positionWindow(newConnectionEditor, WindowManager.ScreenSide.CASCADE_TR);
            }
        });
        this.newOutgoingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cnIdx = EventEditor.this.makeUniqueIndex(EventEditor.this.ourGUI.getInput().getEventData().getEventByIndex(0), ourEv);
                Connection newConnection = new Connection(cnIdx, "", EventEditor.this.ourGUI.getPreferences().getPalette().getColorName(0), ourEv, null, null, EventEditor.this.ourGUI.getInput().getEventData().getEventByIndex(0), null, null, Connection.LineType.DIRECT, Connection.DashType.PLAIN, Connection.FwdArrow.NO_FWD_ARROW, Connection.BckArrow.NO_BCK_ARROW, Connection.Curve.STRAIGHT, EventEditor.this.ourGUI.getPreferences().getBezierCtrlX(), EventEditor.this.ourGUI.getPreferences().getBezierCtrlY(), Connection.ShowNameAtSrc.NO_NAME_AT_SRC, Connection.INITIAL_CON_NAME_SRC, Connection.ShowNameAtDst.NO_NAME_AT_DST, Connection.INITIAL_CON_NAME_DST);
                ConnectionEditor newConnectionEditor = new ConnectionEditor(EventEditor.this.ourGUI, newConnection, EventEditor.this.ourGUI.getInput().getEventData(), EventEditor.this.ourGUI.getInput().getConnections(), CommonEditor.NewObject.NEW);
                EventEditor.this.ourGUI.getWindowManager().positionWindow(newConnectionEditor, WindowManager.ScreenSide.CASCADE_TR);
            }
        });
        this.deleteIncomingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventEditor.this.deleteEventsConnections(EventEditor.this.incomingPanel);
                EventEditor.this.incomingPanel.updateConnectionTable(EventEditor.this.ourGUI.getInput().getConnections(), true, ConnectionData.Direction.INCOMING, "");
            }
        });
        this.deleteOutgoingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventEditor.this.deleteEventsConnections(EventEditor.this.outgoingPanel);
                EventEditor.this.outgoingPanel.updateConnectionTable(EventEditor.this.ourGUI.getInput().getConnections(), true, ConnectionData.Direction.OUTGOING, "");
            }
        });
        JPanel okPanel = new JPanel();
        okPanel.add(this.buttonOK);
        okPanel.add(this.buttonCancel);
        okPanel.add(this.buttonDelete);
        if (ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
            okPanel.add(this.buttonNewSeg);
            okPanel.add(this.buttonNewTlEvent);
        }
        okPanel.add(this.buttonApply);
        this.tabbedPane.addTab("Data", null, generalTab, "General event data");
        this.tabbedPane.addTab("MetaData", null, this.metaDataPanel, "Event metadata");
        this.tabbedPane.addTab("Connections", null, this.connectionsPanel, "Incoming and Outgoing connections");
        if (this.isNew.equals((Object)CommonEditor.NewObject.NEW)) {
            this.tabbedPane.setSelectedComponent(generalTab);
        } else {
            this.tabbedPane.setSelectedComponent(this.metaDataPanel);
        }
        JPanel allPane = new JPanel();
        allPane.setLayout(new BorderLayout());
        JScrollPane allScroll = new JScrollPane(allPane);
        allPane.add((Component)this.tabbedPane, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)allScroll, "Center");
        this.add((Component)okPanel, "Last");
        this.setTitle(String.valueOf((Object)ourEv.getEventType()) + " Editor: " + Utils.flatline(ourEv.getName()));
        this.toFront();
        this.pack();
    }

    private void deleteEventsConnections(ConnectionsPanel cnPanel) {
        Connection[] tmp = cnPanel.getSelectedConnections();
        Object confirmList = "";
        int i = 0;
        while (i < tmp.length) {
            Connection nextCn = tmp[i];
            if (nextCn != null) {
                confirmList = (String)confirmList + nextCn.getID() + "\n";
            }
            ++i;
        }
        int deleteSelection = JOptionPane.showConfirmDialog(this.ourGUI, confirmList, "Delete the following connections?", 0, 3);
        if (deleteSelection != 0) {
            return;
        }
        int i2 = 0;
        while (i2 < tmp.length) {
            Connection nextCn = tmp[i2];
            if (nextCn != null) {
                if (!this.ourGUI.getInput().getConnections().deleteConnection(tmp[i2]).booleanValue()) {
                    JOptionPane.showMessageDialog(this.ourEditorFrame, "Event Editor: Delete incoming connection failed to remove connection " + nextCn.getID());
                } else {
                    if (nextCn.getEditor() != null) {
                        nextCn.getEditor().dispose();
                    }
                    this.ourGUI.getWindowManager().closeWindow();
                }
            }
            ++i2;
        }
        this.ourGUI.getTimePanel().repaint();
        this.ourGUI.setFileSaved(false);
    }

    public void setRowChanges() {
        this.rowChanges = true;
    }

    public void setNewRow(int n) {
        this.evRowSpinner.setValue(n);
    }

    public void setFirstFit(boolean f) {
        this.evOptimiseRowBox.setSelected(f);
    }

    public void enDisableDeleteIncoming(boolean set) {
        this.deleteIncomingButton.setEnabled(set);
    }

    public void enDisableDeleteOutgoing(boolean set) {
        this.deleteOutgoingButton.setEnabled(set);
    }

    private void okApply(Event ourEv) {
        if (this.nameField.getText().equals("")) {
            this.errorMsg = String.valueOf(this.errorMsg) + "\nEvent Editor: Event name cannot be blank";
            ++this.errorCount;
        } else if (this.nameField.getText().matches(".*[;\\?%*:|\"<>=].*")) {
            this.errorMsg = String.valueOf(this.errorMsg) + "\nEvent Editor: Event name cannot contain any of ; \\ ? % * : | \" < > , =";
            ++this.errorCount;
        } else if (ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE) && this.nameField.getText().matches(".*\\n.*")) {
            this.errorMsg = String.valueOf(this.errorMsg) + "\nEvent Editor: Timeline event names can only have one line.";
            ++this.errorCount;
        } else {
            this.newName = Utils.encodeEscapes(this.nameField.getText());
        }
        Event tmpEv = this.ourEventData.getEventByName(this.newName);
        if (tmpEv != null && tmpEv.getEditor() != this.ourEditor) {
            this.errorMsg = String.valueOf(this.errorMsg) + "\nEvent Editor: Event name must be unique";
            ++this.errorCount;
        }
        if (ourEv.getEventType().equals((Object)CommonData.EventType.GENERAL_EVENT) || ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE_EVENT) || ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
            this.evNewEarlyStartDate = null;
            if (this.evEarlyStartField.getText().equals("")) {
                this.errorMsg = String.valueOf(this.errorMsg) + "\nEvent Editor: Event earliest start date cannot be blank";
                ++this.errorCount;
            } else {
                try {
                    this.evNewEarlyStartDate = LocalDate.parse(this.evEarlyStartField.getText(), Utils.dayFormatter);
                }
                catch (DateTimeParseException f) {
                    this.evNewEarlyStartDate = null;
                }
                if (this.evNewEarlyStartDate == null) {
                    this.errorMsg = this.errorMsg + "\nEvent Editor: Invalid event earliest start date - " + this.evCorrectDate;
                    ++this.errorCount;
                }
            }
            this.evNewLateStartDate = null;
            if (!this.evLateStartField.getText().equals("")) {
                try {
                    this.evNewLateStartDate = LocalDate.parse(this.evLateStartField.getText(), Utils.dayFormatter);
                }
                catch (DateTimeParseException f) {
                    this.evNewLateStartDate = null;
                }
                if (this.evNewLateStartDate == null) {
                    this.errorMsg = this.errorMsg + "\nEvent Editor: Invalid event latest start date - " + this.evCorrectDate;
                    ++this.errorCount;
                }
            }
            this.evNewEarlyEndDate = null;
            if (this.evEarlyEndField.getText().equals("") && ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
                this.errorMsg = String.valueOf(this.errorMsg) + "\nEvent Editor: Event earliest end date cannot be blank";
                ++this.errorCount;
            }
            if (!this.evEarlyEndField.getText().equals("")) {
                try {
                    this.evNewEarlyEndDate = LocalDate.parse(this.evEarlyEndField.getText(), Utils.dayFormatter);
                }
                catch (DateTimeParseException f) {
                    this.evNewEarlyEndDate = null;
                }
                if (this.evNewEarlyEndDate == null) {
                    this.errorMsg = this.errorMsg + "\nEvent Editor: Invalid event earliest end date - " + this.evCorrectDate;
                    ++this.errorCount;
                }
            }
            this.evNewLateEndDate = null;
            if (!this.evLateEndField.getText().equals("")) {
                try {
                    this.evNewLateEndDate = LocalDate.parse(this.evLateEndField.getText(), Utils.dayFormatter);
                }
                catch (DateTimeParseException f) {
                    this.evNewLateEndDate = null;
                }
                if (this.evNewLateEndDate == null) {
                    this.errorMsg = this.errorMsg + "\nEvent Editor: Invalid event latest end date " + this.evCorrectDate;
                    ++this.errorCount;
                }
            }
            if (this.evNewLateEndDate != null && this.evNewEarlyEndDate == null) {
                this.errorMsg = String.valueOf(this.errorMsg) + "\nEvent Editor: event latest end date cannot be given without an early end date";
                ++this.errorCount;
            }
            if (this.evNewEarlyStartDate != null && this.evNewLateStartDate != null && this.evNewLateStartDate.isBefore(this.evNewEarlyStartDate)) {
                this.errorMsg = String.valueOf(this.errorMsg) + "\nEvent Editor: Latest start date cannot be before earliest start date";
                ++this.errorCount;
            }
            if (this.evNewEarlyEndDate != null && this.evNewLateEndDate != null && this.evNewLateEndDate.isBefore(this.evNewEarlyEndDate)) {
                this.errorMsg = String.valueOf(this.errorMsg) + "\nEvent Editor: Latest end date cannot be before earliest end date";
                ++this.errorCount;
            }
            LocalDate tmpStart = this.evNewEarlyStartDate;
            if (this.evNewLateStartDate != null) {
                tmpStart = this.evNewLateStartDate;
            }
            if (this.evNewEarlyEndDate != null && tmpStart != null && this.evNewEarlyEndDate.isBefore(tmpStart)) {
                this.errorMsg = String.valueOf(this.errorMsg) + "\nEvent Editor: End dates cannot be before start dates";
                ++this.errorCount;
            }
            if (this.errorCount == 0 && (ourEv.getEventType().equals((Object)CommonData.EventType.GENERAL_EVENT) || ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE))) {
                this.evNewRowIdx = (Integer)this.evRowSpinner.getValue() - 1;
                this.evNewOptimiseRow = this.evOptimiseRowBox.isSelected();
                LocalDate realEnd = ourEv.getDates().getRealEndDateOf(this.evNewEarlyStartDate, this.evNewLateStartDate, this.evNewEarlyEndDate, this.evNewLateEndDate);
                if (this.isNew.equals((Object)CommonEditor.NewObject.NEW)) {
                    if (this.evNewOptimiseRow) {
                        this.evNewRowIdx = this.rowData.getFirstRowWithFreeDates(this.evNewEarlyStartDate, realEnd, this.errorCount);
                    } else if (this.evNewRowIdx < 0 || this.evNewRowIdx > this.rowData.getSize() - 1) {
                        this.evNewRowIdx = this.rowData.getSize();
                    } else if (!this.rowData.areEvDatesFreeInRow(ourEv, this.evNewEarlyStartDate, realEnd, this.ourGUI.getPreferences().getRowMinXGap(), this.evNewRowIdx)) {
                        this.errorMsg = String.valueOf(this.errorMsg) + "\n Event Editor: Event will not fit in given row";
                        ++this.errorCount;
                    }
                } else if (this.evOptimiseRowBox.isSelected()) {
                    int tmpRow = this.rowData.getFirstRowWithFreeDates(this.evNewEarlyStartDate, realEnd, this.ourGUI.getPreferences().getRowMinXGap());
                    if (this.evOldRowIdx < 0 || tmpRow < this.evOldRowIdx) {
                        this.evNewRowIdx = tmpRow;
                    }
                } else {
                    this.evNewRowIdx = (Integer)this.evRowSpinner.getValue() - 1;
                    if (this.evNewRowIdx == -1) {
                        this.evNewRowIdx = this.rowData.getSize();
                    }
                    if (this.evNewRowIdx < this.rowData.getSize() && !this.rowData.areEvDatesFreeInRow(ourEv, this.evNewEarlyStartDate, realEnd, this.ourGUI.getPreferences().getRowMinXGap(), this.evNewRowIdx)) {
                        this.errorMsg = String.valueOf(this.errorMsg) + "\n Event Editor: Event will not fit in given row";
                        ++this.errorCount;
                    }
                }
            }
        }
        try {
            if (ourEv.getEventType().equals((Object)CommonData.EventType.UNTIMED)) {
                this.evNewSeq = (Integer)this.evSeqSpinner.getValue() - 1;
                List<Event> untimedEventList = this.ourGUI.getInput().getEventData().getListOfUntimedEvents(true);
                EventData.sortEventsBySequence(untimedEventList);
                int i = this.evNewSeq;
                while (i < untimedEventList.size()) {
                    Event ev = untimedEventList.get(i);
                    ev.setSequenceNo(i + 1);
                    ++i;
                }
                ourEv.setSequenceNo(this.evNewSeq);
                EventData.sortEventsBySequence(untimedEventList);
                i = 0;
                while (i < untimedEventList.size()) {
                    Event ev = untimedEventList.get(i);
                    ev.setSequenceNo(i);
                    ++i;
                }
                this.evCurrentSeq.setText(String.valueOf(ourEv.getSequenceNo() + 1));
            }
            if (ourEv.getEventType().equals((Object)CommonData.EventType.GENERAL_EVENT) || ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE_EVENT) || ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
                ImageIcon tmpIcon = new ImageIcon();
                if (!this.evIconField.getText().equals("")) {
                    tmpIcon = InputFileJSON.iconFromPathString(this.evIconField.getText());
                    this.evIconLabelImage.setIcon(tmpIcon);
                    this.evIconLabelImage.setVisible(true);
                    if (tmpIcon == null) {
                        this.errorMsg = String.valueOf(this.errorMsg) + "\nTimeline Editor: Invalid start icon file";
                        ++this.errorCount;
                    } else {
                        this.evNewIconImage = tmpIcon;
                    }
                } else {
                    this.evNewIconImage = null;
                }
                if (ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
                    if (!this.evEndIconField.getText().equals("")) {
                        tmpIcon = InputFileJSON.iconFromPathString(this.evEndIconField.getText());
                        this.evEndIconLabelImage.setIcon(tmpIcon);
                        this.evEndIconLabelImage.setVisible(true);
                        if (tmpIcon == null) {
                            this.errorMsg = String.valueOf(this.errorMsg) + "\nTimeline Editor: Invalid end icon file";
                            ++this.errorCount;
                        } else {
                            this.evNewEndIconImage = tmpIcon;
                        }
                    } else {
                        this.evNewEndIconImage = null;
                    }
                }
            }
            if (this.errorCount != 0) {
                JOptionPane.showMessageDialog(this.evEditorFrame, this.errorMsg);
            }
            if (this.errorCount == 0) {
                ourEv.setName(this.newName);
                if (ourEv.getEventType().equals((Object)CommonData.EventType.GENERAL_EVENT) || ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE_EVENT) || ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
                    ourEv.setDates(new Dates(this.evNewEarlyStartDate, this.evNewLateStartDate, this.evNewEarlyEndDate, this.evNewLateEndDate));
                    if ((ourEv.getEventType().equals((Object)CommonData.EventType.GENERAL_EVENT) || ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE)) && this.evNewRowIdx != this.evOldRowIdx) {
                        boolean result;
                        if (this.evNewRowIdx > this.rowData.getSize() - 1) {
                            this.rowData.insertRow(new Row(), this.evNewRowIdx);
                        }
                        if (this.isNew.equals((Object)CommonEditor.NewObject.EXISTING) && this.evOldRowIdx != -1) {
                            this.rowData.removeEventFromRow(ourEv, this.evOldRowIdx);
                        }
                        if ((ourEv.getEventType().equals((Object)CommonData.EventType.GENERAL_EVENT) || ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE)) && !(result = this.rowData.addEventToRow(ourEv, this.ourGUI.getPreferences().getRowMinXGap(), this.evNewRowIdx))) {
                            JOptionPane.showMessageDialog(this.evEditorFrame, "Event will not fit in row");
                        }
                    }
                    if (ourEv.getEventType().equals((Object)CommonData.EventType.GENERAL_EVENT) || ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
                        this.evRowSpinner.setValue(this.evNewRowIdx + 1);
                        this.evCurrentRow.setText(Integer.toString(this.evNewRowIdx + 1));
                        ((SpinnerNumberModel)this.evRowModel).setMaximum(Integer.valueOf(this.rowData.getSize() + 1));
                        ourEv.setFirstFit(this.evNewOptimiseRow);
                    }
                }
                if (ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE_EVENT)) {
                    if (this.isNew.equals((Object)CommonEditor.NewObject.NEW)) {
                        if (this.evNewTimeline.getTlEventList() == null) {
                            this.evNewTimeline.setTlEventList(new EventData());
                        }
                        this.evNewTimeline.getTlEventList().addEvent(ourEv);
                        ourEv.setEventTimeline(this.evNewTimeline);
                        ourEv.setEditor(this.evEditor);
                    } else if (this.evOldTimeline != this.evNewTimeline) {
                        if (this.evNewTimeline.getTlEventList() == null) {
                            this.evNewTimeline.setTlEventList(new EventData());
                        }
                        this.evNewTimeline.getTlEventList().addEvent(ourEv);
                        if (this.evOldTimeline != null) {
                            this.evOldTimeline.getTlEventList().deleteEvent(ourEv);
                        }
                        ourEv.setEventTimeline(this.evNewTimeline);
                    }
                }
                if (this.isNew.equals((Object)CommonEditor.NewObject.NEW) && (ourEv.getEventType().equals((Object)CommonData.EventType.GENERAL_EVENT) || ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE_EVENT) || ourEv.getEventType().equals((Object)CommonData.EventType.UNTIMED))) {
                    this.ourEventData.addEvent(ourEv);
                    ourEv.setEditor(this.evEditor);
                }
                if (this.isNew.equals((Object)CommonEditor.NewObject.NEW) && ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
                    this.ourEventData.addEvent(ourEv);
                    ourEv.setEditor(this.evEditor);
                }
                this.ourEventData.sortEventsByStart();
                if (ourEv.getEventType() == CommonData.EventType.TIMELINE_EVENT && ourEv.getEventTimeline().getTlEventList() != null) {
                    ourEv.getEventTimeline().getTlEventList().sortEventsByStart();
                }
                ourEv.setColor(this.newColor);
                if (ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE) || ourEv.getEventType().equals((Object)CommonData.EventType.GENERAL_EVENT) || ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE_EVENT)) {
                    ourEv.setIcon(this.evNewIconImage);
                    if (this.evNewIconImage == null) {
                        this.evIconLabelImage.setVisible(false);
                    } else {
                        this.evIconLabelImage.setVisible(true);
                    }
                    if (ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
                        ourEv.setEndIcon(this.evNewEndIconImage);
                        if (this.evNewEndIconImage == null) {
                            this.evEndIconLabelImage.setVisible(false);
                        } else {
                            this.evEndIconLabelImage.setVisible(true);
                        }
                    }
                }
                this.evOldTimeline = this.evNewTimeline;
                this.evOldRowIdx = this.evNewRowIdx;
                this.evOldSeq = this.evNewSeq;
                this.isNew = CommonEditor.NewObject.EXISTING;
                TagList updatedTags = this.mainTagsPanel.getNewTagList();
                ourEv.setTags(updatedTags);
                ourEv.setDescription(this.newDescription);
                if (this.linkDialogRan) {
                    ourEv.setLinks(this.newLinks);
                    this.linkDialogRan = false;
                }
                if (ourEv.getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
                    this.buttonNewSeg.setEnabled(true);
                    this.buttonNewTlEvent.setEnabled(true);
                }
            }
        }
        catch (Throwable unforeseen) {
            JOptionPane.showMessageDialog(this.evEditorFrame, "Event Editor: Unhandled Error!\n" + this.ourGUI.displayError(unforeseen));
        }
    }

    private String makeUniqueIndex(Event src, Event dst) {
        int index = 1;
        boolean conflict = true;
        while (conflict) {
            Connection tmpCn = this.ourConnectionData.getConnectionByID(Connection.makeID(src.getName(), String.valueOf(index), dst.getName()));
            if (tmpCn != null) {
                ++index;
                continue;
            }
            conflict = false;
        }
        return String.valueOf(index);
    }
}

