/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CDgui;
import culturalDynamics.CommonData;
import culturalDynamics.ConnectionData;
import culturalDynamics.Dates;
import culturalDynamics.EventData;
import culturalDynamics.Segment;
import culturalDynamics.SegmentList;
import culturalDynamics.Utils;
import java.awt.geom.Rectangle2D;
import java.nio.file.Paths;
import java.util.List;
import javax.swing.ImageIcon;
import org.json.JSONWriter;

class Event
extends CommonData {
    private static final String INITIAL_POPUP_WIDTH = "750";
    private static final String INITIAL_POPUP_HEIGHT = "450";
    private CommonData.EventType eType;
    private boolean firstFit;
    private int sequenceNo;
    private Dates dates;
    private ImageIcon icon;
    private ImageIcon endIcon;
    private Event timeline;
    private SegmentList segmentList;
    private EventData eventList;
    private final int[] position = new int[2];
    private Rectangle2D nameBounds;

    Event(CommonData.EventType eType, String name, String color, int seq, Dates datesIn, ImageIcon sIcon, ImageIcon eIcon, Event timeline) {
        super(name, color);
        this.eType = eType;
        this.sequenceNo = seq;
        this.dates = datesIn;
        this.icon = sIcon;
        this.endIcon = eIcon;
        this.timeline = timeline;
        this.nameBounds = new Rectangle2D.Double(0.0, 0.0, 20.0, 20.0);
    }

    public String getID() {
        return super.getName();
    }

    public CommonData.EventType getEventType() {
        return this.eType;
    }

    public String getEventTypeAsName() {
        return this.eType.name();
    }

    public void setEventType(CommonData.EventType t) {
        this.eType = t;
    }

    public int getSequenceNo() {
        if (this.eType != CommonData.EventType.UNTIMED) {
            System.out.println("Can't get sequence number for non-Untimed event!");
            return 0;
        }
        return this.sequenceNo;
    }

    public void setSequenceNo(int seq) {
        int newSeq = seq;
        if (this.eType != CommonData.EventType.UNTIMED) {
            System.out.println("Can't set sequence number for non-Untimed event!");
            newSeq = 0;
        }
        this.sequenceNo = newSeq;
    }

    public boolean getFirstFit() {
        return this.firstFit;
    }

    public void setFirstFit(boolean firstFit) {
        this.firstFit = firstFit;
    }

    public void setDates(Dates newDates) {
        this.dates = newDates;
    }

    public Dates getDates() {
        return this.dates;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
    }

    public ImageIcon getEndIcon() {
        return this.endIcon;
    }

    public void setEndIcon(ImageIcon e) {
        this.endIcon = e;
    }

    public Event getEventTimeline() {
        return this.timeline;
    }

    public void setEventTimeline(Event tl) {
        this.timeline = tl;
    }

    public SegmentList getTlSegmentList() {
        return this.segmentList;
    }

    public void setTlSegmentList(SegmentList segments) {
        this.segmentList = segments;
    }

    public EventData getTlEventList() {
        return this.eventList;
    }

    public void setTlEventList(EventData eList) {
        this.eventList = eList;
    }

    public List<Event> getListOfTlEvents(boolean sort) {
        List<Event> result = null;
        if (this.eventList != null && this.eventList.getTotalNumberOfEvents() > 0) {
            result = this.eventList.getListOfAllEvents(sort);
        }
        return result;
    }

    public int[] getPosition() {
        return this.position;
    }

    public int getPositionX() {
        return this.position[0];
    }

    public int getPositionY() {
        return this.position[1];
    }

    public void setPosition(int x, int y) {
        this.position[0] = x;
        this.position[1] = y;
    }

    public Rectangle2D getNameBounds() {
        return this.nameBounds;
    }

    public void setNameBounds(Rectangle2D nameBounds) {
        this.nameBounds = nameBounds;
    }

    public boolean isClicked(double mouseX, double mouseY) {
        return this.nameBounds != null && this.nameBounds.contains(mouseX, mouseY);
    }

    public void toJSON(JSONWriter writer, CDgui mainGUI) {
        writer.object();
        writer.key("type").value(this.getEventType().toString()).key("name").value(this.getName()).key("colour").value(this.getColor());
        if (this.getEventType().equals((Object)CommonData.EventType.TIMELINE) || this.getEventType().equals((Object)CommonData.EventType.TIMELINE_EVENT) || this.getEventType().equals((Object)CommonData.EventType.GENERAL_EVENT)) {
            writer.key("earliestStartDate").value(Utils.dayFormatterOut.format(this.getDates().getEarlyStartDate()));
            if (this.getDates().getLateStartDate() != null) {
                writer.key("latestStartDate").value(Utils.dayFormatterOut.format(this.getDates().getLateStartDate()));
            }
            if (this.getDates().getEarlyEndDate() != null) {
                writer.key("earliestEndDate").value(Utils.dayFormatterOut.format(this.getDates().getEarlyEndDate()));
            }
            if (this.getDates().getLateEndDate() != null) {
                writer.key("latestEndDate").value(Utils.dayFormatterOut.format(this.getDates().getLateEndDate()));
            }
            if (this.getIcon() != null) {
                writer.key("startIcon").value(Paths.get(this.getIcon().toString(), new String[0]).getFileName().toString());
            }
        }
        if (this.getEventType().equals((Object)CommonData.EventType.TIMELINE) && this.getEndIcon() != null) {
            writer.key("endIcon").value(Paths.get(this.getEndIcon().toString(), new String[0]).getFileName().toString());
        }
        if (this.getEventType().equals((Object)CommonData.EventType.TIMELINE_EVENT)) {
            writer.key("timelineOfTimelineEvent").value(this.getEventTimeline().getName());
        }
        if (this.getEventType().equals((Object)CommonData.EventType.TIMELINE) || this.getEventType().equals((Object)CommonData.EventType.GENERAL_EVENT)) {
            writer.key("row").value(String.valueOf(mainGUI.getRowData().getRowOfEvent(this))).key("firstFit").value(this.getFirstFit());
        }
        if (this.getEventType().equals((Object)CommonData.EventType.UNTIMED)) {
            writer.key("untimedSequenceNo").value(this.getSequenceNo());
        }
        this.metaDataToJSON(writer, mainGUI);
        if (this.getEventType().equals((Object)CommonData.EventType.TIMELINE) && this.segmentList != null && this.segmentList.getNumberOfSegments() > 0) {
            writer.key("segments").array();
            int j = 0;
            while (j < this.segmentList.getNumberOfSegments()) {
                Segment tmpSegment = this.segmentList.getASegment(j);
                tmpSegment.toJSON(writer, mainGUI);
                ++j;
            }
            writer.endArray();
        }
        writer.endObject();
    }

    public String getEventHTMLSummary(CDgui mainGUI) {
        ConnectionData allConnections;
        int j;
        String tmp;
        SegmentList ourSegs;
        String result = "<h1>" + this.getEventType().toString() + " ";
        result = result + Utils.flatline(this.getName()) + "</h1>\n";
        if (!this.getEventType().equals((Object)CommonData.EventType.UNTIMED)) {
            result = result + "<h2>Dates</h2>\n";
            result = result + "Start: " + this.getDates().getSimpleDate(this.getDates().getEarlyStartDate(), this.getDates().getLateStartDate()) + "<br>\n";
            if (this.getDates().getEarlyEndDate() != null) {
                result = result + "End : " + this.getDates().getSimpleDate(this.getDates().getEarlyEndDate(), this.getDates().getLateEndDate()) + "<br>\n";
            }
        }
        if (this.getEventType().equals((Object)CommonData.EventType.TIMELINE) && (ourSegs = this.segmentList) != null && ourSegs.getNumberOfSegments() != 0) {
            ourSegs.sortSegmentsByStart();
            result = result + "<h2>Segments<h2>\n";
            int i = 0;
            while (i < ourSegs.getNumberOfSegments()) {
                Segment s = ourSegs.getASegment(i);
                result = result + "<h3>" + s.getText() + "</h3>\n";
                result = result + "Start: " + s.getDates().getSimpleDate(s.getDates().getEarlyStartDate(), s.getDates().getLateStartDate()) + "<br>\n";
                result = result + "End: " + s.getDates().getSimpleDate(s.getDates().getEarlyEndDate(), s.getDates().getLateEndDate()) + "<br>\n";
                ++i;
            }
        }
        if (!(tmp = this.getDescription()).isEmpty() && !tmp.isBlank()) {
            result = result + "<h2>Description</h2>\n";
            tmp = tmp.replace("\\n", "<br>\n");
            result = result + tmp + "<br>\n";
            if (this.getLinks().size() != 0) {
                result = result + "<h2>Links</h2>\n";
                j = 0;
                while (j < this.getLinks().size()) {
                    result = result + Utils.makeExtLink(this.getLinks().get(j).getURL(), this.getLinks().get(j).getText()) + "<br>\n";
                    ++j;
                }
            }
        }
        if (this.getEventType().equals((Object)CommonData.EventType.TIMELINE) && this.getTlEventList() != null && this.getTlEventList().getNumberOfEventsOnly() != 0) {
            result = result + "<h2>Timeline Events</h2>";
            j = 0;
            while (j < this.getTlEventList().getNumberOfEventsOnly()) {
                Event ourEv = this.getTlEventList().getEventByIndex(j);
                String eventName = Utils.correctFilename(ourEv.getName());
                String eventFileName = "./" + eventName + ".html";
                String namePopup = "<a onclick=\"javascript:myPopup('" + eventFileName + "', '" + eventName + "',  '750', '450')\">" + eventName + "</a>";
                result = result + namePopup + "<br>\n";
                ++j;
            }
        }
        if ((allConnections = mainGUI.getInput().getConnections()).getNumberOfConnections() != 0 && (allConnections.getConnectedEvents(this, ConnectionData.Direction.INCOMING).getNumberOfConnections() != 0 || allConnections.getConnectedEvents(this, ConnectionData.Direction.OUTGOING).getNumberOfConnections() != 0)) {
            result = result + "<h2>Connections</h2>\n";
            ConnectionData inConnections = allConnections.getConnectedEvents(this, ConnectionData.Direction.INCOMING);
            inConnections.sortConnectionsByName();
            if (inConnections.getNumberOfConnections() != 0) {
                result = result + "<h3>Incoming</h3>\n";
                int i = 0;
                while (i < inConnections.getNumberOfConnections()) {
                    String eventName = Utils.correctFilename(inConnections.getConnection(i).getSourceEvent().getName());
                    String eventFileName = "./" + eventName + ".html";
                    String namePopup = "<a onclick=\"javascript:myPopup('" + eventFileName + "', '" + eventName + "',  '750', '450')\">" + eventName + "</a>";
                    result = result + "<strong> from </strong>" + namePopup + " : " + inConnections.getConnection(i).getName().replace("\\n", " ") + "\n";
                    result = result + "<blockquote>" + inConnections.getConnection(i).getDescription().replace("\\n", "<br>") + "</blockquote>\n";
                    ++i;
                }
            }
            ConnectionData outConnections = allConnections.getConnectedEvents(this, ConnectionData.Direction.OUTGOING);
            outConnections.sortConnectionsByName();
            if (outConnections.getNumberOfConnections() != 0) {
                result = result + "<h3>Outgoing</h3>\n";
                int i = 0;
                while (i < outConnections.getNumberOfConnections()) {
                    String eventName = Utils.correctFilename(outConnections.getConnection(i).getDestEvent().getName());
                    String eventFileName = "./" + eventName + ".html";
                    String namePopup = "<a onclick=\"javascript:myPopup('" + eventFileName + "', '" + eventName + "',  '750', '450')\">" + eventName + "</a>";
                    result = result + "<strong> to </strong>" + namePopup + " : " + outConnections.getConnection(i).getName().replace("\\n", " ") + "<br>\n";
                    result = result + "<blockquote>" + outConnections.getConnection(i).getDescription().replace("\\n", "<br>") + "</blockquote>\n";
                    ++i;
                }
            }
        }
        return result;
    }
}

