/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CDgui;
import culturalDynamics.CommonData;
import culturalDynamics.CommonEditor;
import culturalDynamics.Connection;
import culturalDynamics.ConnectionData;
import culturalDynamics.Event;
import culturalDynamics.EventData;
import culturalDynamics.Preferences;
import culturalDynamics.TagList;
import culturalDynamics.TimePanel;
import culturalDynamics.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.DateTimeParseException;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

class ConnectionEditor
extends CommonEditor {
    private static final long serialVersionUID = 1L;
    private ConnectionEditor ourFrame;
    private Preferences ourPrefs;
    private TimePanel ourTimePanel;
    private ConnectionData ourConnections;
    private List<Event> eventList;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JLabel cnNameLabel = new JLabel("Show at:");
    private JCheckBox cnShowNameAtSrc = new JCheckBox("Source");
    private JCheckBox cnShowNameAtDst = new JCheckBox("Destination");
    private String cnNewIndex;
    private Connection.LineType cnNewLineType;
    private Connection.DashType cnNewDashType;
    private Event cnNewSrcEvent;
    private Event cnNewDstEvent;
    private String cnCorrectDate = "Use yyyy-mm-dd, yyyy-mm-dd CE, yyyy-mm-dd BCE.";
    private JComboBox<String> cnSrcEventField = new JComboBox();
    private JComboBox<String> cnDstEventField = new JComboBox();
    private JLabel cnSrcEarlyDateLabel = new JLabel("Earliest: ", 4);
    private JTextField cnSrcEarlyDateField = new JTextField(12);
    private JLabel cnDstEarlyDateLabel = new JLabel("Earliest: ", 4);
    private JTextField cnDstEarlyDateField = new JTextField(12);
    private JLabel cnSrcLateDateLabel = new JLabel("Latest: ", 4);
    private JTextField cnSrcLateDateField = new JTextField(12);
    private JLabel cnDstLateDateLabel = new JLabel("Latest: ", 4);
    private JTextField cnDstLateDateField = new JTextField(12);
    private JLabel cnLineTypeLabel = new JLabel("Line Type: ", 4);
    private JComboBox<String> cnLineTypeField = new JComboBox();
    private JLabel cnDashTypeLabel = new JLabel("Dash Type: ", 4);
    private JComboBox<String> cnDashTypeField = new JComboBox();
    private JCheckBox cnArrowForward = new JCheckBox("Forward Arrow");
    private JCheckBox cnArrowBack = new JCheckBox("Back Arrow");
    private JCheckBox cnCurveChoice = new JCheckBox("Curve");
    private JLabel cnBezCtrlXLabel = new JLabel("B\u00e9zier Control X:");
    private JTextField cnBezCtrlX = new JTextField(5);
    private JLabel cnBezCtrlYLabel = new JLabel("B\u00e9zier Control Y:");
    private JTextField cnBezCtrlY = new JTextField(5);

    ConnectionEditor(final CDgui mainGUI, final Connection ourData, final EventData allEvents, ConnectionData cnData, CommonEditor.NewObject isNewCn) {
        super(mainGUI, ourData);
        this.ourFrame = this;
        this.ourPrefs = this.ourGUI.getPreferences();
        this.ourConnections = cnData;
        this.isNew = isNewCn;
        this.eventList = allEvents.getListOfAllEvents(true);
        this.ourTimePanel = mainGUI.getTimePanel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                ourData.setEditor(null);
                ConnectionEditor.this.ourGUI.getWindowManager().closeWindow();
            }

            @Override
            public void windowActivated(WindowEvent wa) {
                ConnectionEditor.this.colorPanel.updatePaletteTable(ConnectionEditor.this.ourPrefs.getPalette(), true, ConnectionEditor.this.colorPanel.getSelectedColorName());
                Event selectedEv = null;
                selectedEv = ConnectionEditor.this.cnNewSrcEvent != null ? ConnectionEditor.this.cnNewSrcEvent : ourData.getSourceEvent();
                Utils.updateCombos(ConnectionEditor.this.eventList, selectedEv, ConnectionEditor.this.cnSrcEventField);
                selectedEv = ConnectionEditor.this.cnNewDstEvent != null ? ConnectionEditor.this.cnNewDstEvent : ourData.getDestEvent();
                Utils.updateCombos(ConnectionEditor.this.eventList, selectedEv, ConnectionEditor.this.cnDstEventField);
                ConnectionEditor.this.cnNewIndex = ConnectionEditor.this.makeUniqueIndex(ConnectionEditor.this.cnNewSrcEvent, ConnectionEditor.this.cnNewDstEvent);
                ConnectionEditor.this.ourFrame.setTitle("Connection Editor: " + ourData.getNiceID());
                ConnectionEditor.this.ourFrame.repaint();
                ConnectionEditor.this.mainTagsPanel.updateAvailableTags();
                ConnectionEditor.this.ourEditorFrame.revalidate();
            }
        });
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.errorCount = 0;
        String cnNamePosTip = "Select where to show the connection name.";
        this.cnNameLabel.setToolTipText(cnNamePosTip);
        this.cnShowNameAtSrc.setToolTipText(cnNamePosTip);
        this.cnShowNameAtDst.setToolTipText(cnNamePosTip);
        this.namePanel.add(this.cnNameLabel);
        this.namePanel.add(this.cnShowNameAtSrc);
        this.namePanel.add(this.cnShowNameAtDst);
        this.cnShowNameLogic();
        this.nameField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent f) {
            }

            @Override
            public void focusLost(FocusEvent f) {
                ConnectionEditor.this.cnShowNameLogic();
            }
        });
        this.cnShowNameAtSrc.setSelected(ourData.getShowAtSrc());
        this.cnShowNameAtDst.setSelected(ourData.getShowAtDst());
        LineBorder cnPanelsBorder = new LineBorder(Color.lightGray, 3);
        FlowLayout flowLayoutLeft = new FlowLayout(0);
        JPanel cnSourcEventPanel = new JPanel(flowLayoutLeft);
        this.cnSrcEventField.setToolTipText("Select the event from which the connection comes");
        cnSourcEventPanel.add(this.cnSrcEventField);
        JPanel cnSourceDatesPanel = new JPanel(flowLayoutLeft);
        this.cnSrcEarlyDateLabel.setToolTipText("The earliest or exact date for the connection");
        cnSourceDatesPanel.add(this.cnSrcEarlyDateLabel);
        this.cnSrcEarlyDateField.setToolTipText("The earliest or exact date for the connection");
        cnSourceDatesPanel.add(this.cnSrcEarlyDateField);
        this.cnSrcLateDateLabel.setToolTipText("The latest date for the connection if not exactly known");
        cnSourceDatesPanel.add(this.cnSrcLateDateLabel);
        this.cnSrcLateDateField.setToolTipText("The latest date for the connection if not exactly known");
        cnSourceDatesPanel.add(this.cnSrcLateDateField);
        Box cnSourcePanel = Box.createVerticalBox();
        TitledBorder cnSourcePanelTitle = new TitledBorder(cnPanelsBorder, "Source", 1, 2);
        cnSourcePanel.setBorder(cnSourcePanelTitle);
        cnSourcePanel.add(cnSourcEventPanel);
        cnSourcePanel.add(cnSourceDatesPanel);
        JPanel cnDestventPanel = new JPanel(flowLayoutLeft);
        cnDestventPanel.add(this.cnDstEventField);
        JPanel cnDestDatesPanel = new JPanel(flowLayoutLeft);
        this.cnDstEarlyDateLabel.setToolTipText("The earliest or exact date for the connection");
        cnDestDatesPanel.add(this.cnDstEarlyDateLabel);
        this.cnDstEarlyDateField.setToolTipText("The earliest or exact date for the connection");
        cnDestDatesPanel.add(this.cnDstEarlyDateField);
        this.cnDstLateDateLabel.setToolTipText("The latest date for the connection if not exactly known");
        cnDestDatesPanel.add(this.cnDstLateDateLabel);
        this.cnDstLateDateField.setToolTipText("The latest date for the connection if not exactly known");
        cnDestDatesPanel.add(this.cnDstLateDateField);
        Box cnDestPanel = Box.createVerticalBox();
        TitledBorder cnDestPanelTitle = new TitledBorder(cnPanelsBorder, "Destination", 1, 2);
        cnDestPanel.setBorder(cnDestPanelTitle);
        cnDestPanel.add(cnDestventPanel);
        cnDestPanel.add(cnDestDatesPanel);
        Utils.updateCombos(this.eventList, ourData.getSourceEvent(), this.cnSrcEventField);
        Utils.updateCombos(this.eventList, ourData.getDestEvent(), this.cnDstEventField);
        if (allEvents.getTotalNumberOfEvents() != 0) {
            this.cnSrcEventField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int cnNewSrcEventIndex = ConnectionEditor.this.cnSrcEventField.getSelectedIndex();
                    ConnectionEditor.this.cnNewSrcEvent = allEvents.getEventByIndex(cnNewSrcEventIndex);
                    ConnectionEditor.this.srcDstLogic();
                }
            });
            this.cnDstEventField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int cnNewDstEventIndex = ConnectionEditor.this.cnDstEventField.getSelectedIndex();
                    ConnectionEditor.this.cnNewDstEvent = allEvents.getEventByIndex(cnNewDstEventIndex);
                    ConnectionEditor.this.srcDstLogic();
                }
            });
        }
        if (ourData.getDates().getSrcEarlyDate() != null) {
            this.cnSrcEarlyDateField.setText(Utils.dayFormatter.format(ourData.getDates().getSrcEarlyDate()));
        }
        if (ourData.getDates().getSrcLateDate() != null) {
            this.cnSrcLateDateField.setText(Utils.dayFormatter.format(ourData.getDates().getSrcLateDate()));
        }
        if (ourData.getDates().getDstEarlyDate() != null) {
            this.cnDstEarlyDateField.setText(Utils.dayFormatter.format(ourData.getDates().getDstEarlyDate()));
        }
        if (ourData.getDates().getDstLateDate() != null) {
            this.cnDstLateDateField.setText(Utils.dayFormatter.format(ourData.getDates().getDstLateDate()));
        }
        this.cnSrcEarlyDateField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent f) {
            }

            @Override
            public void focusLost(FocusEvent f) {
                String eStart = ConnectionEditor.this.cnSrcEarlyDateField.getText();
                String eStartYear = ConnectionEditor.this.cnSrcEarlyDateField.getText();
                if (!eStart.isEmpty() && eStart.length() == 4 && ConnectionEditor.this.cnSrcLateDateField.getText().isEmpty()) {
                    ConnectionEditor.this.cnSrcEarlyDateField.setText(eStartYear + "-01-01");
                    ConnectionEditor.this.cnSrcLateDateField.setText(eStartYear + "-12-31");
                } else if (!eStart.isEmpty() && eStart.length() == 7 && ConnectionEditor.this.cnSrcLateDateField.getText().isEmpty()) {
                    String mString = ConnectionEditor.this.cnSrcEarlyDateField.getText().substring(5, 7);
                    eStartYear = ConnectionEditor.this.cnSrcEarlyDateField.getText().substring(0, 4);
                    int ultimo = 0;
                    try {
                        int y = Integer.parseInt(eStartYear);
                        int m = Integer.parseInt(mString);
                        YearMonth yearMonthObject = YearMonth.of(y, m);
                        ultimo = yearMonthObject.lengthOfMonth();
                    }
                    catch (NumberFormatException | DateTimeException n) {
                        JOptionPane.showMessageDialog(ConnectionEditor.this.ourGUI, "Connection Editor: invalid month or year in source timeline start date field");
                    }
                    ConnectionEditor.this.cnSrcEarlyDateField.setText(eStart + "-01");
                    ConnectionEditor.this.cnSrcLateDateField.setText(eStart + "-" + String.valueOf(ultimo));
                }
            }
        });
        this.cnDstEarlyDateField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent f) {
                if (ConnectionEditor.this.cnDstEarlyDateField.getText().isEmpty()) {
                    ConnectionEditor.this.cnDstEarlyDateField.setText(ConnectionEditor.this.cnSrcEarlyDateField.getText());
                }
                if (ConnectionEditor.this.cnDstLateDateField.getText().isEmpty()) {
                    ConnectionEditor.this.cnDstLateDateField.setText(ConnectionEditor.this.cnSrcLateDateField.getText());
                }
            }

            @Override
            public void focusLost(FocusEvent f) {
                String eStart = ConnectionEditor.this.cnDstEarlyDateField.getText();
                String eStartYear = ConnectionEditor.this.cnDstEarlyDateField.getText();
                if (!eStart.isEmpty() && eStart.length() == 4 && ConnectionEditor.this.cnDstLateDateField.getText().isEmpty()) {
                    ConnectionEditor.this.cnDstEarlyDateField.setText(eStartYear + "-01-01");
                    ConnectionEditor.this.cnDstLateDateField.setText(eStartYear + "-12-31");
                } else if (!eStart.isEmpty() && eStart.length() == 7 && ConnectionEditor.this.cnDstLateDateField.getText().isEmpty()) {
                    String mString = ConnectionEditor.this.cnDstEarlyDateField.getText().substring(5, 7);
                    eStartYear = ConnectionEditor.this.cnDstEarlyDateField.getText().substring(0, 4);
                    int ultimo = 0;
                    try {
                        int y = Integer.parseInt(eStartYear);
                        int m = Integer.parseInt(mString);
                        YearMonth yearMonthObject = YearMonth.of(y, m);
                        ultimo = yearMonthObject.lengthOfMonth();
                    }
                    catch (NumberFormatException | DateTimeException n) {
                        JOptionPane.showMessageDialog(ConnectionEditor.this.ourGUI, "Connection Editor: invalid month or year in destination timeline start date field");
                    }
                    ConnectionEditor.this.cnDstEarlyDateField.setText(eStart + "-01");
                    ConnectionEditor.this.cnDstLateDateField.setText(eStart + "-" + String.valueOf(ultimo));
                }
            }
        });
        this.srcDstLogic();
        final Connection.LineType[] lineTypeValues = Connection.LineType.values();
        String[] cnLineTypes = new String[lineTypeValues.length];
        int i = 0;
        while (i < lineTypeValues.length) {
            cnLineTypes[i] = lineTypeValues[i].toString();
            ++i;
        }
        Connection.LineType cnOldLineType = ourData.getLineType();
        int cnOldLineTypeIdx = cnOldLineType.ordinal();
        this.cnLineTypeField.setModel(new DefaultComboBoxModel<String>(cnLineTypes));
        this.cnLineTypeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int cnNewLineTypeIndex = ConnectionEditor.this.cnLineTypeField.getSelectedIndex();
                ConnectionEditor.this.cnNewLineType = lineTypeValues[cnNewLineTypeIndex];
            }
        });
        this.cnLineTypeField.setSelectedIndex(cnOldLineTypeIdx);
        JPanel cnLineTypePanel = new JPanel(flowLayoutLeft);
        this.cnLineTypeLabel.setToolTipText("How should the line look?");
        cnLineTypePanel.add(this.cnLineTypeLabel);
        this.cnLineTypeField.setToolTipText("How should the line look?");
        cnLineTypePanel.add(this.cnLineTypeField);
        final Connection.DashType[] dashTypeValues = Connection.DashType.values();
        String[] cnDashTypes = new String[dashTypeValues.length];
        int i2 = 0;
        while (i2 < dashTypeValues.length) {
            cnDashTypes[i2] = dashTypeValues[i2].toString();
            ++i2;
        }
        Connection.DashType cnOldDashType = ourData.getDashType();
        int cnOldDashTypeIdx = cnOldDashType.ordinal();
        this.cnDashTypeField.setModel(new DefaultComboBoxModel<String>(cnDashTypes));
        this.cnDashTypeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int cnNewDashTypeIndex = ConnectionEditor.this.cnDashTypeField.getSelectedIndex();
                ConnectionEditor.this.cnNewDashType = dashTypeValues[cnNewDashTypeIndex];
            }
        });
        this.cnDashTypeField.setSelectedIndex(cnOldDashTypeIdx);
        JPanel cnDashTypePanel = new JPanel(flowLayoutLeft);
        this.cnDashTypeLabel.setToolTipText("Select dashes and/or dots for line.");
        cnDashTypePanel.add(this.cnDashTypeLabel);
        this.cnDashTypeField.setToolTipText("Select dashes and/or dots for line.");
        cnDashTypePanel.add(this.cnDashTypeField);
        Box cnLineDashPanel = Box.createVerticalBox();
        cnLineDashPanel.add(cnLineTypePanel);
        cnLineDashPanel.add(cnDashTypePanel);
        JPanel cnArrowsPanel = new JPanel(new GridLayout(2, 1));
        this.cnArrowForward.setToolTipText("Filled arrow forwards to destination");
        cnArrowsPanel.add(this.cnArrowForward);
        this.cnArrowForward.setSelected(ourData.getArrowForward());
        this.cnArrowBack.setToolTipText("Open arrow backwards to source");
        cnArrowsPanel.add(this.cnArrowBack);
        this.cnArrowBack.setSelected(ourData.getArrowBack());
        if (this.isNew.equals((Object)CommonEditor.NewObject.NEW)) {
            ourData.setCurve(this.ourPrefs.getCurveConnectionsChoice());
            ourData.setBezCtrlX(this.ourPrefs.getBezierCtrlX());
            ourData.setBezCtrlY(this.ourPrefs.getBezierCtrlY());
        }
        this.cnCurveChoice.setSelected(ourData.getCurve());
        this.cnCurveChoice.setToolTipText("Make connection lines curved");
        this.cnBezCtrlX.setEnabled(ourData.getCurve());
        this.cnBezCtrlY.setEnabled(ourData.getCurve());
        this.cnBezCtrlX.setToolTipText("X coordinate of control point for curves");
        this.cnBezCtrlY.setToolTipText("Y coordinate of control point for curves");
        this.cnBezCtrlX.setText(String.valueOf(ourData.getBezCtrlX()));
        this.cnBezCtrlY.setText(String.valueOf(ourData.getBezCtrlY()));
        JPanel cnBezXPanel = new JPanel(flowLayoutLeft);
        cnBezXPanel.add(this.cnBezCtrlXLabel);
        cnBezXPanel.add(this.cnBezCtrlX);
        JPanel cnBezYPanel = new JPanel(flowLayoutLeft);
        cnBezYPanel.add(this.cnBezCtrlYLabel);
        cnBezYPanel.add(this.cnBezCtrlY);
        Box cnBezierPanel = Box.createVerticalBox();
        cnBezierPanel.setAlignmentX(0.0f);
        cnBezierPanel.add(cnBezXPanel);
        cnBezierPanel.add(cnBezYPanel);
        this.cnCurveChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ConnectionEditor.this.curveBoxLogic();
            }
        });
        Box cnLineConfigPanel = Box.createHorizontalBox();
        TitledBorder cnLineConfigPanelTitle = new TitledBorder(cnPanelsBorder, "Line Type", 1, 2);
        cnLineConfigPanel.setBorder(cnLineConfigPanelTitle);
        cnLineConfigPanel.add(cnLineDashPanel);
        cnLineConfigPanel.add(cnArrowsPanel);
        cnLineConfigPanel.add(this.cnCurveChoice);
        cnLineConfigPanel.add(cnBezierPanel);
        this.curveBoxLogic();
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ok) {
                ConnectionEditor.this.okApply();
                ConnectionEditor.this.okApply(ourData);
                if (ConnectionEditor.this.errorCount == 0) {
                    if (ConnectionEditor.this.isNew.equals((Object)CommonEditor.NewObject.NEW)) {
                        ConnectionEditor.this.ourConnections.addConnection(ourData);
                        ourData.setEditor(ConnectionEditor.this.ourEditor);
                    }
                    ConnectionEditor.this.ourEditorFrame.dispose();
                    ourData.setEditor(null);
                    ConnectionEditor.this.ourGUI.getWindowManager().closeWindow();
                    ConnectionEditor.this.ourGUI.setFileSaved(false);
                }
                ConnectionEditor.this.ourGUI.getFilterEditor().doFilter();
                ConnectionEditor.this.ourGUI.setRange();
                ConnectionEditor.this.ourGUI.panLimits();
                ConnectionEditor.this.ourTimePanel.repaint();
            }
        });
        this.buttonApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ok) {
                ConnectionEditor.this.okApply();
                ConnectionEditor.this.okApply(ourData);
                if (ConnectionEditor.this.errorCount == 0) {
                    if (ConnectionEditor.this.isNew.equals((Object)CommonEditor.NewObject.NEW)) {
                        ConnectionEditor.this.ourConnections.addConnection(ourData);
                        ourData.setEditor(ConnectionEditor.this.ourEditor);
                        ConnectionEditor.this.isNew = CommonEditor.NewObject.EXISTING;
                        ConnectionEditor.this.buttonDelete.setEnabled(true);
                    }
                    ConnectionEditor.this.ourGUI.setFileSaved(false);
                    ConnectionEditor.this.ourEditor.setTitle("Connection Editor: " + ourData.getNiceID());
                }
                ConnectionEditor.this.ourGUI.getFilterEditor().doFilter();
                ConnectionEditor.this.ourGUI.setRange();
                ConnectionEditor.this.ourGUI.panLimits();
                ConnectionEditor.this.ourTimePanel.repaint();
            }
        });
        if (this.isNew.equals((Object)CommonEditor.NewObject.NEW)) {
            this.buttonDelete.setEnabled(false);
        } else {
            this.buttonDelete.setEnabled(true);
        }
        this.buttonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent del) {
                if (!ConnectionEditor.this.ourConnections.deleteConnection(ourData).booleanValue()) {
                    JOptionPane.showMessageDialog(ConnectionEditor.this.ourEditorFrame, "Connection Editor: Failed to remove connection");
                } else {
                    ConnectionEditor.this.ourEditorFrame.dispose();
                    ourData.setEditor(null);
                    ConnectionEditor.this.ourGUI.getWindowManager().closeWindow();
                    mainGUI.setRange();
                    mainGUI.panLimits();
                    ConnectionEditor.this.ourTimePanel.repaint();
                    ConnectionEditor.this.ourGUI.setFileSaved(false);
                }
            }
        });
        Box generalTab = Box.createVerticalBox();
        generalTab.add(this.namePanel);
        generalTab.add(cnSourcePanel);
        generalTab.add(cnDestPanel);
        generalTab.add(cnLineConfigPanel);
        generalTab.add(this.colorPanel);
        JPanel okPanel = new JPanel();
        okPanel.add(this.buttonOK);
        okPanel.add(this.buttonCancel);
        okPanel.add(this.buttonDelete);
        okPanel.add(this.buttonApply);
        this.tabbedPane.addTab("Data", null, generalTab, "General connection data");
        this.tabbedPane.addTab("MetaData", null, this.metaDataPanel, "Connection metadata");
        if (this.isNew.equals((Object)CommonEditor.NewObject.NEW)) {
            this.tabbedPane.setSelectedComponent(generalTab);
        } else {
            this.tabbedPane.setSelectedComponent(this.metaDataPanel);
        }
        JPanel allPane = new JPanel();
        allPane.setLayout(new BorderLayout());
        JScrollPane allScroll = new JScrollPane(allPane);
        allPane.add((Component)this.tabbedPane, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)allScroll, "Center");
        this.add((Component)okPanel, "Last");
        this.setTitle("Connection Editor: " + ourData.getNiceID());
        this.pack();
        this.toFront();
    }

    private void okApply(Connection ourCn) {
        this.cnNewIndex = this.makeUniqueIndex(this.cnNewSrcEvent, this.cnNewDstEvent);
        ourCn.setIndex(this.cnNewIndex);
        if (this.cnSrcEventField.getSelectedIndex() == this.cnDstEventField.getSelectedIndex()) {
            this.errorMsg = String.valueOf(this.errorMsg) + "\nConnection Editor: Cannot connect event to itself.";
            ++this.errorCount;
        }
        LocalDate cnNewSrcEarlyDate = null;
        LocalDate cnNewSrcLateDate = null;
        if (!this.cnSrcEarlyDateField.getText().equals("")) {
            try {
                cnNewSrcEarlyDate = LocalDate.parse(this.cnSrcEarlyDateField.getText(), Utils.dayFormatter);
            }
            catch (DateTimeParseException f) {
                cnNewSrcEarlyDate = null;
            }
            if (cnNewSrcEarlyDate == null) {
                this.errorMsg = this.errorMsg + "\nConnection Editor: Invalid earliest source start date.\n" + this.cnCorrectDate;
                ++this.errorCount;
                cnNewSrcEarlyDate = null;
            }
        }
        if (!this.cnSrcLateDateField.getText().equals("")) {
            try {
                cnNewSrcLateDate = LocalDate.parse(this.cnSrcLateDateField.getText(), Utils.dayFormatter);
            }
            catch (DateTimeParseException f) {
                cnNewSrcLateDate = null;
            }
            if (cnNewSrcLateDate == null) {
                this.errorMsg = this.errorMsg + "\nConnection Editor: Invalid latest source start date.\n" + this.cnCorrectDate;
                ++this.errorCount;
                cnNewSrcLateDate = null;
            }
            if (cnNewSrcEarlyDate != null && cnNewSrcLateDate != null && cnNewSrcLateDate.isBefore(cnNewSrcEarlyDate)) {
                this.errorMsg = String.valueOf(this.errorMsg) + "\nConnection Editor: latest source start date must be after earliest.";
                ++this.errorCount;
            }
        }
        LocalDate cnNewDstEarlyDate = null;
        LocalDate cnNewDstLateDate = null;
        if (!this.cnDstEarlyDateField.getText().equals("")) {
            try {
                cnNewDstEarlyDate = LocalDate.parse(this.cnDstEarlyDateField.getText(), Utils.dayFormatter);
            }
            catch (DateTimeParseException f) {
                cnNewDstEarlyDate = null;
            }
            if (cnNewDstEarlyDate == null) {
                this.errorMsg = this.errorMsg + "\nConnection Editor: Invalid earliest destination start date.\n" + this.cnCorrectDate;
                ++this.errorCount;
                cnNewDstEarlyDate = null;
            }
        }
        if (!this.cnDstLateDateField.getText().equals("")) {
            try {
                cnNewDstLateDate = LocalDate.parse(this.cnDstLateDateField.getText(), Utils.dayFormatter);
            }
            catch (DateTimeParseException f) {
                cnNewDstLateDate = null;
            }
            if (cnNewDstLateDate == null) {
                this.errorMsg = this.errorMsg + "\nConnection Editor: Invalid latest destination start date.\n" + this.cnCorrectDate;
                ++this.errorCount;
                cnNewDstLateDate = null;
            }
            if (cnNewDstEarlyDate != null && cnNewDstLateDate != null && cnNewDstLateDate.isBefore(cnNewDstEarlyDate)) {
                this.errorMsg = String.valueOf(this.errorMsg) + "\nConnection Editor: latest destination start date must be after earliest.";
                ++this.errorCount;
            }
        }
        Double cnNewBezCtrlX = 0.1;
        try {
            cnNewBezCtrlX = Double.valueOf(this.cnBezCtrlX.getText());
        }
        catch (NumberFormatException n) {
            this.errorMsg = String.valueOf(this.errorMsg) + "\nConnection Editor: Invalid number in B\u00e9zier Control X.";
        }
        Double cnNewBezCtrlY = 0.2;
        try {
            cnNewBezCtrlY = Double.valueOf(this.cnBezCtrlY.getText());
        }
        catch (NumberFormatException n) {
            this.errorMsg = String.valueOf(this.errorMsg) + "\nConnection Editor: Invalid number in B\u00e9zier Control Y.";
        }
        if (this.errorCount != 0) {
            JOptionPane.showMessageDialog(this.ourEditorFrame, this.errorMsg);
        }
        if (this.errorCount == 0) {
            this.newName = Utils.encodeEscapes(this.nameField.getText());
            ourCn.setName(this.newName);
            ourCn.setShowAtSrc(this.cnShowNameAtSrc.isSelected());
            ourCn.setShowAtDst(this.cnShowNameAtDst.isSelected());
            if (this.newColor != null) {
                ourCn.setColor(this.newColor);
            }
            ourCn.setSourceEvent(this.cnNewSrcEvent);
            ourCn.getDates().setSrcEarlyDate(cnNewSrcEarlyDate);
            ourCn.getDates().setSrcLateDate(cnNewSrcLateDate);
            ourCn.getDates().setDstEarlyDate(cnNewDstEarlyDate);
            ourCn.getDates().setDstLateDate(cnNewDstLateDate);
            ourCn.setDestEvent(this.cnNewDstEvent);
            ourCn.setLineType(this.cnNewLineType);
            ourCn.setDashType(this.cnNewDashType);
            ourCn.setArrowForward(this.cnArrowForward.isSelected());
            ourCn.setArrowBack(this.cnArrowBack.isSelected());
            ourCn.setCurve(this.cnCurveChoice.isSelected());
            ourCn.setBezCtrlX(cnNewBezCtrlX);
            ourCn.setBezCtrlY(cnNewBezCtrlY);
            TagList updatedTags = this.mainTagsPanel.getNewTagList();
            ourCn.setTags(updatedTags);
            ourCn.setDescription(this.newDescription);
            if (this.linkDialogRan) {
                ourCn.setLinks(this.newLinks);
                this.linkDialogRan = false;
            }
        }
    }

    private void cnShowNameLogic() {
        if (this.nameField.getText().isEmpty()) {
            this.cnShowNameAtSrc.setEnabled(false);
            this.cnShowNameAtSrc.setSelected(false);
            this.cnShowNameAtDst.setEnabled(false);
            this.cnShowNameAtDst.setSelected(false);
        } else {
            this.cnShowNameAtSrc.setEnabled(true);
            this.cnShowNameAtDst.setEnabled(true);
        }
    }

    private void srcDstLogic() {
        if (this.cnNewSrcEvent != null) {
            if (this.cnNewSrcEvent.getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
                this.cnSrcEarlyDateLabel.setForeground(Color.black);
                this.cnSrcEarlyDateField.setEnabled(true);
                this.cnSrcLateDateLabel.setForeground(Color.black);
                this.cnSrcLateDateField.setEnabled(true);
            } else {
                this.cnSrcEarlyDateLabel.setForeground(Color.gray);
                this.cnSrcEarlyDateField.setEnabled(false);
                this.cnSrcEarlyDateField.setText("");
                this.cnSrcLateDateLabel.setForeground(Color.gray);
                this.cnSrcLateDateField.setEnabled(false);
                this.cnSrcLateDateField.setText("");
            }
        }
        if (this.cnNewDstEvent != null) {
            if (this.cnNewDstEvent != null && this.cnNewDstEvent.getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
                this.cnDstEarlyDateLabel.setForeground(Color.black);
                this.cnDstEarlyDateField.setEnabled(true);
                this.cnDstLateDateLabel.setForeground(Color.black);
                this.cnDstLateDateField.setEnabled(true);
            } else {
                this.cnDstEarlyDateLabel.setForeground(Color.gray);
                this.cnDstEarlyDateField.setEnabled(false);
                this.cnDstEarlyDateField.setText("");
                this.cnDstLateDateLabel.setForeground(Color.gray);
                this.cnDstLateDateField.setEnabled(false);
                this.cnDstLateDateField.setText("");
            }
        }
    }

    private String makeUniqueIndex(Event src, Event dst) {
        int index = 1;
        boolean conflict = true;
        while (conflict) {
            Connection tmpCn = this.ourConnections.getConnectionByID(Connection.makeID(src.getName(), String.valueOf(index), dst.getName()));
            if (tmpCn != null && tmpCn.getEditor() != this.ourEditor) {
                ++index;
                continue;
            }
            conflict = false;
        }
        return String.valueOf(index);
    }

    private void curveBoxLogic() {
        if (!this.cnCurveChoice.isSelected()) {
            this.cnBezCtrlX.setEnabled(false);
            this.cnBezCtrlXLabel.setForeground(Color.gray);
            this.cnBezCtrlY.setEnabled(false);
            this.cnBezCtrlYLabel.setForeground(Color.gray);
        } else {
            this.cnBezCtrlX.setEnabled(true);
            this.cnBezCtrlXLabel.setForeground(Color.black);
            this.cnBezCtrlY.setEnabled(true);
            this.cnBezCtrlYLabel.setForeground(Color.black);
        }
    }
}

