/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CDgui;
import culturalDynamics.CommonData;
import culturalDynamics.Connection;
import culturalDynamics.Event;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.json.JSONWriter;

class ConnectionData {
    private List<Connection> connections = new ArrayList<Connection>();

    public void addConnection(Connection con) {
        this.connections.add(con);
    }

    public List<Connection> getConnections() {
        return this.connections;
    }

    public int getNumberOfConnections() {
        return this.connections.size();
    }

    public Connection getConnection(int i) {
        return this.connections.get(i);
    }

    public Connection getConnectionByID(String id) {
        int i = 0;
        while (i < this.connections.size()) {
            if (this.connections.get(i).getID().equals(id)) {
                return this.getConnection(i);
            }
            ++i;
        }
        return null;
    }

    public Boolean deleteConnection(Connection con) {
        return this.connections.remove(con);
    }

    public void sortConnectionsByName() {
        if (this.connections != null && this.connections.size() != 0) {
            this.connections.sort(new NameSorter());
        }
    }

    public void sortConnectionsByID() {
        if (this.connections != null && this.connections.size() != 0) {
            Collections.sort(this.connections, Comparator.comparing(Connection::getSrcEvTlName).thenComparing(Connection::getIndex).thenComparing(Connection::getDstEvTlName));
        }
    }

    public ConnectionData getConnectedEvents(Event ev, Direction dir) {
        ConnectionData result = new ConnectionData();
        for (Connection connection : this.connections) {
            if (dir.equals((Object)Direction.INCOMING) && connection.getDestEvent() != null && connection.getDestEvent().equals(ev)) {
                result.addConnection(connection);
            }
            if (!dir.equals((Object)Direction.OUTGOING) || connection.getSourceEvent() == null || !connection.getSourceEvent().equals(ev)) continue;
            result.addConnection(connection);
        }
        return result;
    }

    public String getConnectedEvTlNamesOfEvent(Event ev) {
        Object result = "";
        for (Connection connection : this.connections) {
            String thisCnIndex = connection.getIndex();
            Object tmp = "";
            if (connection.getSourceEvent() != null && connection.getSourceEvent().equals(ev)) {
                tmp = !connection.getDestEvent().getEventType().equals((Object)CommonData.EventType.TIMELINE) ? (String)tmp + thisCnIndex + " to event " + connection.getDestEvent().getName() : (String)tmp + thisCnIndex + " to timeline " + connection.getDestEvent().getName();
            }
            if (connection.getDestEvent() != null && connection.getDestEvent().equals(ev)) {
                tmp = (String)tmp + thisCnIndex + " from event " + connection.getSourceEvent().getName();
            }
            if (((String)tmp).equals("")) continue;
            result = (String)result + (String)tmp + "\n";
        }
        return result;
    }

    public LocalDate getEarliestStartDate() {
        LocalDate minimumStartDate = null;
        if (this.connections.size() == 0) {
            return null;
        }
        for (Connection connection : this.connections) {
            if (connection.isShown() && connection.getDates().getSrcEarlyDate() != null && (minimumStartDate == null || connection.getDates().getSrcEarlyDate().isBefore(minimumStartDate))) {
                minimumStartDate = connection.getDates().getSrcEarlyDate();
            }
            if (!connection.isShown() || connection.getDates().getDstEarlyDate() == null || minimumStartDate != null && !connection.getDates().getDstEarlyDate().isBefore(minimumStartDate)) continue;
            minimumStartDate = connection.getDates().getDstEarlyDate();
        }
        return minimumStartDate;
    }

    public LocalDate getLatestEndDate() {
        LocalDate maximumEndDate = null;
        if (this.connections.size() == 0) {
            return null;
        }
        LocalDate tmp = null;
        for (Connection connection : this.connections) {
            if (!connection.isShown()) continue;
            if (connection.getDates().getSrcLateDate() != null) {
                tmp = connection.getDates().getSrcLateDate();
            } else if (connection.getDates().getSrcEarlyDate() != null) {
                tmp = connection.getDates().getSrcEarlyDate();
            }
            if (maximumEndDate == null || maximumEndDate != null && tmp.isAfter(maximumEndDate)) {
                maximumEndDate = tmp;
            }
            if (connection.getDates().getDstLateDate() != null) {
                tmp = connection.getDates().getDstLateDate();
            } else if (connection.getDates().getDstEarlyDate() != null) {
                tmp = connection.getDates().getDstEarlyDate();
            }
            if (maximumEndDate != null && (maximumEndDate == null || !tmp.isAfter(maximumEndDate))) continue;
            maximumEndDate = tmp;
        }
        return maximumEndDate;
    }

    public void toJSON(JSONWriter writer, CDgui mainGUI) {
        if (this.connections != null && this.connections.size() > 0) {
            writer.key("connections");
            writer.array();
            List<Connection> connections = this.getConnections();
            int i = 0;
            while (i < connections.size()) {
                Connection tmpConnection = connections.get(i);
                tmpConnection.toJSON(writer, mainGUI);
                ++i;
            }
            writer.endArray();
        }
    }

    public static enum Direction {
        INCOMING,
        OUTGOING;

    }

    private class NameSorter
    implements Comparator<Connection> {
        private NameSorter() {
        }

        @Override
        public int compare(Connection o1, Connection o2) {
            int tmp = o1.getID().compareToIgnoreCase(o2.getID());
            return tmp;
        }
    }
}

