/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CDgui;
import culturalDynamics.CommonData;
import culturalDynamics.Link;
import culturalDynamics.LinkEditor;
import culturalDynamics.PaletteColorPanel;
import culturalDynamics.TagList;
import culturalDynamics.TagSelector;
import culturalDynamics.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

abstract class CommonEditor
extends JFrame {
    protected static final long serialVersionUID = 1L;
    protected CDgui ourGUI;
    protected CommonEditor ourEditor;
    protected JFrame ourEditorFrame;
    protected JTextArea nameField = new JTextArea(3, 20);
    protected JScrollPane nameScroll;
    private String oldName;
    protected String newName;
    protected NewObject isNew = NewObject.NEW;
    protected int errorCount = 0;
    protected String errorMsg = "";
    protected JPanel namePanel;
    private LineBorder panelsBorder = new LineBorder(Color.lightGray, 3);
    private FlowLayout flowLayoutLeft = new FlowLayout(0);
    private Dimension buttonSmallSize = new Dimension(60, 20);
    protected Dimension buttonLargeSize = new Dimension(100, 20);
    protected PaletteColorPanel colorPanel;
    protected String newColor;
    private TagList oldTagList;
    protected TagSelector mainTagsPanel;
    private JTextArea descriptionField = new JTextArea(5, 50);
    protected String newDescription = "";
    private JEditorPane linksField = new JEditorPane();
    private JButton linksEditButton = new JButton("Edit");
    private ArrayList<Link> editLinks = new ArrayList();
    protected ArrayList<Link> newLinks = new ArrayList();
    protected boolean linkDialogRan;
    private ArrayList<Link> oldLinks = new ArrayList();
    protected Box metaDataPanel;
    protected Box connectionsPanel;
    protected JButton buttonOK = new JButton("OK");
    protected JButton buttonCancel = new JButton("Cancel");
    protected JButton buttonDelete = new JButton("Delete");
    protected JButton buttonApply = new JButton("Apply");
    private FocusListener nameListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent f) {
            if (CommonEditor.this.isNew.equals((Object)NewObject.NEW)) {
                CommonEditor.this.nameField.selectAll();
            }
        }

        @Override
        public void focusLost(FocusEvent f) {
        }
    };

    CommonEditor(CDgui mainGUI, final CommonData ourData) {
        this.ourGUI = mainGUI;
        this.ourEditor = this;
        this.ourEditorFrame = this;
        ourData.setEditor(this);
        this.nameScroll = new JScrollPane();
        this.nameScroll.setViewportView(this.nameField);
        this.nameField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    e.consume();
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                }
                if (e.getKeyCode() == 9 && e.isShiftDown()) {
                    e.consume();
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
                }
            }
        });
        this.nameField.addFocusListener(this.nameListener);
        this.nameField.setToolTipText("Name of this item. Items other than timelines can have multiple lines.");
        this.nameField.setLineWrap(false);
        this.nameField.setWrapStyleWord(true);
        this.oldName = Utils.decodeEscapes(ourData.getName());
        if (this.oldName.isEmpty() || this.oldName == "") {
            this.nameField.setText("");
        } else {
            String[] lines = this.oldName.split(System.lineSeparator());
            int i = 0;
            while (i < lines.length) {
                if (i < lines.length - 1) {
                    this.nameField.append(lines[i] + "\n");
                } else {
                    this.nameField.append(lines[i]);
                }
                ++i;
            }
            if (lines.length > 10) {
                this.nameField.setRows(lines.length);
            }
        }
        this.namePanel = new JPanel(this.flowLayoutLeft);
        TitledBorder evPanelTitle = new TitledBorder(this.panelsBorder, "Name", 1, 2);
        this.namePanel.setBorder(evPanelTitle);
        this.namePanel.add(this.nameScroll);
        this.colorPanel = new PaletteColorPanel(this.ourGUI.getPreferences().getPalette(), ourData.getColor());
        this.oldTagList = new TagList();
        this.oldTagList = ourData.getTags().getCopyOfTags();
        this.mainTagsPanel = new TagSelector(this.ourGUI, this.oldTagList, TagSelector.AllowDefine.DEFINE);
        JPanel descriptionPanel = new JPanel();
        descriptionPanel.setLayout(new BorderLayout());
        TitledBorder descriptionTitle = new TitledBorder(this.panelsBorder, "Description", 1, 2);
        descriptionPanel.setBorder(descriptionTitle);
        JScrollPane descriptionScroll = new JScrollPane();
        descriptionScroll.setViewportView(this.descriptionField);
        this.descriptionField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 10) {
                    CommonEditor.this.descriptionField.setRows(CommonEditor.this.descriptionField.getRows() + 1);
                }
            }
        });
        this.descriptionField.setToolTipText("Descriptive Text for this event or connection");
        this.descriptionField.setLineWrap(true);
        this.descriptionField.setWrapStyleWord(true);
        String oldDescription = Utils.decodeEscapes(ourData.getDescription());
        if (oldDescription.isEmpty() || oldDescription == "") {
            this.descriptionField.setText("");
        } else {
            String[] lines = oldDescription.split(System.lineSeparator());
            int i = 0;
            while (i < lines.length) {
                if (i < lines.length - 1) {
                    this.descriptionField.append(lines[i] + System.lineSeparator());
                } else {
                    this.descriptionField.append(lines[i]);
                }
                ++i;
            }
            if (lines.length > 10) {
                this.descriptionField.setRows(lines.length);
            }
        }
        descriptionPanel.add((Component)descriptionScroll, "Center");
        this.descriptionField.setCaretPosition(0);
        JPanel linksPanel = new JPanel(this.flowLayoutLeft);
        TitledBorder linksTitle = new TitledBorder(this.panelsBorder, "Links", 1, 2);
        linksPanel.setBorder(linksTitle);
        JScrollPane linksScroll = new JScrollPane();
        linksScroll.setViewportView(this.linksField);
        linksScroll.setPreferredSize(new Dimension(500, 80));
        this.linksField.setContentType("text/html");
        this.linksField.setEditable(false);
        this.linksField.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hle) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                    Desktop desktop = Desktop.getDesktop();
                    URL linkURL = hle.getURL();
                    if (linkURL != null) {
                        try {
                            String rawURI = hle.getURL().toURI().toString();
                            String encURI = Utils.URLpercents(rawURI);
                            desktop.browse(new URI(encURI));
                        }
                        catch (IOException | IllegalArgumentException | NullPointerException | SecurityException | UnsupportedOperationException | URISyntaxException ex) {
                            JOptionPane.showMessageDialog(CommonEditor.this.ourEditorFrame, "Common Editor open browser: Unhandled Error!" + ex.getMessage() + "\n");
                        }
                    } else {
                        JOptionPane.showMessageDialog(CommonEditor.this.ourEditorFrame, "Common Editor open browser: Invalid URL: " + hle.getDescription() + "\n");
                    }
                }
            }
        });
        this.linksField.setText(Utils.buildLinksHTML(ourData.getLinks()));
        this.editLinks = new ArrayList<Link>(Utils.getCopyOf(ourData.getLinks()));
        this.linkDialogRan = false;
        this.linksEditButton.setPreferredSize(this.buttonSmallSize);
        this.linksEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonEditor.this.oldLinks = new ArrayList<Link>(Utils.getCopyOf(CommonEditor.this.editLinks));
                LinkEditor linkEditor = new LinkEditor(CommonEditor.this.ourEditorFrame, CommonEditor.this.editLinks);
                String result = linkEditor.getResult();
                if (result != "Cancel") {
                    CommonEditor.this.linksField.setText(Utils.buildLinksHTML(CommonEditor.this.editLinks));
                } else {
                    CommonEditor.this.newLinks = CommonEditor.this.oldLinks;
                }
                CommonEditor.this.ourEditorFrame.revalidate();
                CommonEditor.this.ourEditorFrame.repaint();
                CommonEditor.this.linkDialogRan = true;
            }
        });
        linksPanel.add(linksScroll);
        linksPanel.add(this.linksEditButton);
        this.metaDataPanel = Box.createVerticalBox();
        this.metaDataPanel.add(this.mainTagsPanel);
        this.metaDataPanel.add(descriptionPanel);
        this.metaDataPanel.add(linksPanel);
        this.buttonOK.setToolTipText("Apply the edits and close the window");
        this.buttonOK.setPreferredSize(this.buttonLargeSize);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonEditor.this.okApply();
            }
        });
        this.buttonApply.setToolTipText("Apply the edits and keep the window open");
        this.buttonApply.setPreferredSize(this.buttonLargeSize);
        this.buttonApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonEditor.this.okApply();
            }
        });
        this.buttonCancel.setToolTipText("Cancel the edits");
        this.buttonCancel.setPreferredSize(this.buttonLargeSize);
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonEditor.this.linkDialogRan = false;
                CommonEditor.this.ourEditorFrame.dispose();
                ourData.setEditor(null);
                CommonEditor.this.ourGUI.getWindowManager().closeWindow();
            }
        });
        this.buttonDelete.setToolTipText("Delete this Event of Connection");
        this.buttonDelete.setPreferredSize(this.buttonLargeSize);
    }

    protected void okApply() {
        this.errorCount = 0;
        this.errorMsg = "Please correct the following errors or cancel the edit:";
        this.newColor = this.colorPanel.getSelectedPaletteColor().getName();
        this.newDescription = Utils.encodeEscapes(this.descriptionField.getText());
        if (this.linkDialogRan) {
            this.newLinks = this.editLinks;
        }
    }

    public TagSelector getTagsPanel() {
        return this.mainTagsPanel;
    }

    static enum NewObject {
        NEW,
        EXISTING;

    }
}

