/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CDgui;
import culturalDynamics.CommonEditor;
import culturalDynamics.Link;
import culturalDynamics.TagList;
import java.util.ArrayList;
import org.json.JSONWriter;

abstract class CommonData {
    private String name;
    private String color;
    private TagList tags;
    private String description;
    private ArrayList<Link> links;
    private CommonEditor editor;
    private boolean isShown;

    CommonData(String name, String color) {
        this.name = name;
        this.color = color;
        this.tags = new TagList();
        this.isShown = true;
        this.description = "";
        this.links = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public TagList getTags() {
        return this.tags;
    }

    public void setTags(TagList t) {
        this.tags = t;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ArrayList<Link> getLinks() {
        return this.links;
    }

    public void setLinks(ArrayList<Link> linksIn) {
        this.links = linksIn;
    }

    public CommonEditor getEditor() {
        return this.editor;
    }

    public void setEditor(CommonEditor editor) {
        this.editor = editor;
    }

    public boolean isShown() {
        return this.isShown;
    }

    public void setShown(boolean s) {
        this.isShown = s;
    }

    public void metaDataToJSON(JSONWriter writer, CDgui mainGUI) {
        if (this.getTags() != null) {
            writer.key("tags").value(this.getTags().getTagsAsString());
        }
        if (this.links != null && this.links.size() > 0) {
            writer.key("links").array();
            int i = 0;
            while (i < this.links.size()) {
                writer.object().key("linkText").value(this.links.get(i).getText()).key("linkURL").value(this.links.get(i).getURL()).endObject();
                ++i;
            }
            writer.endArray();
        }
        if (this.description != null && this.description.length() > 0) {
            writer.key("description").value(this.description);
        }
    }

    static enum EventType {
        TIMELINE_EVENT,
        GENERAL_EVENT,
        TIMELINE,
        UNTIMED;

    }
}

