/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CDgui;
import java.awt.Desktop;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitHandler;
import java.awt.desktop.QuitResponse;
import java.util.Locale;
import javax.swing.InputMap;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

class CDmain {
    private static String exitDialog1 = "Are you sure you want to close this program?\n";

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Could not set Look and Feel to Metal.");
        }
        Locale.setDefault(Locale.Category.DISPLAY, Locale.US);
        if (System.getProperty("os.name", "").toUpperCase().startsWith("MAC")) {
            InputMap im = (InputMap)UIManager.get("TextField.focusInputMap");
            CDmain.setMacKeys(im);
            im = (InputMap)UIManager.get("FormattedTextField.focusInputMap");
            CDmain.setMacKeys(im);
            im = (InputMap)UIManager.get("TextArea.focusInputMap");
            CDmain.setMacKeys(im);
            im = (InputMap)UIManager.get("TextPane.focusInputMap");
            CDmain.setMacKeys(im);
            im = (InputMap)UIManager.get("EditorPane.focusInputMap");
            CDmain.setMacKeys(im);
            im = (InputMap)UIManager.get("List.focusInputMap");
            CDmain.setMacKeys(im);
        }
        try {
            Desktop.getDesktop().setQuitHandler(new QuitHandler(){

                @Override
                public void handleQuitRequestWith(QuitEvent q, QuitResponse r) {
                    if (JOptionPane.showConfirmDialog(null, exitDialog1, "Close Program without saving?", 0, 3) == 0) {
                        r.performQuit();
                    }
                    r.cancelQuit();
                }
            });
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CDgui mainWindow = new CDgui();
                mainWindow.setVisible(true);
            }
        });
    }

    private static void setMacKeys(InputMap im) {
        im.put(KeyStroke.getKeyStroke(65, 256), "select-all");
        im.put(KeyStroke.getKeyStroke(67, 256), "copy-to-clipboard");
        im.put(KeyStroke.getKeyStroke(86, 256), "paste-from-clipboard");
        im.put(KeyStroke.getKeyStroke(88, 256), "cut-to-clipboard");
        im.put(KeyStroke.getKeyStroke(37, 512), "caret-previous-word");
        im.put(KeyStroke.getKeyStroke(37, 576), "selection-previous-word");
        im.put(KeyStroke.getKeyStroke(37, 256), "caret-begin-line");
        im.put(KeyStroke.getKeyStroke(37, 320), "selection-begin-line");
        im.put(KeyStroke.getKeyStroke(39, 512), "caret-next-word");
        im.put(KeyStroke.getKeyStroke(39, 576), "selection-next-word");
        im.put(KeyStroke.getKeyStroke(39, 256), "caret-end-line");
        im.put(KeyStroke.getKeyStroke(39, 320), "selection-end-line");
        im.put(KeyStroke.getKeyStroke(38, 256), "caret-begin");
        im.put(KeyStroke.getKeyStroke(38, 320), "selection-begin");
        im.put(KeyStroke.getKeyStroke(40, 256), "caret-end");
        im.put(KeyStroke.getKeyStroke(40, 320), "selection-end");
    }
}

