/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CommonData;
import culturalDynamics.CommonEditor;
import culturalDynamics.Connection;
import culturalDynamics.ConnectionEditor;
import culturalDynamics.DateAndWidth;
import culturalDynamics.Dates;
import culturalDynamics.Event;
import culturalDynamics.EventEditor;
import culturalDynamics.ExportDialog;
import culturalDynamics.ExportHTML;
import culturalDynamics.FilterEditor;
import culturalDynamics.Find;
import culturalDynamics.FloaterViewPort;
import culturalDynamics.ImportSelector;
import culturalDynamics.InputFileJSON;
import culturalDynamics.IntroEditor;
import culturalDynamics.OutputFile;
import culturalDynamics.PopupMenuItem;
import culturalDynamics.Preferences;
import culturalDynamics.PreferencesImport;
import culturalDynamics.ReportMissing;
import culturalDynamics.ReportSummary;
import culturalDynamics.ReportXref;
import culturalDynamics.Row;
import culturalDynamics.RowData;
import culturalDynamics.RowEditor;
import culturalDynamics.SavedFilterData;
import culturalDynamics.Segment;
import culturalDynamics.SegmentEditor;
import culturalDynamics.SegmentList;
import culturalDynamics.TagList;
import culturalDynamics.TimePanel;
import culturalDynamics.Utils;
import culturalDynamics.WindowManager;
import culturalDynamics.XAxisPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileNameExtensionFilter;

class CDgui
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final String programVersion = "10.03";
    private final String programName = "Cultural Dynamics";
    private static final Point INITIAL_LOCATION = new Point(0, 0);
    private static final int N_AXIS_TICKS = 10;
    private static final int X_SLIDER_MAJOR_TICK = 10;
    private static final double INITIAL_XMAG = 1.0;
    private static final LocalDate INITIAL_START_DATE = LocalDate.of(1600, 1, 1);
    private static final LocalDate INITIAL_END_DATE = LocalDate.of(1900, 1, 1);
    private static final int INITIAL_VIEW_RANGE = 365;
    private static final int INITIAL_MAX_MAG_SLIDER = 200;
    private static final int OFFSET_X_REL_NOTES = 100;
    private static final int OFFSET_Y_REL_NOTES = 100;
    private static final Dimension INITIAL_REL_NOTES_SIZE = new Dimension(700, 600);
    private static final int OFFSET_X_ABOUT = 80;
    private static final int OFFSET_Y_ABOUT = 80;
    private static final Dimension INITIAL_ABOUT_SIZE = new Dimension(600, 400);
    private static final int OFFSET_X_HELP = 60;
    private static final int OFFSET_Y_HELP = 60;
    private static final Dimension INITIAL_HELP_SIZE = new Dimension(550, 350);
    private static String exitDialog1 = "Are you sure you want to close this program?\n";
    private static String exitDialog2 = "There are unsaved changes - are you sure you want to close this program?\n";
    private static String newSureDialog = "Data has not been saved. Are you sure you want to discard it and start a new history?";
    private static String openSureDialog = "Data has not been saved. Are you sure you want to discard it and open a different file?";
    private static String newOverwriteDialog = "New output file already exists. Do you want to overwrite it?";
    private String filePath = "";
    private String fileDir = "";
    private String jarPath = "";
    private String openRoot = "";
    private boolean fileSaved = true;
    private InputFileJSON inputFileJSON;
    private InputFileJSON oldInputFileJSON;
    private String importPath = "";
    private String importDir = "";
    private InputFileJSON importFileJSON;
    private InputFileJSON oldImportFileJSON;
    private PreferencesImport prefsImport;
    private JMenuItem itemPrefs = new JMenuItem("Preferences");
    private JMenuItem itemClose = new JMenuItem("Close");
    private JMenuItem itemNewFile = new JMenuItem("New File ...");
    private JMenuItem itemOpen = new JMenuItem("Open File ...");
    private JMenuItem itemImport = new JMenuItem("Import from File ...");
    private JMenuItem itemSave = new JMenuItem("Save");
    private JMenuItem itemSaveAs = new JMenuItem("Save As ...");
    private JMenuItem itemExportImage = new JMenuItem("Export Image ...");
    private JMenuItem itemExportHTML = new JMenuItem("Export HTML ...");
    private JMenuItem itemNewTimeline = new JMenuItem("New Timeline ...");
    private JMenuItem itemNewTimelineEvent = new JMenuItem("New Timeline Event ...");
    private JMenuItem itemNewGeneralEvent = new JMenuItem("New General Event ...");
    private JMenuItem itemNewConnection = new JMenuItem("New Connection ...");
    private JMenuItem itemNewUntimed = new JMenuItem("New Untimed Event ...");
    private JMenuItem itemEditRows = new JMenuItem("Edit Rows ...");
    private JMenuItem itemEditIntro = new JMenuItem("Edit Introduction ...");
    private JMenuItem itemFilter = new JMenuItem("Filter ...");
    private JMenuItem itemListTags = new JMenuItem("Cross-Reference Report");
    private JMenuItem itemListAll = new JMenuItem("Summary Report");
    private JMenuItem itemListMissing = new JMenuItem("Missing MetaData Report");
    private JMenuItem itemFind = new JMenuItem("Find ...");
    private JMenuItem itemAbout = new JMenuItem("About");
    private JMenuItem itemRelNotes = new JMenuItem("Release Notes");
    private JMenuItem itemIHelp = new JMenuItem("Help");
    private JMenuItem itemManual = new JMenuItem("Extract Manual");
    private JMenuItem itemIcons = new JMenuItem("Extract Icons");
    private int nTicks = 10;
    private double xMag = 1.0;
    private String filterStatusString = "Off";
    private LocalDate rangeStart = INITIAL_START_DATE;
    private LocalDate rangeEnd = INITIAL_END_DATE;
    private int startYear = this.rangeStart.getYear();
    private int endYear = this.rangeEnd.getYear();
    private int viewRangeDays = 365;
    private int maxZoom = this.endYear - this.startYear;
    private int maxMagSlider = 200;
    private JLabel xMagLabel = new JLabel("Zoom", 2);
    private JSlider xMagSlider = new JSlider(0, this.maxMagSlider, 0);
    private JLabel panScrollLabel = new JLabel("Pan", 2);
    private JScrollBar panScrollbar = new JScrollBar(0, 0, 10, 0, 100);
    private LocalDate viewStartDate = INITIAL_START_DATE;
    private JLabel unsavedChanges = new JLabel("");
    private final String unsavedString = "Unsaved Changes";
    private JLabel status = new JLabel("Magnification: " + this.xMag + "x", 2);
    private CDgui mainWindow;
    private TimePanel openTimePanel = null;
    private JScrollPane timeScrollPane = null;
    private FloaterViewPort timePort = null;
    private Preferences prefsWindow;
    private ExportDialog exportImageWindow;
    private ExportHTML exportHTMLWindow;
    private Find findWindow;
    private boolean findPlaced = false;
    private RowEditor rowEditor;
    private RowData ourRowData;
    private FilterEditor ourFilterEditor;
    private boolean filterPlaced = false;
    private SavedFilterData ourSavedFilterData = new SavedFilterData();
    private WindowManager windowManager;
    private TimePanel timePanel;
    private XAxisPanel ourXAxis;
    private String introText = "";
    private String techText = "";
    private IntroEditor ourIntroEditor = null;
    private ReportSummary listAllWin;
    private TagList masterTagList = new TagList();
    private Connection selectedCn = null;
    private int cnNameOldAbsX;
    private int cnNameOldAbsY;
    private double cnNameOldRelX;
    private double cnNameOldRelY;
    private boolean srcClicked = false;
    private boolean anyClicked = false;
    private PopupListener popupMenuListener = new PopupListener();

    public CDgui() {
        this.mainWindow = this;
        this.setTitle("Cultural Dynamics 10.03");
        this.setDefaultCloseOperation(0);
        this.setLayout(new BorderLayout());
        this.windowManager = new WindowManager(this.mainWindow);
        this.prefsWindow = new Preferences(this);
        this.prefsWindow.setResizable(true);
        this.prefsWindow.setVisible(false);
        this.exportImageWindow = new ExportDialog(this);
        this.exportImageWindow.setResizable(true);
        this.exportImageWindow.setVisible(false);
        this.exportHTMLWindow = new ExportHTML(this);
        this.exportHTMLWindow.setResizable(true);
        this.exportHTMLWindow.setVisible(false);
        this.findWindow = new Find(this);
        this.findPlaced = false;
        this.findWindow.setResizable(true);
        this.findWindow.setVisible(false);
        this.ourRowData = new RowData();
        this.ourRowData.insertRow(new Row(), 0);
        this.rowEditor = new RowEditor(this, 0, this.ourRowData);
        this.rowEditor.setResizable(true);
        this.rowEditor.setVisible(false);
        this.filePath = "";
        this.openFile("");
        this.xMag = 1.0;
        this.status.setText("Magnification: " + this.xMag + "x  Filter: " + this.filterStatusString);
        this.nTicks = 10;
        this.xMagSlider.setValue(0);
        this.setRange();
        this.panLimits();
        this.openTimePanel.revalidate();
        this.openTimePanel.repaint();
        this.setLocation(INITIAL_LOCATION);
        Rectangle2D screen = this.windowManager.getCurrentScreenBounds();
        int width = (int)screen.getWidth() * 2 / 3;
        int height = (int)screen.getHeight();
        this.setSize(new Dimension(width, height));
        this.setPreferredSize(new Dimension(width, height));
        this.ourFilterEditor = new FilterEditor(this);
        this.ourFilterEditor.setVisible(false);
        this.unsavedChanges.setForeground(Color.red);
        this.getMainWindow().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                CDgui.this.mainWindow.toFront();
                String exitDialog = exitDialog1;
                if (!CDgui.this.fileSaved) {
                    exitDialog = exitDialog2;
                }
                if (JOptionPane.showConfirmDialog(CDgui.this.getMainWindow(), exitDialog, "Close Program?", 0, 3) == 0) {
                    System.exit(0);
                }
            }
        });
        try {
            this.jarPath = new File(TimePanel.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
        }
        catch (URISyntaxException e) {
            JOptionPane.showMessageDialog(this, "CDGUI Exception getting jar path\n" + e.getMessage());
        }
        this.setVisible(true);
        JMenuBar mainMenu = new JMenuBar();
        JMenu menuProgram = new JMenu("Program");
        menuProgram.add(this.itemPrefs);
        this.itemPrefs.addActionListener(this);
        menuProgram.add(this.itemClose);
        this.itemClose.addActionListener(this);
        JMenu menuFile = new JMenu("File");
        menuFile.add(this.itemNewFile);
        this.itemNewFile.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        this.itemNewFile.addActionListener(this);
        menuFile.add(this.itemOpen);
        this.itemOpen.addActionListener(this);
        menuFile.add(this.itemImport);
        this.itemImport.addActionListener(this);
        if (System.getProperty("os.name", "").toUpperCase().startsWith("MAC")) {
            this.itemOpen.setAccelerator(KeyStroke.getKeyStroke(79, 4));
        } else {
            this.itemOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        }
        menuFile.add(this.itemSave);
        this.itemSave.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        this.itemSave.addActionListener(this);
        menuFile.add(this.itemSaveAs);
        if (System.getProperty("os.name", "").toUpperCase().startsWith("MAC")) {
            this.itemSaveAs.setAccelerator(KeyStroke.getKeyStroke(83, 5));
        } else {
            this.itemSaveAs.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        }
        this.itemSaveAs.addActionListener(this);
        menuFile.addSeparator();
        menuFile.add(this.itemExportImage);
        this.itemExportImage.addActionListener(this);
        menuFile.add(this.itemExportHTML);
        this.itemExportHTML.addActionListener(this);
        JMenu menuEdit = new JMenu("Edit");
        menuEdit.add(this.itemNewTimeline);
        this.itemNewTimeline.addActionListener(this);
        menuEdit.add(this.itemNewTimelineEvent);
        this.itemNewTimelineEvent.addActionListener(this);
        menuEdit.add(this.itemNewGeneralEvent);
        this.itemNewGeneralEvent.addActionListener(this);
        menuEdit.add(this.itemNewConnection);
        this.itemNewConnection.addActionListener(this);
        menuEdit.add(this.itemNewUntimed);
        this.itemNewUntimed.addActionListener(this);
        menuEdit.addSeparator();
        menuEdit.add(this.itemEditRows);
        this.itemEditRows.addActionListener(this);
        menuEdit.add(this.itemEditIntro);
        this.itemEditIntro.addActionListener(this);
        JMenu menuView = new JMenu("View");
        menuView.add(this.itemFilter);
        this.itemFilter.addActionListener(this);
        menuView.add(this.itemFind);
        this.itemFind.setAccelerator(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        this.itemFind.addActionListener(this);
        menuView.addSeparator();
        menuView.add(this.itemListAll);
        this.itemListAll.addActionListener(this);
        menuView.add(this.itemListTags);
        this.itemListTags.addActionListener(this);
        menuView.add(this.itemListMissing);
        this.itemListMissing.addActionListener(this);
        menuView.addSeparator();
        this.itemNewTimeline.setEnabled(false);
        this.itemNewTimelineEvent.setEnabled(false);
        this.itemNewGeneralEvent.setEnabled(false);
        this.itemNewConnection.setEnabled(false);
        this.itemNewUntimed.setEnabled(false);
        this.itemEditRows.setEnabled(false);
        this.itemEditIntro.setEnabled(false);
        this.itemImport.setEnabled(false);
        this.itemSave.setEnabled(false);
        this.itemSaveAs.setEnabled(false);
        this.itemExportImage.setEnabled(false);
        this.itemExportHTML.setEnabled(false);
        this.itemFilter.setEnabled(false);
        this.itemFind.setEnabled(false);
        this.itemListTags.setEnabled(false);
        this.itemListAll.setEnabled(false);
        this.itemListMissing.setEnabled(false);
        JMenu menuHelp = new JMenu("Help");
        menuHelp.add(this.itemRelNotes);
        this.itemRelNotes.addActionListener(this);
        menuHelp.add(this.itemAbout);
        this.itemAbout.addActionListener(this);
        menuHelp.add(this.itemIHelp);
        this.itemIHelp.addActionListener(this);
        menuHelp.add(this.itemManual);
        this.itemManual.addActionListener(this);
        menuHelp.add(this.itemIcons);
        this.itemIcons.addActionListener(this);
        this.itemPrefs.setToolTipText("Open the preferences window");
        this.itemClose.setToolTipText("Close the program");
        this.itemNewFile.setToolTipText("Create a new file");
        this.itemNewTimeline.setToolTipText("Create a new time line");
        this.itemNewTimelineEvent.setToolTipText("Create new event associated with a time line");
        this.itemNewGeneralEvent.setToolTipText("Create new general event");
        this.itemNewConnection.setToolTipText("Create new connection");
        this.itemNewUntimed.setToolTipText("Create a new untimed event independent of the timeline");
        this.itemEditRows.setToolTipText("Open the row editor");
        this.itemEditIntro.setToolTipText("Edit overall introductory text of the file");
        this.itemOpen.setToolTipText("Select a JSON file for processing");
        this.itemImport.setToolTipText("Import selected items from another file");
        this.itemSave.setToolTipText("Save to the input file");
        this.itemSaveAs.setToolTipText("Select and save to output file");
        this.itemExportImage.setToolTipText("Export the diagram to graphics files");
        this.itemExportHTML.setToolTipText("Export the graphics and descriptions as an HTML website");
        this.itemFilter.setToolTipText("Filter the display");
        this.itemListTags.setToolTipText("Show a formatted list of all the tags per item and items that use each tag.");
        this.itemListAll.setToolTipText("Show a formatted list of all items.");
        this.itemListMissing.setToolTipText("Show a formatted list of items with missing metadata");
        this.itemFind.setToolTipText("Find an item on the diagram");
        this.itemRelNotes.setToolTipText("Display the changes made in all versions of the program");
        this.itemAbout.setToolTipText("Display information about the program");
        this.itemIHelp.setToolTipText("Display help information");
        this.itemManual.setToolTipText("Extract the user manual PDF to the location of the jar file or your home folder on your disc and then opens it");
        this.itemIcons.setToolTipText("Extract some basic icons to your disc, OVERWRITES existing files!");
        mainMenu.add(menuProgram);
        mainMenu.add(menuFile);
        mainMenu.add(menuEdit);
        mainMenu.add(menuView);
        mainMenu.add(menuHelp);
        this.setJMenuBar(mainMenu);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            var2_2 = e.getActionCommand();
            tmp = -1;
            switch (var2_2.hashCode()) {
                case -1891854858: {
                    if (var2_2.equals("Cross-Reference Report")) {
                        tmp = 1;
                    }
                    break;
                }
                case -1836553944: {
                    if (var2_2.equals("Release Notes")) {
                        tmp = 2;
                    }
                    break;
                }
                case -1768732539: {
                    if (var2_2.equals("Extract Manual")) {
                        tmp = 3;
                    }
                    break;
                }
                case -1759862423: {
                    if (var2_2.equals("New Timeline Event ...")) {
                        tmp = 4;
                    }
                    break;
                }
                case -1648337667: {
                    if (var2_2.equals("Edit Rows ...")) {
                        tmp = 5;
                    }
                    break;
                }
                case -1545472949: {
                    if (var2_2.equals("Missing MetaData Report")) {
                        tmp = 6;
                    }
                    break;
                }
                case -1307615621: {
                    if (var2_2.equals("Extract Icons")) {
                        tmp = 7;
                    }
                    break;
                }
                case -956168402: {
                    if (var2_2.equals("Summary Report")) {
                        tmp = 8;
                    }
                    break;
                }
                case -672183107: {
                    if (var2_2.equals("Export Image ...")) {
                        tmp = 9;
                    }
                    break;
                }
                case -637237544: {
                    if (var2_2.equals("Preferences")) {
                        tmp = 10;
                    }
                    break;
                }
                case -616164441: {
                    if (var2_2.equals("Find ...")) {
                        tmp = 11;
                    }
                    break;
                }
                case -577318676: {
                    if (var2_2.equals("New Connection ...")) {
                        tmp = 12;
                    }
                    break;
                }
                case -473664322: {
                    if (var2_2.equals("Edit Introduction ...")) {
                        tmp = 13;
                    }
                    break;
                }
                case 2245473: {
                    if (var2_2.equals("Help")) {
                        tmp = 14;
                    }
                    break;
                }
                case 2569629: {
                    if (var2_2.equals("Save")) {
                        tmp = 15;
                    }
                    break;
                }
                case 63058797: {
                    if (var2_2.equals("About")) {
                        tmp = 16;
                    }
                    break;
                }
                case 65203672: {
                    if (var2_2.equals("Close")) {
                        tmp = 17;
                    }
                    break;
                }
                case 83286154: {
                    if (var2_2.equals("New File ...")) {
                        tmp = 18;
                    }
                    break;
                }
                case 241751776: {
                    if (var2_2.equals("Open File ...")) {
                        tmp = 19;
                    }
                    break;
                }
                case 438790630: {
                    if (var2_2.equals("Filter ...")) {
                        tmp = 20;
                    }
                    break;
                }
                case 955836326: {
                    if (var2_2.equals("New Untimed Event ...")) {
                        tmp = 21;
                    }
                    break;
                }
                case 997320067: {
                    if (var2_2.equals("Save As ...")) {
                        tmp = 22;
                    }
                    break;
                }
                case 1570335951: {
                    if (var2_2.equals("New Timeline ...")) {
                        tmp = 23;
                    }
                    break;
                }
                case 1719490693: {
                    if (var2_2.equals("Import from File ...")) {
                        tmp = 24;
                    }
                    break;
                }
                case 1772347205: {
                    if (var2_2.equals("Export HTML ...")) {
                        tmp = 25;
                    }
                    break;
                }
                case 1876980688: {
                    if (var2_2.equals("New General Event ...")) {
                        tmp = 26;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 10: {
                    this.windowManager.positionWindow(this.prefsWindow, WindowManager.ScreenSide.TOP_RIGHT);
                    break;
                }
                case 17: {
                    exitDialog = CDgui.exitDialog1;
                    if (!this.fileSaved) {
                        exitDialog = CDgui.exitDialog2;
                    }
                    if ((closeSelection = JOptionPane.showConfirmDialog(this.getMainWindow(), exitDialog, "Close Program?", 0, 3)) == 0) {
                        System.exit(0);
                    }
                    break;
                }
                case 18: {
                    if (this.openTimePanel == null || this.fileSaved || (newSureSelection = JOptionPane.showConfirmDialog(this.getMainWindow(), CDgui.newSureDialog, "New File", 0, 3)) != 1) {
                        this.windowManager.resetWindows();
                        this.initialise();
                        this.filePath = "";
                        this.openFile("");
                        this.itemNewTimeline.setEnabled(true);
                        this.itemNewGeneralEvent.setEnabled(true);
                        this.itemEditRows.setEnabled(true);
                        this.itemEditIntro.setEnabled(true);
                        this.itemImport.setEnabled(true);
                        this.itemSave.setEnabled(false);
                        this.itemSaveAs.setEnabled(true);
                        this.itemExportImage.setEnabled(true);
                        this.itemExportHTML.setEnabled(true);
                        this.xMag = 1.0;
                        this.status.setText("Magnification: " + this.xMag + "x  Filter: " + this.filterStatusString);
                        this.nTicks = 10;
                        this.xMagSlider.setValue(0);
                        this.setRange();
                        this.panLimits();
                        this.openTimePanel.revalidate();
                        this.openTimePanel.repaint();
                    }
                    break;
                }
                case 19: {
                    if (this.openTimePanel == null || this.fileSaved || (openSureSelection = JOptionPane.showConfirmDialog(this.getMainWindow(), CDgui.openSureDialog, "Open File", 0, 3)) != 1) {
                        oldFilePath = this.filePath;
                        this.oldInputFileJSON = this.inputFileJSON;
                        this.openRoot = "";
                        this.openRoot = this.fileDir.equals("") != false ? System.getProperty("user.home") : this.fileDir;
                        openChooser = new JFileChooser(this.openRoot);
                        openChooser.setDialogTitle("Open an Existing File");
                        openChoice = openChooser.showOpenDialog(this.getMainWindow());
                        if (openChoice != 0) {
                            return;
                        }
                        chosenOpenFile = openChooser.getSelectedFile();
                        this.filePath = chosenOpenFile.getAbsolutePath();
                        this.fileDir = chosenOpenFile.getParent();
                        this.windowManager.resetWindows();
                        this.initialise();
                        if (this.openFile(this.filePath)) {
                            this.setTitle("Cultural Dynamics 10.03 " + this.filePath);
                            this.itemNewTimeline.setEnabled(true);
                            this.itemNewTimelineEvent.setEnabled(true);
                            this.itemNewGeneralEvent.setEnabled(true);
                            this.itemNewConnection.setEnabled(true);
                            this.itemNewUntimed.setEnabled(true);
                            this.itemEditRows.setEnabled(true);
                            this.itemEditIntro.setEnabled(true);
                            this.itemImport.setEnabled(true);
                            this.itemSave.setEnabled(true);
                            this.itemSaveAs.setEnabled(true);
                            this.itemExportImage.setEnabled(true);
                            this.itemExportHTML.setEnabled(true);
                            this.itemFilter.setEnabled(true);
                            this.itemFind.setEnabled(true);
                            this.itemListTags.setEnabled(true);
                            this.itemListAll.setEnabled(true);
                            this.itemListMissing.setEnabled(true);
                        } else {
                            this.filePath = oldFilePath;
                            this.inputFileJSON = this.oldInputFileJSON;
                        }
                        this.openTimePanel.revalidate();
                        this.openTimePanel.repaint();
                    }
                    break;
                }
                case 24: {
                    oldImportPath = this.importPath;
                    this.oldImportFileJSON = this.importFileJSON;
                    ourImportRoot = "";
                    ourImportRoot = this.importDir.equals("") ? (!this.fileDir.equals("") ? this.fileDir : System.getProperty("user.home")) : this.importDir;
                    importChooser = new JFileChooser(ourImportRoot);
                    importChooser.setDialogTitle("Import from an Existing File");
                    importChoice = importChooser.showOpenDialog(this.getMainWindow());
                    if (importChoice != 0) {
                        return;
                    }
                    chosenImportFile = importChooser.getSelectedFile();
                    this.importPath = chosenImportFile.getAbsolutePath();
                    this.importDir = chosenImportFile.getParent();
                    if (this.importPath != "") {
                        this.prefsImport = new PreferencesImport();
                        this.importFileJSON = new InputFileJSON(this, this.prefsWindow, this.prefsImport, this.masterTagList, this.ourRowData, InputFileJSON.ReadImport.IMPORT);
                        if (!this.importFileJSON.readDataFile(this.importPath)) {
                            JOptionPane.showMessageDialog(this, "Could not read JSON Import file.");
                            this.importPath = oldImportPath;
                            this.importFileJSON = this.oldImportFileJSON;
                            i = 0;
                            while (i < this.importFileJSON.getEvents().size()) {
                                ev = this.importFileJSON.getEvents().get(i);
                                System.out.println(ev.getEventTypeAsName() + " " + ev.getName());
                                ++i;
                            }
                        }
                        importFrame = new ImportSelector(this, this.importFileJSON);
                        this.windowManager.positionWindow(importFrame, WindowManager.ScreenSide.CASCADE_TR);
                    }
                    break;
                }
                case 15: {
                    if (this.filePath != "") {
                        if (this.inputFileJSON == null) {
                            JOptionPane.showMessageDialog(this, "There is nothing to save!");
                            break;
                        }
                        outFile = new OutputFile();
                        saveFile = new File(this.filePath);
                        saveResult1 = outFile.OpenFileForWrite(saveFile, this);
                        saveResult2 = outFile.writeJSONdata(this.inputFileJSON.getEventData(), this.inputFileJSON.getConnections(), this);
                        if (saveResult1 && saveResult2) {
                            this.fileSaved = true;
                            this.unsavedChanges.setText("");
                            this.setTitle("Cultural Dynamics 10.03 " + this.filePath);
                        }
                        break;
                    }
                    JOptionPane.showMessageDialog(this, "CDGUI No file chosen - Use Save As");
                    break;
                }
                case 22: {
                    if (this.inputFileJSON == null) {
                        JOptionPane.showMessageDialog(this, "There is nothing to save!");
                        break;
                    }
                    try {
                        outfolderPath = System.getProperty("user.home");
                        if (!this.filePath.equals("")) {
                            outfolderPath = this.filePath;
                        }
                        outFileChooser = new JFileChooser(outfolderPath);
                        outFileChooser.setDialogType(1);
                        outFileChooser.setDialogTitle("Save to File");
                        outFileChooser.setApproveButtonText("Save");
                        outFileChooser.setSelectedFile(new File("newfile.json"));
                        outFileChooser.setFileFilter(new FileNameExtensionFilter("json file", new String[]{"json"}));
                        outfolderChoice = outFileChooser.showSaveDialog(this);
                        filename = null;
                        if (outfolderChoice == 0) {
                            filename = outFileChooser.getSelectedFile().toString();
                            filename = outFileChooser.getSelectedFile().toString();
                            if (!filename.endsWith(".json")) {
                                filename = (String)filename + ".json";
                            }
                        } else {
                            return;
                        }
                        saveFile = new File((String)filename);
                        outfolderPath = saveFile.getAbsolutePath();
                        fileToSave = new OutputFile();
                        if (!saveFile.exists() || (newOverwriteSelection = JOptionPane.showConfirmDialog(this.getMainWindow(), CDgui.newOverwriteDialog, "That File Already Exists - overwrite it?", 0, 3)) != 1) {
                            saveAsResult1 = OutputFile.CreateOutFile(saveFile, this);
                            saveAsResult2 = fileToSave.OpenFileForWrite(saveFile, this);
                            saveAsResult3 = fileToSave.writeJSONdata(this.inputFileJSON.getEventData(), this.inputFileJSON.getConnections(), this);
                            if (saveAsResult1 && saveAsResult2 && saveAsResult3) {
                                this.fileSaved = true;
                                this.unsavedChanges.setText("");
                                this.filePath = outfolderPath;
                                this.setTitle("Cultural Dynamics 10.03 " + this.filePath);
                                this.itemSave.setEnabled(true);
                            }
                        }
                    }
                    catch (Throwable unforeseen) {
                        JOptionPane.showMessageDialog(this, "Unhandled Error in file save!\n" + this.displayError(unforeseen));
                        this.fileSaved = false;
                        this.unsavedChanges.setText("Unsaved Changes");
                    }
                    break;
                }
                case 9: {
                    this.exportImageWindow.setTimePanel(this.openTimePanel);
                    this.windowManager.positionWindow(this.exportImageWindow, WindowManager.ScreenSide.CASCADE_TR);
                    break;
                }
                case 25: {
                    this.windowManager.positionWindow(this.exportHTMLWindow, WindowManager.ScreenSide.CASCADE_TR);
                    break;
                }
                case 23: {
                    if (this.inputFileJSON == null) {
                        JOptionPane.showMessageDialog(this, "Cannot create new time line if no file is open");
                        break;
                    }
                    newTimeline = new Event(CommonData.EventType.TIMELINE, "New Timeline", this.prefsWindow.getPalette().getColorName(0), 0, new Dates(null, null, null, null), null, null, null);
                    newTimelineEditor = new EventEditor(this.mainWindow, newTimeline, this.openTimePanel, this.inputFileJSON.getEventData(), this.inputFileJSON.getConnections(), CommonEditor.NewObject.NEW);
                    this.windowManager.positionWindow(newTimelineEditor, WindowManager.ScreenSide.CASCADE_TR);
                    this.itemNewTimelineEvent.setEnabled(true);
                    this.itemNewGeneralEvent.setEnabled(true);
                    this.itemNewConnection.setEnabled(true);
                    this.itemNewUntimed.setEnabled(true);
                    this.itemSaveAs.setEnabled(true);
                    this.itemExportImage.setEnabled(true);
                    this.itemFilter.setEnabled(true);
                    this.itemFind.setEnabled(true);
                    this.itemListTags.setEnabled(true);
                    this.itemListAll.setEnabled(true);
                    this.itemListMissing.setEnabled(true);
                    break;
                }
                case 4: {
                    if (this.inputFileJSON == null) {
                        JOptionPane.showMessageDialog(this, "Cannot create new event if no file is open");
                        break;
                    }
                    if (this.inputFileJSON.getEventData().getNumberOfTimelines() == 0) {
                        JOptionPane.showMessageDialog(this, "Cannot create new timeline event if no timeline exists.");
                        break;
                    }
                    newEvent = new Event(CommonData.EventType.TIMELINE_EVENT, "New Event", this.prefsWindow.getPalette().getColorName(0), 0, new Dates(null, null, null, null), null, null, null);
                    newEventEditor = new EventEditor(this, newEvent, this.openTimePanel, this.inputFileJSON.getEventData(), this.inputFileJSON.getConnections(), CommonEditor.NewObject.NEW);
                    this.windowManager.positionWindow(newEventEditor, WindowManager.ScreenSide.CASCADE_TR);
                    this.itemNewTimelineEvent.setEnabled(true);
                    this.itemNewGeneralEvent.setEnabled(true);
                    this.itemNewConnection.setEnabled(true);
                    this.itemNewUntimed.setEnabled(true);
                    this.itemFilter.setEnabled(true);
                    this.itemFind.setEnabled(true);
                    this.itemListTags.setEnabled(true);
                    this.itemListAll.setEnabled(true);
                    this.itemListMissing.setEnabled(true);
                    break;
                }
                case 26: {
                    if (this.inputFileJSON == null) {
                        JOptionPane.showMessageDialog(this, "Cannot create new event if no file is open");
                        break;
                    }
                    newEvent = new Event(CommonData.EventType.GENERAL_EVENT, "New Event", this.prefsWindow.getPalette().getColorName(0), 0, new Dates(null, null, null, null), null, null, null);
                    newEventEditor = new EventEditor(this, newEvent, this.openTimePanel, this.inputFileJSON.getEventData(), this.inputFileJSON.getConnections(), CommonEditor.NewObject.NEW);
                    this.windowManager.positionWindow(newEventEditor, WindowManager.ScreenSide.CASCADE_TR);
                    this.itemNewTimeline.setEnabled(true);
                    this.itemNewTimelineEvent.setEnabled(true);
                    this.itemNewConnection.setEnabled(true);
                    this.itemNewUntimed.setEnabled(true);
                    this.itemSaveAs.setEnabled(true);
                    this.itemExportImage.setEnabled(true);
                    this.itemFilter.setEnabled(true);
                    this.itemFind.setEnabled(true);
                    this.itemListTags.setEnabled(true);
                    this.itemListAll.setEnabled(true);
                    this.itemListMissing.setEnabled(true);
                    break;
                }
                case 21: {
                    if (this.inputFileJSON == null) {
                        JOptionPane.showMessageDialog(this, "Cannot create new untimed event if no file is open");
                        break;
                    }
                    newEvent = new Event(CommonData.EventType.UNTIMED, "New Untimed", this.prefsWindow.getPalette().getColorName(0), 0, new Dates(null, null, null, null), null, null, null);
                    newUntimedEditor = new EventEditor(this, newEvent, this.openTimePanel, this.inputFileJSON.getEventData(), this.inputFileJSON.getConnections(), CommonEditor.NewObject.NEW);
                    this.windowManager.positionWindow(newUntimedEditor, WindowManager.ScreenSide.CASCADE_TR);
                    this.itemNewTimeline.setEnabled(true);
                    this.itemNewTimelineEvent.setEnabled(true);
                    this.itemNewConnection.setEnabled(true);
                    this.itemNewUntimed.setEnabled(true);
                    this.itemSaveAs.setEnabled(true);
                    this.itemExportImage.setEnabled(true);
                    this.itemFilter.setEnabled(true);
                    this.itemFind.setEnabled(true);
                    this.itemListTags.setEnabled(true);
                    this.itemListAll.setEnabled(true);
                    this.itemListMissing.setEnabled(true);
                    break;
                }
                case 12: {
                    if (this.inputFileJSON == null) {
                        JOptionPane.showMessageDialog(this, "Cannot create new connection if no file is open");
                        break;
                    }
                    if (this.inputFileJSON.getEventData().getNumberOfTimelines() + this.inputFileJSON.getEventData().getNumberOfEventsOnly() < 2) {
                        JOptionPane.showMessageDialog(this, "At least two timelines and/or events are needed for a connection.");
                        break;
                    }
                    newConnection = new Connection("", "", this.prefsWindow.getPalette().getColorName(0), this.inputFileJSON.getEventData().getEventByIndex(0), null, null, this.inputFileJSON.getEventData().getEventByIndex(1), null, null, Connection.LineType.DIRECT, Connection.DashType.PLAIN, Connection.FwdArrow.NO_FWD_ARROW, Connection.BckArrow.NO_BCK_ARROW, Connection.Curve.STRAIGHT, this.prefsWindow.getBezierCtrlX(), this.prefsWindow.getBezierCtrlY(), Connection.ShowNameAtSrc.NO_NAME_AT_SRC, Connection.INITIAL_CON_NAME_SRC, Connection.ShowNameAtDst.NO_NAME_AT_DST, Connection.INITIAL_CON_NAME_DST);
                    newConnectionEditor = new ConnectionEditor(this, newConnection, this.inputFileJSON.getEventData(), this.inputFileJSON.getConnections(), CommonEditor.NewObject.NEW);
                    this.windowManager.positionWindow(newConnectionEditor, WindowManager.ScreenSide.CASCADE_TR);
                    this.itemFilter.setEnabled(true);
                    this.itemFind.setEnabled(true);
                    this.itemListTags.setEnabled(true);
                    this.itemListAll.setEnabled(true);
                    this.itemListMissing.setEnabled(true);
                    break;
                }
                case 5: {
                    if (this.inputFileJSON == null) {
                        JOptionPane.showMessageDialog(this, "Cannot edit rows if no file is open");
                        break;
                    }
                    this.windowManager.positionWindow(this.rowEditor, WindowManager.ScreenSide.TOP_RIGHT);
                    break;
                }
                case 13: {
                    if (this.inputFileJSON == null) {
                        JOptionPane.showMessageDialog(this, "Cannot edit introduction if no file is open");
                        break;
                    }
                    this.showIntroEditor();
                    break;
                }
                case 20: {
                    this.windowManager.positionWindow(this.ourFilterEditor, WindowManager.ScreenSide.TOP_RIGHT);
                    if (!this.filterPlaced) {
                        this.filterPlaced = true;
                    }
                    this.ourFilterEditor.setVisible(true);
                    break;
                }
                case 11: {
                    this.windowManager.positionWindow(this.findWindow, WindowManager.ScreenSide.BOTTOM_RIGHT);
                    if (!this.findPlaced) {
                        this.findPlaced = true;
                    }
                    break;
                }
                case 1: {
                    xRefWindow = new ReportXref(this);
                    this.windowManager.positionWindow(xRefWindow, WindowManager.ScreenSide.CASCADE_TL);
                    break;
                }
                case 8: {
                    this.listAllWin = new ReportSummary(this);
                    this.windowManager.positionWindow(this.listAllWin, WindowManager.ScreenSide.CASCADE_TL);
                    break;
                }
                case 6: {
                    missingWin = new ReportMissing(this);
                    this.windowManager.positionWindow(missingWin, WindowManager.ScreenSide.CASCADE_TL);
                    break;
                }
                case 2: {
                    relNotesFrame = new JFrame();
                    relNotesFrame.setDefaultCloseOperation(1);
                    relNotesPane = new JEditorPane();
                    relNotesPane.setEditable(false);
                    relNotesPane.setContentType("text/html");
                    relNotesURL = this.getClass().getClassLoader().getResource("relnotes.html");
                    if (relNotesURL != null) {
                        try {
                            relNotesPane.setPage(relNotesURL);
                        }
                        catch (IOException rne) {
                            rne.printStackTrace();
                        }
                    } else {
                        JOptionPane.showMessageDialog(this.getMainWindow(), "Release Notes file not found");
                    }
                    relNotesScrollPane = new JScrollPane(relNotesPane);
                    relNotesFrame.setLocation(this.getMainWindow().getX() + 100, this.getMainWindow().getY() + 100);
                    relNotesFrame.add(relNotesScrollPane);
                    relNotesScrollPane.setPreferredSize(CDgui.INITIAL_REL_NOTES_SIZE);
                    relNotesFrame.setSize(CDgui.INITIAL_REL_NOTES_SIZE);
                    relNotesFrame.setVisible(true);
                    break;
                }
                case 16: {
                    aboutFrame = new JFrame();
                    aboutFrame.setDefaultCloseOperation(1);
                    aboutPane = new JEditorPane();
                    aboutPane.setEditable(false);
                    aboutPane.setContentType("text/html");
                    aboutPane.addHyperlinkListener(new HyperlinkListener(){

                        @Override
                        public void hyperlinkUpdate(HyperlinkEvent hle) {
                            if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                                Desktop desktop = Desktop.getDesktop();
                                try {
                                    desktop.browse(hle.getURL().toURI());
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        }
                    });
                    aboutURL = this.getClass().getClassLoader().getResource("about.html");
                    if (aboutURL != null) {
                        try {
                            aboutPane.setPage(aboutURL);
                        }
                        catch (IOException rne) {
                            rne.printStackTrace();
                        }
                    } else {
                        JOptionPane.showMessageDialog(this.getMainWindow(), "About file not found");
                    }
                    versionText = "Program Version: 10.03 Java Version: " + System.getProperty("java.version");
                    aboutScrollPane = new JScrollPane(aboutPane);
                    tlIconPanelTitle = new TitledBorder(new LineBorder(Color.lightGray, 3), versionText, 1, 2);
                    aboutScrollPane.setBorder(tlIconPanelTitle);
                    aboutFrame.add(aboutScrollPane);
                    aboutScrollPane.setPreferredSize(CDgui.INITIAL_ABOUT_SIZE);
                    aboutFrame.setSize(CDgui.INITIAL_ABOUT_SIZE);
                    aboutFrame.setLocation(this.getMainWindow().getX() + 80, this.getMainWindow().getY() + 80);
                    aboutFrame.setVisible(true);
                    break;
                }
                case 14: {
                    helpFrame = new JFrame();
                    helpFrame.setDefaultCloseOperation(1);
                    helpPane = new JEditorPane();
                    helpPane.setEditable(false);
                    helpPane.setContentType("text/html");
                    helpURL = this.getClass().getClassLoader().getResource("help.html");
                    if (helpURL != null) {
                        try {
                            helpPane.setPage(helpURL);
                        }
                        catch (IOException rne) {
                            rne.printStackTrace();
                        }
                    } else {
                        JOptionPane.showMessageDialog(this.getMainWindow(), "Help file not found");
                    }
                    helpScrollPane = new JScrollPane(helpPane);
                    helpScrollPane.setPreferredSize(CDgui.INITIAL_HELP_SIZE);
                    helpFrame.add(helpScrollPane);
                    helpFrame.setPreferredSize(CDgui.INITIAL_HELP_SIZE);
                    helpFrame.setSize(CDgui.INITIAL_HELP_SIZE);
                    helpFrame.setLocation(this.getMainWindow().getX() + 60, this.getMainWindow().getY() + 60);
                    helpFrame.setVisible(true);
                    break;
                }
                case 3: {
                    manualFile = null;
                    manualOK = false;
                    jarPath = Paths.get(CDgui.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                    jarPathString = jarPath.toString();
                    if (jarPathString.endsWith(".jar")) {
                        jarPathString = jarPath.getParent().toString();
                    }
                    jarPathString = (String)jarPathString + File.separator + "cdManual10.03.pdf";
                    jarPath = Paths.get((String)jarPathString, new String[0]);
                    manualStream = this.getClass().getResourceAsStream("manual.pdf");
                    if (manualStream == null) ** GOTO lbl548
                    try {
                        Files.copy(manualStream, jarPath, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                        JOptionPane.showMessageDialog(this.getMainWindow(), "Manual copied to " + jarPath.toString() + "\nWill now open PDF");
                        manualFile = jarPath.toFile();
                        manualOK = true;
                    }
                    catch (IOException exc1) {
                        JOptionPane.showMessageDialog(this.getMainWindow(), "Manual file could not be written to location of jar file");
                        try {
                            userPath = Paths.get(System.getProperty("user.home") + File.separator + "cdManual10.03.pdf", new String[0]);
                            Files.copy(manualStream, userPath, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                            JOptionPane.showMessageDialog(this.getMainWindow(), "Manual copied to " + userPath.toString() + "\nWill now open PDF");
                            manualFile = userPath.toFile();
                            manualOK = true;
                            ** GOTO lbl549
                        }
                        catch (IOException exc2) {
                            JOptionPane.showMessageDialog(this.getMainWindow(), "Manual file could not be written to user folder - see Help");
                        }
                    }
                    ** GOTO lbl549
lbl548:
                    // 1 sources

                    JOptionPane.showMessageDialog(this.getMainWindow(), "Manual file not found in jar file");
lbl549:
                    // 4 sources

                    if (manualOK && Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().open(manualFile);
                        }
                        catch (IOException | IllegalArgumentException exd) {
                            JOptionPane.showMessageDialog(this.getMainWindow(), "Cannot open user manual PDF file in desktop");
                        }
                    }
                    break;
                }
                case 7: {
                    iconsOK = false;
                    iconBrowsePath = this.prefsWindow.getIconsPath();
                    tmp = new File(iconBrowsePath);
                    if (!tmp.exists()) {
                        iconBrowsePath = System.getProperty("user.home");
                    }
                    iconDirChooser = new JFileChooser(iconBrowsePath);
                    iconDirChooser.setDialogTitle("Folder to Extract Icons  - will overwrite existing!");
                    iconDirChooser.setApproveButtonText("Select and Go");
                    iconDirChooser.setFileSelectionMode(1);
                    iconDirChoice = iconDirChooser.showOpenDialog(this);
                    if (iconDirChoice != 0) break;
                    chosenDir = iconDirChooser.getSelectedFile();
                    newIconsPath = chosenDir.getAbsolutePath();
                    iconsURL = this.getClass().getClassLoader().getResource("icons");
                    if (iconsURL == null) ** GOTO lbl601
                    try {
                        var43_80 = null;
                        var44_83 = null;
                        try {
                            iconsDirStream = Files.newDirectoryStream(Paths.get(iconsURL.getPath(), new String[0]));
                            try {
                                for (Path p : iconsDirStream) {
                                    nextFile = p.toString();
                                    System.out.println(nextFile + " to " + String.valueOf(Paths.get(newIconsPath + File.separator + String.valueOf(p.getFileName()), new String[0])));
                                    Files.copy(p, Paths.get(newIconsPath + File.separator + String.valueOf(p.getFileName()), new String[0]), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                                }
                                iconsDirStream.close();
                                iconsOK = true;
                                ** GOTO lbl602
                            }
                            finally {
                                if (iconsDirStream != null) {
                                    iconsDirStream.close();
                                }
                            }
                        }
                        catch (Throwable var44_84) {
                            if (var43_80 == null) {
                                var43_80 = var44_84;
                            } else if (var43_80 != var44_84) {
                                var43_80.addSuppressed(var44_84);
                            }
                            throw var43_80;
                        }
                    }
                    catch (Throwable dirStreamError) {
                        JOptionPane.showMessageDialog(this.getMainWindow(), "Directory Stream Error!\n" + String.valueOf(dirStreamError));
                    }
                    ** GOTO lbl602
lbl601:
                    // 1 sources

                    JOptionPane.showMessageDialog(this.getMainWindow(), "Icons folder not found in jar file");
lbl602:
                    // 3 sources

                    if (iconsOK) {
                        this.prefsWindow.setIconsPath(newIconsPath);
                        JOptionPane.showMessageDialog(this.getMainWindow(), "Icons copied to " + newIconsPath.toString() + " and set in Preferences");
                    }
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(this.getMainWindow(), "cdGUI: Menu Item Listener called with invalid menu.");
                    break;
                }
            }
        }
        catch (Throwable unforeseen) {
            JOptionPane.showMessageDialog(this.getMainWindow(), "Unhandled Error!\n" + this.displayError(unforeseen));
        }
    }

    private void initialise() {
        this.closeWindows();
        this.getContentPane().removeAll();
        this.fileSaved = true;
        this.unsavedChanges.setText("");
        this.introText = "";
        this.techText = "";
        this.setTitle("Cultural Dynamics 10.03 (no file open)");
        this.prefsWindow.resetToDefaults();
        this.ourFilterEditor.fileNewOpen();
        this.findWindow.clearLists();
        this.ourRowData = new RowData();
        this.rowEditor.dispose();
        this.rowEditor = new RowEditor(this, 0, this.ourRowData);
        this.rowEditor.setResizable(true);
        this.rowEditor.setVisible(false);
        this.getHTMLDialog().setHTMLPrimaryPath(System.getProperty("user.home"));
        this.getHTMLDialog().setHTMLSubdirs(false);
    }

    private boolean openFile(String filePathIn) {
        this.masterTagList.initialiseList();
        this.inputFileJSON = new InputFileJSON(this, this.prefsWindow, null, this.masterTagList, this.ourRowData, InputFileJSON.ReadImport.READ);
        if (filePathIn != "" && !this.inputFileJSON.readDataFile(filePathIn)) {
            JOptionPane.showMessageDialog(this, "Could not read JSON file.");
            return false;
        }
        this.xMag = 1.0;
        this.status.setText("Magnification: " + this.xMag + "x  Filter: " + this.filterStatusString);
        this.nTicks = 10;
        this.xMagSlider.setValue(0);
        this.setRange();
        this.panLimits();
        this.getContentPane().removeAll();
        this.openTimePanel = this.timePanel = new TimePanel(this, this.inputFileJSON.getConnections(), this.nTicks);
        this.timeScrollPane = new JScrollPane();
        this.timeScrollPane.setHorizontalScrollBarPolicy(31);
        this.timeScrollPane.setVerticalScrollBarPolicy(20);
        this.timePort = new FloaterViewPort(this, this.timePanel);
        this.timePanel.setOpaque(false);
        this.timeScrollPane.setViewport(this.timePort);
        this.timeScrollPane.setViewportView(this.timePanel);
        this.timeScrollPane.getVerticalScrollBar().setBlockIncrement(this.getHeight() / 2);
        this.timePort.setVisible(true);
        this.timeScrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent r) {
                CDgui.this.openTimePanel.setFound(null, TimePanel.HighlightEnd.SRC);
                CDgui.this.mainWindow.setPreferredSize(new Dimension(CDgui.this.mainWindow.getWidth(), CDgui.this.mainWindow.getHeight()));
                CDgui.this.timePanel.setWidth(r.getComponent().getWidth());
            }
        });
        JScrollBar timeVerticalScrollbar = this.timeScrollPane.getVerticalScrollBar();
        timeVerticalScrollbar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent a) {
                CDgui.this.openTimePanel.setFound(null, TimePanel.HighlightEnd.SRC);
                int panPosition = CDgui.this.panScrollbar.getValue();
                CDgui.this.viewStartDate = CDgui.this.rangeStart.plusDays(panPosition);
                CDgui.this.timePanel.revalidate();
                CDgui.this.timePanel.repaint();
            }
        });
        this.panScrollbar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent a) {
                CDgui.this.openTimePanel.setFound(null, TimePanel.HighlightEnd.SRC);
                int panPosition = CDgui.this.panScrollbar.getValue();
                CDgui.this.viewStartDate = CDgui.this.rangeStart.plusDays(panPosition);
                CDgui.this.timePanel.revalidate();
                CDgui.this.timePanel.repaint();
            }
        });
        this.xMagSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CDgui.this.openTimePanel.setFound(null, TimePanel.HighlightEnd.SRC);
                CDgui.this.xMag = Math.max(CDgui.this.xMagSlider.getValue() * CDgui.this.maxZoom / CDgui.this.maxMagSlider, 1);
                CDgui.this.status.setText("Magnification: " + CDgui.this.xMag + "x  Filter: " + CDgui.this.filterStatusString);
                CDgui.this.panLimits();
                CDgui.this.timePanel.repaint();
                CDgui.this.panScrollbar.repaint();
            }
        });
        FlowLayout flowLayout = new FlowLayout(0);
        JPanel panScrollLabelPanel = new JPanel(flowLayout);
        panScrollLabelPanel.add(this.panScrollLabel);
        JPanel xMagLabelPanel = new JPanel(flowLayout);
        xMagLabelPanel.add(this.xMagLabel);
        Box sliderBox = Box.createVerticalBox();
        sliderBox.setAlignmentX(0.0f);
        sliderBox.add(panScrollLabelPanel);
        this.panScrollLabel.setAlignmentX(0.0f);
        this.panScrollbar.setBackground(Color.WHITE);
        sliderBox.add(this.panScrollbar);
        sliderBox.add(xMagLabelPanel);
        sliderBox.add(this.xMagSlider);
        MouseHandler ourMouseHandler = new MouseHandler();
        this.timePanel.addMouseListener(ourMouseHandler);
        this.timePanel.addMouseMotionListener(ourMouseHandler);
        Box statusBox = Box.createHorizontalBox();
        statusBox.add(this.status);
        statusBox.add(Box.createHorizontalGlue());
        statusBox.add(this.unsavedChanges);
        statusBox.add(Box.createHorizontalGlue());
        sliderBox.add(statusBox);
        this.ourXAxis = new XAxisPanel(this, this.timePanel);
        Box bottomBox = Box.createVerticalBox();
        bottomBox.add(this.ourXAxis);
        bottomBox.add(sliderBox);
        this.add((Component)this.timeScrollPane, "Center");
        this.add((Component)bottomBox, "South");
        this.pack();
        return true;
    }

    public void setRange() {
        DateAndWidth earlyData = new DateAndWidth(null, 0);
        DateAndWidth lateData = new DateAndWidth(null, 0);
        int earlyWidth = 0;
        int lateWidth = 0;
        earlyData = this.inputFileJSON.getEventData().getEarliestStartDate();
        earlyWidth = earlyData.getWidth();
        this.rangeStart = earlyData.getDate();
        if (this.inputFileJSON.getConnections().getNumberOfConnections() != 0 && this.inputFileJSON.getConnections().getEarliestStartDate() != null && this.inputFileJSON.getConnections().getEarliestStartDate().isBefore(this.rangeStart)) {
            this.rangeStart = this.inputFileJSON.getConnections().getEarliestStartDate();
        }
        lateData = this.inputFileJSON.getEventData().getLatestEndDateWidth();
        this.rangeEnd = lateData.getDate();
        lateWidth = lateData.getWidth();
        if (this.inputFileJSON.getConnections().getNumberOfConnections() != 0 && this.inputFileJSON.getConnections().getLatestEndDate() != null && this.inputFileJSON.getConnections().getLatestEndDate().isAfter(this.rangeEnd)) {
            this.rangeEnd = this.inputFileJSON.getConnections().getLatestEndDate();
        }
        int width = this.getWidth() - this.prefsWindow.getMarginLeft() - this.prefsWindow.getMarginRight();
        double pxPerDay = (double)width / (double)ChronoUnit.DAYS.between(this.rangeStart, this.rangeEnd);
        pxPerDay = Math.min(pxPerDay, 1.0);
        this.rangeStart = this.rangeStart.minusDays(Math.round((double)earlyWidth / pxPerDay));
        this.rangeStart = this.rangeStart.withMonth(1).withDayOfMonth(1);
        if (this.rangeStart.getYear() < 0 && this.rangeEnd.getYear() > 0 && this.rangeEnd.isBefore(Utils.MAX_DATE.minusYears(1L))) {
            this.rangeEnd = this.rangeEnd.plusYears(1L);
        }
        this.rangeEnd = this.rangeEnd.plusDays(Math.round((double)lateWidth / pxPerDay));
        this.rangeEnd = this.rangeEnd.withMonth(12).withDayOfMonth(31);
        this.maxZoom = Math.max(this.rangeEnd.getYear() - this.rangeStart.getYear(), 1);
        if (this.maxZoom <= 1) {
            this.xMagSlider.setPaintTicks(false);
            this.xMagSlider.setPaintLabels(false);
            this.xMagSlider.setEnabled(false);
            this.xMagSlider.setValue(0);
        } else {
            Hashtable<Integer, JLabel> xMagTable = new Hashtable<Integer, JLabel>();
            int i = 0;
            while (i <= this.maxMagSlider) {
                int labeli = (int)Math.max((double)i * ((double)this.maxZoom / (double)this.maxMagSlider), 1.0);
                Integer intObj = i;
                xMagTable.put(intObj, new JLabel(String.valueOf(labeli)));
                i += 10;
            }
            this.xMagSlider.setLabelTable(xMagTable);
            this.xMagSlider.setMajorTickSpacing(10);
            this.xMagSlider.setMinorTickSpacing(1);
            this.xMagSlider.setPaintTicks(true);
            this.xMagSlider.setPaintLabels(true);
            this.xMagSlider.setSnapToTicks(false);
            this.xMagSlider.setEnabled(true);
        }
        if (this.xMag > (double)this.maxZoom) {
            this.xMag = this.maxZoom;
            this.status.setText("Magnification: " + this.xMag + "x  Filter: " + this.filterStatusString);
        }
        this.xMagSlider.revalidate();
        this.xMagSlider.repaint();
    }

    public void panLimits() {
        long range = ChronoUnit.DAYS.between(this.rangeStart, this.rangeEnd);
        int panScrollVisible = this.viewRangeDays = (int)Math.ceil((double)range / this.xMag);
        int panScrollEnd = (int)range;
        int panScrollStart = 0;
        this.panScrollbar.setBlockIncrement(panScrollVisible / 2);
        this.panScrollbar.setUnitIncrement(1);
        int panScrollCurrent = Math.min(this.panScrollbar.getValue(), panScrollEnd - panScrollVisible);
        this.viewStartDate = this.rangeStart.plusDays(panScrollCurrent);
        this.panScrollbar.setValues(panScrollCurrent, panScrollVisible, panScrollStart, panScrollEnd);
        this.panScrollbar.repaint();
    }

    public JFrame getMainWindow() {
        return this;
    }

    public InputFileJSON getInput() {
        return this.inputFileJSON;
    }

    public void menuLogic() {
        if (this.inputFileJSON.getEventData().getNumberOfTimelines() == 0) {
            this.itemNewTimelineEvent.setEnabled(false);
        } else {
            this.itemNewTimelineEvent.setEnabled(true);
        }
        if (this.inputFileJSON.getEventData().getTotalNumberOfEvents() < 2) {
            this.itemNewConnection.setEnabled(false);
        } else {
            this.itemNewConnection.setEnabled(true);
        }
    }

    public void menusAfterImport() {
        this.itemNewTimeline.setEnabled(true);
        this.itemNewTimelineEvent.setEnabled(true);
        this.itemNewGeneralEvent.setEnabled(true);
        this.itemNewConnection.setEnabled(true);
        this.itemNewUntimed.setEnabled(true);
        this.itemEditRows.setEnabled(true);
        this.itemEditIntro.setEnabled(true);
        this.itemImport.setEnabled(true);
        this.itemSaveAs.setEnabled(true);
        this.itemExportImage.setEnabled(true);
        this.itemExportHTML.setEnabled(true);
        this.itemFilter.setEnabled(true);
        this.itemFind.setEnabled(true);
        this.itemListTags.setEnabled(true);
        this.itemListAll.setEnabled(true);
        this.itemListMissing.setEnabled(true);
    }

    public String getJarPath() {
        return this.jarPath;
    }

    public LocalDate getLaterDate(LocalDate early, LocalDate late) {
        LocalDate result = early;
        if (late != null) {
            result = late;
        }
        return result;
    }

    public String displayError(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        String stackTrace = sw.toString();
        return stackTrace.replace(System.getProperty("line.separator"), "\n");
    }

    private void closeWindows() {
        if (this.inputFileJSON != null) {
            Window[] children;
            if (this.ourIntroEditor != null) {
                this.ourIntroEditor.dispose();
                this.ourIntroEditor = null;
            }
            Event tmpEv = null;
            int i = 0;
            while (i < this.inputFileJSON.getEventData().getTotalNumberOfEvents()) {
                tmpEv = this.inputFileJSON.getEventData().getEventByIndex(i);
                if (tmpEv.getEventType().equals((Object)CommonData.EventType.TIMELINE) && tmpEv.getTlSegmentList() != null) {
                    int j = 0;
                    while (j < tmpEv.getTlSegmentList().getNumberOfSegments()) {
                        if (tmpEv.getTlSegmentList().getASegment(j).getEditor() != null) {
                            tmpEv.getTlSegmentList().getASegment(j).getEditor().dispose();
                        }
                        ++j;
                    }
                }
                if (tmpEv.getEditor() != null && this.inputFileJSON.getEventData().getEventByIndex(i).getEditor() != null) {
                    this.inputFileJSON.getEventData().getEventByIndex(i).getEditor().dispose();
                }
                ++i;
            }
            i = 0;
            while (i < this.inputFileJSON.getConnections().getNumberOfConnections()) {
                if (this.inputFileJSON.getConnections().getConnection(i).getEditor() != null) {
                    this.inputFileJSON.getConnections().getConnection(i).getEditor().dispose();
                }
                ++i;
            }
            Window[] windowArray = children = CDgui.getOwnerlessWindows();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Window win = windowArray[n2];
                if (win != this) {
                    win.dispose();
                }
                ++n2;
            }
        }
    }

    public String getProgramVersion() {
        return "10.03";
    }

    public String getProgramMajorVersion() {
        return "10.03".substring(0, 2);
    }

    public String getProgramName() {
        return "Cultural Dynamics";
    }

    public String getOpenFile() {
        return this.filePath;
    }

    public InputFileJSON getImportFile() {
        return this.importFileJSON;
    }

    public void setFileSaved(boolean s) {
        this.fileSaved = s;
        if (s) {
            this.unsavedChanges.setText("");
        } else {
            this.unsavedChanges.setText("Unsaved Changes");
        }
    }

    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    public Preferences getPreferences() {
        return this.prefsWindow;
    }

    public PreferencesImport getPrefsImport() {
        return this.prefsImport;
    }

    public ExportDialog getExportDialog() {
        return this.exportImageWindow;
    }

    public ExportHTML getHTMLDialog() {
        return this.exportHTMLWindow;
    }

    public FilterEditor getFilterEditor() {
        return this.ourFilterEditor;
    }

    public RowData getRowData() {
        return this.ourRowData;
    }

    public TimePanel getTimePanel() {
        return this.openTimePanel;
    }

    public XAxisPanel getXAxis() {
        return this.ourXAxis;
    }

    public JScrollPane getTimeScrollPane() {
        return this.timeScrollPane;
    }

    public LocalDate getRangeStart() {
        return this.rangeStart;
    }

    public LocalDate getRangeEnd() {
        return this.rangeEnd;
    }

    public int getRangeDays() {
        return (int)Math.ceil(ChronoUnit.DAYS.between(this.rangeStart, this.rangeEnd));
    }

    public LocalDate getViewStartDate() {
        return this.viewStartDate;
    }

    public int getViewRangeDays() {
        return this.viewRangeDays;
    }

    public LocalDate getViewEndDate() {
        return this.viewStartDate.plusDays(this.viewRangeDays);
    }

    public void setViewportTopLeft() {
        this.timePort.setViewPosition(new Point(0, 0));
    }

    public void setViewPortTop() {
        this.timePort.setViewPosition(new Point(this.timePort.getX(), 0));
    }

    public FloaterViewPort getViewPort() {
        return this.timePort;
    }

    public void showPosition(LocalDate x, int y) {
        this.timeScrollPane.getVerticalScrollBar().setValue(y - this.timeScrollPane.getVerticalScrollBar().getVisibleAmount() / 2);
        long inc = ChronoUnit.DAYS.between(this.rangeStart, x);
        this.panScrollbar.setValue((int)inc);
        this.viewStartDate = this.rangeStart.plusDays(inc);
        this.panLimits();
        this.openTimePanel.revalidate();
        this.openTimePanel.repaint();
    }

    public void showSegmentEditor(Segment sg) {
        if (sg.getEditor() != null) {
            sg.getEditor().toFront();
        } else {
            SegmentEditor sgEditWindow = new SegmentEditor(this.mainWindow, sg, sg.getTimeline(), this.openTimePanel, CommonEditor.NewObject.EXISTING);
            this.windowManager.positionWindow(sgEditWindow, WindowManager.ScreenSide.CASCADE_TR);
        }
    }

    public void showEventEditor(Event ev) {
        if (ev.getEditor() != null) {
            ev.getEditor().toFront();
        } else {
            EventEditor evEditWindow = new EventEditor(this.mainWindow, ev, this.openTimePanel, this.inputFileJSON.getEventData(), this.inputFileJSON.getConnections(), CommonEditor.NewObject.EXISTING);
            this.windowManager.positionWindow(evEditWindow, WindowManager.ScreenSide.CASCADE_TR);
        }
    }

    public void showConnectionEditor(Connection cn) {
        if (cn.getEditor() != null) {
            cn.getEditor().toFront();
        } else {
            ConnectionEditor cnEditWindow = new ConnectionEditor(this.mainWindow, cn, this.inputFileJSON.getEventData(), this.inputFileJSON.getConnections(), CommonEditor.NewObject.EXISTING);
            this.windowManager.positionWindow(cnEditWindow, WindowManager.ScreenSide.CASCADE_TR);
        }
    }

    public void showIntroEditor() {
        if (this.ourIntroEditor == null) {
            this.ourIntroEditor = new IntroEditor(this);
            this.windowManager.positionWindow(this.ourIntroEditor, WindowManager.ScreenSide.CASCADE_TR);
        } else {
            this.ourIntroEditor.toFront();
        }
    }

    public ReportSummary getSummaryWindow() {
        return this.listAllWin;
    }

    public void setFilterStatus(String filter) {
        this.filterStatusString = filter != null ? filter : "Off";
        this.status.setText("Magnification: " + this.xMag + "x  Filter: " + this.filterStatusString);
    }

    public SavedFilterData getSavedFilterData() {
        return this.ourSavedFilterData;
    }

    public String getIntroText() {
        return this.introText;
    }

    public void setIntroText(String introText) {
        this.introText = introText;
    }

    public String getTechText() {
        return this.techText;
    }

    public void setTechText(String techText) {
        this.techText = techText;
    }

    public void closeIntroEditor() {
        this.ourIntroEditor = null;
    }

    public TagList getMasterTags() {
        return this.masterTagList;
    }

    private void openEditor(PopupMenuItem item) {
        switch (item.getType()) {
            case EVENT: {
                Event selectedEvent = item.getEv();
                if (selectedEvent.getEditor() != null) {
                    selectedEvent.getEditor().toFront();
                    break;
                }
                EventEditor evEditWindow = new EventEditor(this.mainWindow, selectedEvent, this.timePanel, this.inputFileJSON.getEventData(), this.inputFileJSON.getConnections(), CommonEditor.NewObject.EXISTING);
                this.windowManager.positionWindow(evEditWindow, WindowManager.ScreenSide.CASCADE_TR);
                break;
            }
            case CONNECTION: {
                Connection selectedConnection = item.getCn();
                this.showOrOpenCn(selectedConnection);
                break;
            }
            case SEGMENT: {
                Segment selectedSegment = item.getSeg();
                Event tmpEvent = selectedSegment.getTimeline();
                if (selectedSegment.getEditor() != null) {
                    selectedSegment.getEditor().toFront();
                    break;
                }
                SegmentEditor segEditWindow = new SegmentEditor(this.mainWindow, selectedSegment, tmpEvent, this.timePanel, CommonEditor.NewObject.EXISTING);
                this.windowManager.positionWindow(segEditWindow, WindowManager.ScreenSide.CASCADE_TR);
                break;
            }
            case ROW: {
                int row = item.getRow();
                this.rowEditor.setRow(row);
                this.windowManager.positionWindow(this.rowEditor, WindowManager.ScreenSide.TOP_RIGHT);
                this.rowEditor.setVisible(true);
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this.getMainWindow(), "Unknown type in popup menu listener");
            }
        }
    }

    public void showOrOpenCn(Connection cn) {
        if (cn.getEditor() != null) {
            cn.getEditor().toFront();
        } else {
            ConnectionEditor cnEditWindow = new ConnectionEditor(this.mainWindow, cn, this.inputFileJSON.getEventData(), this.inputFileJSON.getConnections(), CommonEditor.NewObject.EXISTING);
            this.windowManager.positionWindow(cnEditWindow, WindowManager.ScreenSide.CASCADE_TR);
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private double limitedX;
        private double limitedY;
        private double offsetLeft;
        private double offsetRight;
        private double offsetTop;
        private double offsetBottom;
        private boolean mouseDragged;

        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent c) {
            if (c.getClickCount() == 2) {
                int i;
                ArrayList<PopupMenuItem> clickedList = new ArrayList<PopupMenuItem>();
                if (CDgui.this.prefsWindow.getShowRowNosChoice()) {
                    i = 0;
                    while (i < CDgui.this.ourRowData.getSize()) {
                        Row tmpRow = CDgui.this.ourRowData.getRowByIndex(i);
                        if (tmpRow.isClickedRow(c.getX(), c.getY())) {
                            clickedList.add(new PopupMenuItem(PopupMenuItem.ClickedType.ROW, "Row: " + (i + 1), null, null, null, i));
                        }
                        ++i;
                    }
                }
                i = 0;
                while (i < CDgui.this.inputFileJSON.getEventData().getTotalNumberOfEvents()) {
                    SegmentList tmpSegList;
                    boolean clickedEvent;
                    Event tmpEvent = CDgui.this.inputFileJSON.getEventData().getEventByIndex(i);
                    boolean bl = clickedEvent = tmpEvent.isClicked(c.getX(), c.getY()) && tmpEvent.isShown();
                    if (clickedEvent) {
                        clickedList.add(new PopupMenuItem(PopupMenuItem.ClickedType.EVENT, tmpEvent.getEventTypeAsName() + ": " + tmpEvent.getName(), tmpEvent, null, null, 0));
                    }
                    if (tmpEvent.getEventType().equals((Object)CommonData.EventType.TIMELINE) && tmpEvent.isShown() && (tmpSegList = tmpEvent.getTlSegmentList()) != null) {
                        int j = 0;
                        while (j < tmpSegList.getNumberOfSegments()) {
                            Segment tmpSegment = tmpSegList.getASegment(j);
                            if (tmpSegment.isClickedSegment(c.getX(), c.getY()) && tmpSegment.getTimeline().isShown()) {
                                clickedList.add(new PopupMenuItem(PopupMenuItem.ClickedType.SEGMENT, "Segment: " + tmpSegment.getTimeline().getName() + "-" + tmpSegment.getText(), null, null, tmpSegment, 0));
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                i = 0;
                while (i < CDgui.this.inputFileJSON.getConnections().getNumberOfConnections()) {
                    boolean clickedConnection;
                    Connection tmpConnection = CDgui.this.inputFileJSON.getConnections().getConnection(i);
                    boolean bl = clickedConnection = tmpConnection.isShown() && (tmpConnection.isClickedConnection(c.getX(), c.getY()) || tmpConnection.isClickedSrcName(c.getX(), c.getY()) || tmpConnection.isClickedDstName(c.getX(), c.getY()));
                    if (clickedConnection) {
                        clickedList.add(new PopupMenuItem(PopupMenuItem.ClickedType.CONNECTION, "Connection: " + tmpConnection.getID(), null, tmpConnection, null, 0));
                    }
                    ++i;
                }
                if (clickedList.size() == 1) {
                    CDgui.this.openEditor((PopupMenuItem)clickedList.get(0));
                } else {
                    JPopupMenu clickPopup = new JPopupMenu();
                    int i2 = 0;
                    while (i2 < clickedList.size()) {
                        clickPopup.add((JMenuItem)clickedList.get(i2));
                        ((PopupMenuItem)clickedList.get(i2)).addActionListener(CDgui.this.popupMenuListener);
                        ++i2;
                    }
                    clickPopup.show(c.getComponent(), c.getX(), c.getY());
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent c) {
            Connection tmpConnection = null;
            CDgui.this.srcClicked = false;
            CDgui.this.anyClicked = false;
            this.mouseDragged = false;
            int i = 0;
            while (i < CDgui.this.inputFileJSON.getConnections().getNumberOfConnections()) {
                tmpConnection = CDgui.this.inputFileJSON.getConnections().getConnection(i);
                if (tmpConnection.isClickedSrcName(c.getX(), c.getY()) && tmpConnection.isShown()) {
                    CDgui.this.srcClicked = true;
                    CDgui.this.anyClicked = true;
                }
                if (tmpConnection.isClickedDstName(c.getX(), c.getY()) && tmpConnection.isShown()) {
                    CDgui.this.srcClicked = false;
                    CDgui.this.anyClicked = true;
                }
                if (CDgui.this.anyClicked) break;
                tmpConnection = null;
                ++i;
            }
            if (tmpConnection != null) {
                CDgui.this.selectedCn = tmpConnection;
                CDgui.this.cnNameOldAbsX = c.getX();
                CDgui.this.cnNameOldAbsY = c.getY();
                if (CDgui.this.anyClicked) {
                    Rectangle2D bounds;
                    if (CDgui.this.srcClicked) {
                        bounds = CDgui.this.selectedCn.getBoundsNameSource();
                        CDgui.this.selectedCn.setSrcNameSelected(true);
                        CDgui.this.cnNameOldRelX = CDgui.this.selectedCn.getPosNameSource().getX();
                        CDgui.this.cnNameOldRelY = CDgui.this.selectedCn.getPosNameSource().getY();
                    } else {
                        bounds = CDgui.this.selectedCn.getBoundsNameDestination();
                        CDgui.this.selectedCn.setDstNameSelected(true);
                        CDgui.this.cnNameOldRelX = CDgui.this.selectedCn.getPosNameDestination().getX();
                        CDgui.this.cnNameOldRelY = CDgui.this.selectedCn.getPosNameDestination().getY();
                    }
                    this.offsetLeft = (double)c.getX() - bounds.getMinX();
                    this.offsetRight = bounds.getMaxX() - (double)c.getX();
                    this.offsetTop = (double)c.getY() - bounds.getMinY();
                    this.offsetBottom = bounds.getMaxY() - (double)c.getY();
                }
                CDgui.this.timePanel.setCursor(new Cursor(12));
                CDgui.this.timePanel.repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent c) {
            if (CDgui.this.selectedCn != null) {
                this.mouseDragged = true;
                Rectangle view = CDgui.this.getViewPort().getViewRect();
                double leftX = (double)CDgui.this.prefsWindow.getMarginLeft() + this.offsetLeft;
                double rightX = (double)(CDgui.this.timePanel.getWidth() - CDgui.this.getTimeScrollPane().getVerticalScrollBar().getWidth() - CDgui.this.prefsWindow.getMarginRight()) - this.offsetRight;
                double topY = view.getMinY() + (double)CDgui.this.prefsWindow.getMarginTop() + this.offsetTop;
                double bottomY = view.getMaxY() - this.offsetBottom;
                this.limitedX = c.getX();
                this.limitedY = c.getY();
                this.limitedX = Math.max(this.limitedX, leftX);
                this.limitedX = Math.min(this.limitedX, rightX);
                this.limitedY = Math.max(this.limitedY, topY);
                this.limitedY = Math.min(this.limitedY, bottomY);
                if (CDgui.this.srcClicked) {
                    CDgui.this.selectedCn.setPosNameSource(new Point2D.Double(this.limitedX - (double)CDgui.this.cnNameOldAbsX + CDgui.this.cnNameOldRelX, this.limitedY - (double)CDgui.this.cnNameOldAbsY + CDgui.this.cnNameOldRelY));
                } else {
                    CDgui.this.selectedCn.setPosNameDestination(new Point2D.Double(this.limitedX - (double)CDgui.this.cnNameOldAbsX + CDgui.this.cnNameOldRelX, this.limitedY - (double)CDgui.this.cnNameOldAbsY + CDgui.this.cnNameOldRelY));
                }
                CDgui.this.setFileSaved(false);
                CDgui.this.timePanel.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent c) {
            if (CDgui.this.selectedCn != null && this.mouseDragged) {
                if (CDgui.this.srcClicked) {
                    CDgui.this.selectedCn.setPosNameSource(new Point2D.Double(this.limitedX - (double)CDgui.this.cnNameOldAbsX + CDgui.this.cnNameOldRelX, this.limitedY - (double)CDgui.this.cnNameOldAbsY + CDgui.this.cnNameOldRelY));
                } else {
                    CDgui.this.selectedCn.setPosNameDestination(new Point2D.Double(this.limitedX - (double)CDgui.this.cnNameOldAbsX + CDgui.this.cnNameOldRelX, this.limitedY - (double)CDgui.this.cnNameOldAbsY + CDgui.this.cnNameOldRelY));
                }
            }
            if (CDgui.this.selectedCn != null) {
                CDgui.this.selectedCn.setSrcNameSelected(false);
                CDgui.this.selectedCn.setDstNameSelected(false);
            }
            CDgui.this.timePanel.repaint();
            CDgui.this.selectedCn = null;
            this.mouseDragged = false;
            CDgui.this.timePanel.setCursor(new Cursor(0));
        }
    }

    private class PopupListener
    implements ActionListener {
        private PopupListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PopupMenuItem item = (PopupMenuItem)e.getSource();
            CDgui.this.openEditor(item);
        }
    }
}

