/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CommonData;
import culturalDynamics.Connection;
import culturalDynamics.ConnectionEditor;
import culturalDynamics.DateAndWidth;
import culturalDynamics.Event;
import culturalDynamics.EventEditor;
import culturalDynamics.ExportDialog;
import culturalDynamics.ExportHTML;
import culturalDynamics.FileConverter;
import culturalDynamics.FileConverterException;
import culturalDynamics.FilterEditor;
import culturalDynamics.Find;
import culturalDynamics.FloaterViewPort;
import culturalDynamics.InputFileCSV;
import culturalDynamics.InputFileJSON;
import culturalDynamics.IntroEditor;
import culturalDynamics.OutputFile;
import culturalDynamics.PopupMenuItem;
import culturalDynamics.Preferences;
import culturalDynamics.ReportMissing;
import culturalDynamics.ReportSummary;
import culturalDynamics.ReportXref;
import culturalDynamics.Row;
import culturalDynamics.RowData;
import culturalDynamics.RowEditor;
import culturalDynamics.SavedFilterData;
import culturalDynamics.Segment;
import culturalDynamics.SegmentEditor;
import culturalDynamics.SegmentList;
import culturalDynamics.TagList;
import culturalDynamics.TimePanel;
import culturalDynamics.Utils;
import culturalDynamics.XAxisPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitHandler;
import java.awt.desktop.QuitResponse;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileNameExtensionFilter;

class cdGUI
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final String programName = "Cultural Dynamics";
    private final String programVersion = "09.05";
    private static String exitDialog1 = "Are you sure you want to close this program?\n";
    private String exitDialog2 = "There are unsaved changes - are you sure you want to close this program?\n";
    private String newSureDialog = "Data has not been saved. Are you sure you want to discard it and start a new history?";
    private String openSureDialog = "Data has not been saved. Are you sure you want to discard it and open a different file?";
    private String newOverwriteDialog = "New output file already exists. Do you want to overwrite it?";
    private String myFilePath = "";
    private String myFileDir = "";
    private String jarPath = "";
    private Boolean fileSaved = true;
    private InputFileJSON ourInputFileJSON;
    private InputFileJSON oldInputFileJSON;
    private InputFileCSV ourInputFileCSV;
    private InputFileCSV oldInputFileCSV;
    private String convertFilesDir = "";
    private FileConverter ourConverter;
    private JMenuItem itemPrefs = new JMenuItem("Preferences");
    private JMenuItem itemClose = new JMenuItem("Close");
    private JMenuItem itemNewFile = new JMenuItem("New File ...");
    private JMenuItem itemOpen = new JMenuItem("Open File ...");
    private JMenuItem itemOpenCSV = new JMenuItem("Open CSV File ...");
    private JMenuItem itemSave = new JMenuItem("Save");
    private JMenuItem itemSaveAs = new JMenuItem("Save As ...");
    private JMenuItem itemConvert = new JMenuItem("Convert ...");
    private JMenuItem itemExportImage = new JMenuItem("Export Image ...");
    private JMenuItem itemExportHTML = new JMenuItem("Export HTML ...");
    private JMenuItem itemNewTimeline = new JMenuItem("New Timeline ...");
    private JMenuItem itemNewTimelineEvent = new JMenuItem("New Timeline Event ...");
    private JMenuItem itemNewGeneralEvent = new JMenuItem("New General Event ...");
    private JMenuItem itemNewConnection = new JMenuItem("New Connection ...");
    private JMenuItem itemNewUntimed = new JMenuItem("New Untimed Event ...");
    private JMenuItem itemEditRows = new JMenuItem("Edit Rows ...");
    private JMenuItem itemEditIntro = new JMenuItem("Edit Introduction ...");
    private JMenuItem itemFilter = new JMenuItem("Filter ...");
    private JMenuItem itemListTags = new JMenuItem("Cross-Reference Report");
    private JMenuItem itemListAll = new JMenuItem("Summary Report");
    private JMenuItem itemListMissing = new JMenuItem("Missing MetaData Report");
    private JMenuItem itemFind = new JMenuItem("Find ...");
    private JMenuItem itemAbout = new JMenuItem("About");
    private JMenuItem itemRelNotes = new JMenuItem("Release Notes");
    private JMenuItem itemIHelp = new JMenuItem("Help");
    private JMenuItem itemManual = new JMenuItem("Extract Manual");
    private JMenuItem itemIcons = new JMenuItem("Extract Icons");
    private int initialWidth = 1000;
    private int initialHeight = 500;
    private int nTicks = 10;
    private double xMag = 1.0;
    private String filterStatusString = "Off";
    private LocalDate rangeStart = LocalDate.of(1600, 1, 1);
    private LocalDate rangeEnd = LocalDate.of(1900, 1, 1);
    private int startYear = this.rangeStart.getYear();
    private int endYear = this.rangeEnd.getYear();
    private int viewRangeDays = 365;
    private int maxZoom = this.endYear - this.startYear;
    private int maxMagSlider = 200;
    private JLabel xMagLabel = new JLabel("Zoom", 2);
    private JSlider xMagSlider = new JSlider(0, this.maxMagSlider, 0);
    private JLabel panScrollLabel = new JLabel("Pan", 2);
    private JScrollBar panScrollbar = new JScrollBar(0, 0, 10, 0, 100);
    private LocalDate viewStartDate = LocalDate.of(1600, 1, 1);
    private JLabel unsavedChanges = new JLabel("");
    private final String unsavedString = "Unsaved Changes";
    private JLabel status = new JLabel("Magnification: " + this.xMag + "x", 2);
    private cdGUI mainWindow;
    private int openEditors = 0;
    private int editorCascadeX = 20;
    private int editorCascadeY = 20;
    private TimePanel openTimePanel = null;
    private JScrollPane timeScrollPane = null;
    private FloaterViewPort timePort = null;
    private Preferences prefsWindow;
    private boolean prefsPlaced = false;
    private ExportDialog exportImageWindow;
    private boolean exportImagePlaced = false;
    private ExportHTML exportHTMLWindow;
    private boolean exportHTMLPlaced = false;
    private Find findWindow;
    private boolean findPlaced = false;
    private RowEditor rowEditor;
    private RowData ourRowData;
    private boolean rowEditorPlaced = false;
    private FilterEditor ourFilterEditor;
    private boolean filterPlaced = false;
    private SavedFilterData ourSavedFilterData = new SavedFilterData();
    private GraphicsConfiguration mainWindowConfig;
    private GraphicsDevice myScreen;
    private int myScreenIndex;
    private GraphicsEnvironment env;
    private GraphicsDevice[] allScreens;
    private Rectangle bounds;
    private Insets insets;
    private TimePanel myTimePanel;
    private XAxisPanel ourXAxis;
    private String introText = "";
    private String techText = "";
    private IntroEditor ourIntroEditor = null;
    private boolean introEditorPlaced = false;
    private Point introPoint;
    private ReportSummary listAllWin;
    private TagList masterTagList = new TagList();
    private Connection selectedCn = null;
    private int cnNameOldAbsX;
    private int cnNameOldAbsY;
    private double cnNameOldRelX;
    private double cnNameOldRelY;
    private boolean srcClicked = false;
    private boolean anyClicked = false;
    private PopupListener popupMenuListener = new PopupListener();

    public cdGUI() {
        this.mainWindow = this;
        this.setTitle("Cultural Dynamics 09.05");
        this.setDefaultCloseOperation(0);
        this.setLayout(new BorderLayout());
        this.prefsWindow = new Preferences(this);
        this.prefsPlaced = false;
        this.prefsWindow.setResizable(true);
        this.prefsWindow.setVisible(false);
        this.exportImageWindow = new ExportDialog(this);
        this.exportImagePlaced = false;
        this.exportImageWindow.setResizable(true);
        this.exportImageWindow.setVisible(false);
        this.exportHTMLWindow = new ExportHTML(this);
        this.exportHTMLPlaced = false;
        this.exportHTMLWindow.setResizable(true);
        this.exportHTMLWindow.setVisible(false);
        this.findWindow = new Find(this);
        this.findPlaced = false;
        this.findWindow.setResizable(true);
        this.findWindow.setVisible(false);
        this.ourRowData = new RowData();
        this.ourRowData.insertRow(new Row(), 0);
        this.rowEditorPlaced = false;
        this.rowEditor = new RowEditor(this, 0, this.ourRowData);
        this.rowEditor.setResizable(true);
        this.rowEditor.setVisible(false);
        this.myFilePath = "";
        this.openFile("", true);
        this.xMag = 1.0;
        this.status.setText("Magnification: " + this.xMag + "x  Filter: " + this.filterStatusString);
        this.nTicks = 10;
        this.xMagSlider.setValue(0);
        this.setRange();
        this.panLimits();
        this.openTimePanel.revalidate();
        this.openTimePanel.repaint();
        this.setSize(this.initialWidth, this.initialHeight);
        this.introEditorPlaced = false;
        this.ourFilterEditor = new FilterEditor(this);
        this.ourFilterEditor.setVisible(false);
        this.unsavedChanges.setForeground(Color.red);
        this.getMainWindow().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                cdGUI.this.mainWindow.toFront();
                String exitDialog = exitDialog1;
                if (!cdGUI.this.fileSaved.booleanValue()) {
                    exitDialog = cdGUI.this.exitDialog2;
                }
                if (JOptionPane.showConfirmDialog(cdGUI.this.getMainWindow(), exitDialog, "Close Program?", 0, 3) == 0) {
                    System.exit(0);
                }
            }
        });
        try {
            this.jarPath = new File(TimePanel.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
        }
        catch (URISyntaxException e) {
            JOptionPane.showMessageDialog(this, "CDGUI Exception getting jar path\n" + e.getMessage());
        }
        this.setVisible(true);
        JMenuBar mainMenu = new JMenuBar();
        JMenu menuProgram = new JMenu("Program");
        menuProgram.add(this.itemPrefs);
        this.itemPrefs.addActionListener(this);
        menuProgram.add(this.itemClose);
        this.itemClose.addActionListener(this);
        JMenu menuFile = new JMenu("File");
        menuFile.add(this.itemNewFile);
        this.itemNewFile.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        this.itemNewFile.addActionListener(this);
        menuFile.add(this.itemOpen);
        this.itemOpen.addActionListener(this);
        if (System.getProperty("os.name", "").toUpperCase().startsWith("MAC")) {
            this.itemOpen.setAccelerator(KeyStroke.getKeyStroke(79, 4));
        } else {
            this.itemOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        }
        this.itemOpenCSV.addActionListener(this);
        menuFile.add(this.itemSave);
        this.itemSave.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        this.itemSave.addActionListener(this);
        menuFile.add(this.itemSaveAs);
        if (System.getProperty("os.name", "").toUpperCase().startsWith("MAC")) {
            this.itemSaveAs.setAccelerator(KeyStroke.getKeyStroke(83, 5));
        } else {
            this.itemSaveAs.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        }
        this.itemSaveAs.addActionListener(this);
        menuFile.addSeparator();
        menuFile.add(this.itemConvert);
        this.itemConvert.addActionListener(this);
        menuFile.add(this.itemExportImage);
        this.itemExportImage.addActionListener(this);
        menuFile.add(this.itemExportHTML);
        this.itemExportHTML.addActionListener(this);
        JMenu menuEdit = new JMenu("Edit");
        menuEdit.add(this.itemNewTimeline);
        this.itemNewTimeline.addActionListener(this);
        menuEdit.add(this.itemNewTimelineEvent);
        this.itemNewTimelineEvent.addActionListener(this);
        menuEdit.add(this.itemNewGeneralEvent);
        this.itemNewGeneralEvent.addActionListener(this);
        menuEdit.add(this.itemNewConnection);
        this.itemNewConnection.addActionListener(this);
        menuEdit.add(this.itemNewUntimed);
        this.itemNewUntimed.addActionListener(this);
        menuEdit.addSeparator();
        menuEdit.add(this.itemEditRows);
        this.itemEditRows.addActionListener(this);
        menuEdit.add(this.itemEditIntro);
        this.itemEditIntro.addActionListener(this);
        JMenu menuView = new JMenu("View");
        menuView.add(this.itemFilter);
        this.itemFilter.addActionListener(this);
        menuView.add(this.itemFind);
        this.itemFind.setAccelerator(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        this.itemFind.addActionListener(this);
        menuView.addSeparator();
        menuView.add(this.itemListAll);
        this.itemListAll.addActionListener(this);
        menuView.add(this.itemListTags);
        this.itemListTags.addActionListener(this);
        menuView.add(this.itemListMissing);
        this.itemListMissing.addActionListener(this);
        menuView.addSeparator();
        this.itemNewTimeline.setEnabled(false);
        this.itemNewTimelineEvent.setEnabled(false);
        this.itemNewGeneralEvent.setEnabled(false);
        this.itemNewConnection.setEnabled(false);
        this.itemNewUntimed.setEnabled(false);
        this.itemEditRows.setEnabled(false);
        this.itemEditIntro.setEnabled(false);
        this.itemSave.setEnabled(false);
        this.itemSaveAs.setEnabled(false);
        this.itemConvert.setEnabled(true);
        this.itemExportImage.setEnabled(false);
        this.itemExportHTML.setEnabled(false);
        this.itemFilter.setEnabled(false);
        this.itemFind.setEnabled(false);
        this.itemListTags.setEnabled(false);
        this.itemListAll.setEnabled(false);
        this.itemListMissing.setEnabled(false);
        JMenu menuHelp = new JMenu("Help");
        menuHelp.add(this.itemRelNotes);
        this.itemRelNotes.addActionListener(this);
        menuHelp.add(this.itemAbout);
        this.itemAbout.addActionListener(this);
        menuHelp.add(this.itemIHelp);
        this.itemIHelp.addActionListener(this);
        menuHelp.add(this.itemManual);
        this.itemManual.addActionListener(this);
        menuHelp.add(this.itemIcons);
        this.itemIcons.addActionListener(this);
        this.itemPrefs.setToolTipText("Open the preferences window");
        this.itemClose.setToolTipText("Close the program");
        this.itemNewFile.setToolTipText("Create a new file");
        this.itemNewTimeline.setToolTipText("Create a new time line");
        this.itemNewTimelineEvent.setToolTipText("Create new event associated with a time line");
        this.itemNewGeneralEvent.setToolTipText("Create new general event");
        this.itemNewConnection.setToolTipText("Create new connection");
        this.itemNewUntimed.setToolTipText("Create a new untimed event independent of the timeline");
        this.itemEditRows.setToolTipText("Open the row editor");
        this.itemEditIntro.setToolTipText("Edit overall introductory text of the file");
        this.itemOpen.setToolTipText("Select a JSON file for processing");
        this.itemOpenCSV.setToolTipText("Select a legacy CSV file for reading");
        this.itemSave.setToolTipText("Save to the input file");
        this.itemSaveAs.setToolTipText("Select and save to output file");
        this.itemConvert.setToolTipText("Convert one or more data files from a previous version to be readable with this version of the program");
        this.itemExportImage.setToolTipText("Export the diagram to graphics files");
        this.itemExportHTML.setToolTipText("Export the graphics and descriptions as an HTML website");
        this.itemFilter.setToolTipText("Filter the display");
        this.itemListTags.setToolTipText("Show a formatted list of all the tags per item and items that use each tag.");
        this.itemListAll.setToolTipText("Show a formatted list of all items.");
        this.itemListMissing.setToolTipText("Show a formatted list of items with missing metadata");
        this.itemFind.setToolTipText("Find an item on the diagram");
        this.itemRelNotes.setToolTipText("Display the changes made in all versions of the program");
        this.itemAbout.setToolTipText("Display information about the program");
        this.itemIHelp.setToolTipText("Display help information");
        this.itemManual.setToolTipText("Extract the user manual PDF to the location of the jar file or your home folder on your disc and then opens it");
        this.itemIcons.setToolTipText("Extract some basic icons to your disc, OVERWRITES existing files!");
        mainMenu.add(menuProgram);
        mainMenu.add(menuFile);
        mainMenu.add(menuEdit);
        mainMenu.add(menuView);
        mainMenu.add(menuHelp);
        this.setJMenuBar(mainMenu);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            var2_2 = e.getActionCommand();
            tmp = -1;
            switch (var2_2.hashCode()) {
                case -1891854858: {
                    if (var2_2.equals("Cross-Reference Report")) {
                        tmp = 1;
                    }
                    break;
                }
                case -1836553944: {
                    if (var2_2.equals("Release Notes")) {
                        tmp = 2;
                    }
                    break;
                }
                case -1768732539: {
                    if (var2_2.equals("Extract Manual")) {
                        tmp = 3;
                    }
                    break;
                }
                case -1759862423: {
                    if (var2_2.equals("New Timeline Event ...")) {
                        tmp = 4;
                    }
                    break;
                }
                case -1648337667: {
                    if (var2_2.equals("Edit Rows ...")) {
                        tmp = 5;
                    }
                    break;
                }
                case -1606186790: {
                    if (var2_2.equals("Open CSV File ...")) {
                        tmp = 6;
                    }
                    break;
                }
                case -1545472949: {
                    if (var2_2.equals("Missing MetaData Report")) {
                        tmp = 7;
                    }
                    break;
                }
                case -1307615621: {
                    if (var2_2.equals("Extract Icons")) {
                        tmp = 8;
                    }
                    break;
                }
                case -956168402: {
                    if (var2_2.equals("Summary Report")) {
                        tmp = 9;
                    }
                    break;
                }
                case -672183107: {
                    if (var2_2.equals("Export Image ...")) {
                        tmp = 10;
                    }
                    break;
                }
                case -637237544: {
                    if (var2_2.equals("Preferences")) {
                        tmp = 11;
                    }
                    break;
                }
                case -616164441: {
                    if (var2_2.equals("Find ...")) {
                        tmp = 12;
                    }
                    break;
                }
                case -577318676: {
                    if (var2_2.equals("New Connection ...")) {
                        tmp = 13;
                    }
                    break;
                }
                case -473664322: {
                    if (var2_2.equals("Edit Introduction ...")) {
                        tmp = 14;
                    }
                    break;
                }
                case 2245473: {
                    if (var2_2.equals("Help")) {
                        tmp = 15;
                    }
                    break;
                }
                case 2569629: {
                    if (var2_2.equals("Save")) {
                        tmp = 16;
                    }
                    break;
                }
                case 63058797: {
                    if (var2_2.equals("About")) {
                        tmp = 17;
                    }
                    break;
                }
                case 65203672: {
                    if (var2_2.equals("Close")) {
                        tmp = 18;
                    }
                    break;
                }
                case 83286154: {
                    if (var2_2.equals("New File ...")) {
                        tmp = 19;
                    }
                    break;
                }
                case 241751776: {
                    if (var2_2.equals("Open File ...")) {
                        tmp = 20;
                    }
                    break;
                }
                case 438790630: {
                    if (var2_2.equals("Filter ...")) {
                        tmp = 21;
                    }
                    break;
                }
                case 582283873: {
                    if (var2_2.equals("Convert ...")) {
                        tmp = 22;
                    }
                    break;
                }
                case 955836326: {
                    if (var2_2.equals("New Untimed Event ...")) {
                        tmp = 23;
                    }
                    break;
                }
                case 997320067: {
                    if (var2_2.equals("Save As ...")) {
                        tmp = 24;
                    }
                    break;
                }
                case 1570335951: {
                    if (var2_2.equals("New Timeline ...")) {
                        tmp = 25;
                    }
                    break;
                }
                case 1772347205: {
                    if (var2_2.equals("Export HTML ...")) {
                        tmp = 26;
                    }
                    break;
                }
                case 1876980688: {
                    if (var2_2.equals("New General Event ...")) {
                        tmp = 27;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 11: {
                    if (!this.prefsPlaced) {
                        prefsPoint = this.editorCascadePosition(this.prefsWindow.getWidth(), false);
                        this.prefsWindow.setLocation(prefsPoint);
                        this.prefsPlaced = true;
                    }
                    this.prefsWindow.setVisible(true);
                    break;
                }
                case 18: {
                    exitDialog = cdGUI.exitDialog1;
                    if (!this.fileSaved.booleanValue()) {
                        exitDialog = this.exitDialog2;
                    }
                    if ((closeSelection = JOptionPane.showConfirmDialog(this.getMainWindow(), exitDialog, "Close Program?", 0, 3)) == 0) {
                        System.exit(0);
                    }
                    break;
                }
                case 19: {
                    if (this.openTimePanel == null || this.fileSaved.booleanValue() || (newSureSelection = JOptionPane.showConfirmDialog(this.getMainWindow(), this.newSureDialog, "New File", 0, 3)) != 1) {
                        this.initialise();
                        this.myFilePath = "";
                        this.openFile("", true);
                        this.itemNewTimeline.setEnabled(true);
                        this.itemNewGeneralEvent.setEnabled(true);
                        this.itemEditRows.setEnabled(true);
                        this.itemEditIntro.setEnabled(true);
                        this.itemSave.setEnabled(false);
                        this.itemSaveAs.setEnabled(true);
                        this.itemExportImage.setEnabled(true);
                        this.itemExportHTML.setEnabled(true);
                        this.xMag = 1.0;
                        this.status.setText("Magnification: " + this.xMag + "x  Filter: " + this.filterStatusString);
                        this.nTicks = 10;
                        this.xMagSlider.setValue(0);
                        this.setRange();
                        this.panLimits();
                        this.openTimePanel.revalidate();
                        this.openTimePanel.repaint();
                    }
                    break;
                }
                case 20: {
                    this.ourInputFileCSV = null;
                    this.oldInputFileCSV = null;
                    if (this.openTimePanel == null || this.fileSaved.booleanValue() || (openSureSelection = JOptionPane.showConfirmDialog(this.getMainWindow(), this.openSureDialog, "Open File", 0, 3)) != 1) {
                        oldFilePath = this.myFilePath;
                        this.oldInputFileJSON = this.ourInputFileJSON;
                        ourOpenRoot = "";
                        ourOpenRoot = this.myFileDir.equals("") != false ? System.getProperty("user.home") : this.myFileDir;
                        openChooser = new JFileChooser(ourOpenRoot);
                        openChooser.setDialogTitle("Open an Existing File");
                        openChoice = openChooser.showOpenDialog(this.getMainWindow());
                        if (openChoice != 0) {
                            return;
                        }
                        chosenOpenFile = openChooser.getSelectedFile();
                        this.myFilePath = chosenOpenFile.getAbsolutePath();
                        this.myFileDir = chosenOpenFile.getParent();
                        this.initialise();
                        if (this.openFile(this.myFilePath, true)) {
                            this.setTitle("Cultural Dynamics 09.05 " + this.myFilePath);
                            this.itemNewTimeline.setEnabled(true);
                            this.itemNewTimelineEvent.setEnabled(true);
                            this.itemNewGeneralEvent.setEnabled(true);
                            this.itemNewConnection.setEnabled(true);
                            this.itemNewUntimed.setEnabled(true);
                            this.itemEditRows.setEnabled(true);
                            this.itemEditIntro.setEnabled(true);
                            this.itemSave.setEnabled(true);
                            this.itemSaveAs.setEnabled(true);
                            this.itemExportImage.setEnabled(true);
                            this.itemExportHTML.setEnabled(true);
                            this.itemFilter.setEnabled(true);
                            this.itemFind.setEnabled(true);
                            this.itemListTags.setEnabled(true);
                            this.itemListAll.setEnabled(true);
                            this.itemListMissing.setEnabled(true);
                        } else {
                            this.myFilePath = oldFilePath;
                            this.ourInputFileJSON = this.oldInputFileJSON;
                        }
                        this.openTimePanel.revalidate();
                        this.openTimePanel.repaint();
                    }
                    break;
                }
                case 6: {
                    this.ourInputFileJSON = null;
                    this.oldInputFileJSON = null;
                    this.ourInputFileJSON = new InputFileJSON(this);
                    if (this.openTimePanel == null || this.fileSaved.booleanValue() || (openSureSelection = JOptionPane.showConfirmDialog(this.getMainWindow(), this.openSureDialog, "Open File", 0, 3)) != 1) {
                        oldFilePath = this.myFilePath;
                        this.oldInputFileCSV = this.ourInputFileCSV;
                        ourOpenRoot = "";
                        ourOpenRoot = this.myFileDir.equals("") != false ? System.getProperty("user.home") : this.myFileDir;
                        openChooser = new JFileChooser(ourOpenRoot);
                        openChooser.setDialogTitle("Open an Existing File");
                        openChoice = openChooser.showOpenDialog(this.getMainWindow());
                        if (openChoice != 0) {
                            return;
                        }
                        chosenOpenFile = openChooser.getSelectedFile();
                        this.myFilePath = chosenOpenFile.getAbsolutePath();
                        this.myFileDir = chosenOpenFile.getParent();
                        this.initialise();
                        if (this.openFile(this.myFilePath, false)) {
                            this.setTitle("Cultural Dynamics 09.05 " + this.myFilePath);
                            this.itemNewTimeline.setEnabled(true);
                            this.itemNewTimelineEvent.setEnabled(true);
                            this.itemNewGeneralEvent.setEnabled(true);
                            this.itemNewConnection.setEnabled(true);
                            this.itemNewUntimed.setEnabled(true);
                            this.itemEditRows.setEnabled(true);
                            this.itemEditIntro.setEnabled(true);
                            this.itemSave.setEnabled(true);
                            this.itemSaveAs.setEnabled(true);
                            this.itemExportImage.setEnabled(true);
                            this.itemExportHTML.setEnabled(true);
                            this.itemFilter.setEnabled(true);
                            this.itemFind.setEnabled(true);
                            this.itemListTags.setEnabled(true);
                            this.itemListAll.setEnabled(true);
                            this.itemListMissing.setEnabled(true);
                        } else {
                            this.myFilePath = oldFilePath;
                            this.ourInputFileCSV = this.oldInputFileCSV;
                        }
                        this.openTimePanel.revalidate();
                        this.openTimePanel.repaint();
                    }
                    break;
                }
                case 16: {
                    if (this.myFilePath != "") {
                        if (this.ourInputFileJSON == null) {
                            JOptionPane.showMessageDialog(this, "There is nothing to save!");
                            break;
                        }
                        outFile = new OutputFile();
                        mySaveFile = new File(this.myFilePath);
                        saveResult1 = outFile.OpenFileForWrite(mySaveFile, this);
                        saveResult2 = outFile.writeJSONdata(this.ourInputFileJSON.getEventData(), this.ourInputFileJSON.getConnections(), this);
                        if (saveResult1.booleanValue() && saveResult2.booleanValue()) {
                            this.fileSaved = true;
                            this.unsavedChanges.setText("");
                            this.setTitle("Cultural Dynamics 09.05 " + this.myFilePath);
                        }
                        break;
                    }
                    JOptionPane.showMessageDialog(this, "CDGUI No file chosen - Use Save As");
                    break;
                }
                case 24: {
                    if (this.ourInputFileJSON == null) {
                        JOptionPane.showMessageDialog(this, "There is nothing to save!");
                        break;
                    }
                    try {
                        outfolderPath = System.getProperty("user.home");
                        if (!this.myFilePath.equals("")) {
                            outfolderPath = this.myFilePath;
                        }
                        outFileChooser = new JFileChooser(outfolderPath);
                        outFileChooser.setDialogType(1);
                        outFileChooser.setDialogTitle("Save to File");
                        outFileChooser.setApproveButtonText("Save");
                        outFileChooser.setSelectedFile(new File("newfile.json"));
                        outFileChooser.setFileFilter(new FileNameExtensionFilter("json file", new String[]{"json"}));
                        outfolderChoice = outFileChooser.showSaveDialog(this);
                        filename = null;
                        if (outfolderChoice == 0) {
                            filename = outFileChooser.getSelectedFile().toString();
                            filename = outFileChooser.getSelectedFile().toString();
                            if (!filename.endsWith(".json")) {
                                filename = (String)filename + ".json";
                            }
                        } else {
                            return;
                        }
                        saveFile = new File((String)filename);
                        outfolderPath = saveFile.getAbsolutePath();
                        fileToSave = new OutputFile();
                        if (!saveFile.exists() || (newOverwriteSelection = JOptionPane.showConfirmDialog(this.getMainWindow(), this.newOverwriteDialog, "That File Already Exists - overwrite it?", 0, 3)) != 1) {
                            saveAsResult1 = OutputFile.CreateOutFile(saveFile, this);
                            saveAsResult2 = fileToSave.OpenFileForWrite(saveFile, this);
                            saveAsResult3 = fileToSave.writeJSONdata(this.ourInputFileJSON.getEventData(), this.ourInputFileJSON.getConnections(), this);
                            if (saveAsResult1.booleanValue() && saveAsResult2.booleanValue() && saveAsResult3.booleanValue()) {
                                this.fileSaved = true;
                                this.unsavedChanges.setText("");
                                this.myFilePath = outfolderPath;
                                this.setTitle("Cultural Dynamics 09.05 " + this.myFilePath);
                                this.itemSave.setEnabled(true);
                            }
                        }
                    }
                    catch (Throwable unforeseen) {
                        JOptionPane.showMessageDialog(this, "Unhandled Error in file save!\n" + this.displayError(unforeseen));
                        this.fileSaved = false;
                        this.unsavedChanges.setText("Unsaved Changes");
                    }
                    break;
                }
                case 22: {
                    ourConvertRoot = "";
                    ourConvertRoot = this.convertFilesDir.equals("") != false ? System.getProperty("user.home") : this.convertFilesDir;
                    convertChooser = new JFileChooser(ourConvertRoot);
                    convertChooser.setFileSelectionMode(0);
                    convertChooser.setMultiSelectionEnabled(true);
                    convertChooser.setDialogTitle("Select Files to Convert");
                    convertChoice = convertChooser.showOpenDialog(this.getMainWindow());
                    if (convertChoice != 0) {
                        return;
                    }
                    chosenConvertFileList = convertChooser.getSelectedFiles();
                    this.convertFilesDir = convertChooser.getCurrentDirectory().getAbsolutePath();
                    if (chosenConvertFileList.length == 0) {
                        JOptionPane.showMessageDialog(this, "No files were selected for conversion");
                        break;
                    }
                    if (this.ourConverter != null) {
                        this.ourConverter.getLogScrollPane().dispose();
                    }
                    try {
                        this.ourConverter = new FileConverter(this, this.convertFilesDir);
                    }
                    catch (FileConverterException c) {
                        JOptionPane.showMessageDialog(this, "Could not create file converter " + String.valueOf(c));
                        break;
                    }
                    i = 0;
                    while (i < chosenConvertFileList.length) {
                        result = this.ourConverter.convertAFile(chosenConvertFileList[i]);
                        if (!result) {
                            JOptionPane.showMessageDialog(this, "File converter failed on file " + i + " " + String.valueOf(chosenConvertFileList[i]));
                            break;
                        }
                        ++i;
                    }
                    this.ourConverter.getLogScrollPane().endLog();
                    break;
                }
                case 10: {
                    this.exportImageWindow.setTimePanel(this.openTimePanel);
                    if (!this.exportImagePlaced) {
                        exportPoint = this.editorCascadePosition(this.exportImageWindow.getWidth(), false);
                        this.exportImageWindow.setLocation(exportPoint);
                        this.exportImagePlaced = true;
                    }
                    this.exportImageWindow.setVisible(true);
                    break;
                }
                case 26: {
                    if (!this.exportHTMLPlaced) {
                        exportPoint = this.editorCascadePosition(this.exportHTMLWindow.getWidth(), false);
                        this.exportHTMLWindow.setLocation(exportPoint);
                        this.exportHTMLPlaced = true;
                    }
                    this.exportHTMLWindow.setVisible(true);
                    break;
                }
                case 25: {
                    if (this.ourInputFileJSON == null) {
                        JOptionPane.showMessageDialog(this, "Cannot create new time line if no file is open");
                        break;
                    }
                    newTimeline = new Event(CommonData.EventType.TIMELINE, "New Timeline", this.prefsWindow.getPalette().getColorName(0), 0, null, null, null, null, null, null, null);
                    newTimelineEditor = new EventEditor(this.mainWindow, newTimeline, this.openTimePanel, this.ourInputFileJSON.getEventData(), this.ourInputFileJSON.getConnections(), true);
                    tlPoint = this.editorCascadePosition(newTimelineEditor.getWidth(), false);
                    newTimelineEditor.setLocation(tlPoint);
                    ++this.openEditors;
                    newTimelineEditor.setResizable(true);
                    newTimelineEditor.setVisible(true);
                    this.itemNewTimelineEvent.setEnabled(true);
                    this.itemNewGeneralEvent.setEnabled(true);
                    this.itemNewConnection.setEnabled(true);
                    this.itemNewUntimed.setEnabled(true);
                    this.itemSaveAs.setEnabled(true);
                    this.itemExportImage.setEnabled(true);
                    this.itemFilter.setEnabled(true);
                    this.itemFind.setEnabled(true);
                    this.itemListTags.setEnabled(true);
                    this.itemListAll.setEnabled(true);
                    this.itemListMissing.setEnabled(true);
                    break;
                }
                case 4: {
                    if (this.ourInputFileJSON == null) {
                        JOptionPane.showMessageDialog(this, "Cannot create new event if no file is open");
                        break;
                    }
                    if (this.ourInputFileJSON.getEventData().getNumberOfTimelines() == 0) {
                        JOptionPane.showMessageDialog(this, "Cannot create new timeline event if no timeline exists.");
                        break;
                    }
                    newEvent = new Event(CommonData.EventType.TIMELINE_EVENT, "New Event", this.prefsWindow.getPalette().getColorName(0), 0, null, null, null, null, null, null, null);
                    newEventEditor = new EventEditor(this, newEvent, this.openTimePanel, this.ourInputFileJSON.getEventData(), this.ourInputFileJSON.getConnections(), true);
                    tlevPoint = this.editorCascadePosition(newEventEditor.getWidth(), false);
                    newEventEditor.setLocation(tlevPoint);
                    ++this.openEditors;
                    newEventEditor.setResizable(true);
                    newEventEditor.setVisible(true);
                    this.itemNewTimelineEvent.setEnabled(true);
                    this.itemNewGeneralEvent.setEnabled(true);
                    this.itemNewConnection.setEnabled(true);
                    this.itemNewUntimed.setEnabled(true);
                    this.itemFilter.setEnabled(true);
                    this.itemFind.setEnabled(true);
                    this.itemListTags.setEnabled(true);
                    this.itemListAll.setEnabled(true);
                    this.itemListMissing.setEnabled(true);
                    break;
                }
                case 27: {
                    if (this.ourInputFileJSON == null) {
                        JOptionPane.showMessageDialog(this, "Cannot create new event if no file is open");
                        break;
                    }
                    newEvent = new Event(CommonData.EventType.GENERAL_EVENT, "New Event", this.prefsWindow.getPalette().getColorName(0), 0, null, null, null, null, null, null, null);
                    newEventEditor = new EventEditor(this, newEvent, this.openTimePanel, this.ourInputFileJSON.getEventData(), this.ourInputFileJSON.getConnections(), true);
                    evPoint = this.editorCascadePosition(newEventEditor.getWidth(), false);
                    newEventEditor.setLocation(evPoint);
                    ++this.openEditors;
                    newEventEditor.setResizable(true);
                    newEventEditor.setVisible(true);
                    this.itemNewTimeline.setEnabled(true);
                    this.itemNewTimelineEvent.setEnabled(true);
                    this.itemNewConnection.setEnabled(true);
                    this.itemNewUntimed.setEnabled(true);
                    this.itemSaveAs.setEnabled(true);
                    this.itemExportImage.setEnabled(true);
                    this.itemFilter.setEnabled(true);
                    this.itemFind.setEnabled(true);
                    this.itemListTags.setEnabled(true);
                    this.itemListAll.setEnabled(true);
                    this.itemListMissing.setEnabled(true);
                    break;
                }
                case 23: {
                    if (this.ourInputFileJSON == null) {
                        JOptionPane.showMessageDialog(this, "Cannot create new untimed event if no file is open");
                        break;
                    }
                    newEvent = new Event(CommonData.EventType.UNTIMED, "New Untimed", this.prefsWindow.getPalette().getColorName(0), 0, null, null, null, null, null, null, null);
                    newUntimedEditor = new EventEditor(this, newEvent, this.openTimePanel, this.ourInputFileJSON.getEventData(), this.ourInputFileJSON.getConnections(), true);
                    evPoint = this.editorCascadePosition(newUntimedEditor.getWidth(), false);
                    newUntimedEditor.setLocation(evPoint);
                    ++this.openEditors;
                    newUntimedEditor.setResizable(true);
                    newUntimedEditor.setVisible(true);
                    this.itemNewTimeline.setEnabled(true);
                    this.itemNewTimelineEvent.setEnabled(true);
                    this.itemNewConnection.setEnabled(true);
                    this.itemNewUntimed.setEnabled(true);
                    this.itemSaveAs.setEnabled(true);
                    this.itemExportImage.setEnabled(true);
                    this.itemFilter.setEnabled(true);
                    this.itemFind.setEnabled(true);
                    this.itemListTags.setEnabled(true);
                    this.itemListAll.setEnabled(true);
                    this.itemListMissing.setEnabled(true);
                    break;
                }
                case 13: {
                    if (this.ourInputFileJSON == null) {
                        JOptionPane.showMessageDialog(this, "Cannot create new connection if no file is open");
                        break;
                    }
                    if (this.ourInputFileJSON.getEventData().getNumberOfTimelines() + this.ourInputFileJSON.getEventData().getNumberOfEventsOnly() < 2) {
                        JOptionPane.showMessageDialog(this, "At least two timelines and/or events are needed for a connection.");
                        break;
                    }
                    newConnection = new Connection("", "", this.prefsWindow.getPalette().getColorName(0), this.ourInputFileJSON.getEventData().getEventByIndex(0), null, null, this.ourInputFileJSON.getEventData().getEventByIndex(1), null, null, Connection.LineType.DIRECT, Connection.DashType.PLAIN, false, false, false, this.prefsWindow.getBezierCtrlX(), this.prefsWindow.getBezierCtrlY(), false, new Point2D.Double(20.0, 20.0), false, new Point2D.Double(20.0, 20.0));
                    newConnectionEditor = new ConnectionEditor(this, newConnection, this.ourInputFileJSON.getEventData(), this.ourInputFileJSON.getConnections(), true);
                    cnPoint = this.editorCascadePosition(newConnectionEditor.getWidth(), false);
                    newConnectionEditor.setLocation(cnPoint);
                    ++this.openEditors;
                    newConnectionEditor.setResizable(true);
                    newConnectionEditor.setVisible(true);
                    this.itemFilter.setEnabled(true);
                    this.itemFind.setEnabled(true);
                    this.itemListTags.setEnabled(true);
                    this.itemListAll.setEnabled(true);
                    this.itemListMissing.setEnabled(true);
                    break;
                }
                case 5: {
                    if (this.ourInputFileJSON == null) {
                        JOptionPane.showMessageDialog(this, "Cannot edit rows if no file is open");
                        break;
                    }
                    rowPoint = this.editorCascadePosition(this.rowEditor.getWidth(), false);
                    if (!this.rowEditorPlaced) {
                        this.rowEditorPlaced = true;
                    }
                    this.rowEditor.setLocation(rowPoint);
                    this.rowEditor.setVisible(true);
                    break;
                }
                case 14: {
                    if (this.ourInputFileJSON == null) {
                        JOptionPane.showMessageDialog(this, "Cannot edit introduction if no file is open");
                        break;
                    }
                    this.showIntroEditor();
                    break;
                }
                case 21: {
                    if (!this.filterPlaced) {
                        filterPoint = this.editorCascadePosition(this.ourFilterEditor.getWidth(), false);
                        this.ourFilterEditor.setLocation(filterPoint);
                        this.filterPlaced = true;
                    }
                    this.ourFilterEditor.setVisible(true);
                    break;
                }
                case 12: {
                    if (!this.findPlaced) {
                        findPoint = this.editorCascadePosition(this.findWindow.getWidth(), false);
                        this.findWindow.setLocation(findPoint);
                        this.findPlaced = true;
                    }
                    this.findWindow.setVisible(true);
                    break;
                }
                case 1: {
                    listTagsWin = new ReportXref(this);
                    listTagsWin.setVisible(true);
                    break;
                }
                case 9: {
                    this.listAllWin = new ReportSummary(this);
                    this.listAllWin.setVisible(true);
                    break;
                }
                case 7: {
                    missingWin = new ReportMissing(this);
                    missingWin.setVisible(true);
                    break;
                }
                case 2: {
                    relNotesFrame = new JFrame();
                    relNotesFrame.setDefaultCloseOperation(1);
                    relNotesFrame.setLocation(50, 50);
                    relNotesPane = new JEditorPane();
                    relNotesPane.setEditable(false);
                    relNotesPane.setContentType("text/html");
                    relNotesURL = this.getClass().getClassLoader().getResource("relnotes.html");
                    if (relNotesURL != null) {
                        try {
                            relNotesPane.setPage(relNotesURL);
                        }
                        catch (IOException rne) {
                            rne.printStackTrace();
                        }
                    } else {
                        JOptionPane.showMessageDialog(this.getMainWindow(), "Release Notes file not found");
                    }
                    relNotesScrollPane = new JScrollPane(relNotesPane);
                    relNotesScrollPane.setPreferredSize(new Dimension(700, 600));
                    relNotesFrame.setLocation(this.getMainWindow().getX() + 100, this.getMainWindow().getY() + 100);
                    relNotesFrame.add(relNotesScrollPane);
                    relNotesFrame.setSize(700, 600);
                    relNotesFrame.setVisible(true);
                    break;
                }
                case 17: {
                    aboutFrame = new JFrame();
                    aboutFrame.setDefaultCloseOperation(1);
                    aboutFrame.setLocation(50, 50);
                    aboutPane = new JEditorPane();
                    aboutPane.setEditable(false);
                    aboutPane.setContentType("text/html");
                    aboutPane.addHyperlinkListener(new HyperlinkListener(){

                        @Override
                        public void hyperlinkUpdate(HyperlinkEvent hle) {
                            if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                                Desktop desktop = Desktop.getDesktop();
                                try {
                                    desktop.browse(hle.getURL().toURI());
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        }
                    });
                    aboutURL = this.getClass().getClassLoader().getResource("about.html");
                    if (aboutURL != null) {
                        try {
                            aboutPane.setPage(aboutURL);
                        }
                        catch (IOException rne) {
                            rne.printStackTrace();
                        }
                    } else {
                        JOptionPane.showMessageDialog(this.getMainWindow(), "About file not found");
                    }
                    versionText = "Program Version: 09.05 Java Version: " + System.getProperty("java.version");
                    aboutScrollPane = new JScrollPane(aboutPane);
                    aboutScrollPane.setPreferredSize(new Dimension(600, 400));
                    tlIconPanelTitle = new TitledBorder(new LineBorder(Color.lightGray, 3), versionText, 1, 2);
                    aboutScrollPane.setBorder(tlIconPanelTitle);
                    aboutFrame.add(aboutScrollPane);
                    aboutFrame.setSize(600, 400);
                    aboutFrame.setLocation(this.getMainWindow().getX() + 80, this.getMainWindow().getY() + 80);
                    aboutFrame.setVisible(true);
                    break;
                }
                case 15: {
                    helpFrame = new JFrame();
                    helpFrame.setLocation(250, 350);
                    helpFrame.setDefaultCloseOperation(1);
                    helpPane = new JEditorPane();
                    helpPane.setEditable(false);
                    helpPane.setContentType("text/html");
                    helpURL = this.getClass().getClassLoader().getResource("help.html");
                    if (helpURL != null) {
                        try {
                            helpPane.setPage(helpURL);
                        }
                        catch (IOException rne) {
                            rne.printStackTrace();
                        }
                    } else {
                        JOptionPane.showMessageDialog(this.getMainWindow(), "Help file not found");
                    }
                    helpScrollPane = new JScrollPane(helpPane);
                    helpScrollPane.setPreferredSize(new Dimension(600, 400));
                    helpFrame.add(helpScrollPane);
                    helpFrame.setSize(550, 350);
                    helpFrame.setLocation(this.getMainWindow().getX() + 60, this.getMainWindow().getY() + 60);
                    helpFrame.setVisible(true);
                    break;
                }
                case 3: {
                    manualFile = null;
                    manualOK = false;
                    jarPath = Paths.get(cdGUI.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                    jarPathString = jarPath.toString();
                    if (jarPathString.endsWith(".jar")) {
                        jarPathString = jarPath.getParent().toString();
                    }
                    jarPathString = (String)jarPathString + File.separator + "cdManual09.05.pdf";
                    jarPath = Paths.get((String)jarPathString, new String[0]);
                    manualStream = this.getClass().getResourceAsStream("manual.pdf");
                    if (manualStream == null) ** GOTO lbl637
                    try {
                        Files.copy(manualStream, jarPath, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                        JOptionPane.showMessageDialog(this.getMainWindow(), "Manual copied to " + jarPath.toString() + "\nWill now open PDF");
                        manualFile = jarPath.toFile();
                        manualOK = true;
                    }
                    catch (IOException exc1) {
                        JOptionPane.showMessageDialog(this.getMainWindow(), "Manual file could not be written to location of jar file");
                        try {
                            userPath = Paths.get(System.getProperty("user.home") + File.separator + "cdManual09.05.pdf", new String[0]);
                            Files.copy(manualStream, userPath, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                            JOptionPane.showMessageDialog(this.getMainWindow(), "Manual copied to " + userPath.toString() + "\nWill now open PDF");
                            manualFile = userPath.toFile();
                            manualOK = true;
                            ** GOTO lbl638
                        }
                        catch (IOException exc2) {
                            JOptionPane.showMessageDialog(this.getMainWindow(), "Manual file could not be written to user folder - see Help");
                        }
                    }
                    ** GOTO lbl638
lbl637:
                    // 1 sources

                    JOptionPane.showMessageDialog(this.getMainWindow(), "Manual file not found in jar file");
lbl638:
                    // 4 sources

                    if (manualOK.booleanValue() && Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().open(manualFile);
                        }
                        catch (IOException | IllegalArgumentException exd) {
                            JOptionPane.showMessageDialog(this.getMainWindow(), "Cannot open user manual PDF file in desktop");
                        }
                    }
                    break;
                }
                case 8: {
                    iconsOK = false;
                    iconBrowsePath = this.prefsWindow.getIconsPath();
                    tmp = new File(iconBrowsePath);
                    if (!tmp.exists()) {
                        iconBrowsePath = System.getProperty("user.home");
                    }
                    iconDirChooser = new JFileChooser(iconBrowsePath);
                    iconDirChooser.setDialogTitle("Folder to Extract Icons  - will overwrite existing!");
                    iconDirChooser.setApproveButtonText("Select and Go");
                    iconDirChooser.setFileSelectionMode(1);
                    iconDirChoice = iconDirChooser.showOpenDialog(this);
                    if (iconDirChoice != 0) break;
                    chosenDir = iconDirChooser.getSelectedFile();
                    newIconsPath = chosenDir.getAbsolutePath();
                    iconsURL = this.getClass().getClassLoader().getResource("icons");
                    if (iconsURL == null) ** GOTO lbl690
                    try {
                        var43_98 = null;
                        var44_101 = null;
                        try {
                            iconsDirStream = Files.newDirectoryStream(Paths.get(iconsURL.getPath(), new String[0]));
                            try {
                                for (Path p : iconsDirStream) {
                                    nextFile = p.toString();
                                    System.out.println(nextFile + " to " + String.valueOf(Paths.get(newIconsPath + File.separator + String.valueOf(p.getFileName()), new String[0])));
                                    Files.copy(p, Paths.get(newIconsPath + File.separator + String.valueOf(p.getFileName()), new String[0]), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                                }
                                iconsDirStream.close();
                                iconsOK = true;
                                ** GOTO lbl691
                            }
                            finally {
                                if (iconsDirStream != null) {
                                    iconsDirStream.close();
                                }
                            }
                        }
                        catch (Throwable var44_102) {
                            if (var43_98 == null) {
                                var43_98 = var44_102;
                            } else if (var43_98 != var44_102) {
                                var43_98.addSuppressed(var44_102);
                            }
                            throw var43_98;
                        }
                    }
                    catch (Throwable dirStreamError) {
                        JOptionPane.showMessageDialog(this.getMainWindow(), "Directory Stream Error!\n" + String.valueOf(dirStreamError));
                    }
                    ** GOTO lbl691
lbl690:
                    // 1 sources

                    JOptionPane.showMessageDialog(this.getMainWindow(), "Icons folder not found in jar file");
lbl691:
                    // 3 sources

                    if (iconsOK.booleanValue()) {
                        this.prefsWindow.setIconsPath(newIconsPath);
                        JOptionPane.showMessageDialog(this.getMainWindow(), "Icons copied to " + newIconsPath.toString() + " and set in Preferences");
                    }
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(this.getMainWindow(), "cdGUI: Menu Item Listener called with invalid menu.");
                    break;
                }
            }
        }
        catch (Throwable unforeseen) {
            JOptionPane.showMessageDialog(this.getMainWindow(), "Unhandled Error!\n" + this.displayError(unforeseen));
        }
    }

    private void initialise() {
        this.closeWindows();
        this.getContentPane().removeAll();
        this.fileSaved = true;
        this.unsavedChanges.setText("");
        this.introText = "";
        this.techText = "";
        this.setTitle("Cultural Dynamics 09.05 (no file open)");
        this.prefsWindow.resetToDefaults();
        this.prefsWindow.createEmptyPalette();
        this.prefsWindow.resetPalette();
        this.ourFilterEditor.fileNewOpen();
        this.findWindow.clearLists();
        this.ourRowData = new RowData();
        this.rowEditor.dispose();
        this.rowEditor = new RowEditor(this, 0, this.ourRowData);
        this.rowEditor.setResizable(true);
        this.rowEditor.setVisible(false);
        this.getHTMLDialog().setHTMLPrimaryPath(System.getProperty("user.home"));
        this.getHTMLDialog().setHTMLSubdirs(false);
    }

    private boolean openFile(String myFilePath, Boolean json) {
        if (json.booleanValue()) {
            this.ourInputFileJSON = new InputFileJSON(this);
            if (myFilePath != "" && !this.ourInputFileJSON.readDataFile(myFilePath).booleanValue()) {
                JOptionPane.showMessageDialog(this, "Could not read JSON file.");
                return false;
            }
        } else {
            this.ourInputFileCSV = new InputFileCSV(this);
            if (myFilePath != "" && !this.ourInputFileCSV.readDataFile(myFilePath).booleanValue()) {
                JOptionPane.showMessageDialog(this, "Could not read CSV file.");
                return false;
            }
        }
        this.xMag = 1.0;
        this.status.setText("Magnification: " + this.xMag + "x  Filter: " + this.filterStatusString);
        this.nTicks = 10;
        this.xMagSlider.setValue(0);
        this.setRange();
        this.panLimits();
        this.getContentPane().removeAll();
        this.openTimePanel = this.myTimePanel = new TimePanel(this, this.ourInputFileJSON.getConnections(), this.nTicks);
        this.timeScrollPane = new JScrollPane();
        this.timeScrollPane.setHorizontalScrollBarPolicy(31);
        this.timeScrollPane.setVerticalScrollBarPolicy(20);
        this.timePort = new FloaterViewPort(this, this.myTimePanel);
        this.myTimePanel.setOpaque(false);
        this.timeScrollPane.setViewport(this.timePort);
        this.timeScrollPane.setViewportView(this.myTimePanel);
        this.timeScrollPane.getVerticalScrollBar().setBlockIncrement(this.getHeight() / 2);
        this.timePort.setVisible(true);
        this.timeScrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent r) {
                cdGUI.this.openTimePanel.setFound(null, false);
                cdGUI.this.mainWindow.setPreferredSize(new Dimension(cdGUI.this.mainWindow.getWidth(), cdGUI.this.mainWindow.getHeight()));
                cdGUI.this.myTimePanel.setWidth(r.getComponent().getWidth());
            }
        });
        JScrollBar timeVerticalScrollbar = this.timeScrollPane.getVerticalScrollBar();
        timeVerticalScrollbar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent a) {
                cdGUI.this.openTimePanel.setFound(null, false);
                int panPosition = cdGUI.this.panScrollbar.getValue();
                cdGUI.this.viewStartDate = cdGUI.this.rangeStart.plusDays(panPosition);
                cdGUI.this.myTimePanel.revalidate();
                cdGUI.this.myTimePanel.repaint();
            }
        });
        this.panScrollbar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent a) {
                cdGUI.this.openTimePanel.setFound(null, false);
                int panPosition = cdGUI.this.panScrollbar.getValue();
                cdGUI.this.viewStartDate = cdGUI.this.rangeStart.plusDays(panPosition);
                cdGUI.this.myTimePanel.revalidate();
                cdGUI.this.myTimePanel.repaint();
            }
        });
        this.xMagSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                cdGUI.this.openTimePanel.setFound(null, false);
                cdGUI.this.xMag = Math.max(cdGUI.this.xMagSlider.getValue() * cdGUI.this.maxZoom / cdGUI.this.maxMagSlider, 1);
                cdGUI.this.status.setText("Magnification: " + cdGUI.this.xMag + "x  Filter: " + cdGUI.this.filterStatusString);
                cdGUI.this.panLimits();
                cdGUI.this.myTimePanel.repaint();
                cdGUI.this.panScrollbar.repaint();
            }
        });
        FlowLayout flowLayout = new FlowLayout(0);
        JPanel panScrollLabelPanel = new JPanel(flowLayout);
        panScrollLabelPanel.add(this.panScrollLabel);
        JPanel xMagLabelPanel = new JPanel(flowLayout);
        xMagLabelPanel.add(this.xMagLabel);
        Box sliderBox = Box.createVerticalBox();
        sliderBox.setAlignmentX(0.0f);
        sliderBox.add(panScrollLabelPanel);
        this.panScrollLabel.setAlignmentX(0.0f);
        this.panScrollbar.setBackground(Color.WHITE);
        sliderBox.add(this.panScrollbar);
        sliderBox.add(xMagLabelPanel);
        sliderBox.add(this.xMagSlider);
        MouseHandler ourMouseHandler = new MouseHandler();
        this.myTimePanel.addMouseListener(ourMouseHandler);
        this.myTimePanel.addMouseMotionListener(ourMouseHandler);
        Box statusBox = Box.createHorizontalBox();
        statusBox.add(this.status);
        statusBox.add(Box.createHorizontalGlue());
        statusBox.add(this.unsavedChanges);
        statusBox.add(Box.createHorizontalGlue());
        sliderBox.add(statusBox);
        this.ourXAxis = new XAxisPanel(this, this.myTimePanel);
        Box bottomBox = Box.createVerticalBox();
        bottomBox.add(this.ourXAxis);
        bottomBox.add(sliderBox);
        this.add((Component)this.timeScrollPane, "Center");
        this.add((Component)bottomBox, "South");
        this.pack();
        return true;
    }

    public Point editorCascadePosition(int edWidth, boolean left) {
        int yPos;
        int xPos;
        this.mainWindowConfig = this.mainWindow.getGraphicsConfiguration();
        this.bounds = this.mainWindowConfig.getBounds();
        this.insets = Toolkit.getDefaultToolkit().getScreenInsets(this.mainWindowConfig);
        this.myScreen = this.mainWindowConfig.getDevice();
        this.env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.allScreens = this.env.getScreenDevices();
        this.myScreenIndex = -1;
        int j = 0;
        while (j < this.allScreens.length) {
            if (this.allScreens[j].equals(this.myScreen)) {
                this.myScreenIndex = j;
                break;
            }
            ++j;
        }
        if (left) {
            xPos = this.allScreens[this.myScreenIndex].getDefaultConfiguration().getBounds().x + this.insets.right;
            yPos = this.allScreens[this.myScreenIndex].getDefaultConfiguration().getBounds().y + this.insets.top;
        } else {
            xPos = this.allScreens[this.myScreenIndex].getDefaultConfiguration().getBounds().x + this.bounds.width - this.insets.right - edWidth;
            yPos = this.allScreens[this.myScreenIndex].getDefaultConfiguration().getBounds().y + this.insets.top;
            xPos -= this.openEditors * this.editorCascadeX;
            yPos += this.openEditors * this.editorCascadeY;
        }
        Point result = new Point(xPos, yPos);
        return result;
    }

    public void setRange() {
        DateAndWidth earlyData = new DateAndWidth(null, 0);
        DateAndWidth lateData = new DateAndWidth(null, 0);
        int earlyWidth = 0;
        int lateWidth = 0;
        earlyData = this.ourInputFileJSON.getEventData().getEarliestStartDate();
        earlyWidth = earlyData.getWidth();
        this.rangeStart = earlyData.getDate();
        if (this.ourInputFileJSON.getConnections().getNumberOfConnections() != 0 && this.ourInputFileJSON.getConnections().getEarliestStartDate() != null && this.ourInputFileJSON.getConnections().getEarliestStartDate().isBefore(this.rangeStart)) {
            this.rangeStart = this.ourInputFileJSON.getConnections().getEarliestStartDate();
        }
        lateData = this.ourInputFileJSON.getEventData().getLatestEndDateWidth();
        this.rangeEnd = lateData.getDate();
        lateWidth = lateData.getWidth();
        if (this.ourInputFileJSON.getConnections().getNumberOfConnections() != 0 && this.ourInputFileJSON.getConnections().getLatestEndDate() != null && this.ourInputFileJSON.getConnections().getLatestEndDate().isAfter(this.rangeEnd)) {
            this.rangeEnd = this.ourInputFileJSON.getConnections().getLatestEndDate();
        }
        int width = this.getWidth() - this.prefsWindow.getMarginLeft() - this.prefsWindow.getMarginRight();
        double pxPerDay = (double)width / (double)ChronoUnit.DAYS.between(this.rangeStart, this.rangeEnd);
        pxPerDay = Math.min(pxPerDay, 1.0);
        this.rangeStart = this.rangeStart.minusDays(Math.round((double)earlyWidth / pxPerDay));
        this.rangeStart = this.rangeStart.withMonth(1).withDayOfMonth(1);
        if (this.rangeStart.getYear() < 0 && this.rangeEnd.getYear() > 0 && this.rangeEnd.isBefore(Utils.maxDate.minusYears(1L))) {
            this.rangeEnd = this.rangeEnd.plusYears(1L);
        }
        this.rangeEnd = this.rangeEnd.plusDays(Math.round((double)lateWidth / pxPerDay));
        this.rangeEnd = this.rangeEnd.withMonth(12).withDayOfMonth(31);
        this.maxZoom = Math.max(this.rangeEnd.getYear() - this.rangeStart.getYear(), 1);
        if (this.maxZoom <= 1) {
            this.xMagSlider.setPaintTicks(false);
            this.xMagSlider.setPaintLabels(false);
            this.xMagSlider.setEnabled(false);
            this.xMagSlider.setValue(0);
        } else {
            Hashtable<Integer, JLabel> xMagTable = new Hashtable<Integer, JLabel>();
            int i = 0;
            while (i <= this.maxMagSlider) {
                int labeli = (int)Math.max((double)i * ((double)this.maxZoom / (double)this.maxMagSlider), 1.0);
                Integer intObj = i;
                xMagTable.put(intObj, new JLabel(String.valueOf(labeli)));
                i += 10;
            }
            this.xMagSlider.setLabelTable(xMagTable);
            this.xMagSlider.setMajorTickSpacing(10);
            this.xMagSlider.setMinorTickSpacing(1);
            this.xMagSlider.setPaintTicks(true);
            this.xMagSlider.setPaintLabels(true);
            this.xMagSlider.setSnapToTicks(false);
            this.xMagSlider.setEnabled(true);
        }
        if (this.xMag > (double)this.maxZoom) {
            this.xMag = this.maxZoom;
            this.status.setText("Magnification: " + this.xMag + "x  Filter: " + this.filterStatusString);
        }
        this.xMagSlider.revalidate();
        this.xMagSlider.repaint();
    }

    public void panLimits() {
        long range = ChronoUnit.DAYS.between(this.rangeStart, this.rangeEnd);
        int panScrollVisible = this.viewRangeDays = (int)Math.ceil((double)range / this.xMag);
        int panScrollEnd = (int)range;
        int panScrollStart = 0;
        this.panScrollbar.setBlockIncrement(panScrollVisible / 2);
        this.panScrollbar.setUnitIncrement(1);
        int panScrollCurrent = Math.min(this.panScrollbar.getValue(), panScrollEnd - panScrollVisible);
        this.viewStartDate = this.rangeStart.plusDays(panScrollCurrent);
        this.panScrollbar.setValues(panScrollCurrent, panScrollVisible, panScrollStart, panScrollEnd);
        this.panScrollbar.repaint();
    }

    public JFrame getMainWindow() {
        return this;
    }

    public InputFileJSON getInput() {
        return this.ourInputFileJSON;
    }

    public void decOpenEditors() {
        --this.openEditors;
    }

    public void incOpenEditors() {
        ++this.openEditors;
    }

    public void menuLogic() {
        if (this.ourInputFileJSON.getEventData().getNumberOfTimelines() == 0) {
            this.itemNewTimelineEvent.setEnabled(false);
        } else {
            this.itemNewTimelineEvent.setEnabled(true);
        }
        if (this.ourInputFileJSON.getEventData().getTotalNumberOfEvents() < 2) {
            this.itemNewConnection.setEnabled(false);
        } else {
            this.itemNewConnection.setEnabled(true);
        }
    }

    public String getJarPath() {
        return this.jarPath;
    }

    public LocalDate getLaterDate(LocalDate early, LocalDate late) {
        LocalDate result = early;
        if (late != null) {
            result = late;
        }
        return result;
    }

    public String displayError(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        String stackTrace = sw.toString();
        return stackTrace.replace(System.getProperty("line.separator"), "\n");
    }

    private void closeWindows() {
        if (this.ourInputFileJSON != null) {
            Window[] children;
            if (this.ourIntroEditor != null) {
                this.ourIntroEditor.dispose();
                this.ourIntroEditor = null;
            }
            Event tmpEv = null;
            int i = 0;
            while (i < this.ourInputFileJSON.getEventData().getTotalNumberOfEvents()) {
                tmpEv = this.ourInputFileJSON.getEventData().getEventByIndex(i);
                if (tmpEv.getEventType().equals((Object)CommonData.EventType.TIMELINE) && tmpEv.getTlSegmentList() != null) {
                    int j = 0;
                    while (j < tmpEv.getTlSegmentList().getNumberOfSegments()) {
                        if (tmpEv.getTlSegmentList().getASegment(j).getEditor() != null) {
                            tmpEv.getTlSegmentList().getASegment(j).getEditor().dispose();
                        }
                        ++j;
                    }
                }
                if (tmpEv.getEditor() != null && this.ourInputFileJSON.getEventData().getEventByIndex(i).getEditor() != null) {
                    this.ourInputFileJSON.getEventData().getEventByIndex(i).getEditor().dispose();
                }
                ++i;
            }
            i = 0;
            while (i < this.ourInputFileJSON.getConnections().getNumberOfConnections()) {
                if (this.ourInputFileJSON.getConnections().getConnection(i).getEditor() != null) {
                    this.ourInputFileJSON.getConnections().getConnection(i).getEditor().dispose();
                }
                ++i;
            }
            Window[] windowArray = children = cdGUI.getOwnerlessWindows();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Window win = windowArray[n2];
                if (win != this) {
                    win.dispose();
                }
                ++n2;
            }
        }
    }

    public String getProgramVersion() {
        return "09.05";
    }

    public String getProgramMajorVersion() {
        return "09.05".substring(0, 2);
    }

    public String getProgramName() {
        return "Cultural Dynamics";
    }

    public String getOpenFile() {
        return this.myFilePath;
    }

    public void setFileSaved(Boolean s) {
        this.fileSaved = s;
        if (s.booleanValue()) {
            this.unsavedChanges.setText("");
        } else {
            this.unsavedChanges.setText("Unsaved Changes");
        }
    }

    public Preferences getPreferences() {
        return this.prefsWindow;
    }

    public ExportDialog getExportDialog() {
        return this.exportImageWindow;
    }

    public ExportHTML getHTMLDialog() {
        return this.exportHTMLWindow;
    }

    public FilterEditor getFilterEditor() {
        return this.ourFilterEditor;
    }

    public RowData getRowData() {
        return this.ourRowData;
    }

    public TimePanel getTimePanel() {
        return this.openTimePanel;
    }

    public XAxisPanel getXAxis() {
        return this.ourXAxis;
    }

    public JScrollPane getTimeScrollPane() {
        return this.timeScrollPane;
    }

    public LocalDate getRangeStart() {
        return this.rangeStart;
    }

    public LocalDate getRangeEnd() {
        return this.rangeEnd;
    }

    public int getRangeDays() {
        return (int)Math.ceil(ChronoUnit.DAYS.between(this.rangeStart, this.rangeEnd));
    }

    public LocalDate getViewStartDate() {
        return this.viewStartDate;
    }

    public int getViewRangeDays() {
        return this.viewRangeDays;
    }

    public LocalDate getViewEndDate() {
        return this.viewStartDate.plusDays(this.viewRangeDays);
    }

    public void setViewportTopLeft() {
        this.timePort.setViewPosition(new Point(0, 0));
    }

    public void setViewPortTop() {
        this.timePort.setViewPosition(new Point(this.timePort.getX(), 0));
    }

    public FloaterViewPort getViewPort() {
        return this.timePort;
    }

    public void showPosition(LocalDate x, int y) {
        this.timeScrollPane.getVerticalScrollBar().setValue(y - this.timeScrollPane.getVerticalScrollBar().getVisibleAmount() / 2);
        long inc = ChronoUnit.DAYS.between(this.rangeStart, x);
        this.panScrollbar.setValue((int)inc);
        this.viewStartDate = this.rangeStart.plusDays(inc);
        this.panLimits();
        this.openTimePanel.revalidate();
        this.openTimePanel.repaint();
    }

    public void showSegmentEditor(Segment sg) {
        if (sg.getEditor() != null) {
            sg.getEditor().toFront();
        } else {
            SegmentEditor sgEditWindow = new SegmentEditor(this.mainWindow, sg, sg.getTimeline(), this.openTimePanel, false);
            Point sgPoint = this.editorCascadePosition(sgEditWindow.getWidth(), false);
            sgEditWindow.setLocation(sgPoint);
            ++this.openEditors;
            sgEditWindow.setResizable(true);
            sgEditWindow.setVisible(true);
        }
    }

    public void showEventEditor(Event ev) {
        if (ev.getEditor() != null) {
            ev.getEditor().toFront();
        } else {
            EventEditor evEditWindow = new EventEditor(this.mainWindow, ev, this.openTimePanel, this.ourInputFileJSON.getEventData(), this.ourInputFileJSON.getConnections(), false);
            Point tlPoint = this.editorCascadePosition(evEditWindow.getWidth(), false);
            evEditWindow.setLocation(tlPoint);
            ++this.openEditors;
            evEditWindow.setResizable(true);
            evEditWindow.setVisible(true);
        }
    }

    public void showConnectionEditor(Connection cn) {
        if (cn.getEditor() != null) {
            cn.getEditor().toFront();
        } else {
            ConnectionEditor cnEditWindow = new ConnectionEditor(this.mainWindow, cn, this.ourInputFileJSON.getEventData(), this.ourInputFileJSON.getConnections(), false);
            Point cnPoint = this.editorCascadePosition(cnEditWindow.getWidth(), false);
            cnEditWindow.setLocation(cnPoint);
            ++this.openEditors;
            cnEditWindow.setResizable(true);
            cnEditWindow.setVisible(true);
        }
    }

    public void showIntroEditor() {
        if (this.ourIntroEditor == null) {
            this.ourIntroEditor = new IntroEditor(this);
        } else {
            this.ourIntroEditor.toFront();
        }
        if (!this.introEditorPlaced) {
            this.introPoint = this.editorCascadePosition(this.ourIntroEditor.getWidth(), false);
            this.introEditorPlaced = true;
        }
        this.ourIntroEditor.setLocation(this.introPoint);
        this.ourIntroEditor.setResizable(true);
        this.ourIntroEditor.setVisible(true);
    }

    public ReportSummary getSummaryWindow() {
        return this.listAllWin;
    }

    public void setFilterStatus(String filter) {
        this.filterStatusString = filter != null ? filter : "Off";
        this.status.setText("Magnification: " + this.xMag + "x  Filter: " + this.filterStatusString);
    }

    public SavedFilterData getSavedFilterData() {
        return this.ourSavedFilterData;
    }

    public String getIntroText() {
        return this.introText;
    }

    public void setIntroText(String introText) {
        this.introText = introText;
    }

    public String getTechText() {
        return this.techText;
    }

    public void setTechText(String techText) {
        this.techText = techText;
    }

    public void closeIntroEditor() {
        this.ourIntroEditor = null;
        this.introEditorPlaced = false;
    }

    public TagList getMasterTags() {
        return this.masterTagList;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Could not set Look and Feel to Metal.");
        }
        Locale.setDefault(Locale.Category.DISPLAY, Locale.US);
        if (System.getProperty("os.name", "").toUpperCase().startsWith("MAC")) {
            InputMap im = (InputMap)UIManager.get("TextField.focusInputMap");
            cdGUI.setMacKeys(im);
            im = (InputMap)UIManager.get("FormattedTextField.focusInputMap");
            cdGUI.setMacKeys(im);
            im = (InputMap)UIManager.get("TextArea.focusInputMap");
            cdGUI.setMacKeys(im);
            im = (InputMap)UIManager.get("TextPane.focusInputMap");
            cdGUI.setMacKeys(im);
            im = (InputMap)UIManager.get("EditorPane.focusInputMap");
            cdGUI.setMacKeys(im);
            im = (InputMap)UIManager.get("List.focusInputMap");
            cdGUI.setMacKeys(im);
        }
        try {
            Desktop.getDesktop().setQuitHandler(new QuitHandler(){

                @Override
                public void handleQuitRequestWith(QuitEvent q, QuitResponse r) {
                    if (JOptionPane.showConfirmDialog(null, exitDialog1, "Close Program without saving?", 0, 3) == 0) {
                        r.performQuit();
                    }
                    r.cancelQuit();
                }
            });
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                cdGUI mainWindow = new cdGUI();
                mainWindow.setLocation(20, 20);
                mainWindow.setVisible(true);
                mainWindow.setPreferredSize(new Dimension(1000, 500));
            }
        });
    }

    private static void setMacKeys(InputMap im) {
        im.put(KeyStroke.getKeyStroke(65, 256), "select-all");
        im.put(KeyStroke.getKeyStroke(67, 256), "copy-to-clipboard");
        im.put(KeyStroke.getKeyStroke(86, 256), "paste-from-clipboard");
        im.put(KeyStroke.getKeyStroke(88, 256), "cut-to-clipboard");
        im.put(KeyStroke.getKeyStroke(37, 512), "caret-previous-word");
        im.put(KeyStroke.getKeyStroke(37, 576), "selection-previous-word");
        im.put(KeyStroke.getKeyStroke(37, 256), "caret-begin-line");
        im.put(KeyStroke.getKeyStroke(37, 320), "selection-begin-line");
        im.put(KeyStroke.getKeyStroke(39, 512), "caret-next-word");
        im.put(KeyStroke.getKeyStroke(39, 576), "selection-next-word");
        im.put(KeyStroke.getKeyStroke(39, 256), "caret-end-line");
        im.put(KeyStroke.getKeyStroke(39, 320), "selection-end-line");
        im.put(KeyStroke.getKeyStroke(38, 256), "caret-begin");
        im.put(KeyStroke.getKeyStroke(38, 320), "selection-begin");
        im.put(KeyStroke.getKeyStroke(40, 256), "caret-end");
        im.put(KeyStroke.getKeyStroke(40, 320), "selection-end");
    }

    private void openEditor(PopupMenuItem item) {
        switch (item.getType()) {
            case EVENT: {
                Event selectedEvent = item.getEv();
                if (selectedEvent.getEditor() != null) {
                    selectedEvent.getEditor().toFront();
                    break;
                }
                EventEditor evEditWindow = new EventEditor(this.mainWindow, selectedEvent, this.myTimePanel, this.ourInputFileJSON.getEventData(), this.ourInputFileJSON.getConnections(), false);
                Point evPoint = this.editorCascadePosition(evEditWindow.getWidth(), false);
                evEditWindow.setLocation(evPoint);
                ++this.openEditors;
                evEditWindow.setResizable(true);
                evEditWindow.setVisible(true);
                break;
            }
            case CONNECTION: {
                Connection selectedConnection = item.getCn();
                this.showOrOpenCn(selectedConnection);
                break;
            }
            case SEGMENT: {
                Segment selectedSegment = item.getSeg();
                Event tmpEvent = selectedSegment.getTimeline();
                if (selectedSegment.getEditor() != null) {
                    selectedSegment.getEditor().toFront();
                    break;
                }
                SegmentEditor segEditWindow = new SegmentEditor(this.mainWindow, selectedSegment, tmpEvent, this.myTimePanel, false);
                Point segPoint = this.editorCascadePosition(segEditWindow.getWidth(), false);
                segEditWindow.setLocation(segPoint);
                ++this.openEditors;
                segEditWindow.setResizable(true);
                segEditWindow.setVisible(true);
                break;
            }
            case ROW: {
                int row = item.getRow();
                this.rowEditor.setRow(row);
                this.rowEditor.setVisible(true);
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this.getMainWindow(), "Unknown type in popup menu listener");
            }
        }
    }

    public void showOrOpenCn(Connection cn) {
        if (cn.getEditor() != null) {
            cn.getEditor().toFront();
        } else {
            ConnectionEditor cnEditWindow = new ConnectionEditor(this.mainWindow, cn, this.ourInputFileJSON.getEventData(), this.ourInputFileJSON.getConnections(), false);
            Point cnPoint = this.editorCascadePosition(cnEditWindow.getWidth(), false);
            cnEditWindow.setLocation(cnPoint);
            ++this.openEditors;
            cnEditWindow.setResizable(true);
            cnEditWindow.setVisible(true);
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private double limitedX;
        private double limitedY;
        private double offsetLeft;
        private double offsetRight;
        private double offsetTop;
        private double offsetBottom;
        private boolean mouseDragged;

        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent c) {
            if (c.getClickCount() == 2) {
                int i;
                ArrayList<PopupMenuItem> clickedList = new ArrayList<PopupMenuItem>();
                if (cdGUI.this.prefsWindow.getShowRowNosChoice()) {
                    i = 0;
                    while (i < cdGUI.this.ourRowData.getSize()) {
                        Row tmpRow = cdGUI.this.ourRowData.getRowByIndex(i);
                        if (tmpRow.isClickedRow(c.getX(), c.getY())) {
                            clickedList.add(new PopupMenuItem(PopupMenuItem.ClickedType.ROW, "Row: " + (i + 1), null, null, null, i));
                        }
                        ++i;
                    }
                }
                i = 0;
                while (i < cdGUI.this.ourInputFileJSON.getEventData().getTotalNumberOfEvents()) {
                    SegmentList tmpSegList;
                    boolean clickedEvent;
                    Event tmpEvent = cdGUI.this.ourInputFileJSON.getEventData().getEventByIndex(i);
                    boolean bl = clickedEvent = tmpEvent.isClicked(c.getX(), c.getY()) && tmpEvent.isShown();
                    if (clickedEvent) {
                        clickedList.add(new PopupMenuItem(PopupMenuItem.ClickedType.EVENT, tmpEvent.getEventTypeAsName() + ": " + tmpEvent.getName(), tmpEvent, null, null, 0));
                    }
                    if (tmpEvent.getEventType().equals((Object)CommonData.EventType.TIMELINE) && tmpEvent.isShown() && (tmpSegList = tmpEvent.getTlSegmentList()) != null) {
                        int j = 0;
                        while (j < tmpSegList.getNumberOfSegments()) {
                            Segment tmpSegment = tmpSegList.getASegment(j);
                            if (tmpSegment.isClickedSegment(c.getX(), c.getY()) && tmpSegment.getTimeline().isShown()) {
                                clickedList.add(new PopupMenuItem(PopupMenuItem.ClickedType.SEGMENT, "Segment: " + tmpSegment.getTimeline().getName() + "-" + tmpSegment.getText(), null, null, tmpSegment, 0));
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                i = 0;
                while (i < cdGUI.this.ourInputFileJSON.getConnections().getNumberOfConnections()) {
                    boolean clickedConnection;
                    Connection tmpConnection = cdGUI.this.ourInputFileJSON.getConnections().getConnection(i);
                    boolean bl = clickedConnection = tmpConnection.isShown() && (tmpConnection.isClickedConnection(c.getX(), c.getY()) || tmpConnection.isClickedSrcName(c.getX(), c.getY()) || tmpConnection.isClickedDstName(c.getX(), c.getY()));
                    if (clickedConnection) {
                        clickedList.add(new PopupMenuItem(PopupMenuItem.ClickedType.CONNECTION, "Connection: " + tmpConnection.getID(), null, tmpConnection, null, 0));
                    }
                    ++i;
                }
                if (clickedList.size() == 1) {
                    cdGUI.this.openEditor((PopupMenuItem)clickedList.get(0));
                } else {
                    JPopupMenu clickPopup = new JPopupMenu();
                    int i2 = 0;
                    while (i2 < clickedList.size()) {
                        clickPopup.add((JMenuItem)clickedList.get(i2));
                        ((PopupMenuItem)clickedList.get(i2)).addActionListener(cdGUI.this.popupMenuListener);
                        ++i2;
                    }
                    clickPopup.show(c.getComponent(), c.getX(), c.getY());
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent c) {
            Connection tmpConnection = null;
            cdGUI.this.srcClicked = false;
            cdGUI.this.anyClicked = false;
            this.mouseDragged = false;
            int i = 0;
            while (i < cdGUI.this.ourInputFileJSON.getConnections().getNumberOfConnections()) {
                tmpConnection = cdGUI.this.ourInputFileJSON.getConnections().getConnection(i);
                if (tmpConnection.isClickedSrcName(c.getX(), c.getY()) && tmpConnection.isShown()) {
                    cdGUI.this.srcClicked = true;
                    cdGUI.this.anyClicked = true;
                }
                if (tmpConnection.isClickedDstName(c.getX(), c.getY()) && tmpConnection.isShown()) {
                    cdGUI.this.srcClicked = false;
                    cdGUI.this.anyClicked = true;
                }
                if (cdGUI.this.anyClicked) break;
                tmpConnection = null;
                ++i;
            }
            if (tmpConnection != null) {
                cdGUI.this.selectedCn = tmpConnection;
                cdGUI.this.cnNameOldAbsX = c.getX();
                cdGUI.this.cnNameOldAbsY = c.getY();
                if (cdGUI.this.anyClicked) {
                    Rectangle2D bounds;
                    if (cdGUI.this.srcClicked) {
                        bounds = cdGUI.this.selectedCn.getBoundsNameSource();
                        cdGUI.this.selectedCn.setSrcNameSelected(true);
                        cdGUI.this.cnNameOldRelX = cdGUI.this.selectedCn.getPosNameSource().getX();
                        cdGUI.this.cnNameOldRelY = cdGUI.this.selectedCn.getPosNameSource().getY();
                    } else {
                        bounds = cdGUI.this.selectedCn.getBoundsNameDestination();
                        cdGUI.this.selectedCn.setDstNameSelected(true);
                        cdGUI.this.cnNameOldRelX = cdGUI.this.selectedCn.getPosNameDestination().getX();
                        cdGUI.this.cnNameOldRelY = cdGUI.this.selectedCn.getPosNameDestination().getY();
                    }
                    this.offsetLeft = (double)c.getX() - bounds.getMinX();
                    this.offsetRight = bounds.getMaxX() - (double)c.getX();
                    this.offsetTop = (double)c.getY() - bounds.getMinY();
                    this.offsetBottom = bounds.getMaxY() - (double)c.getY();
                }
                cdGUI.this.myTimePanel.setCursor(new Cursor(12));
                cdGUI.this.myTimePanel.repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent c) {
            if (cdGUI.this.selectedCn != null) {
                this.mouseDragged = true;
                Rectangle view = cdGUI.this.getViewPort().getViewRect();
                double leftX = (double)cdGUI.this.prefsWindow.getMarginLeft() + this.offsetLeft;
                double rightX = (double)(cdGUI.this.myTimePanel.getWidth() - cdGUI.this.getTimeScrollPane().getVerticalScrollBar().getWidth() - cdGUI.this.prefsWindow.getMarginRight()) - this.offsetRight;
                double topY = view.getMinY() + (double)cdGUI.this.prefsWindow.getMarginTop() + this.offsetTop;
                double bottomY = view.getMaxY() - this.offsetBottom;
                this.limitedX = c.getX();
                this.limitedY = c.getY();
                this.limitedX = Math.max(this.limitedX, leftX);
                this.limitedX = Math.min(this.limitedX, rightX);
                this.limitedY = Math.max(this.limitedY, topY);
                this.limitedY = Math.min(this.limitedY, bottomY);
                if (cdGUI.this.srcClicked) {
                    cdGUI.this.selectedCn.setPosNameSource(new Point2D.Double(this.limitedX - (double)cdGUI.this.cnNameOldAbsX + cdGUI.this.cnNameOldRelX, this.limitedY - (double)cdGUI.this.cnNameOldAbsY + cdGUI.this.cnNameOldRelY));
                } else {
                    cdGUI.this.selectedCn.setPosNameDestination(new Point2D.Double(this.limitedX - (double)cdGUI.this.cnNameOldAbsX + cdGUI.this.cnNameOldRelX, this.limitedY - (double)cdGUI.this.cnNameOldAbsY + cdGUI.this.cnNameOldRelY));
                }
                cdGUI.this.setFileSaved(false);
                cdGUI.this.myTimePanel.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent c) {
            if (cdGUI.this.selectedCn != null && this.mouseDragged) {
                if (cdGUI.this.srcClicked) {
                    cdGUI.this.selectedCn.setPosNameSource(new Point2D.Double(this.limitedX - (double)cdGUI.this.cnNameOldAbsX + cdGUI.this.cnNameOldRelX, this.limitedY - (double)cdGUI.this.cnNameOldAbsY + cdGUI.this.cnNameOldRelY));
                } else {
                    cdGUI.this.selectedCn.setPosNameDestination(new Point2D.Double(this.limitedX - (double)cdGUI.this.cnNameOldAbsX + cdGUI.this.cnNameOldRelX, this.limitedY - (double)cdGUI.this.cnNameOldAbsY + cdGUI.this.cnNameOldRelY));
                }
            }
            if (cdGUI.this.selectedCn != null) {
                cdGUI.this.selectedCn.setSrcNameSelected(false);
                cdGUI.this.selectedCn.setDstNameSelected(false);
            }
            cdGUI.this.myTimePanel.repaint();
            cdGUI.this.selectedCn = null;
            this.mouseDragged = false;
            cdGUI.this.myTimePanel.setCursor(new Cursor(0));
        }
    }

    private class PopupListener
    implements ActionListener {
        private PopupListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PopupMenuItem item = (PopupMenuItem)e.getSource();
            cdGUI.this.openEditor(item);
        }
    }
}

