/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CommonData;
import culturalDynamics.Event;
import culturalDynamics.EventEditor;
import culturalDynamics.Row;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONWriter;

class RowData {
    private List<Row> rows = new ArrayList<Row>();

    public RowData() {
        this.insertRow(new Row(), 0);
    }

    public boolean isRowDataEmpty() {
        return this.rows == null || this.rows.size() == 0;
    }

    public boolean isRowDataPlusEmpty() {
        if (this.rows == null || this.rows.size() == 0) {
            return true;
        }
        int i = 0;
        while (i < this.rows.size()) {
            if (!this.rows.get(i).isRowEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getSize() {
        return this.rows.size();
    }

    public Row getRowByIndex(int idx) {
        return this.rows.get(idx);
    }

    public void appendRow(Row r) {
        this.rows.add(r);
    }

    public void insertRow(Row r, int idx) {
        if (idx == 0 && this.rows == null || idx >= this.rows.size()) {
            this.rows.add(r);
        } else {
            this.rows.add(idx, r);
        }
        int i = idx;
        while (i < this.rows.size()) {
            this.notifyEventEditors(i);
            ++i;
        }
    }

    public boolean addEventToRow(Event ev, int minXGap, int rowIdx) {
        if (this.areDatesFreeInRow(ev.getDates().getEarlyStartDate(), ev.getDates().getRealEndDate(), minXGap, rowIdx)) {
            this.rows.get(rowIdx).getEvents().add(ev);
            return true;
        }
        return false;
    }

    public void removeEventFromRow(Event ev, int rowIdx) {
        Row tmpRow = this.rows.get(rowIdx);
        tmpRow.removeEvent(ev);
    }

    public void removeRow(int idx) {
        this.rows.remove(idx);
        int i = idx;
        while (i < this.rows.size()) {
            this.notifyEventEditors(i);
            ++i;
        }
    }

    public int getFirstRowWithFreeDates(LocalDate start, LocalDate end, int minXGap) {
        int i = 0;
        while (i < this.rows.size()) {
            if (!this.rows.get(i).getKeepRowEmpty() && this.areDatesFreeInRow(start, end, minXGap, i)) {
                return i;
            }
            ++i;
        }
        this.rows.add(new Row());
        return this.rows.size() - 1;
    }

    public int getRowOfEvent(Event ev) {
        int i = 0;
        while (i < this.rows.size()) {
            Row tmpRow = this.rows.get(i);
            int j = 0;
            while (j < tmpRow.getNumberOfEvents()) {
                if (tmpRow.getEventByIndex(j) == ev) {
                    return i;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    public void sortRows() {
        if (this.rows != null) {
            Collections.sort(this.rows, (a, b) -> a.getEarliestDate().compareTo(b.getEarliestDate()));
        }
        int i = 0;
        while (i < this.rows.size()) {
            this.notifyEventEditors(i);
            ++i;
        }
    }

    public int moveUp(int idx) {
        int newIdx;
        Row tmpRow = this.rows.get(idx);
        int chgIdx = newIdx = idx - 1;
        if (newIdx < 0) {
            newIdx = this.rows.size() - 1;
            chgIdx = 0;
        }
        this.rows.remove(idx);
        this.rows.add(newIdx, tmpRow);
        int i = chgIdx;
        while (i < this.rows.size()) {
            this.notifyEventEditors(i);
            ++i;
        }
        return newIdx;
    }

    public int moveDown(int idx) {
        Row tmpRow = this.rows.get(idx);
        int newIdx = idx + 1;
        int chgIdx = idx;
        if (newIdx > this.rows.size() - 1) {
            newIdx = 0;
            chgIdx = 0;
        }
        this.rows.remove(idx);
        this.rows.add(newIdx, tmpRow);
        int i = chgIdx;
        while (i < this.rows.size()) {
            this.notifyEventEditors(i);
            ++i;
        }
        return newIdx;
    }

    private boolean areDatesFreeInRow(LocalDate startIn, LocalDate endIn, int daysMinXGap, int rowIdx) {
        Row ourRow = this.rows.get(rowIdx);
        LocalDate start = startIn.minusDays(daysMinXGap - 1);
        LocalDate end = endIn;
        if (end == null) {
            end = start;
        }
        end = end.plusDays(daysMinXGap);
        int i = 0;
        while (i < ourRow.getNumberOfEvents()) {
            Event tmpEv = ourRow.getEventByIndex(i);
            if (this.dateIsOnOrBetween(start, tmpEv.getDates().getEarlyStartDate(), tmpEv.getDates().getRealEndDate()) || this.dateIsOnOrBetween(end, tmpEv.getDates().getEarlyStartDate(), tmpEv.getDates().getRealEndDate()) || start.isBefore(tmpEv.getDates().getEarlyStartDate()) && end.isAfter(tmpEv.getDates().getRealEndDate())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean areEvDatesFreeInRow(Event event, LocalDate startIn, LocalDate endIn, int daysMinXGap, int rowIdx) {
        Row ourRow = this.rows.get(rowIdx);
        if (ourRow.getKeepRowEmpty()) {
            return false;
        }
        LocalDate start = startIn.minusDays(daysMinXGap - 1);
        LocalDate end = endIn;
        if (end == null) {
            end = start;
        }
        end = end.plusDays(daysMinXGap);
        int i = 0;
        while (i < ourRow.getNumberOfEvents()) {
            Event tmpEv = ourRow.getEventByIndex(i);
            if (tmpEv != event && (this.dateIsOnOrBetween(start, tmpEv.getDates().getEarlyStartDate(), tmpEv.getDates().getRealEndDate()) || this.dateIsOnOrBetween(end, tmpEv.getDates().getEarlyStartDate(), tmpEv.getDates().getRealEndDate()) || start.isBefore(tmpEv.getDates().getEarlyStartDate()) && end.isAfter(tmpEv.getDates().getRealEndDate()))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean dateIsOnOrBetween(LocalDate date, LocalDate start, LocalDate end) {
        return !(!date.isAfter(start) && !date.equals(start) || !date.isBefore(end) && !date.equals(end));
    }

    private void notifyEventEditors(int row) {
        Row aRow = this.getRowByIndex(row);
        int i = 0;
        while (i < aRow.getNumberOfEvents()) {
            Event tmpEv = aRow.getEventByIndex(i);
            if ((tmpEv.getEventType().equals((Object)CommonData.EventType.TIMELINE) || tmpEv.getEventType().equals((Object)CommonData.EventType.GENERAL_EVENT)) && tmpEv.getEditor() != null) {
                EventEditor evEd = (EventEditor)tmpEv.getEditor();
                evEd.setRowChanges();
            }
            ++i;
        }
    }

    public void toJSON(JSONWriter writer) {
        writer.key("rows").array();
        int i = 0;
        while (i < this.getSize()) {
            writer.object().key("rowIndex").value(String.valueOf(i)).key("keepEmpty").value(String.valueOf(this.getRowByIndex(i).getKeepRowEmpty()));
            writer.endObject();
            ++i;
        }
        writer.endArray();
    }
}

