/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.Connection;
import culturalDynamics.ConnectionData;
import culturalDynamics.Event;
import culturalDynamics.EventData;
import culturalDynamics.Filter;
import culturalDynamics.FilterEditor;
import culturalDynamics.SavedFilterData;
import culturalDynamics.SegmentList;
import culturalDynamics.TagList;
import culturalDynamics.Utils;
import culturalDynamics.cdGUI;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileNameExtensionFilter;

class ReportXref
extends JFrame {
    private static final long serialVersionUID = 1L;
    private cdGUI ourGUI;
    private JFrame xrefFrame;
    private String buffer;
    private ArrayList<String> byColour = new ArrayList();
    private ArrayList<String> byColourContent = new ArrayList();
    private ArrayList<String> byIcon = new ArrayList();
    private ArrayList<String> byIconContent = new ArrayList();
    private JButton exportButton = new JButton("Export");
    private String exportButtonTip = "Export report to an html file.";
    private JButton printButton = new JButton("Print");
    private String printButtonTip = "Print the summary report. Note the number of pages is not available in the print dialog.";
    private JButton closeButton = new JButton("Close");
    private String closeButtonTip = "Close the summary.";
    private FlowLayout flowLayoutCenter = new FlowLayout(1);
    private String currentExportDir = "";
    private BufferedWriter outBuffer = null;
    private String newOverwriteDialog = "New output file already exists. Do you want to overwrite it?";
    private String head = "<html><head><meta charset=\"UTF-8\"><title>Cultural Dynamics Cross Reference Report</title>";
    private String styles = "<style type=\"text/css\">\n\tp{margin: 0px 0px 0px 0px; padding: 0px 0px 0px 0px;}\n\t.indent{margin: 0px 0px 0px 30px;}\nh1{margin: 12pt 0px 0px 0px; padding: 0px 0px 0px 0px; font-size:24pt;}\nh2{margin:  9pt 0px 0px 0px; padding: 0px 0px 0px 0px; font-size:18pt;}\nh3{margin:  7pt 0px 0px 0px; padding: 0px 0px 0px 0px; font-size:14pt;}\nh4(margin:  6pt 0px 0px 0px; padding: 0px 0px 0px 0px; font-size:12pt;)\n</style>";
    private String body = "<body style=\"font-size:10pt;\">";
    private String headerEvents = "Events";
    private String headerConnections = "Connections";
    private String headerByColour = "Colours";
    private String headerFilters = "Saved Filters";
    private String headerByTag = "Tags";
    private String headerByIcon = "Icons";

    ReportXref(cdGUI mainGUI) {
        this.ourGUI = mainGUI;
        this.xrefFrame = this;
        this.setTitle("Cross-Reference Report of " + this.ourGUI.getOpenFile());
        this.buffer = "";
        this.appendString(this.head);
        this.appendString(this.styles);
        this.appendString("</head>");
        this.appendString(this.body);
        String tmpTimestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + " with " + this.ourGUI.getProgramName() + " version " + this.ourGUI.getProgramVersion();
        this.appendString(Utils.makeH1("Cross-Reference Report"));
        this.appendString("For file " + this.ourGUI.getOpenFile() + "<br>");
        this.appendString("File written at " + tmpTimestamp + "<br>");
        this.appendString(Utils.makeH2("Contents"));
        this.appendString(Utils.makeIntLink("toc_" + Utils.noSpace(this.headerEvents), this.headerEvents) + "<br>\n");
        this.appendString(Utils.makeIntLink("toc_" + Utils.noSpace(this.headerConnections), this.headerConnections) + "<br>\n");
        if (this.ourGUI.getPreferences().getXrefColour()) {
            this.appendString(Utils.makeIntLink("toc_" + Utils.noSpace(this.headerByColour), this.headerByColour) + "<br>\n");
        }
        this.appendString(Utils.makeIntLink("toc_" + Utils.noSpace(this.headerFilters), this.headerFilters) + "<br>\n");
        this.appendString(Utils.makeIntLink("toc_" + Utils.noSpace(this.headerByTag), this.headerByTag) + "<br>\n");
        if (this.ourGUI.getPreferences().getXrefIcons()) {
            this.appendString(Utils.makeIntLink("toc_" + Utils.noSpace(this.headerByIcon), this.headerByIcon) + "<br>\n");
        }
        this.appendString(Utils.makeH2(this.headerEvents));
        EventData events = this.ourGUI.getInput().getEventData();
        List<Event> eventsList = events.getListOfAllEvents(true);
        int i = 0;
        while (i < eventsList.size()) {
            Object tmp;
            Event ourEv = eventsList.get(i);
            String type = "?";
            type = ourEv.getEventType().toString();
            String evLink = Utils.makeIntLink("event_" + Utils.noSpace(type + " " + ourEv.getName()), ourEv.getName());
            this.appendString(Utils.makeH3(Utils.makeAnchor("event_", type + " " + ourEv.getName())));
            this.appendString("Tags: ");
            String[] tagsArray = ourEv.getTags().getTagsAsArray();
            int j = 0;
            while (j < tagsArray.length) {
                this.appendString(Utils.makeIntLink("tag_" + tagsArray[j], tagsArray[j]));
                ++j;
            }
            if (this.ourGUI.getPreferences().getXrefColour()) {
                String colour = ourEv.getColor();
                this.appendString("<br>\nColour: ");
                this.appendString(Utils.makeIntLink("col_" + colour, colour) + "<br>\n");
                int colourIdx = this.byColour.indexOf(colour);
                if (colourIdx == -1) {
                    this.byColour.add(colour);
                    this.byColourContent.add(Utils.makeH3("Colour " + Utils.makeAnchor("col_", colour)));
                    colourIdx = this.byColour.size() - 1;
                }
                tmp = this.byColourContent.get(colourIdx);
                tmp = (String)tmp + type + " " + evLink + "<br>\n";
                this.byColourContent.set(colourIdx, (String)tmp);
                SegmentList segments = ourEv.getTlSegmentList();
                if (segments != null) {
                    int j2 = 0;
                    while (j2 < segments.getNumberOfSegments()) {
                        String segColourFG = segments.getASegment(j2).getColorFG();
                        String segmentName = segments.getASegment(j2).getText();
                        int segColourIdx = this.byColour.indexOf(segColourFG);
                        if (segColourIdx == -1) {
                            this.byColour.add(segColourFG);
                            this.byColourContent.add(Utils.makeH3("Colour " + Utils.makeAnchor("col_", segColourFG)));
                            segColourIdx = this.byColour.size() - 1;
                        }
                        Object tmp2 = this.byColourContent.get(segColourIdx);
                        tmp2 = (String)tmp2 + type + " " + evLink + " Segment " + segmentName + "<br>\n";
                        this.byColourContent.set(segColourIdx, (String)tmp2);
                        String segColourBGOS = segments.getASegment(j2).getColorOuterStart();
                        segmentName = segments.getASegment(j2).getText();
                        segColourIdx = this.byColour.indexOf(segColourBGOS);
                        if (segColourIdx == -1) {
                            this.byColour.add(segColourBGOS);
                            this.byColourContent.add(Utils.makeH3("Colour " + Utils.makeAnchor("col_", segColourBGOS)));
                            segColourIdx = this.byColour.size() - 1;
                        }
                        tmp2 = this.byColourContent.get(segColourIdx);
                        tmp2 = (String)tmp2 + type + " " + evLink + " Segment " + segmentName + "<br>\n";
                        this.byColourContent.set(segColourIdx, (String)tmp2);
                        String segColourBGOE = segments.getASegment(j2).getColorOuterEnd();
                        segmentName = segments.getASegment(j2).getText();
                        segColourIdx = this.byColour.indexOf(segColourBGOE);
                        if (segColourIdx == -1) {
                            this.byColour.add(segColourBGOE);
                            this.byColourContent.add(Utils.makeH3("Colour " + Utils.makeAnchor("col_", segColourBGOE)));
                            segColourIdx = this.byColour.size() - 1;
                        }
                        tmp2 = this.byColourContent.get(segColourIdx);
                        tmp2 = (String)tmp2 + type + " " + evLink + " Segment " + segmentName + "<br>\n";
                        this.byColourContent.set(segColourIdx, (String)tmp2);
                        String segColourBGin = segments.getASegment(j2).getColorInner();
                        segmentName = segments.getASegment(j2).getText();
                        segColourIdx = this.byColour.indexOf(segColourBGin);
                        if (segColourIdx == -1) {
                            this.byColour.add(segColourBGin);
                            this.byColourContent.add(Utils.makeH3("Colour " + Utils.makeAnchor("col_", segColourBGin)));
                            segColourIdx = this.byColour.size() - 1;
                        }
                        tmp2 = this.byColourContent.get(segColourIdx);
                        tmp2 = (String)tmp2 + type + " " + evLink + " Segment " + segmentName + "<br>\n";
                        this.byColourContent.set(segColourIdx, (String)tmp2);
                        ++j2;
                    }
                }
            }
            if (this.ourGUI.getPreferences().getXrefIcons()) {
                int iconIdx;
                if (ourEv.getIcon() != null) {
                    String startIcon = ourEv.getIcon().toString();
                    this.appendString("Start Icon: ");
                    this.appendString(Utils.makeIntLink("icon_" + startIcon, startIcon) + "<br>\n");
                    iconIdx = this.byIcon.indexOf(startIcon);
                    if (iconIdx == -1) {
                        this.byIcon.add(startIcon);
                        this.byIconContent.add(Utils.makeH3("Icon " + Utils.makeAnchor("icon_", startIcon)));
                        iconIdx = this.byIcon.size() - 1;
                    }
                    tmp = this.byIconContent.get(iconIdx);
                    tmp = (String)tmp + type + " " + evLink + "<br>\n";
                    this.byIconContent.set(iconIdx, (String)tmp);
                }
                if (ourEv.getEndIcon() != null) {
                    String endIcon = ourEv.getEndIcon().toString();
                    this.appendString("End Icon: ");
                    this.appendString(Utils.makeIntLink("icon_" + endIcon, endIcon) + "<br>\n");
                    iconIdx = this.byIcon.indexOf(endIcon);
                    if (iconIdx == -1) {
                        this.byIcon.add(endIcon);
                        this.byIconContent.add(Utils.makeH3("Icon " + Utils.makeAnchor("icon_", endIcon)));
                        iconIdx = this.byIcon.size() - 1;
                    }
                    tmp = this.byIconContent.get(iconIdx);
                    tmp = (String)tmp + type + " " + evLink + "<br>\n";
                    this.byIconContent.set(iconIdx, (String)tmp);
                }
            }
            ++i;
        }
        this.appendString(Utils.makeH2(this.headerConnections));
        ConnectionData connections = this.ourGUI.getInput().getConnections();
        connections.sortConnectionsByName();
        int i2 = 0;
        while (i2 < connections.getNumberOfConnections()) {
            Connection ourCn = connections.getConnection(i2);
            String anchor = Utils.noSpace("cn_" + ourCn.getSourceEvent().getName() + "_" + ourCn.getDestEvent().getName());
            this.appendString(Utils.makeH3("Connection " + Utils.makeCnAnchor(anchor, ourCn.getNiceID())));
            String cnLink = Utils.makeIntLink(anchor, ourCn.getID());
            if (ourCn.getName() != "") {
                this.appendString("Name: " + ourCn.getName() + "<br>\n");
            }
            this.appendString("Tags: ");
            String[] tagsArray = ourCn.getTags().getTagsAsArray();
            int j = 0;
            while (j < tagsArray.length) {
                this.appendString(Utils.makeIntLink("tag_" + tagsArray[j], tagsArray[j]));
                ++j;
            }
            if (this.ourGUI.getPreferences().getXrefColour()) {
                String colour = ourCn.getColor();
                this.appendString("<br>\nColour: ");
                this.appendString(Utils.makeIntLink("col_" + colour, colour) + "<br>\n");
                int colourIdx = this.byColour.indexOf(colour);
                if (colourIdx == -1) {
                    this.byColour.add(colour);
                    this.byColourContent.add(Utils.makeH3("Colour " + Utils.makeAnchor("col_", colour)));
                    colourIdx = this.byColour.size() - 1;
                }
                Object tmp = this.byColourContent.get(colourIdx);
                tmp = (String)tmp + "CONNECTION " + cnLink + "<br>\n";
                this.byColourContent.set(colourIdx, (String)tmp);
            }
            ++i2;
        }
        if (this.ourGUI.getPreferences().getXrefColour()) {
            this.byColourContent.sort(null);
            this.appendString(Utils.makeH2(this.headerByColour));
            i2 = 0;
            while (i2 < this.byColour.size()) {
                this.appendString(this.byColourContent.get(i2) + "<br>\n");
                ++i2;
            }
        }
        SavedFilterData ourFilters = this.ourGUI.getSavedFilterData();
        this.appendString(Utils.makeH2(this.headerFilters));
        int i3 = 0;
        while (i3 < ourFilters.getNumFilters()) {
            Filter currentFilter = ourFilters.getSavedFilterByIndex(i3);
            String name = currentFilter.getName();
            this.appendString(Utils.makeH3(Utils.makeAnchor("fil_", name)));
            int j = 0;
            while (j < currentFilter.getNumFilterStages()) {
                String logic = String.valueOf((Object)currentFilter.getLogic(j));
                if (logic == "NOP") {
                    logic = "";
                }
                FilterEditor.Operation op = currentFilter.getOperation(j);
                this.appendString(logic + " " + String.valueOf((Object)op));
                String[] tagsArray = currentFilter.getFilterStageSaved(j).getTags().getTagsAsArray();
                int k = 0;
                while (k < tagsArray.length) {
                    this.appendString(Utils.makeIntLink("tag_" + tagsArray[k], tagsArray[k]));
                    ++k;
                }
                ++j;
            }
            ++i3;
        }
        this.appendString(Utils.makeH2(this.headerByTag));
        TagList allTags = this.ourGUI.getMasterTags();
        allTags.sortTags();
        int i4 = 0;
        while (i4 < allTags.getSize()) {
            String ourTag = allTags.getTagByIndex(i4);
            String tagPattern = ".*" + ourTag + "\\b.*";
            this.appendString(Utils.makeH3(Utils.makeAnchor("tag_", ourTag)));
            int j = 0;
            while (j < eventsList.size()) {
                String evTags;
                Event ourEv = eventsList.get(j);
                String type = ourEv.getEventType().toString();
                String evLink = Utils.makeIntLink("event_" + Utils.noSpace(type + " " + ourEv.getName()), ourEv.getName());
                if (ourEv.getTags().getSize() != 0 && Utils.patternMatch(tagPattern, evTags = ourEv.getTags().getTagsAsString(), false, true, false)) {
                    String tmp = type + " " + evLink + "<br>\n";
                    this.appendString(tmp);
                }
                ++j;
            }
            j = 0;
            while (j < connections.getNumberOfConnections()) {
                Connection ourCn = connections.getConnection(j);
                String cnTags = ourCn.getTags().getTagsAsString();
                if (ourCn.getTags().getSize() != 0 && Utils.patternMatch(tagPattern, cnTags, false, true, false)) {
                    String cnLink = Utils.makeIntLink(Utils.noSpace("cn_" + ourCn.getSourceEvent().getName() + "_" + ourCn.getDestEvent().getName()), ourCn.getNiceID());
                    String tmp = "CONNECTION " + cnLink + "<br>\n";
                    this.appendString(tmp);
                }
                ++j;
            }
            j = 0;
            while (j < ourFilters.getNumFilters()) {
                Filter currentFilter = ourFilters.getSavedFilterByIndex(j);
                String filLink = Utils.makeIntLink("fil_" + currentFilter.getName(), currentFilter.getName());
                int k = 0;
                while (k < currentFilter.getNumFilterStages()) {
                    TagList tagList = currentFilter.getFilterStageSaved(k).getTags();
                    String stageTags = tagList.getTagsAsString();
                    if (Utils.patternMatch(tagPattern, stageTags, false, true, false)) {
                        String tmp = "Filter " + filLink + "<br>\n";
                        this.appendString(tmp);
                    }
                    ++k;
                }
                ++j;
            }
            ++i4;
        }
        if (this.ourGUI.getPreferences().getXrefIcons()) {
            this.byIconContent.sort(null);
            this.appendString(Utils.makeH2(this.headerByIcon));
            i4 = 0;
            while (i4 < this.byIcon.size()) {
                this.appendString(this.byIconContent.get(i4));
                ++i4;
            }
        }
        this.appendString("<br>End of Cross Reference Report");
        this.appendString("</body></html>");
        final JEditorPane htmlPane = new JEditorPane("text/html", this.buffer);
        htmlPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hle) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                    String ref = hle.getDescription();
                    if (ref != null && ref.startsWith("#")) {
                        ref = ref.substring(1);
                        htmlPane.scrollToReference(ref);
                    } else {
                        try {
                            Desktop desktop = Desktop.getDesktop();
                            desktop.browse(hle.getURL().toURI());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        });
        JScrollPane xrefScrollPane = new JScrollPane(htmlPane);
        htmlPane.setCaretPosition(0);
        htmlPane.setEditable(false);
        this.add(xrefScrollPane);
        JPanel buttonPanel = new JPanel(this.flowLayoutCenter);
        this.printButton.setToolTipText(this.printButtonTip);
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent print) {
                try {
                    htmlPane.print(null, new MessageFormat("Page - {0}"));
                }
                catch (PrinterException e) {
                    e.printStackTrace();
                }
            }
        });
        this.exportButton.setToolTipText(this.exportButtonTip);
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int newOverwriteSelection;
                if (ReportXref.this.currentExportDir == "") {
                    ReportXref.this.currentExportDir = System.getProperty("user.home");
                }
                JFileChooser expChooser = new JFileChooser(ReportXref.this.currentExportDir);
                expChooser.setDialogTitle("Save Report to HTML File");
                expChooser.setMultiSelectionEnabled(false);
                expChooser.setFileSelectionMode(2);
                FileNameExtensionFilter filter = new FileNameExtensionFilter("HTML files", "htm", "html");
                expChooser.setFileFilter(filter);
                expChooser.setFileHidingEnabled(true);
                int expChoice = expChooser.showSaveDialog(ReportXref.this.ourGUI);
                if (expChoice != 0) {
                    return;
                }
                File saveFile = expChooser.getSelectedFile();
                ReportXref.this.currentExportDir = saveFile.getParent();
                if (saveFile.exists() && (newOverwriteSelection = JOptionPane.showConfirmDialog(ReportXref.this.ourGUI, ReportXref.this.newOverwriteDialog, "That File Already Exists - overwrite it?", 0, 3)) == 1) {
                    return;
                }
                try {
                    saveFile.createNewFile();
                    String path = saveFile.getAbsolutePath();
                    BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), StandardCharsets.UTF_8));
                    ReportXref.this.outBuffer = new BufferedWriter(outWriter);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(ReportXref.this.ourGUI, "Output File: IO Exception opening file for write" + ex.getMessage());
                    return;
                }
                try {
                    ReportXref.this.outBuffer.write(ReportXref.this.buffer);
                    ReportXref.this.outBuffer.flush();
                    ReportXref.this.outBuffer.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.closeButton.setToolTipText(this.closeButtonTip);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent close) {
                ReportXref.this.xrefFrame.dispose();
            }
        });
        Box overallPanel = Box.createVerticalBox();
        buttonPanel.add(this.exportButton);
        buttonPanel.add(this.printButton);
        buttonPanel.add(this.closeButton);
        overallPanel.add(xrefScrollPane);
        overallPanel.add(buttonPanel);
        this.add(overallPanel);
        this.setVisible(true);
        this.setSize(600, 600);
    }

    private void appendString(String str) {
        this.buffer = this.buffer + str + "\n";
    }
}

