/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CommonData;
import culturalDynamics.ConnectionData;
import culturalDynamics.EventData;
import culturalDynamics.Palette;
import culturalDynamics.PaletteColor;
import culturalDynamics.PaletteColorPanel;
import culturalDynamics.PaletteEditor;
import culturalDynamics.SegmentList;
import culturalDynamics.TimePanel;
import culturalDynamics.Typeface;
import culturalDynamics.cdGUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.math.RoundingMode;
import java.text.NumberFormat;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.InternationalFormatter;
import org.json.JSONWriter;

class Preferences
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public String defaultSegFG = "SegmentFG";
    public String defaultSegBGouterStart = "SegmentBGOuterStart";
    public String defaultSegBGouterEnd = "SegmentBGOuterEnd";
    public String defaultBGinner = "SegmentBGInner";
    private GraphicsEnvironment graphicsEnvironment = null;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private LineBorder contentBorder = new LineBorder(Color.lightGray, 3);
    private FlowLayout flowLayout = new FlowLayout(0);
    private JCheckBox savePrefsBox = new JCheckBox("Save Preferences", true);
    private boolean newSavePrefsChoice = true;
    private JLabel logLabel = new JLabel("File open/convert logging");
    private JRadioButton logAllButton = new JRadioButton("All");
    private JRadioButton logErrorsButton = new JRadioButton("Errors only");
    private JCheckBox logToConsoleBox = new JCheckBox("and to console");
    private ButtonGroup logGroup = new ButtonGroup();
    private boolean newLogAll;
    private boolean newLogToConsole;
    private JTextField iconsDirField = new JTextField(30);
    private String newIconsPath = "";
    private String[] fonts;
    private static final String[] fontSizes = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
    private String[] tfObjects = new String[]{"Timeline Names", "Timeline Segments", "Timeline Ages", "Event Names", "Untimed Event Names", "Connection Names", "Time Axis"};
    private static final int timelineNamesIdx = 0;
    private static final int timelineSegmentsIdx = 1;
    private static final int timelineAgesIdx = 2;
    private static final int eventNamesIdx = 3;
    private static final int untimedIdx = 4;
    private static final int connectionIdx = 5;
    private static final int timeAxisIdx = 6;
    private int tfCurrentObject = 0;
    private int tfNewObject = 0;
    private Typeface[] tfCurrentTypefaces = new Typeface[]{new Typeface("Serif", 12, true, false), new Typeface("SansSerif", 10, false, false), new Typeface("SansSerif", 10, false, false), new Typeface("Serif", 12, true, false), new Typeface("Serif", 14, true, false), new Typeface("Serif", 12, false, false), new Typeface("SansSerif", 12, true, true)};
    private Typeface[] tfNewTypefaces = new Typeface[7];
    private String tfSampleText = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\nabcdefghijklmnopqrstuvwxyz\n0123456789.";
    private JComboBox<String> generalFontObjectBox = new JComboBox<String>(this.tfObjects);
    private JComboBox<String> generalFontsBox = new JComboBox();
    private JComboBox<String> generalSizeBox = new JComboBox<String>(fontSizes);
    private JCheckBox generalBoldBox = new JCheckBox("Bold");
    private JCheckBox generalItalicBox = new JCheckBox("Italic");
    private JTextArea generalFontSample = new JTextArea(this.tfSampleText);
    private static final int defaultMargin = 50;
    private static final int defaultMarginInner = 2;
    private SpinnerModel spinnerModelMarginLeft = new SpinnerNumberModel(50, 0, 500, 1);
    private SpinnerModel spinnerModelMarginRight = new SpinnerNumberModel(50, 0, 500, 1);
    private SpinnerModel spinnerModelMarginTop = new SpinnerNumberModel(50, 0, 500, 1);
    private SpinnerModel spinnerModelMarginBottom = new SpinnerNumberModel(50, 0, 500, 1);
    private JSpinner spinnerMarginLeft = new JSpinner(this.spinnerModelMarginLeft);
    private JLabel marginLabelLeft = new JLabel("Left", 2);
    private int newMarginLeft = 50;
    private JSpinner spinnerMarginRight = new JSpinner(this.spinnerModelMarginRight);
    private JLabel marginLabelRight = new JLabel("Right", 2);
    private int newMarginRight = 50;
    private JSpinner spinnerMarginTop = new JSpinner(this.spinnerModelMarginTop);
    private JLabel marginLabelTop = new JLabel("Top", 2);
    private int newMarginTop = 50;
    private JSpinner spinnerMarginBottom = new JSpinner(this.spinnerModelMarginBottom);
    private JLabel marginLabelBottom = new JLabel("Bottom", 2);
    private int newMarginBottom = 50;
    private SpinnerModel spinnerModelMarginInner = new SpinnerNumberModel(2, 0, 50, 1);
    private JLabel textMarginInner = new JLabel("Textbox inner");
    private JSpinner spinnerTextMarginInner = new JSpinner(this.spinnerModelMarginInner);
    private int newMarginInner = 2;
    private JCheckBox showRowNosBox = new JCheckBox("Show Row Numbers", true);
    private JCheckBox optimiseRowsBox = new JCheckBox("Optimise Row Usage", true);
    private SpinnerModel spinnerRowMinXGapModel = new SpinnerNumberModel(1, 0, 365, 1);
    private JSpinner spinnerRowMinXGap = new JSpinner(this.spinnerRowMinXGapModel);
    private JLabel spinnerRowMinXGapLabel = new JLabel("Minimum X Gap");
    private SpinnerModel spinnerRowMinYGapModel = new SpinnerNumberModel(5, 0, 100, 1);
    private JSpinner spinnerRowMinYGap = new JSpinner(this.spinnerRowMinYGapModel);
    private JLabel spinnerRowMinYGapLabel = new JLabel("Minimum Y Gap");
    private boolean newShowRowNos = true;
    private boolean newOptimiseRows = true;
    private int newRowMinXGap = 1;
    private int newRowMinYGap = 5;
    private PaletteColorPanel paletteColorPanel;
    private Palette defaultPalette;
    private Palette newPalette = new Palette();
    private Palette oldPalette = new Palette();
    private static final int defaultLineThickness = 1;
    private SpinnerModel spinnerModelTlThickness = new SpinnerNumberModel(1, 1, 100, 1);
    private SpinnerModel spinnerModelEvThickness = new SpinnerNumberModel(1, 1, 100, 1);
    private JLabel tlThicknessLabel = new JLabel("Timeline line thickness:", 2);
    private JSpinner spinnerTlThickness = new JSpinner(this.spinnerModelTlThickness);
    private int newTlThickness = 1;
    private JCheckBox tlShowAgesBox = new JCheckBox("Show Ages on Timelines", true);
    private Boolean newTlShowAgesChoice = true;
    private JLabel evThicknessLabel = new JLabel("Event line thickness:", 2);
    private JSpinner spinnerEvThickness = new JSpinner(this.spinnerModelEvThickness);
    private int newEvThickness = 1;
    private JCheckBox stackEventsBox = new JCheckBox("Stack Timeline-Events", true);
    private boolean newStackEvents = true;
    private static final int defaultWaveAmplitude = 5;
    private static final int defaultWaveLength = 10;
    private static final int defaultHelixAmplitude = 5;
    private static final int defaultHelixPitch = 10;
    private static final double defaultBezCtrlX = 0.1;
    private static final double defaultBezCtrlY = 0.2;
    private static final int defaultDotMark = 1;
    private static final int defaultDotGap = 5;
    private static final int defaultDashMark = 10;
    private static final int defaultDashGap = 10;
    private static final int defaultDotDashMark1 = 1;
    private static final int defaultDotDashGap1 = 5;
    private static final int defaultDotDashMark2 = 10;
    private static final int defaultDotDashGap2 = 10;
    private SpinnerModel spinnerModelWaveAmp = new SpinnerNumberModel(5, 1, 100, 1);
    private SpinnerModel spinnerModelWaveLen = new SpinnerNumberModel(10, 2, 100, 2);
    private SpinnerModel spinnerModelHelixAmp = new SpinnerNumberModel(5, 1, 100, 1);
    private SpinnerModel spinnerModelHelixPitch = new SpinnerNumberModel(10, 1, 100, 1);
    private JLabel waveAmpLabel = new JLabel("Amplitude:", 2);
    private JSpinner spinnerWaveAmp = new JSpinner(this.spinnerModelWaveAmp);
    private JLabel waveLengthLabel = new JLabel("Wavelength:", 2);
    private JSpinner spinnerWaveLength = new JSpinner(this.spinnerModelWaveLen);
    private JLabel helixAmpLabel = new JLabel("Amplitude:", 2);
    private JSpinner spinnerHelixAmp = new JSpinner(this.spinnerModelHelixAmp);
    private JLabel helixLengthLabel = new JLabel("Helix Pitch:", 2);
    private JSpinner spinnerHelixPitch = new JSpinner(this.spinnerModelHelixPitch);
    private SpinnerModel spinnerModelDotMark = new SpinnerNumberModel(1, 1, 100, 1);
    private SpinnerModel spinnerModelDotGap = new SpinnerNumberModel(5, 1, 100, 1);
    private SpinnerModel spinnerModelDashMark = new SpinnerNumberModel(10, 1, 100, 1);
    private SpinnerModel spinnerModelDashGap = new SpinnerNumberModel(10, 1, 100, 1);
    private SpinnerModel spinnerModelDotDashMark1 = new SpinnerNumberModel(1, 1, 100, 1);
    private SpinnerModel spinnerModelDotDashGap1 = new SpinnerNumberModel(5, 1, 100, 1);
    private SpinnerModel spinnerModelDotDashMark2 = new SpinnerNumberModel(10, 1, 100, 1);
    private SpinnerModel spinnerModelDotDashGap2 = new SpinnerNumberModel(10, 1, 100, 1);
    private JLabel markLabel1 = new JLabel("Mark", 0);
    private JLabel gapLabel1 = new JLabel("Gap", 0);
    private JLabel markLabel2 = new JLabel("Mark", 0);
    private JLabel gapLabel2 = new JLabel("Gap", 0);
    private JLabel dotLabel = new JLabel("Dot:", 4);
    private JLabel dashLabel = new JLabel("Dash:", 4);
    private JLabel dotDashLabel = new JLabel("Dot-Dash:", 4);
    private JSpinner spinnerDotMark = new JSpinner(this.spinnerModelDotMark);
    private JSpinner spinnerDotGap = new JSpinner(this.spinnerModelDotGap);
    private JSpinner spinnerDashMark = new JSpinner(this.spinnerModelDashMark);
    private JSpinner spinnerDashGap = new JSpinner(this.spinnerModelDashGap);
    private JSpinner spinnerDotDashMark1 = new JSpinner(this.spinnerModelDotDashMark1);
    private JSpinner spinnerDotDashGap1 = new JSpinner(this.spinnerModelDotDashGap1);
    private JSpinner spinnerDotDashMark2 = new JSpinner(this.spinnerModelDotDashMark2);
    private JSpinner spinnerDotDashGap2 = new JSpinner(this.spinnerModelDotDashGap2);
    private int newDotMark = 1;
    private int newDotGap = 5;
    private int newDashMark = 10;
    private int newDashGap = 10;
    private int newDotDashMark1 = 1;
    private int newDotDashGap1 = 5;
    private int newDotDashMark2 = 10;
    private int newDotDashGap2 = 10;
    private static final int defaultArrowLength = 10;
    private static final int defaultArrowTail = 5;
    private static final int defaultArrowWidth = 3;
    private SpinnerModel spinnerModelArrowLength = new SpinnerNumberModel(10, 1, 50, 1);
    private SpinnerModel spinnerModelArrowTail = new SpinnerNumberModel(5, 1, 50, 1);
    private SpinnerModel spinnerModelArrowHWidth = new SpinnerNumberModel(3, 1, 50, 1);
    private JLabel arrowLengthLabel = new JLabel("Arrow Length");
    private JSpinner spinnerArrowLength = new JSpinner(this.spinnerModelArrowLength);
    private JLabel arrowTailLabel = new JLabel("Arrow Tail Length");
    private JSpinner spinnerArrowTail = new JSpinner(this.spinnerModelArrowTail);
    private JLabel arrowWidthLabel = new JLabel("Half Arrow Width");
    private JSpinner spinnerArrowWidth = new JSpinner(this.spinnerModelArrowHWidth);
    private int newArrowLength = 10;
    private int newArrowTail = 5;
    private int newArrowWidth = 3;
    private JCheckBox bezCheckBox = new JCheckBox("Curved Lines");
    private JLabel bezCtrlXLabel = new JLabel("B\u00e9zier Control Point X:", 2);
    private JLabel bezCtrlYLabel = new JLabel("B\u00e9zier Control Point Y:", 2);
    private JFormattedTextField bezCtrlXField = new JFormattedTextField();
    private JFormattedTextField bezCtrlYField = new JFormattedTextField();
    private int newWaveAmplitude = 5;
    private int newWaveLength = 10;
    private int newHelixAmplitude = 5;
    private int newHelixPitch = 10;
    private boolean newBezCurveChoice = false;
    private double newBezCtrlX = 0.1;
    private double newBezCtrlY = 0.2;
    private JCheckBox rptSummaryIntro = new JCheckBox("Introduction");
    private JCheckBox rptSummaryDescription = new JCheckBox("Description");
    private JCheckBox rptSummaryUntimed = new JCheckBox("Untimed Events");
    private JCheckBox rptSummaryLinks = new JCheckBox("Links");
    private JCheckBox rptSummaryTags = new JCheckBox("Tags");
    private JCheckBox rptSummaryIcons = new JCheckBox("Icons");
    private JCheckBox rptSummaryTlEventList = new JCheckBox("Timeline Event List");
    private JCheckBox rptSummaryConnections = new JCheckBox("Connections");
    private JCheckBox rptSummaryStats = new JCheckBox("Statistics");
    private JCheckBox rptSummaryOmitEmpty = new JCheckBox("Omit Empty Titles");
    private JCheckBox rptSummaryFilter = new JCheckBox("Apply Filter");
    private JCheckBox rptXrefColours = new JCheckBox("Colours");
    private JCheckBox rptXrefIcons = new JCheckBox("Icons");
    private JCheckBox rptMissingDescription = new JCheckBox("Description");
    private JCheckBox rptMissingLinks = new JCheckBox("Links");
    private JLabel rptMissingCnNameLabel = new JLabel("Connection Name");
    private JCheckBox rptMissingCnName = new JCheckBox("Name");
    private JCheckBox rptMissingTags = new JCheckBox("Tags");
    private SpinnerModel spinnerModelMissingCnTags = new SpinnerNumberModel(0, 0, 10, 1);
    private JSpinner rptMissingCnTagsSpinner = new JSpinner(this.spinnerModelMissingCnTags);
    private JLabel rptMissingCnTagsLabel = new JLabel("Tags <");
    private JCheckBox rptMissingStats = new JCheckBox("Statistics");
    private boolean newSummaryIntro;
    private boolean newSummaryDescription;
    private boolean newSummaryUntimed;
    private boolean newSummaryLinks;
    private boolean newSummaryTags;
    private boolean newSummaryIcons;
    private boolean newSummaryTlEventList;
    private boolean newSummaryConnections;
    private boolean newSummaryStats;
    private boolean newSummaryOmitEmpty;
    private boolean newSummaryFilter;
    private boolean newXrefColours;
    private boolean newXrefIcons;
    private boolean newMissingDescription;
    private boolean newMissingLinks;
    private boolean newMissingTags;
    private boolean newMissingCnName;
    private int newMissingCnTags;
    private boolean newMissingStats;
    private JButton buttonOK = new JButton("OK");
    private JButton buttonApply = new JButton("Apply");
    private JButton buttonCancel = new JButton("Cancel");
    private JFrame prefsFrame = this;
    private cdGUI ourGUI;

    Preferences(cdGUI mainGUI) {
        this.ourGUI = mainGUI;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                Preferences.this.setFieldsFromCurrent();
            }

            @Override
            public void windowActivated(WindowEvent wa) {
                Preferences.this.prefsFrame.revalidate();
            }
        });
        this.graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.fonts = this.graphicsEnvironment.getAvailableFontFamilyNames();
        this.generalFontsBox.setModel(new DefaultComboBoxModel<String>(this.fonts));
        JLabel fontsLabel = new JLabel("Font:");
        JLabel styleLabel = new JLabel("Style:");
        JLabel sizeLabel = new JLabel("Size:");
        this.generalFontObjectBox.setActionCommand("ObjectBox");
        this.generalFontsBox.setActionCommand("FontsBox");
        this.generalSizeBox.setActionCommand("SizeBox");
        this.generalBoldBox.setActionCommand("BoldBox");
        this.generalItalicBox.setActionCommand("ItalicBox");
        if (this.tfNewTypefaces[0] == null) {
            System.arraycopy(this.tfCurrentTypefaces, 0, this.tfNewTypefaces, 0, this.tfNewTypefaces.length);
            int i = 0;
            while (i < this.tfNewTypefaces.length) {
                FontMetrics metrics = this.getFontMetrics(this.tfNewTypefaces[i].getTypefaceAsFont());
                this.tfNewTypefaces[i].setMetrics(metrics);
                ++i;
            }
        }
        JPanel savePrefsPanel = new JPanel(this.flowLayout);
        this.savePrefsBox.setToolTipText("Save preferences in the output file.");
        savePrefsPanel.add(this.savePrefsBox);
        this.logLabel.setToolTipText("Select whether to log all input lines or just the errors");
        this.logAllButton.setToolTipText("Log all input lines and errors in a log window");
        this.logErrorsButton.setToolTipText("Only log errors in a log window");
        this.logGroup.add(this.logAllButton);
        this.logGroup.add(this.logErrorsButton);
        this.logErrorsButton.setSelected(true);
        this.logToConsoleBox.setToolTipText("Check this box to additionally write error logging to the java console.");
        this.logToConsoleBox.setSelected(false);
        JPanel logPanel = new JPanel(this.flowLayout);
        logPanel.add(this.logLabel);
        logPanel.add(this.logAllButton);
        logPanel.add(this.logErrorsButton);
        logPanel.add(this.logToConsoleBox);
        JPanel iconsPanel = new JPanel();
        iconsPanel.setLayout(this.flowLayout);
        String iconsTip = "Browse to preset the icons folder or edit it in the field.";
        JLabel iconsDirLabel = new JLabel("Icons Folder");
        this.iconsDirField.setToolTipText(iconsTip);
        iconsDirLabel.setToolTipText(iconsTip);
        JButton iconsBrowseButton = new JButton("Browse");
        iconsBrowseButton.setToolTipText(iconsTip);
        iconsBrowseButton.setPreferredSize(new Dimension(100, 20));
        iconsBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File tmp;
                    Object iconBrowsePath = Preferences.this.iconsDirField.getText();
                    if (((String)iconBrowsePath).equals("") && !(tmp = new File((String)(iconBrowsePath = System.getProperty("user.home") + File.separator + "icons"))).exists()) {
                        iconBrowsePath = System.getProperty("user.home");
                    }
                    JFileChooser iconDirChooser = new JFileChooser((String)iconBrowsePath);
                    iconDirChooser.setDialogTitle("Folder with Icons");
                    iconDirChooser.setApproveButtonText("Select");
                    iconDirChooser.setFileSelectionMode(1);
                    int iconDirChoice = iconDirChooser.showOpenDialog(Preferences.this.prefsFrame);
                    if (iconDirChoice == 0) {
                        File chosenFile = iconDirChooser.getSelectedFile();
                        Preferences.this.newIconsPath = chosenFile.getAbsolutePath();
                        Preferences.this.iconsDirField.setText(Preferences.this.newIconsPath);
                    }
                }
                catch (Throwable unforeseen) {
                    JOptionPane.showMessageDialog(Preferences.this.ourGUI, "Preferences: Unhandled Error!\n" + Preferences.this.ourGUI.displayError(unforeseen));
                }
            }
        });
        iconsPanel.add(iconsDirLabel);
        iconsPanel.add(this.iconsDirField);
        iconsPanel.add(iconsBrowseButton);
        Box filesPanel = Box.createVerticalBox();
        TitledBorder filesTitle = new TitledBorder(this.contentBorder, "Files", 1, 2);
        filesPanel.setBorder(filesTitle);
        filesPanel.add(savePrefsPanel);
        filesPanel.add(logPanel);
        filesPanel.add(iconsPanel);
        Box fontsPanel = Box.createVerticalBox();
        TitledBorder fontsTitle = new TitledBorder(this.contentBorder, "Fonts", 1, 2);
        fontsPanel.setBorder(fontsTitle);
        JPanel generalObjectPanel = new JPanel();
        JLabel generalObjectLabel = new JLabel("Select font for:");
        generalObjectLabel.setToolTipText("Select the graphic item on which the fields below will act");
        this.generalFontObjectBox.setToolTipText("Select the graphic item on which the fields below will act");
        generalObjectPanel.add(generalObjectLabel);
        generalObjectPanel.add(this.generalFontObjectBox);
        JPanel generalFontPanel = new JPanel();
        this.generalFontSample.setFont(this.tfCurrentTypefaces[0].getTypefaceAsFont());
        this.generalFontSample.setAlignmentX(0.5f);
        generalFontPanel.add(fontsLabel);
        generalFontPanel.add(this.generalFontsBox);
        generalFontPanel.add(sizeLabel);
        generalFontPanel.add(this.generalSizeBox);
        generalFontPanel.add(styleLabel);
        generalFontPanel.add(this.generalBoldBox);
        generalFontPanel.add(this.generalItalicBox);
        this.generalFontsBox.setToolTipText("Select the font for the above graphic item");
        this.generalSizeBox.setToolTipText("Select the size for the above graphic item");
        this.generalBoldBox.setToolTipText("Tick to make the above graphic item bold");
        this.generalItalicBox.setToolTipText("Tick to make the above graphic item italic");
        String tmpFont = this.tfCurrentTypefaces[0].getFontAsString();
        int tmpFontIdx = this.getIndexOfString(this.fonts, tmpFont);
        this.generalFontsBox.setSelectedIndex(tmpFontIdx);
        int tmpSize = this.tfCurrentTypefaces[0].getSize();
        int tmpSizeIdx = this.getIndexOfSize(fontSizes, tmpSize);
        this.generalSizeBox.setSelectedIndex(tmpSizeIdx);
        this.generalBoldBox.setSelected(this.tfCurrentTypefaces[0].isBold());
        this.generalItalicBox.setSelected(this.tfCurrentTypefaces[0].isItalic());
        this.generalFontObjectBox.addActionListener(this);
        this.generalFontsBox.addActionListener(this);
        this.generalSizeBox.addActionListener(this);
        this.generalBoldBox.addActionListener(this);
        this.generalItalicBox.addActionListener(this);
        fontsPanel.add(generalObjectPanel);
        fontsPanel.add(generalFontPanel);
        fontsPanel.add(this.generalFontSample);
        JPanel marginPanel = new JPanel(this.flowLayout);
        TitledBorder marginBorder = new TitledBorder(this.contentBorder, "Margins", 1, 2);
        marginPanel.setBorder(marginBorder);
        marginPanel.add(this.marginLabelLeft);
        marginPanel.add(this.spinnerMarginLeft);
        marginPanel.add(this.marginLabelRight);
        marginPanel.add(this.spinnerMarginRight);
        marginPanel.add(this.marginLabelTop);
        marginPanel.add(this.spinnerMarginTop);
        marginPanel.add(this.marginLabelBottom);
        marginPanel.add(this.spinnerMarginBottom);
        marginPanel.add(this.textMarginInner);
        marginPanel.add(this.spinnerTextMarginInner);
        this.spinnerMarginLeft.setToolTipText("Set the left margin in pixels");
        this.spinnerMarginRight.setToolTipText("Set the right margin in pixels");
        this.spinnerMarginTop.setToolTipText("Set the top margins in pixels");
        this.spinnerMarginBottom.setToolTipText("Set the bottom margin in pixels");
        this.spinnerTextMarginInner.setToolTipText("Set the inner margin of text boxes in pixels - Untimed Events and Connection Names");
        JPanel rowPanel = new JPanel(this.flowLayout);
        TitledBorder rowBorder = new TitledBorder(this.contentBorder, "Rows", 1, 2);
        rowPanel.setBorder(rowBorder);
        this.showRowNosBox.setToolTipText("Show row numbers in the left margin");
        this.optimiseRowsBox.setToolTipText("Place new timelines and events in the first row where they will fit");
        this.spinnerRowMinXGap.setToolTipText("Minimum number of days between entries in the same row");
        this.spinnerRowMinXGapLabel.setToolTipText(this.spinnerRowMinXGap.getToolTipText());
        this.spinnerRowMinYGap.setToolTipText("Minimum number of vertical pixels between rows");
        this.spinnerRowMinYGapLabel.setToolTipText(this.spinnerRowMinYGap.getToolTipText());
        rowPanel.add(this.showRowNosBox);
        rowPanel.add(this.optimiseRowsBox);
        rowPanel.add(this.spinnerRowMinXGapLabel);
        rowPanel.add(this.spinnerRowMinXGap);
        rowPanel.add(this.spinnerRowMinYGapLabel);
        rowPanel.add(this.spinnerRowMinYGap);
        Box graphicsPanel = Box.createVerticalBox();
        graphicsPanel.add(fontsPanel);
        graphicsPanel.add(marginPanel);
        graphicsPanel.add(rowPanel);
        this.initDefaultPalette();
        this.resetPalette();
        this.oldPalette = this.newPalette.copyPalette();
        this.paletteColorPanel = new PaletteColorPanel(this.newPalette, null);
        this.paletteColorPanel.addTableListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    Preferences.this.editActions();
                }
            }
        });
        Box palettePanel = Box.createVerticalBox();
        JButton buttonPaletteNew = new JButton("New");
        buttonPaletteNew.setToolTipText("Add a new color to the palette");
        buttonPaletteNew.setPreferredSize(new Dimension(100, 20));
        buttonPaletteNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaletteEditor editor = new PaletteEditor(Preferences.this.ourGUI, Preferences.this.newPalette, null, null, true);
                if (editor.getResult().equals("OK")) {
                    Color newColor = editor.getResultColor();
                    String newName = editor.getResultName();
                    if (newColor.equals(Preferences.this.ourGUI.getTimePanel().getGraphicBackground())) {
                        JOptionPane.showMessageDialog(Preferences.this.prefsFrame, "Preferences color " + newName + " is the same as the graphics background, so will not be visible.");
                    }
                    if (newColor.equals(Preferences.this.ourGUI.getTimePanel().getExportBackground())) {
                        JOptionPane.showMessageDialog(Preferences.this.prefsFrame, "Preferences color " + newName + " is the same as the export background, so will not be visible.");
                    }
                    PaletteColor newPC = new PaletteColor(newName, newColor);
                    Preferences.this.newPalette.addColorToPalette(newPC);
                    Preferences.this.newPalette.sortPalette();
                    Preferences.this.paletteColorPanel.updatePaletteTable(Preferences.this.newPalette, true, newName);
                }
            }
        });
        JButton buttonPaletteEdit = new JButton("Edit");
        buttonPaletteEdit.setToolTipText("Edit the selected color");
        buttonPaletteEdit.setPreferredSize(new Dimension(100, 20));
        buttonPaletteEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.editActions();
            }
        });
        JButton buttonPaletteDelete = new JButton("Delete");
        buttonPaletteDelete.setToolTipText("Delete this color from the palette");
        buttonPaletteDelete.setPreferredSize(new Dimension(100, 20));
        buttonPaletteDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object inUseText = "";
                String deletingColor = Preferences.this.paletteColorPanel.getSelectedColorName();
                if (Preferences.this.newPalette.getSize() == 1) {
                    JOptionPane.showMessageDialog(Preferences.this.prefsFrame, "You cannot delete the last colour");
                    return;
                }
                EventData ourEventData = Preferences.this.ourGUI.getInput().getEventData();
                int i = 0;
                while (i < ourEventData.getTotalNumberOfEvents()) {
                    if (ourEventData.getEventByIndex(i).getColor().equals(deletingColor)) {
                        inUseText = (String)inUseText + "Event " + ourEventData.getEventByIndex(i).getName() + "\n";
                    }
                    if (ourEventData.getEventByIndex(i).getEventType().equals((Object)CommonData.EventType.TIMELINE) && ourEventData.getEventByIndex(i).getTlSegmentList() != null) {
                        SegmentList ourSegmentList = ourEventData.getEventByIndex(i).getTlSegmentList();
                        int j = 0;
                        while (j < ourSegmentList.getNumberOfSegments()) {
                            if (ourSegmentList.getASegment(j).getColorFG().equals(deletingColor)) {
                                inUseText = (String)inUseText + "Segment foreground " + ourSegmentList.getASegment(j).getText() + " of timeline " + ourEventData.getEventByIndex(i).getName() + "\n";
                            }
                            if (ourSegmentList.getASegment(j).getColorOuterStart().equals(deletingColor)) {
                                inUseText = (String)inUseText + "Segment outer background start " + ourSegmentList.getASegment(j).getText() + " of timeline " + ourEventData.getEventByIndex(i).getName() + "\n";
                            }
                            if (ourSegmentList.getASegment(j).getColorOuterEnd().equals(deletingColor)) {
                                inUseText = (String)inUseText + "Segment outer background end " + ourSegmentList.getASegment(j).getText() + " of timeline " + ourEventData.getEventByIndex(i).getName() + "\n";
                            }
                            if (ourSegmentList.getASegment(j).getColorInner().equals(deletingColor)) {
                                inUseText = (String)inUseText + "Segment inner background " + ourSegmentList.getASegment(j).getText() + " of timeline " + ourEventData.getEventByIndex(i).getName() + "\n";
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                ConnectionData ourConnections = Preferences.this.ourGUI.getInput().getConnections();
                int i2 = 0;
                while (i2 < ourConnections.getNumberOfConnections()) {
                    if (ourConnections.getConnection(i2).getColor().equals(deletingColor)) {
                        inUseText = (String)inUseText + "Connection " + ourConnections.getConnection(i2).getName() + "\n";
                    }
                    ++i2;
                }
                if (!((String)inUseText).equals("")) {
                    inUseText = "The colour is in use in the following items. Either change their colours or delete them before deleting the colour from the palette.\n" + (String)inUseText;
                    JOptionPane.showMessageDialog(Preferences.this.prefsFrame, inUseText);
                } else {
                    Preferences.this.newPalette.deleteColorByIndex(Preferences.this.paletteColorPanel.getSelectedColorIndex());
                    Preferences.this.newPalette.sortPalette();
                    Preferences.this.paletteColorPanel.updatePaletteTable(Preferences.this.newPalette, true, "");
                }
            }
        });
        JPanel paletteButtonsPanel = new JPanel();
        paletteButtonsPanel.add(buttonPaletteNew);
        paletteButtonsPanel.add(buttonPaletteEdit);
        paletteButtonsPanel.add(buttonPaletteDelete);
        palettePanel.add(this.paletteColorPanel);
        palettePanel.add(paletteButtonsPanel);
        Box eventsPanel = Box.createVerticalBox();
        TitledBorder eventTitle = new TitledBorder(this.contentBorder, "Events", 1, 2);
        eventsPanel.setBorder(eventTitle);
        String tlThicknessTip = "Set the thickness of the timeline in pixels.";
        this.tlThicknessLabel.setToolTipText(tlThicknessTip);
        this.spinnerTlThickness.setToolTipText(tlThicknessTip);
        JPanel tlPanel = new JPanel();
        tlPanel.setLayout(this.flowLayout);
        tlPanel.add(this.tlThicknessLabel);
        tlPanel.add(this.spinnerTlThickness);
        tlPanel.add(this.tlShowAgesBox);
        String evThicknessTip = "Set the thickness of the line between event and timeline in pixels.";
        this.evThicknessLabel.setToolTipText(evThicknessTip);
        this.spinnerEvThickness.setToolTipText(evThicknessTip);
        JPanel evPanel = new JPanel();
        evPanel.setLayout(this.flowLayout);
        evPanel.add(this.evThicknessLabel);
        evPanel.add(this.spinnerEvThickness);
        this.stackEventsBox.setToolTipText("Stack timeline-events to avoid their names overlapping");
        evPanel.add(this.stackEventsBox);
        eventsPanel.add(tlPanel);
        eventsPanel.add(evPanel);
        Box connectionsPanel = Box.createVerticalBox();
        this.spinnerWaveAmp.setToolTipText("Amplitude in pixels of the wave connection");
        this.spinnerWaveLength.setToolTipText("Wavelength in pixels of the wave connection");
        JPanel wavePanel = new JPanel();
        TitledBorder waveTitle = new TitledBorder(this.contentBorder, "Wave Parameters", 1, 2);
        wavePanel.setBorder(waveTitle);
        wavePanel.setLayout(this.flowLayout);
        wavePanel.add(this.waveAmpLabel);
        wavePanel.add(this.spinnerWaveAmp);
        wavePanel.add(this.waveLengthLabel);
        wavePanel.add(this.spinnerWaveLength);
        this.spinnerHelixAmp.setToolTipText("Amplitude in pixels of the helix connection");
        this.spinnerHelixPitch.setToolTipText("Pitch in pixels of the helix connection");
        JPanel helixPanel = new JPanel();
        TitledBorder helixTitle = new TitledBorder(this.contentBorder, "Helix Parameters", 1, 2);
        helixPanel.setBorder(helixTitle);
        helixPanel.setLayout(this.flowLayout);
        helixPanel.add(this.helixAmpLabel);
        helixPanel.add(this.spinnerHelixAmp);
        helixPanel.add(this.helixLengthLabel);
        helixPanel.add(this.spinnerHelixPitch);
        Box waveHelixPanel = Box.createHorizontalBox();
        waveHelixPanel.add(wavePanel);
        waveHelixPanel.add(helixPanel);
        this.spinnerDotMark.setToolTipText("Set the length of the mark for dotted lines");
        this.spinnerDotGap.setToolTipText("Set the length of the gap between dots for dotted lines");
        this.spinnerDashMark.setToolTipText("Set the length of the mark for dashed lines");
        this.spinnerDashGap.setToolTipText("Set the length of the gap between dashed for dashed lines");
        this.spinnerDotDashMark1.setToolTipText("Set the length of the dash mark for dot-dashed lines");
        this.spinnerDotDashGap1.setToolTipText("Set the length of the gap after dashes for dot-dashed lines");
        this.spinnerDotDashMark2.setToolTipText("Set the length of the dot mark for dot-dashed lines");
        this.spinnerDotDashGap2.setToolTipText("Set the length of the gap after dots for dot-dashed lines");
        JPanel dotDashPanel = new JPanel(new GridLayout(4, 5, 3, 1));
        TitledBorder dotDashTitle = new TitledBorder(this.contentBorder, "Dot-Dash Parameters", 1, 2);
        dotDashPanel.setBorder(dotDashTitle);
        dotDashPanel.add(new JLabel(""));
        dotDashPanel.add(this.markLabel1);
        dotDashPanel.add(this.gapLabel1);
        dotDashPanel.add(this.markLabel2);
        dotDashPanel.add(this.gapLabel2);
        dotDashPanel.add(this.dotLabel);
        dotDashPanel.add(this.spinnerDotMark);
        dotDashPanel.add(this.spinnerDotGap);
        dotDashPanel.add(new JLabel(""));
        dotDashPanel.add(new JLabel(""));
        dotDashPanel.add(this.dashLabel);
        dotDashPanel.add(this.spinnerDashMark);
        dotDashPanel.add(this.spinnerDashGap);
        dotDashPanel.add(new JLabel(""));
        dotDashPanel.add(new JLabel(""));
        dotDashPanel.add(this.dotDashLabel);
        dotDashPanel.add(this.spinnerDotDashMark1);
        dotDashPanel.add(this.spinnerDotDashGap1);
        dotDashPanel.add(this.spinnerDotDashMark2);
        dotDashPanel.add(this.spinnerDotDashGap2);
        this.spinnerArrowLength.setToolTipText("Length of arrows (excluding the tail)");
        this.spinnerArrowTail.setToolTipText("Length of arrow tail");
        this.spinnerArrowWidth.setToolTipText("Half the width of arrow");
        JPanel lineEndPanel = new JPanel();
        TitledBorder arrowTitle = new TitledBorder(this.contentBorder, "Arrow Parameters", 1, 2);
        lineEndPanel.setBorder(arrowTitle);
        lineEndPanel.setLayout(this.flowLayout);
        lineEndPanel.add(this.arrowLengthLabel);
        lineEndPanel.add(this.spinnerArrowLength);
        lineEndPanel.add(this.arrowTailLabel);
        lineEndPanel.add(this.spinnerArrowTail);
        lineEndPanel.add(this.arrowWidthLabel);
        lineEndPanel.add(this.spinnerArrowWidth);
        this.bezCheckBox.setSelected(false);
        this.bezCtrlXField.setEnabled(false);
        this.bezCtrlYField.setEnabled(false);
        this.bezCheckBox.setToolTipText("Preset curved lines in new connections");
        this.bezCtrlXField.setToolTipText("Preset X control point in new connections");
        this.bezCtrlYField.setToolTipText("Preset Y control point in new connections");
        this.bezCtrlXField.setColumns(10);
        this.bezCtrlYField.setColumns(10);
        this.bezCtrlXField.setValue(0.1);
        this.bezCtrlYField.setValue(0.2);
        JPanel bezierPanel = new JPanel();
        TitledBorder bezierTitle = new TitledBorder(this.contentBorder, "B\u00e9zier Curve Presets for New Connections", 1, 2);
        bezierPanel.setBorder(bezierTitle);
        bezierPanel.setLayout(this.flowLayout);
        bezierPanel.add(this.bezCheckBox);
        bezierPanel.add(this.bezCtrlXLabel);
        bezierPanel.add(this.bezCtrlXField);
        bezierPanel.add(this.bezCtrlYLabel);
        bezierPanel.add(this.bezCtrlYField);
        this.bezCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Preferences.this.curveBoxLogic();
            }
        });
        this.bezCtrlXField.setFormatterFactory(new JFormattedTextField.AbstractFormatterFactory(){

            @Override
            public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
                NumberFormat format = NumberFormat.getInstance();
                format.setMinimumFractionDigits(2);
                format.setMaximumFractionDigits(2);
                format.setRoundingMode(RoundingMode.HALF_UP);
                InternationalFormatter formatter = new InternationalFormatter(format);
                formatter.setAllowsInvalid(false);
                formatter.setMinimum(Double.valueOf(0.0));
                formatter.setMaximum(Double.valueOf(1000.0));
                return formatter;
            }
        });
        this.bezCtrlYField.setFormatterFactory(new JFormattedTextField.AbstractFormatterFactory(){

            @Override
            public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
                NumberFormat format = NumberFormat.getInstance();
                format.setMinimumFractionDigits(2);
                format.setMaximumFractionDigits(2);
                format.setRoundingMode(RoundingMode.HALF_UP);
                InternationalFormatter formatter = new InternationalFormatter(format);
                formatter.setAllowsInvalid(false);
                formatter.setMinimum(Double.valueOf(0.0));
                formatter.setMaximum(Double.valueOf(1000.0));
                return formatter;
            }
        });
        connectionsPanel.add(waveHelixPanel);
        connectionsPanel.add(dotDashPanel);
        connectionsPanel.add(lineEndPanel);
        connectionsPanel.add(bezierPanel);
        this.rptSummaryIntro.setToolTipText("Include Introduction in Summary Report");
        this.rptSummaryDescription.setToolTipText("Include Descriptions in Summary Report");
        this.rptSummaryUntimed.setToolTipText("Include Untimed Events in Summary Report");
        this.rptSummaryLinks.setToolTipText("Include Links in Summary Report");
        this.rptSummaryTags.setToolTipText("Include Tags in Summary Report");
        this.rptSummaryIcons.setToolTipText("Include Icons in Summary Report");
        this.rptSummaryTlEventList.setToolTipText("Include list of Timeline-Events in Timelines in Summary Report");
        this.rptSummaryConnections.setToolTipText("Include Connections in Summary Report");
        this.rptSummaryStats.setToolTipText("Include statistics at end of Summar Report");
        this.rptSummaryOmitEmpty.setToolTipText("Omit titles of empty fields in Summary Report");
        this.rptSummaryFilter.setToolTipText("Apply the current filter to the Summary Report data");
        this.rptXrefColours.setToolTipText("Include colours in the cross-reference report");
        this.rptXrefIcons.setToolTipText("Include icons in the cross-reference report");
        this.rptMissingDescription.setToolTipText("Include Descriptions in Missing MetaData Report");
        this.rptMissingLinks.setToolTipText("Include Links in Missing MetaData Report");
        this.rptMissingTags.setToolTipText("Include Tags in Missing MetaData Report");
        String missingCnNameTip = "Include connection Names in Missing MetaData Report";
        this.rptMissingCnNameLabel.setToolTipText(missingCnNameTip);
        this.rptMissingCnName.setToolTipText(missingCnNameTip);
        String missingCnTagsTip = "Include connections with less than this number of tags in Missing MetaData Report";
        this.rptMissingCnTagsLabel.setToolTipText(missingCnTagsTip);
        this.rptMissingCnTagsSpinner.setToolTipText(missingCnTagsTip);
        this.rptMissingStats.setToolTipText("Include statistics at end of Missing MetaData Report");
        this.rptSummaryIntro.setSelected(true);
        this.rptSummaryDescription.setSelected(true);
        this.rptSummaryUntimed.setSelected(true);
        this.rptSummaryLinks.setSelected(true);
        this.rptSummaryTags.setSelected(true);
        this.rptSummaryIcons.setSelected(true);
        this.rptSummaryTlEventList.setSelected(true);
        this.rptSummaryConnections.setSelected(true);
        this.rptSummaryStats.setSelected(true);
        this.rptSummaryOmitEmpty.setSelected(true);
        this.rptSummaryFilter.setSelected(false);
        this.rptXrefColours.setSelected(true);
        this.rptXrefIcons.setSelected(true);
        this.rptMissingDescription.setSelected(true);
        this.rptMissingLinks.setSelected(true);
        this.rptMissingCnName.setSelected(false);
        this.rptMissingTags.setSelected(true);
        this.rptMissingCnTagsSpinner.setValue(1);
        this.rptMissingStats.setSelected(true);
        this.rptMissingTags.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (Preferences.this.rptMissingTags.isSelected()) {
                    Preferences.this.rptMissingCnTagsSpinner.setEnabled(true);
                } else {
                    Preferences.this.rptMissingCnTagsSpinner.setEnabled(false);
                }
            }
        });
        JPanel summaryPanel1 = new JPanel(this.flowLayout);
        summaryPanel1.add(this.rptSummaryIntro);
        summaryPanel1.add(this.rptSummaryDescription);
        summaryPanel1.add(this.rptSummaryUntimed);
        summaryPanel1.add(this.rptSummaryLinks);
        summaryPanel1.add(this.rptSummaryTags);
        summaryPanel1.add(this.rptSummaryIcons);
        summaryPanel1.add(this.rptSummaryTlEventList);
        summaryPanel1.add(this.rptSummaryConnections);
        JPanel summaryPanel2 = new JPanel(this.flowLayout);
        summaryPanel2.add(this.rptSummaryStats);
        summaryPanel2.add(this.rptSummaryOmitEmpty);
        summaryPanel2.add(this.rptSummaryFilter);
        JPanel summaryPanel = new JPanel(new GridLayout(2, 1));
        TitledBorder summaryTitle = new TitledBorder(this.contentBorder, "Summary Report Content", 1, 2);
        summaryPanel.setBorder(summaryTitle);
        summaryPanel.add(summaryPanel1);
        summaryPanel.add(summaryPanel2);
        JPanel xRefPanel = new JPanel(this.flowLayout);
        TitledBorder xRefTitle = new TitledBorder(this.contentBorder, "Cross-Reference Report Content", 1, 2);
        xRefPanel.setBorder(xRefTitle);
        xRefPanel.add(this.rptXrefColours);
        xRefPanel.add(this.rptXrefIcons);
        JPanel missingPanel = new JPanel(this.flowLayout);
        TitledBorder missingTitle = new TitledBorder(this.contentBorder, "Missing Data Report Content", 1, 2);
        missingPanel.setBorder(missingTitle);
        missingPanel.add(this.rptMissingDescription);
        missingPanel.add(this.rptMissingLinks);
        missingPanel.add(this.rptMissingTags);
        missingPanel.add(this.rptMissingCnNameLabel);
        missingPanel.add(this.rptMissingCnName);
        missingPanel.add(this.rptMissingCnTagsLabel);
        missingPanel.add(this.rptMissingCnTagsSpinner);
        missingPanel.add(this.rptMissingStats);
        Box reportsPanel = Box.createVerticalBox();
        reportsPanel.add(summaryPanel);
        reportsPanel.add(xRefPanel);
        reportsPanel.add(missingPanel);
        this.buttonOK.setActionCommand("OKButton");
        this.buttonOK.setToolTipText("Apply the preferences and close window");
        this.buttonOK.setPreferredSize(new Dimension(100, 20));
        this.buttonCancel.setActionCommand("CancelButton");
        this.buttonCancel.setToolTipText("Cancel all changes in all tabs");
        this.buttonCancel.setPreferredSize(new Dimension(100, 20));
        this.buttonApply.setActionCommand("ApplyButton");
        this.buttonApply.setToolTipText("Apply the preferences and leave window open");
        this.buttonApply.setPreferredSize(new Dimension(100, 20));
        this.buttonOK.addActionListener(this);
        this.buttonCancel.addActionListener(this);
        this.buttonApply.addActionListener(this);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.buttonOK);
        buttonsPanel.add(this.buttonCancel);
        buttonsPanel.add(this.buttonApply);
        this.tabbedPane.addTab("Files", null, filesPanel, "Input/Output file settings");
        this.tabbedPane.addTab("Graphics General", null, graphicsPanel, "General Settings for graphics");
        this.tabbedPane.addTab("Color Palette", null, palettePanel, "Color Palette for graphics");
        this.tabbedPane.addTab("Events", null, eventsPanel, "Settings for events");
        this.tabbedPane.addTab("Connections", null, connectionsPanel, "Settings for connections");
        this.tabbedPane.addTab("Reports", null, reportsPanel, "Settings for Reports");
        this.tabbedPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setFieldsToDefaults();
        this.setNewsFromFields();
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)buttonsPanel, "South");
        this.setTitle("Preferences");
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd;
        switch (cmd = e.getActionCommand()) {
            case "ObjectBox": {
                this.tfCurrentObject = this.generalFontObjectBox.getSelectedIndex();
                Typeface tfCurrentTypeface = this.tfCurrentTypefaces[this.tfCurrentObject];
                int fontIdx = this.getIndexOfSelectedFont(this.generalFontsBox, tfCurrentTypeface.getFontAsString());
                this.generalFontsBox.setSelectedIndex(fontIdx);
                int sizeIdx = this.getIndexOfSelectedFont(this.generalSizeBox, String.valueOf(tfCurrentTypeface.getSize()));
                this.generalSizeBox.setSelectedIndex(sizeIdx);
                this.generalBoldBox.setSelected(tfCurrentTypeface.isBold());
                this.generalItalicBox.setSelected(tfCurrentTypeface.isItalic());
                this.generalFontSample.setFont(tfCurrentTypeface.getTypefaceAsFont());
                break;
            }
            case "SizeBox": 
            case "FontsBox": 
            case "ItalicBox": 
            case "BoldBox": {
                Typeface tmp;
                this.tfCurrentObject = this.generalFontObjectBox.getSelectedIndex();
                this.tfCurrentTypefaces[this.tfCurrentObject] = tmp = new Typeface(this.fonts[this.generalFontsBox.getSelectedIndex()], Integer.valueOf(fontSizes[this.generalSizeBox.getSelectedIndex()]), this.generalBoldBox.isSelected(), this.generalItalicBox.isSelected());
                this.generalFontSample.setFont(tmp.getTypefaceAsFont());
                break;
            }
            case "ApplyButton": 
            case "OKButton": {
                try {
                    this.setNewsFromFields();
                    this.ourGUI.setRange();
                    this.ourGUI.panLimits();
                    TimePanel ourTimePanel = this.ourGUI.getTimePanel();
                    if (ourTimePanel != null) {
                        this.ourGUI.getXAxis().revalidate();
                        this.ourGUI.getXAxis().repaint();
                        ourTimePanel.revalidate();
                        ourTimePanel.repaint();
                        if (this.newSavePrefsChoice) {
                            this.ourGUI.setFileSaved(false);
                        }
                    }
                    if (!cmd.equals("OKButton")) break;
                    this.setVisible(false);
                }
                catch (Throwable unforeseen) {
                    JOptionPane.showMessageDialog(this.prefsFrame, "Unhandled Error!\n" + this.ourGUI.displayError(unforeseen));
                }
                break;
            }
            case "CancelButton": {
                this.setFieldsFromCurrent();
                this.setVisible(false);
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this.prefsFrame, "Preferences listener called with unexpected action command " + cmd);
            }
        }
    }

    private void editActions() {
        String oldName = this.paletteColorPanel.getSelectedColorName();
        PaletteEditor editor = new PaletteEditor(this.prefsFrame, this.newPalette, oldName, this.paletteColorPanel.getSelectedPaletteColor(), false);
        if (editor.getResult() != null && editor.getResult().equals("OK")) {
            Color newColor = editor.getResultColor();
            String newName = editor.getResultName();
            if (newColor.equals(this.ourGUI.getTimePanel().getGraphicBackground())) {
                JOptionPane.showMessageDialog(this.prefsFrame, "Preferences color " + newName + " is the same as the graphics background, so will not be visible.");
            }
            if (newColor.equals(this.ourGUI.getTimePanel().getExportBackground())) {
                JOptionPane.showMessageDialog(this.prefsFrame, "Preferences color " + newName + " is the same as the export background, so will not be visible.");
            }
            PaletteColor newPC = new PaletteColor(newName, newColor);
            this.newPalette.replaceColorInPalette(newPC, this.paletteColorPanel.getSelectedColorIndex());
            this.newPalette.sortPalette();
            this.paletteColorPanel.updatePaletteTable(this.newPalette, true, newName);
            EventData ourEventData = this.ourGUI.getInput().getEventData();
            int i = 0;
            while (i < ourEventData.getTotalNumberOfEvents()) {
                if (ourEventData.getEventByIndex(i).getColor().equals(oldName)) {
                    ourEventData.getEventByIndex(i).setColor(newName);
                }
                if (ourEventData.getEventByIndex(i).getEventType().equals((Object)CommonData.EventType.TIMELINE) && ourEventData.getEventByIndex(i).getTlSegmentList() != null) {
                    SegmentList ourSegmentList = ourEventData.getEventByIndex(i).getTlSegmentList();
                    int j = 0;
                    while (j < ourSegmentList.getNumberOfSegments()) {
                        if (ourSegmentList.getASegment(j).getColorFG().equals(oldName)) {
                            ourSegmentList.getASegment(j).setColorFG(newName);
                        }
                        if (ourSegmentList.getASegment(j).getColorOuterStart().equals(oldName)) {
                            ourSegmentList.getASegment(j).setColorOuterStart(newName);
                        }
                        if (ourSegmentList.getASegment(j).getColorOuterEnd().equals(oldName)) {
                            ourSegmentList.getASegment(j).setColorOuterEnd(newName);
                        }
                        if (ourSegmentList.getASegment(j).getColorInner().equals(oldName)) {
                            ourSegmentList.getASegment(j).setColorInner(newName);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            ConnectionData ourConnections = this.ourGUI.getInput().getConnections();
            int i2 = 0;
            while (i2 < ourConnections.getNumberOfConnections()) {
                if (ourConnections.getConnection(i2).getColor().equals(oldName)) {
                    ourConnections.getConnection(i2).setColor(newName);
                }
                ++i2;
            }
        }
    }

    private void setNewsFromFields() {
        this.newLogAll = this.logAllButton.isSelected();
        this.newLogToConsole = this.logToConsoleBox.isSelected();
        this.newSavePrefsChoice = this.savePrefsBox.isSelected();
        this.newIconsPath = this.iconsDirField.getText();
        System.arraycopy(this.tfCurrentTypefaces, 0, this.tfNewTypefaces, 0, this.tfNewTypefaces.length);
        this.tfNewObject = this.tfCurrentObject;
        int i = 0;
        while (i < this.tfNewTypefaces.length) {
            FontMetrics metrics = this.getFontMetrics(this.tfNewTypefaces[i].getTypefaceAsFont());
            this.tfNewTypefaces[i].setMetrics(metrics);
            ++i;
        }
        this.newMarginLeft = (Integer)this.spinnerMarginLeft.getValue();
        this.newMarginRight = (Integer)this.spinnerMarginRight.getValue();
        this.newMarginTop = (Integer)this.spinnerMarginTop.getValue();
        this.newMarginBottom = (Integer)this.spinnerMarginBottom.getValue();
        this.newMarginInner = (Integer)this.spinnerTextMarginInner.getValue();
        this.newShowRowNos = this.showRowNosBox.isSelected();
        this.newOptimiseRows = this.optimiseRowsBox.isSelected();
        this.newRowMinXGap = (Integer)this.spinnerRowMinXGap.getValue();
        this.newRowMinYGap = (Integer)this.spinnerRowMinYGap.getValue();
        this.oldPalette = this.newPalette.copyPalette();
        this.newTlThickness = (Integer)this.spinnerTlThickness.getValue();
        this.newTlShowAgesChoice = this.tlShowAgesBox.isSelected();
        this.newEvThickness = (Integer)this.spinnerEvThickness.getValue();
        this.newStackEvents = this.stackEventsBox.isSelected();
        this.newWaveAmplitude = (Integer)this.spinnerWaveAmp.getValue();
        this.newWaveLength = (Integer)this.spinnerWaveLength.getValue();
        this.newHelixAmplitude = (Integer)this.spinnerHelixAmp.getValue();
        this.newHelixPitch = (Integer)this.spinnerHelixPitch.getValue();
        this.newDotMark = (Integer)this.spinnerDotMark.getValue();
        this.newDotGap = (Integer)this.spinnerDotGap.getValue();
        this.newDashMark = (Integer)this.spinnerDashMark.getValue();
        this.newDashGap = (Integer)this.spinnerDashGap.getValue();
        this.newDotDashMark1 = (Integer)this.spinnerDotDashMark1.getValue();
        this.newDotDashGap1 = (Integer)this.spinnerDotDashGap1.getValue();
        this.newDotDashMark2 = (Integer)this.spinnerDotDashMark2.getValue();
        this.newDotDashGap2 = (Integer)this.spinnerDotDashGap2.getValue();
        this.newArrowLength = (Integer)this.spinnerArrowLength.getValue();
        this.newArrowTail = (Integer)this.spinnerArrowTail.getValue();
        this.newArrowWidth = (Integer)this.spinnerArrowWidth.getValue();
        this.newBezCurveChoice = this.bezCheckBox.isSelected();
        this.newBezCtrlX = (Double)this.bezCtrlXField.getValue();
        this.newBezCtrlY = (Double)this.bezCtrlYField.getValue();
        this.newSummaryIntro = this.rptSummaryIntro.isSelected();
        this.newSummaryDescription = this.rptSummaryDescription.isSelected();
        this.newSummaryUntimed = this.rptSummaryUntimed.isSelected();
        this.newSummaryLinks = this.rptSummaryLinks.isSelected();
        this.newSummaryTags = this.rptSummaryTags.isSelected();
        this.newSummaryIcons = this.rptSummaryIcons.isSelected();
        this.newSummaryTlEventList = this.rptSummaryTlEventList.isSelected();
        this.newSummaryConnections = this.rptSummaryConnections.isSelected();
        this.newSummaryStats = this.rptSummaryStats.isSelected();
        this.newSummaryOmitEmpty = this.rptSummaryOmitEmpty.isSelected();
        this.newSummaryFilter = this.rptSummaryFilter.isSelected();
        this.newXrefColours = this.rptXrefColours.isSelected();
        this.newXrefIcons = this.rptXrefIcons.isSelected();
        this.newMissingDescription = this.rptMissingDescription.isSelected();
        this.newMissingLinks = this.rptMissingLinks.isSelected();
        this.newMissingTags = this.rptMissingTags.isSelected();
        this.newMissingCnName = this.rptMissingCnName.isSelected();
        this.newMissingCnTags = (Integer)this.rptMissingCnTagsSpinner.getValue();
        this.newMissingStats = this.rptMissingStats.isSelected();
    }

    private void setFieldsToDefaults() {
        this.savePrefsBox.setSelected(true);
        this.savePrefsBox.setSelected(true);
        this.iconsDirField.setText("");
        System.arraycopy(this.tfNewTypefaces, 0, this.tfCurrentTypefaces, 0, this.tfNewTypefaces.length);
        this.setFontFields();
        this.spinnerMarginLeft.setValue(50);
        this.spinnerMarginRight.setValue(50);
        this.spinnerMarginTop.setValue(50);
        this.spinnerMarginBottom.setValue(50);
        this.spinnerTextMarginInner.setValue(2);
        this.showRowNosBox.setSelected(true);
        this.optimiseRowsBox.setSelected(true);
        this.spinnerRowMinXGap.setValue(1);
        this.spinnerRowMinYGap.setValue(5);
        this.resetPalette();
        this.spinnerTlThickness.setValue(1);
        this.tlShowAgesBox.setSelected(true);
        this.spinnerEvThickness.setValue(1);
        this.stackEventsBox.setSelected(true);
        this.spinnerWaveAmp.setValue(5);
        this.spinnerWaveLength.setValue(10);
        this.spinnerHelixAmp.setValue(5);
        this.spinnerHelixPitch.setValue(10);
        this.bezCheckBox.setSelected(this.newBezCurveChoice);
        this.spinnerArrowLength.setValue(10);
        this.spinnerArrowTail.setValue(5);
        this.spinnerArrowWidth.setValue(3);
        this.curveBoxLogic();
        this.bezCtrlXField.setValue(0.1);
        this.bezCtrlYField.setValue(0.2);
        this.rptSummaryIntro.setSelected(true);
        this.rptSummaryDescription.setSelected(true);
        this.rptSummaryUntimed.setSelected(true);
        this.rptSummaryLinks.setSelected(true);
        this.rptSummaryTags.setSelected(true);
        this.rptSummaryIcons.setSelected(true);
        this.rptSummaryTlEventList.setSelected(true);
        this.rptSummaryConnections.setSelected(true);
        this.rptSummaryStats.setSelected(true);
        this.rptSummaryOmitEmpty.setSelected(true);
        this.rptSummaryFilter.setSelected(false);
        this.rptXrefColours.setSelected(true);
        this.rptXrefIcons.setSelected(true);
        this.rptMissingDescription.setSelected(true);
        this.rptMissingLinks.setSelected(true);
        this.rptMissingCnName.setSelected(false);
        this.rptMissingTags.setSelected(true);
        this.rptMissingCnTagsSpinner.setValue(1);
        this.rptMissingStats.setSelected(true);
    }

    private void setFieldsFromCurrent() {
        this.savePrefsBox.setSelected(this.newSavePrefsChoice);
        this.logAllButton.setSelected(this.newLogAll);
        this.logErrorsButton.setSelected(!this.newLogAll);
        this.logToConsoleBox.setSelected(this.newLogToConsole);
        this.iconsDirField.setText(this.newIconsPath);
        System.arraycopy(this.tfNewTypefaces, 0, this.tfCurrentTypefaces, 0, this.tfNewTypefaces.length);
        this.setFontFields();
        this.spinnerMarginLeft.setValue(this.newMarginLeft);
        this.spinnerMarginRight.setValue(this.newMarginRight);
        this.spinnerMarginTop.setValue(this.newMarginTop);
        this.spinnerMarginBottom.setValue(this.newMarginBottom);
        this.spinnerTextMarginInner.setValue(this.newMarginInner);
        this.showRowNosBox.setSelected(this.newShowRowNos);
        this.optimiseRowsBox.setSelected(this.newOptimiseRows);
        this.spinnerRowMinXGap.setValue(this.newRowMinXGap);
        this.spinnerRowMinYGap.setValue(this.newRowMinYGap);
        this.newPalette = this.oldPalette.copyPalette();
        this.paletteColorPanel.updatePaletteTable(this.newPalette, true, "");
        this.paletteColorPanel.updatePaletteTable(this.newPalette, true, "");
        this.spinnerTlThickness.setValue(this.newTlThickness);
        this.tlShowAgesBox.setSelected(this.newTlShowAgesChoice);
        this.spinnerEvThickness.setValue(this.newEvThickness);
        this.stackEventsBox.setSelected(this.newStackEvents);
        this.spinnerWaveAmp.setValue(this.newWaveAmplitude);
        this.spinnerWaveLength.setValue(this.newWaveLength);
        this.spinnerHelixAmp.setValue(this.newHelixAmplitude);
        this.spinnerHelixPitch.setValue(this.newHelixPitch);
        this.spinnerDotMark.setValue(this.newDotMark);
        this.spinnerDotGap.setValue(this.newDotGap);
        this.spinnerDashMark.setValue(this.newDashMark);
        this.spinnerDashGap.setValue(this.newDashGap);
        this.spinnerDotDashMark1.setValue(this.newDotDashMark1);
        this.spinnerDotDashGap1.setValue(this.newDotDashGap1);
        this.spinnerDotDashMark2.setValue(this.newDotDashMark2);
        this.spinnerDotDashGap2.setValue(this.newDotDashGap2);
        this.bezCheckBox.setSelected(this.newBezCurveChoice);
        this.spinnerArrowLength.setValue(this.newArrowLength);
        this.spinnerArrowTail.setValue(this.newArrowTail);
        this.spinnerArrowWidth.setValue(this.newArrowWidth);
        this.curveBoxLogic();
        this.bezCtrlXField.setValue(this.newBezCtrlX);
        this.bezCtrlYField.setValue(this.newBezCtrlY);
        this.rptSummaryIntro.setSelected(this.newSummaryIntro);
        this.rptSummaryDescription.setSelected(this.newSummaryDescription);
        this.rptSummaryUntimed.setSelected(this.newSummaryUntimed);
        this.rptSummaryLinks.setSelected(this.newSummaryLinks);
        this.rptSummaryTags.setSelected(this.newSummaryTags);
        this.rptSummaryIcons.setSelected(this.newSummaryIcons);
        this.rptSummaryTlEventList.setSelected(this.newSummaryTlEventList);
        this.rptSummaryConnections.setSelected(this.newSummaryConnections);
        this.rptSummaryStats.setSelected(this.newSummaryStats);
        this.rptSummaryOmitEmpty.setSelected(this.newSummaryOmitEmpty);
        this.rptSummaryFilter.setSelected(this.newSummaryFilter);
        this.rptXrefColours.setSelected(this.newXrefColours);
        this.rptXrefIcons.setSelected(this.newXrefIcons);
        this.rptMissingDescription.setSelected(this.newMissingDescription);
        this.rptMissingLinks.setSelected(this.newMissingLinks);
        this.rptMissingCnName.setSelected(this.newMissingCnName);
        this.rptMissingTags.setSelected(this.newMissingTags);
        this.rptMissingCnTagsSpinner.setValue(this.newMissingCnTags);
        this.rptMissingStats.setSelected(this.newMissingStats);
    }

    private int getIndexOfSelectedFont(JComboBox<String> b, String f) {
        int i = 0;
        while (i < b.getItemCount()) {
            if (b.getItemAt(i).equals(f)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private int getIndexOfString(String[] a, String f) {
        int i = 0;
        while (i < a.length) {
            if (a[i].equals(f)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private int getIndexOfSize(String[] a, int s) {
        String size = String.valueOf(s);
        int i = 0;
        while (i < a.length) {
            if (a[i].equals(size)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private void curveBoxLogic() {
        if (!this.bezCheckBox.isSelected()) {
            this.bezCtrlXField.setEnabled(false);
            this.bezCtrlYField.setEnabled(false);
        } else {
            this.bezCtrlXField.setEnabled(true);
            this.bezCtrlYField.setEnabled(true);
        }
    }

    public void resetToDefaults() {
        this.setFieldsToDefaults();
        this.setNewsFromFields();
    }

    private void initDefaultPalette() {
        this.defaultPalette = new Palette();
        this.defaultPalette.addColorToPalette(new PaletteColor("A missing", Color.GRAY));
        this.defaultPalette.addColorToPalette(new PaletteColor("Red", Color.RED));
        this.defaultPalette.addColorToPalette(new PaletteColor("Black", Color.BLACK));
        this.defaultPalette.addColorToPalette(new PaletteColor("Green", Color.GREEN));
        this.defaultPalette.addColorToPalette(new PaletteColor("Blue", Color.BLUE));
        this.defaultPalette.addColorToPalette(new PaletteColor("Dark Gray", Color.DARK_GRAY));
        this.defaultPalette.addColorToPalette(new PaletteColor("Light Gray", Color.LIGHT_GRAY));
        this.defaultPalette.addColorToPalette(new PaletteColor("Orange", Color.ORANGE));
        this.defaultPalette.addColorToPalette(new PaletteColor(this.defaultSegFG, new Color(0, 0, 0, 255)));
        this.defaultPalette.addColorToPalette(new PaletteColor(this.defaultSegBGouterStart, new Color(100, 100, 100, 200)));
        this.defaultPalette.addColorToPalette(new PaletteColor(this.defaultSegBGouterEnd, new Color(200, 200, 200, 200)));
        this.defaultPalette.addColorToPalette(new PaletteColor(this.defaultBGinner, new Color(230, 230, 230, 255)));
        this.defaultPalette.sortPalette();
    }

    public void resetPalette() {
        this.newPalette = this.defaultPalette.copyPalette();
        if (this.paletteColorPanel != null) {
            this.paletteColorPanel.updatePaletteTable(this.newPalette, true, "");
        }
    }

    public void createEmptyPalette() {
        this.newPalette = new Palette();
    }

    public Palette getPalette() {
        return this.newPalette;
    }

    public void updatePaletteAfterRead() {
        this.newPalette.sortPalette();
        this.paletteColorPanel.updatePaletteTable(this.newPalette, true, "");
        this.oldPalette = this.newPalette.copyPalette();
    }

    public void setFontFields() {
        this.tfCurrentObject = this.tfNewObject;
        this.generalFontObjectBox.setSelectedIndex(this.tfCurrentObject);
        String tmpFont = this.tfNewTypefaces[this.tfCurrentObject].getFontAsString();
        int tmpFontIdx = this.getIndexOfString(this.fonts, tmpFont);
        this.generalFontsBox.setSelectedIndex(tmpFontIdx);
        int tmpSize = this.tfNewTypefaces[this.tfCurrentObject].getSize();
        int tmpSizeIdx = this.getIndexOfSize(fontSizes, tmpSize);
        this.generalSizeBox.setSelectedIndex(tmpSizeIdx);
        this.generalBoldBox.setSelected(this.tfNewTypefaces[this.tfCurrentObject].isBold());
        this.generalItalicBox.setSelected(this.tfNewTypefaces[this.tfCurrentObject].isItalic());
    }

    public boolean getLogChoice() {
        return this.newLogAll;
    }

    public boolean getLogToConsole() {
        return this.newLogToConsole;
    }

    public boolean getSavePrefsChoice() {
        return this.newSavePrefsChoice;
    }

    public void setSavePrefsChoice(boolean p) {
        this.newSavePrefsChoice = p;
        this.savePrefsBox.setSelected(p);
    }

    public String getIconsPath() {
        return this.newIconsPath;
    }

    public void setIconsPath(String path) {
        this.newIconsPath = path;
        this.iconsDirField.setText(path);
    }

    public void setMarginLeft(int m) {
        this.newMarginLeft = m;
        this.spinnerMarginLeft.setValue(m);
    }

    public int getMarginLeft() {
        return this.newMarginLeft;
    }

    public void setMarginRight(int m) {
        this.newMarginRight = m;
        this.spinnerMarginRight.setValue(m);
    }

    public int getMarginRight() {
        return this.newMarginRight;
    }

    public void setMarginTop(int m) {
        this.newMarginTop = m;
        this.spinnerMarginTop.setValue(m);
    }

    public int getMarginTop() {
        return this.newMarginTop;
    }

    public void setMarginBottom(int m) {
        this.newMarginBottom = m;
        this.spinnerMarginBottom.setValue(m);
    }

    public int getMarginBottom() {
        return this.newMarginBottom;
    }

    public void setMarginInner(int m) {
        this.newMarginInner = m;
        this.spinnerTextMarginInner.setValue(m);
    }

    public int getMarginInner() {
        return this.newMarginInner;
    }

    public boolean getShowRowNosChoice() {
        return this.newShowRowNos;
    }

    public boolean getOptimiseRowsChoice() {
        return this.newOptimiseRows;
    }

    public int getRowMinXGap() {
        return this.newRowMinXGap;
    }

    public int getRowMinYGap() {
        return this.newRowMinYGap;
    }

    public void setRowPreferences(boolean show, boolean optimise, int minXGap, int minYGap) {
        this.newShowRowNos = show;
        this.showRowNosBox.setSelected(show);
        this.newOptimiseRows = optimise;
        this.optimiseRowsBox.setSelected(optimise);
        this.newRowMinXGap = minXGap;
        this.spinnerRowMinXGap.setValue(minXGap);
        this.newRowMinYGap = minYGap;
        this.spinnerRowMinYGap.setValue(minYGap);
    }

    public int getTimelineThickness() {
        return this.newTlThickness;
    }

    public void setTimelineThickness(int th) {
        this.newTlThickness = th;
        this.spinnerTlThickness.setValue(th);
    }

    public boolean getTimelineShowAgesChoice() {
        return this.newTlShowAgesChoice;
    }

    public void setTimelineShowAgesChoice(boolean a) {
        this.newTlShowAgesChoice = a;
        this.tlShowAgesBox.setSelected(a);
    }

    public int getEventThickness() {
        return this.newEvThickness;
    }

    public void setEventThickness(int th) {
        this.newEvThickness = th;
        this.spinnerEvThickness.setValue(th);
    }

    public boolean getStackEvents() {
        return this.newStackEvents;
    }

    public void setStackEvents(boolean stack) {
        this.newStackEvents = stack;
        this.stackEventsBox.setSelected(stack);
    }

    public int getWaveAmplitude() {
        return this.newWaveAmplitude;
    }

    public void setWaveAmplitude(int a) {
        this.newWaveAmplitude = a;
        this.spinnerWaveAmp.setValue(a);
    }

    public int getWaveLength() {
        return this.newWaveLength;
    }

    public void setWaveLength(int l) {
        this.newWaveLength = l;
        this.spinnerWaveLength.setValue(l);
    }

    public int getHelixAmplitude() {
        return this.newHelixAmplitude;
    }

    public void setHelixAmplitude(int a) {
        this.newHelixAmplitude = a;
        this.spinnerHelixAmp.setValue(a);
    }

    public int getHelixPitch() {
        return this.newHelixPitch;
    }

    public void setHelixPitch(int p) {
        this.newHelixPitch = p;
        this.spinnerHelixPitch.setValue(p);
    }

    public double getBezierCtrlX() {
        return this.newBezCtrlX;
    }

    public void setBezierCtrlX(double b) {
        this.newBezCtrlX = b;
        this.bezCtrlXField.setValue(b);
    }

    public double getBezierCtrlY() {
        return this.newBezCtrlY;
    }

    public void setBezierCtrlY(double b) {
        this.newBezCtrlY = b;
        this.bezCtrlYField.setValue(b);
    }

    public boolean getCurveConnectionsChoice() {
        return this.newBezCurveChoice;
    }

    public void setCurveConnectionsChoice(boolean c) {
        this.newBezCurveChoice = c;
        this.bezCheckBox.setSelected(c);
        this.curveBoxLogic();
    }

    public int getArrowLength() {
        return this.newArrowLength;
    }

    public void setArrowLength(int length) {
        this.newArrowLength = length;
        this.spinnerArrowLength.setValue(length);
    }

    public int getArrowTail() {
        return this.newArrowTail;
    }

    public void setArrowTail(int tail) {
        this.newArrowTail = tail;
        this.spinnerArrowTail.setValue(tail);
    }

    public int getArrowWidth() {
        return this.newArrowWidth;
    }

    public void setArrowWidth(int width) {
        this.newArrowWidth = width;
        this.spinnerArrowWidth.setValue(width);
    }

    public int getNewDotMark() {
        return this.newDotMark;
    }

    public void setNewDotMark(int dotMark) {
        this.newDotMark = dotMark;
        this.spinnerDotMark.setValue(dotMark);
    }

    public int getNewDotGap() {
        return this.newDotGap;
    }

    public void setNewDotGap(int dotGap) {
        this.newDotGap = dotGap;
        this.spinnerDotGap.setValue(dotGap);
    }

    public int getNewDashMark() {
        return this.newDashMark;
    }

    public void setNewDashMark(int dashMark) {
        this.newDashMark = dashMark;
        this.spinnerDashMark.setValue(dashMark);
    }

    public int getNewDashGap() {
        return this.newDashGap;
    }

    public void setNewDashGap(int dashGap) {
        this.newDashGap = dashGap;
        this.spinnerDashGap.setValue(dashGap);
    }

    public int getNewDotDashMark1() {
        return this.newDotDashMark1;
    }

    public void setNewDotDashMark1(int dotdashMark) {
        this.newDotDashMark1 = dotdashMark;
        this.spinnerDotDashMark1.setValue(dotdashMark);
    }

    public int getNewDotDashGap1() {
        return this.newDotDashGap1;
    }

    public void setNewDotDashGap1(int dotdashGap) {
        this.newDotDashGap1 = dotdashGap;
        this.spinnerDotDashGap1.setValue(dotdashGap);
    }

    public int getNewDotDashMark2() {
        return this.newDotDashMark2;
    }

    public void setNewDotDashMark2(int dotdashMark) {
        this.newDotDashMark2 = dotdashMark;
        this.spinnerDotDashMark2.setValue(dotdashMark);
    }

    public int getNewDotDashGap2() {
        return this.newDotDashGap2;
    }

    public void setNewDotDashGap2(int dotdashGap) {
        this.newDotDashGap2 = dotdashGap;
        this.spinnerDotDashGap2.setValue(dotdashGap);
    }

    public Typeface getTlNameTypeface() {
        return this.tfNewTypefaces[0];
    }

    public FontMetrics getTlNameMetrics() {
        return this.tfNewTypefaces[0].getMetrics();
    }

    public void setTlNameTypeface(Typeface t) {
        this.tfNewTypefaces[0] = t;
    }

    public Typeface getTlSegmentTypeface() {
        return this.tfNewTypefaces[1];
    }

    public FontMetrics getTlSegmentMetrics() {
        return this.tfNewTypefaces[1].getMetrics();
    }

    public void setTlSegmentTypeface(Typeface t) {
        this.tfNewTypefaces[1] = t;
    }

    public Typeface getTlAgeTypeface() {
        return this.tfNewTypefaces[2];
    }

    public FontMetrics getTlAgeMetrics() {
        return this.tfNewTypefaces[2].getMetrics();
    }

    public void setTlAgeTypeface(Typeface t) {
        this.tfNewTypefaces[2] = t;
    }

    public Typeface getEventNameTypeface() {
        return this.tfNewTypefaces[3];
    }

    public FontMetrics getEventNameMetrics() {
        return this.tfNewTypefaces[3].getMetrics();
    }

    public void setEventNameTypeface(Typeface t) {
        this.tfNewTypefaces[3] = t;
    }

    public Typeface getUntimedNameTypeface() {
        return this.tfNewTypefaces[4];
    }

    public FontMetrics getUntimedNameMetrics() {
        return this.tfNewTypefaces[4].getMetrics();
    }

    public void setUntimedNameTypeface(Typeface t) {
        this.tfNewTypefaces[4] = t;
    }

    public Typeface getConnectionTypeface() {
        return this.tfNewTypefaces[5];
    }

    public void setConnectionTypeface(Typeface t) {
        this.tfNewTypefaces[5] = t;
    }

    public Typeface getTimeAxisTypeface() {
        return this.tfNewTypefaces[6];
    }

    public FontMetrics getConnectionMetrics() {
        return this.tfNewTypefaces[5].getMetrics();
    }

    public FontMetrics getTimeAxisMetrics() {
        return this.tfNewTypefaces[6].getMetrics();
    }

    public void setTimeAxisTypeface(Typeface t) {
        this.tfNewTypefaces[6] = t;
    }

    public boolean getSummaryIntro() {
        return this.newSummaryIntro;
    }

    public void setSummaryIntro(boolean intro) {
        this.newSummaryIntro = intro;
        this.rptSummaryIntro.setSelected(intro);
    }

    public boolean getSummaryDescription() {
        return this.newSummaryDescription;
    }

    public void setSummaryDescription(boolean x) {
        this.newSummaryDescription = x;
        this.rptSummaryDescription.setSelected(x);
    }

    public boolean getSummaryUntimed() {
        return this.newSummaryUntimed;
    }

    public void setSummaryUntimed(boolean x) {
        this.newSummaryUntimed = x;
        this.rptSummaryUntimed.setSelected(x);
    }

    public boolean getSummaryLinks() {
        return this.newSummaryLinks;
    }

    public void setSummaryLinks(boolean x) {
        this.newSummaryLinks = x;
        this.rptSummaryLinks.setSelected(x);
    }

    public boolean getSummaryTags() {
        return this.newSummaryTags;
    }

    public void setSummaryTags(boolean x) {
        this.newSummaryTags = x;
        this.rptSummaryTags.setSelected(x);
    }

    public boolean getSummaryIcons() {
        return this.newSummaryIcons;
    }

    public void setSummaryIcons(boolean x) {
        this.newSummaryIcons = x;
        this.rptSummaryIcons.setSelected(x);
    }

    public boolean getSummaryTlEventList() {
        return this.newSummaryTlEventList;
    }

    public void setSummaryTlEventList(boolean x) {
        this.newSummaryTlEventList = x;
        this.rptSummaryTlEventList.setSelected(x);
    }

    public boolean getSummaryConnections() {
        return this.newSummaryConnections;
    }

    public void setSummaryConnections(boolean x) {
        this.newSummaryConnections = x;
        this.rptSummaryConnections.setSelected(x);
    }

    public boolean getSummaryStats() {
        return this.newSummaryStats;
    }

    public void setSummaryStats(boolean x) {
        this.newSummaryStats = x;
        this.rptSummaryStats.setSelected(x);
    }

    public boolean getSummaryOmitEmpty() {
        return this.newSummaryOmitEmpty;
    }

    public void setSummaryOmitEmpty(boolean x) {
        this.newSummaryOmitEmpty = x;
        this.rptSummaryOmitEmpty.setSelected(x);
    }

    public boolean getSummaryFilter() {
        return this.newSummaryFilter;
    }

    public void setSummaryFilter(boolean x) {
        this.newSummaryFilter = x;
        this.rptSummaryFilter.setSelected(x);
    }

    public boolean getXrefColour() {
        return this.newXrefColours;
    }

    public void setXrefColours(boolean x) {
        this.newXrefColours = x;
        this.rptXrefColours.setSelected(x);
    }

    public boolean getXrefIcons() {
        return this.newXrefIcons;
    }

    public void setXrefIcons(boolean x) {
        this.newXrefIcons = x;
        this.rptXrefIcons.setSelected(x);
    }

    public boolean getMissingDescription() {
        return this.newMissingDescription;
    }

    public void setMissingDescription(boolean x) {
        this.newMissingDescription = x;
        this.rptMissingDescription.setSelected(x);
    }

    public boolean getMissingLinks() {
        return this.newMissingLinks;
    }

    public void setMissingLinks(boolean x) {
        this.newMissingLinks = x;
        this.rptMissingLinks.setSelected(x);
    }

    public boolean getMissingTags() {
        return this.newMissingTags;
    }

    public void setMissingTags(boolean x) {
        this.newMissingTags = x;
        this.rptMissingTags.setSelected(x);
        if (x) {
            this.rptMissingCnTagsSpinner.setEnabled(true);
        } else {
            this.rptMissingCnTagsSpinner.setEnabled(false);
        }
    }

    public boolean getMissingCnName() {
        return this.newMissingCnName;
    }

    public void setMissingCnName(boolean name) {
        this.newMissingCnName = name;
        this.rptMissingCnName.setSelected(name);
    }

    public int getMissingCnTags() {
        return this.newMissingCnTags;
    }

    public void setMissingCnTags(int x) {
        this.newMissingCnTags = x;
        this.rptMissingCnTagsSpinner.setValue(x);
    }

    public boolean getMissingStats() {
        return this.newMissingStats;
    }

    public void setMissingStats(boolean x) {
        this.newMissingStats = x;
        this.rptMissingStats.setSelected(x);
    }

    public void toJSON(JSONWriter writer) {
        if (this.getSavePrefsChoice()) {
            writer.key("settings").object();
            writer.key("settingIconsPath").value(this.getIconsPath());
            writer.key("settingMargins").object().key("left").value(this.getMarginLeft()).key("right").value(this.getMarginRight()).key("top").value(this.getMarginTop()).key("bottom").value(this.getMarginBottom()).key("inner").value(this.getMarginInner()).endObject();
            writer.key("settingTimeline").object().key("font").value(this.getTlNameTypeface().getFontAsString()).key("size").value(this.getTlNameTypeface().getSize()).key("bold").value(this.getTlNameTypeface().isBold()).key("italic").value(this.getTlNameTypeface().isItalic()).key("thickness").value(this.getTimelineThickness()).key("showAges").value(this.getTimelineShowAgesChoice()).endObject();
            writer.key("settingSegment").object().key("font").value(this.getTlSegmentTypeface().getFontAsString()).key("size").value(this.getTlSegmentTypeface().getSize()).key("bold").value(this.getTlSegmentTypeface().isBold()).key("italic").value(this.getTlSegmentTypeface().isItalic()).endObject();
            writer.key("settingAges").object().key("font").value(this.getTlAgeTypeface().getFontAsString()).key("size").value(this.getTlAgeTypeface().getSize()).key("bold").value(this.getTlAgeTypeface().isBold()).key("italic").value(this.getTlAgeTypeface().isItalic()).endObject();
            writer.key("settingEvents").object().key("font").value(this.getEventNameTypeface().getFontAsString()).key("size").value(this.getEventNameTypeface().getSize()).key("bold").value(this.getEventNameTypeface().isBold()).key("italic").value(this.getEventNameTypeface().isItalic()).key("thickness").value(this.getEventThickness()).key("stackEvents").value(this.getStackEvents()).endObject();
            writer.key("settingUntimedEvents").object().key("font").value(this.getUntimedNameTypeface().getFontAsString()).key("size").value(this.getUntimedNameTypeface().getSize()).key("bold").value(this.getUntimedNameTypeface().isBold()).key("italic").value(this.getUntimedNameTypeface().isItalic()).endObject();
            writer.key("settingConnections").object().key("font").value(this.getConnectionTypeface().getFontAsString()).key("size").value(this.getConnectionTypeface().getSize()).key("bold").value(this.getConnectionTypeface().isBold()).key("italic").value(this.getConnectionTypeface().isItalic()).key("waveAmplitude").value(this.getWaveAmplitude()).key("waveLength").value(this.getWaveLength()).key("helixAmplitude").value(this.getHelixAmplitude()).key("helixPitch").value(this.getHelixPitch()).key("dotMark").value(this.getNewDotMark()).key("dotGap").value(this.getNewDotGap()).key("dashMark").value(this.getNewDashMark()).key("dashGap").value(this.getNewDashGap()).key("dotDashMark1").value(this.getNewDotDashMark1()).key("dotDashGap1").value(this.getNewDotDashGap1()).key("dotDashMark2").value(this.getNewDotDashMark2()).key("dotDashGap2").value(this.getNewDotDashGap2()).key("arrowLength").value(this.getArrowLength()).key("arrowTail").value(this.getArrowTail()).key("arrowWidth").value(this.getArrowWidth()).key("curvedLines").value(this.getCurveConnectionsChoice()).key("bezierX").value(this.getBezierCtrlX()).key("bezierY").value(this.getBezierCtrlY()).endObject();
            writer.key("settingTimeAxis").object().key("font").value(this.getTimeAxisTypeface().getFontAsString()).key("size").value(this.getTimeAxisTypeface().getSize()).key("bold").value(this.getTimeAxisTypeface().isBold()).key("italic").value(this.getTimeAxisTypeface().isItalic()).endObject();
            writer.key("settingReports").object().key("summaryIntroduction").value(this.getSummaryIntro()).key("summaryDescription").value(this.getSummaryDescription()).key("summaryUntimedEvents").value(this.getSummaryUntimed()).key("summaryLinks").value(this.getSummaryLinks()).key("summaryTags").value(this.getSummaryTags()).key("summaryIcons").value(this.getSummaryIcons()).key("summaryTimelineEventList").value(this.getSummaryTlEventList()).key("summaryConnections").value(this.getSummaryConnections()).key("summaryStatistics").value(this.getSummaryStats()).key("summaryOmitEmpty").value(this.getSummaryOmitEmpty()).key("summaryFilter").value(this.getSummaryFilter()).key("xRefColours").value(this.getXrefColour()).key("xRefIcons").value(this.getXrefIcons()).key("missingDescription").value(this.getMissingDescription()).key("missingLinks").value(this.getMissingLinks()).key("missingTags").value(this.getMissingTags()).key("missingConnectionName").value(this.getMissingCnName()).key("missingConnectionTags").value(this.getMissingCnTags()).key("missingStatistics").value(this.getMissingStats()).endObject().key("settingRows").object().key("showRowNumbers").value(this.getShowRowNosChoice()).key("optimiseRows").value(this.getOptimiseRowsChoice()).key("minimumXGap").value(this.getRowMinXGap()).key("minimumYGap").value(this.getRowMinYGap()).endObject();
            Palette tmpPal = this.getPalette();
            writer.key("settingPaletteColour").array();
            int i = 0;
            while (i < tmpPal.getSize()) {
                writer.object().key("name").value(tmpPal.getColorName(i)).key("colourRGB").value(tmpPal.getColorHex(i)).endObject();
                ++i;
            }
            writer.endArray();
            writer.endObject();
        }
    }
}

