/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.Palette;
import culturalDynamics.PaletteColor;
import culturalDynamics.UtilTableColorRenderer;
import culturalDynamics.UtilTableGreyRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

class PaletteColorPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int col0Width = 70;
    private static final int col1Width = 70;
    private static final int col2Width = 90;
    private DefaultTableModel paletteTableModel = null;
    private JTable paletteTable = null;
    private Palette ourPalette = new Palette();
    private JScrollPane paletteScroll;
    private int selectedRow = 0;
    private LineBorder tlPanelsBorder = new LineBorder(Color.lightGray, 3);

    PaletteColorPanel(Palette inPalette, String currentColor) {
        this.ourPalette = inPalette;
        this.ourPalette.sortPalette();
        Object[] paletteHeader = new String[]{"Color", "GreyScale", "Hex", "Name"};
        this.paletteTableModel = new DefaultTableModel(0, 4){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.paletteTableModel.setColumnIdentifiers(paletteHeader);
        this.paletteTable = new JTable(this.paletteTableModel){
            private static final long serialVersionUID = 1L;
            private Border outside;
            private Border inside;
            private Border highlight;
            private Border noHighlight;
            {
                this.outside = new MatteBorder(1, 0, 1, 0, Color.RED);
                this.inside = new EmptyBorder(0, 1, 0, 1);
                this.highlight = new CompoundBorder(this.outside, this.inside);
                this.noHighlight = new EmptyBorder(0, 1, 0, 1);
            }

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                JComponent jc = (JComponent)c;
                if (this.isRowSelected(row)) {
                    jc.setBorder(this.highlight);
                } else {
                    jc.setBorder(this.noHighlight);
                }
                return c;
            }
        };
        this.paletteTable.setSelectionMode(0);
        this.paletteTable.setFont(new Font("Monospaced", 0, 12));
        this.paletteTable.getColumnModel().getColumn(0).setCellRenderer(new UtilTableColorRenderer());
        this.paletteTable.getColumnModel().getColumn(1).setCellRenderer(new UtilTableGreyRenderer());
        this.paletteTable.getColumnModel().getColumn(0).setMinWidth(70);
        this.paletteTable.getColumnModel().getColumn(0).setMaxWidth(70);
        this.paletteTable.getColumnModel().getColumn(0).setPreferredWidth(70);
        this.paletteTable.getColumnModel().getColumn(1).setMinWidth(70);
        this.paletteTable.getColumnModel().getColumn(1).setMaxWidth(70);
        this.paletteTable.getColumnModel().getColumn(1).setPreferredWidth(70);
        this.paletteTable.getColumnModel().getColumn(2).setMinWidth(90);
        this.paletteTable.getColumnModel().getColumn(2).setMaxWidth(90);
        this.paletteTable.getColumnModel().getColumn(2).setPreferredWidth(90);
        this.paletteScroll = new JScrollPane(this.paletteTable);
        this.paletteScroll.setPreferredSize(new Dimension(450, 150));
        this.updatePaletteTable(this.ourPalette, false, currentColor);
        this.setLayout(new BorderLayout());
        this.add((Component)this.paletteScroll, "Center");
        TitledBorder tlColorTitle = new TitledBorder(this.tlPanelsBorder, "Color", 1, 2);
        this.setBorder(tlColorTitle);
        this.paletteTable.setAutoResizeMode(3);
    }

    public void addTableListener(MouseAdapter m) {
        this.paletteTable.addMouseListener(m);
    }

    public void updatePaletteTable(Palette inPalette, boolean clear, String selected) {
        this.ourPalette = inPalette.copyPalette();
        if (clear) {
            this.paletteTableModel.setRowCount(0);
        }
        int selectedRow = 0;
        int i = 0;
        while (i < inPalette.getSize()) {
            this.paletteTableModel.addRow(new Object[]{inPalette.getColor(i), inPalette.getColor(i), inPalette.getColorHex(i), inPalette.getColorName(i)});
            if (inPalette.getColorName(i).equals(selected)) {
                selectedRow = i;
            }
            ++i;
        }
        this.paletteTable.setRowSelectionInterval(selectedRow, selectedRow);
        this.paletteTable.scrollRectToVisible(this.paletteTable.getCellRect(selectedRow, 0, true));
        this.revalidate();
        this.repaint();
    }

    public PaletteColor getSelectedPaletteColor() {
        this.selectedRow = this.paletteTable.getSelectedRow();
        return this.ourPalette.getPaletteColorByName((String)this.paletteTable.getValueAt(this.selectedRow, 3));
    }

    public String getSelectedColorName() {
        this.selectedRow = this.paletteTable.getSelectedRow();
        return (String)this.paletteTable.getValueAt(this.selectedRow, 3);
    }

    public int getSelectedColorIndex() {
        return this.paletteTable.getSelectedRow();
    }
}

