/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.cdGUI;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileNameExtensionFilter;

class LogScrollPane
extends JFrame {
    private static final long serialVersionUID = 1L;
    private cdGUI ourGUI;
    private JFrame ourFrame;
    private JButton exportButton = new JButton("Export");
    private String exportButtonTip = "Export log to an html file.";
    private JButton printButton = new JButton("Print");
    private String printButtonTip = "Print the log. Note the number of pages is not available in the print dialog.";
    private JButton closeButton = new JButton("Close");
    private String closeButtonTip = "Close the log.";
    private String currentExportDir = "";
    private JEditorPane logPane;
    private String logBuffer;
    private BufferedWriter outBuffer = null;
    private String newOverwriteDialog = "New output file already exists. Do you want to overwrite it?";
    private String errorStyleBegin = "<p class=\"red\">";
    private String warningStyleBegin = "<p class =\"orange\">";
    private String convertedStyleBegin = "<p class=\"green\">";
    private String okStyleBegin = "<p class=\"black\">";
    private String styleEnd = "</p>";
    private String head = "<html><head><meta charset=\"UTF-8\"><title>Open File Log</title>";
    private String styles = "<style type=\"text/css\">\n\tp{margin: 0px 0px 0px 0px; padding: 0px 0px 0px 0px;}\n\t.red{color:red;}\n .black{color:black}\n .green{color:green}\n .orange{color:orange}\n</style>";
    private String body = "<body style=\"font-size:10pt;\">";
    private String endHTML = "</body>\n</html>";
    private FlowLayout flowLayoutCenter = new FlowLayout(1);

    public LogScrollPane(cdGUI mainGUI) {
        this.ourGUI = mainGUI;
        this.logBuffer = this.head + this.styles + "</head>" + this.body;
        this.ourFrame = this;
        this.logPane = new JEditorPane("text/html", this.logBuffer);
        this.logPane.setCaretPosition(0);
        this.logPane.setEditable(false);
        JScrollPane ourScrollPane = new JScrollPane(this.logPane);
        this.ourFrame.setTitle("Error Log");
        JPanel buttonPanel = new JPanel(this.flowLayoutCenter);
        this.printButton.setToolTipText(this.printButtonTip);
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent print) {
                try {
                    LogScrollPane.this.logPane.print(null, new MessageFormat("Page - {0}"));
                }
                catch (PrinterException e) {
                    e.printStackTrace();
                }
            }
        });
        this.exportButton.setToolTipText(this.exportButtonTip);
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int newOverwriteSelection;
                if (LogScrollPane.this.currentExportDir == "") {
                    LogScrollPane.this.currentExportDir = System.getProperty("user.home");
                }
                JFileChooser expChooser = new JFileChooser(LogScrollPane.this.currentExportDir);
                expChooser.setDialogTitle("Save Report to text File");
                expChooser.setMultiSelectionEnabled(false);
                expChooser.setFileSelectionMode(2);
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Text files", "txt", "log");
                expChooser.setFileFilter(filter);
                expChooser.setFileHidingEnabled(true);
                int expChoice = expChooser.showSaveDialog(LogScrollPane.this.ourGUI);
                if (expChoice != 0) {
                    return;
                }
                File saveFile = expChooser.getSelectedFile();
                LogScrollPane.this.currentExportDir = saveFile.getParent();
                if (saveFile.exists() && (newOverwriteSelection = JOptionPane.showConfirmDialog(LogScrollPane.this.ourGUI, LogScrollPane.this.newOverwriteDialog, "That File Already Exists - overwrite it?", 0, 3)) == 1) {
                    return;
                }
                try {
                    saveFile.createNewFile();
                    String path = saveFile.getAbsolutePath();
                    BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), StandardCharsets.UTF_8));
                    LogScrollPane.this.outBuffer = new BufferedWriter(outWriter);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(LogScrollPane.this.ourGUI, "Output File: IO Exception opening file for write" + ex.getMessage());
                    return;
                }
                try {
                    LogScrollPane.this.outBuffer.write(LogScrollPane.this.logPane.getText());
                    LogScrollPane.this.outBuffer.flush();
                    LogScrollPane.this.outBuffer.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.closeButton.setToolTipText(this.closeButtonTip);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent close) {
                LogScrollPane.this.ourFrame.dispose();
            }
        });
        buttonPanel.add(this.exportButton);
        buttonPanel.add(this.printButton);
        buttonPanel.add(this.closeButton);
        Box overallPanel = Box.createVerticalBox();
        overallPanel.add(ourScrollPane);
        overallPanel.add(buttonPanel);
        this.add(overallPanel);
    }

    public int logLine(lineType typeIn, String msg) {
        if (this.ourGUI.getPreferences().getLogChoice() || !typeIn.equals((Object)lineType.OK)) {
            Object tmp = "";
            switch (typeIn) {
                case ERROR: {
                    tmp = this.errorStyleBegin + msg + this.styleEnd;
                    break;
                }
                case WARNING: {
                    tmp = this.warningStyleBegin + msg + this.styleEnd;
                    break;
                }
                case CONVERTED: {
                    tmp = this.convertedStyleBegin + msg + this.styleEnd;
                    break;
                }
                default: {
                    tmp = this.okStyleBegin + msg + this.styleEnd;
                }
            }
            this.logBuffer = String.valueOf(this.logBuffer) + (String)tmp;
            this.logPane.setCaretPosition(this.logPane.getDocument().getLength());
            if (this.ourGUI.getPreferences().getLogToConsole()) {
                System.out.print(msg);
            }
        }
        if (typeIn.equals((Object)lineType.ERROR)) {
            return 1;
        }
        return 0;
    }

    public void endLog() {
        this.logBuffer = String.valueOf(this.logBuffer) + this.endHTML;
        this.logPane.setText(this.logBuffer);
    }

    public static enum lineType {
        OK,
        ERROR,
        WARNING,
        CONVERTED;

    }
}

