/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CommonData;
import culturalDynamics.Connection;
import culturalDynamics.ConnectionData;
import culturalDynamics.Event;
import culturalDynamics.EventData;
import culturalDynamics.Filter;
import culturalDynamics.FilterEditor;
import culturalDynamics.Link;
import culturalDynamics.LogScrollPane;
import culturalDynamics.PaletteColor;
import culturalDynamics.Preferences;
import culturalDynamics.Row;
import culturalDynamics.RowData;
import culturalDynamics.SavedFilterData;
import culturalDynamics.Segment;
import culturalDynamics.SegmentList;
import culturalDynamics.TagList;
import culturalDynamics.Typeface;
import culturalDynamics.Utils;
import culturalDynamics.cdGUI;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

class InputFileJSON
extends JFrame {
    private static final long serialVersionUID = 1L;
    private BufferedReader in;
    private int errorCount = 0;
    private int lineErrors = 0;
    private int prefsCount = 0;
    private LogScrollPane loggingScrollPane;
    private JFrame mainFrame;
    private cdGUI ourGUI;
    private String fileName;
    private EventData ourEventData = new EventData();
    private ConnectionData ourConnections = new ConnectionData();
    private RowData ourRowData;
    private Preferences ourPrefs;
    private TagList masterTagList = new TagList();

    InputFileJSON(cdGUI mainGUI) {
        this.mainFrame = mainGUI.getMainWindow();
        this.ourGUI = mainGUI;
        this.ourPrefs = this.ourGUI.getPreferences();
        this.masterTagList = this.ourGUI.getMasterTags();
        this.masterTagList.initialiseList();
    }

    public EventData getEventData() {
        return this.ourEventData;
    }

    public void setEventData(EventData d) {
        this.ourEventData = new EventData();
        int i = 0;
        while (i < d.getTotalNumberOfEvents()) {
            this.ourEventData.addEvent(d.getEventByIndex(i));
            ++i;
        }
    }

    public List<Event> getTimelines() {
        return this.ourEventData.getListOfTimelines(false);
    }

    public List<Event> getEvents() {
        return this.ourEventData.getListOfEventsOnly(false);
    }

    public ConnectionData getConnections() {
        return this.ourConnections;
    }

    public void setConnections(ConnectionData c) {
        this.ourConnections = new ConnectionData();
        int i = 0;
        while (i < c.getNumberOfConnections()) {
            this.ourConnections.addConnection(c.getConnection(i));
            ++i;
        }
    }

    public Boolean readDataFile(String inFileName) {
        this.fileName = inFileName;
        if (inFileName.equals("")) {
            JOptionPane.showMessageDialog(this.mainFrame, "InputFile: read called with blank file name!");
            return false;
        }
        this.errorCount = 0;
        this.prefsCount = 0;
        String tryingObject = "";
        this.ourRowData = this.ourGUI.getRowData();
        try {
            try {
                JSONObject cdDataJSONObject;
                block118: {
                    this.in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fileName), "UTF8"));
                    this.loggingScrollPane = new LogScrollPane(this.ourGUI);
                    this.loggingScrollPane.setVisible(true);
                    this.loggingScrollPane.setSize(600, 600);
                    this.log(LogScrollPane.lineType.OK, "\n<br><br> Opening file " + inFileName + "\n");
                    JSONTokener cdToken = new JSONTokener(this.in);
                    JSONObject cdJSONObject = new JSONObject(cdToken);
                    tryingObject = "CDdata";
                    cdDataJSONObject = cdJSONObject.getJSONObject("CDdata");
                    tryingObject = "settings";
                    JSONObject settings = cdDataJSONObject.optJSONObject("settings");
                    if (settings != null) {
                        tryingObject = "settingsIconsPath";
                        String iconsDir = settings.getString("settingIconsPath");
                        if (!iconsDir.equals("")) {
                            if (!new File(iconsDir).exists()) {
                                this.log(LogScrollPane.lineType.WARNING, "***  Icons directory " + iconsDir + "in JSON object " + iconsDir + " does not exist\n");
                                iconsDir = "";
                            }
                            this.ourPrefs.setIconsPath(iconsDir);
                            ++this.prefsCount;
                        }
                        tryingObject = "margins";
                        JSONObject settingMargins = settings.optJSONObject("settingMargins");
                        if (settingMargins != null) {
                            int margin = this.parseInteger(settingMargins.optString("left", "10"), "*** Invalid number in margin left in JSON object left margin " + String.valueOf(settingMargins) + "\n");
                            this.ourPrefs.setMarginLeft(margin);
                            margin = this.parseInteger(settingMargins.optString("right", "10"), "*** Invalid number in margin right in JSON object right margin " + String.valueOf(settingMargins) + "\n");
                            this.ourPrefs.setMarginRight(margin);
                            margin = this.parseInteger(settingMargins.optString("top", "10"), "*** Invalid number in margin top in JSON object top margin " + String.valueOf(settingMargins) + "\n");
                            this.ourPrefs.setMarginTop(margin);
                            margin = this.parseInteger(settingMargins.optString("bottom", "10"), "*** Invalid number in margin bottom in JSON object bottom margin " + String.valueOf(settingMargins) + "\n");
                            this.ourPrefs.setMarginBottom(margin);
                            margin = this.parseInteger(settingMargins.optString("inner", "2"), "*** Invalid number in margin bottom in JSON object inner margin" + String.valueOf(settingMargins) + "\n");
                            this.ourPrefs.setMarginInner(margin);
                            ++this.prefsCount;
                        }
                        tryingObject = "settingTimeline";
                        JSONObject settingTimelines = settings.optJSONObject("settingTimeline");
                        if (settingTimelines != null) {
                            String font = settingTimelines.optString("font", "serif");
                            int size = this.parseInteger(settingTimelines.optString("size", "10"), "*** Invalid font size in JSON object " + String.valueOf(settingTimelines) + "\n");
                            boolean bold = this.parseBoolean(settingTimelines.optString("bold", "false"), "*** Invalid boolean for bold in JSON object " + String.valueOf(settingTimelines) + "\n");
                            boolean italic = this.parseBoolean(settingTimelines.optString("italic", "false"), "*** Invalid boolean for italic in JSON object " + String.valueOf(settingTimelines) + "\n");
                            Typeface tmpTypeface = new Typeface(font, size, bold, italic);
                            this.ourPrefs.setTlNameTypeface(tmpTypeface);
                            FontMetrics metrics = this.ourGUI.getFontMetrics(tmpTypeface.getTypefaceAsFont());
                            tmpTypeface.setMetrics(metrics);
                            int th = this.parseInteger(settingTimelines.optString("thickness", "1"), "*** Invalid thickness in JSON object " + String.valueOf(settingTimelines) + "\n");
                            this.ourPrefs.setTimelineThickness(th);
                            this.ourPrefs.setTimelineShowAgesChoice(this.parseBoolean(settingTimelines.optString("showAges", "true"), "*** Invalid boolean for show ages in JSON object " + String.valueOf(settingTimelines) + "\n"));
                            ++this.prefsCount;
                        }
                        tryingObject = "settingSegment";
                        JSONObject settingSegments = settings.optJSONObject("settingSegment");
                        if (settingSegments != null) {
                            String font = settingSegments.optString("font", "serif");
                            int size = this.parseInteger(settingSegments.optString("size", "10"), "*** Invalid font size in JSON object " + String.valueOf(settingSegments) + "\n");
                            boolean bold = this.parseBoolean(settingSegments.optString("bold", "false"), "*** Invalid boolean for bold in JSON object " + String.valueOf(settingSegments) + "\n");
                            boolean italic = this.parseBoolean(settingSegments.optString("italic", "false"), "*** Invalid boolean for italic in JSON object " + String.valueOf(settingSegments) + "\n");
                            Typeface tmpTypeface = new Typeface(font, size, bold, italic);
                            this.ourPrefs.setTlSegmentTypeface(tmpTypeface);
                            FontMetrics metrics = this.ourGUI.getFontMetrics(tmpTypeface.getTypefaceAsFont());
                            tmpTypeface.setMetrics(metrics);
                            ++this.prefsCount;
                        }
                        tryingObject = "settingAges";
                        JSONObject settingTlAge = settings.optJSONObject("settingAges");
                        if (settingTlAge != null) {
                            String font = settingTlAge.optString("font", "serif");
                            int size = this.parseInteger(settingTlAge.optString("size", "10"), "*** Invalid font size in JSON object " + String.valueOf(settingTlAge) + "\n");
                            boolean bold = this.parseBoolean(settingTlAge.optString("bold", "false"), "*** Invalid boolean for bold in JSON object " + String.valueOf(settingTlAge) + "\n");
                            boolean italic = this.parseBoolean(settingTlAge.optString("italic", "false"), "*** Invalid boolean for italic in JSON object " + String.valueOf(settingTlAge) + "\n");
                            Typeface tmpTypeface = new Typeface(font, size, bold, italic);
                            this.ourPrefs.setTimeAxisTypeface(tmpTypeface);
                            FontMetrics metrics = this.ourGUI.getFontMetrics(tmpTypeface.getTypefaceAsFont());
                            tmpTypeface.setMetrics(metrics);
                            ++this.prefsCount;
                        }
                        tryingObject = "settingEvents";
                        JSONObject settingEvents = settings.optJSONObject("settingEvents");
                        if (settingEvents != null) {
                            String font = settingEvents.optString("font", "serif");
                            int size = this.parseInteger(settingEvents.optString("size", "10"), "*** Invalid font size in JSON object " + String.valueOf(settingEvents) + "\n");
                            boolean bold = this.parseBoolean(settingEvents.optString("bold", "false"), "*** Invalid boolean for bold in JSON object " + String.valueOf(settingEvents) + "\n");
                            boolean italic = this.parseBoolean(settingEvents.optString("italic", "false"), "*** Invalid boolean for italic in JSON object " + String.valueOf(settingEvents) + "\n");
                            Typeface tmpTypeface = new Typeface(font, size, bold, italic);
                            this.ourPrefs.setEventNameTypeface(tmpTypeface);
                            FontMetrics metrics = this.ourGUI.getFontMetrics(tmpTypeface.getTypefaceAsFont());
                            tmpTypeface.setMetrics(metrics);
                            int th = this.parseInteger(settingEvents.optString("thickness", "1"), "*** Invalid thickness in JSON object " + String.valueOf(settingEvents) + "\n");
                            this.ourPrefs.setEventThickness(th);
                            boolean stack = this.parseBoolean(settingEvents.optString("stackEvents", "true"), "*** Invalid boolean for stack events in JSON object " + String.valueOf(settingEvents) + "\n");
                            this.ourPrefs.setStackEvents(stack);
                            ++this.prefsCount;
                        }
                        tryingObject = "settingUntimedEvents";
                        JSONObject settingUntimed = settings.optJSONObject("settingUntimed");
                        if (settingUntimed != null) {
                            String font = settingUntimed.optString("font", "serif");
                            int size = this.parseInteger(settingUntimed.optString("size", "10"), "*** Invalid font size in JSON object " + String.valueOf(settingUntimed) + "\n");
                            boolean bold = this.parseBoolean(settingUntimed.optString("bold", "false"), "*** Invalid boolean for bold in JSON object " + String.valueOf(settingUntimed) + "\n");
                            boolean italic = this.parseBoolean(settingUntimed.optString("italic", "false"), "*** Invalid boolean for italic in JSON object " + String.valueOf(settingUntimed) + "\n");
                            Typeface tmpTypeface = new Typeface(font, size, bold, italic);
                            this.ourPrefs.setUntimedNameTypeface(tmpTypeface);
                            FontMetrics metrics = this.ourGUI.getFontMetrics(tmpTypeface.getTypefaceAsFont());
                            tmpTypeface.setMetrics(metrics);
                            ++this.prefsCount;
                        }
                        tryingObject = "settingConnections";
                        JSONObject settingConnections = settings.optJSONObject("settingConnections");
                        if (settingConnections != null) {
                            String font = settingConnections.optString("font", "serif");
                            int size = this.parseInteger(settingConnections.optString("size", "10"), "*** Invalid font size in JSON object " + String.valueOf(settingConnections) + "\n");
                            boolean bold = this.parseBoolean(settingConnections.optString("bold", "false"), "*** Invalid boolean for bold in JSON object " + String.valueOf(settingConnections) + "\n");
                            boolean italic = this.parseBoolean(settingConnections.optString("italic", "false"), "*** Invalid boolean for italic in JSON object " + String.valueOf(settingConnections) + "\n");
                            Typeface tmpTypeface = new Typeface(font, size, bold, italic);
                            this.ourPrefs.setConnectionTypeface(tmpTypeface);
                            FontMetrics metrics = this.ourGUI.getFontMetrics(tmpTypeface.getTypefaceAsFont());
                            tmpTypeface.setMetrics(metrics);
                            this.ourPrefs.setWaveAmplitude(this.parseInteger(settingConnections.optString("waveAmplitude", "5"), "*** Invalid amplitude in JSON object " + String.valueOf(settingConnections) + "\n"));
                            this.ourPrefs.setWaveLength(this.parseInteger(settingConnections.optString("waveLength", "10"), "*** Invalid wave length in JSON object " + String.valueOf(settingConnections) + "\n"));
                            this.ourPrefs.setHelixAmplitude(this.parseInteger(settingConnections.optString("helixAmplitude", "5"), "*** Invalid helix amplitude in JSON object " + String.valueOf(settingConnections) + "\n"));
                            this.ourPrefs.setHelixPitch(this.parseInteger(settingConnections.optString("helixPitch", "10"), "*** Invalid helix pitch in JSON object " + String.valueOf(settingConnections) + "\n"));
                            this.ourPrefs.setNewDotMark(this.parseInteger(settingConnections.optString("dotMark", "1"), "*** Invalid dot mark in JSON object " + String.valueOf(settingConnections) + "\n"));
                            this.ourPrefs.setNewDotGap(this.parseInteger(settingConnections.optString("dotGap", "5"), "*** Invalid dot gap in JSON object " + String.valueOf(settingConnections) + "\n"));
                            this.ourPrefs.setNewDashMark(this.parseInteger(settingConnections.optString("dashMark", "10"), "*** Invalid dash mark in JSON object " + String.valueOf(settingConnections) + "\n"));
                            this.ourPrefs.setNewDashGap(this.parseInteger(settingConnections.optString("dashGap", "10"), "*** Invalid dash gap in JSON object " + String.valueOf(settingConnections) + "\n"));
                            this.ourPrefs.setNewDotDashMark1(this.parseInteger(settingConnections.optString("dotDashMark1", "1"), "*** Invalid dot-dash mark 1 in JSON object " + String.valueOf(settingConnections) + "\n"));
                            this.ourPrefs.setNewDotDashGap1(this.parseInteger(settingConnections.optString("dotDashGap1", "5"), "*** Invalid dot-dash gap 1 in JSON object " + String.valueOf(settingConnections) + "\n"));
                            this.ourPrefs.setNewDotDashMark2(this.parseInteger(settingConnections.optString("dotDashMark2", "10"), "*** Invalid dot-dash mark 2 in JSON object " + String.valueOf(settingConnections) + "\n"));
                            this.ourPrefs.setNewDotDashGap2(this.parseInteger(settingConnections.optString("dotDashGap2", "10"), "*** Invalid dot-dash gap 2 in JSON object " + String.valueOf(settingConnections) + "\n"));
                            this.ourPrefs.setArrowLength(this.parseInteger(settingConnections.optString("arrowLength", "8"), "*** Invalid arrow length in JSON Object " + String.valueOf(settingConnections) + "\n"));
                            this.ourPrefs.setArrowTail(this.parseInteger(settingConnections.optString("arrowTail", "3"), "*** Invalid arrow tail in JSON Object " + String.valueOf(settingConnections) + "\n"));
                            this.ourPrefs.setArrowWidth(this.parseInteger(settingConnections.optString("arrowWidth", "3"), "*** Invalid arrow width in JSON Object " + String.valueOf(settingConnections) + "\n"));
                            this.ourPrefs.setCurveConnectionsChoice(this.parseBoolean(settingConnections.optString("curvedLines", "false"), "Invalid boolean for curved connections in JSON object " + String.valueOf(settingConnections) + "\n"));
                            this.ourPrefs.setBezierCtrlX(this.parseDouble(settingConnections.optString("bezierX", "0.5"), "*** Invalid Bezier Control X in JSON object " + String.valueOf(settingConnections) + "\n"));
                            this.ourPrefs.setBezierCtrlY(this.parseDouble(settingConnections.optString("bezierY", "0.2"), "*** Invalid Bezier Control Y in JSON object " + String.valueOf(settingConnections) + "\n"));
                            ++this.prefsCount;
                        }
                        tryingObject = "settingTimeAxis";
                        JSONObject settingTimeAxis = settings.optJSONObject("settingTimeAxis");
                        if (settingTimeAxis != null) {
                            String font = settingTimeAxis.optString("font", "serif");
                            int size = this.parseInteger(settingTimeAxis.optString("size", "10"), "*** Invalid font size in JSON object " + String.valueOf(settingTimeAxis) + "\n");
                            boolean bold = this.parseBoolean(settingTimeAxis.optString("bold", "false"), "*** Invalid boolean for bold in JSON object " + String.valueOf(settingTimeAxis) + "\n");
                            boolean italic = this.parseBoolean(settingTimeAxis.optString("italic", "false"), "*** Invalid boolean for italic in JSON object " + String.valueOf(settingTimeAxis) + "\n");
                            Typeface tmpTypeface = new Typeface(font, size, bold, italic);
                            this.ourPrefs.setTimeAxisTypeface(tmpTypeface);
                            FontMetrics metrics = this.ourGUI.getFontMetrics(tmpTypeface.getTypefaceAsFont());
                            tmpTypeface.setMetrics(metrics);
                            ++this.prefsCount;
                        }
                        tryingObject = "settingReports";
                        JSONObject settingReports = settings.optJSONObject("settingReports");
                        this.ourPrefs.setSummaryIntro(this.parseBoolean(settingReports.optString("summaryIntroduction", "true"), "*** Invalid boolean for summary introduction in JSON object " + String.valueOf(settingReports) + "\n"));
                        this.ourPrefs.setSummaryDescription(this.parseBoolean(settingReports.optString("summaryDescription", "true"), "*** Invalid boolean for summary description in JSON object " + String.valueOf(settingReports) + "\n"));
                        this.ourPrefs.setSummaryUntimed(this.parseBoolean(settingReports.optString("summaryUntimedEvents", "true"), "*** Invalid boolean for summary untimed events in JSON object " + String.valueOf(settingReports) + "\n"));
                        this.ourPrefs.setSummaryLinks(this.parseBoolean(settingReports.optString("summaryLinks", "true"), "*** Invalid boolean for summary links in JSON object " + String.valueOf(settingReports) + "\n"));
                        this.ourPrefs.setSummaryTags(this.parseBoolean(settingReports.optString("summaryTags", "true"), "*** Invalid boolean for summary tags in JSON object " + String.valueOf(settingReports) + "\n"));
                        this.ourPrefs.setSummaryIcons(this.parseBoolean(settingReports.optString("summaryIcons", "true"), "*** Invalid boolean for summary icons in JSON object " + String.valueOf(settingReports) + "\n"));
                        this.ourPrefs.setSummaryTlEventList(this.parseBoolean(settingReports.optString("summaryTimelineEventList", "true"), "*** Invalid boolean for summary timeline event list in JSON object " + String.valueOf(settingReports) + "\n"));
                        this.ourPrefs.setSummaryConnections(this.parseBoolean(settingReports.optString("summaryConnections", "true"), "*** Invalid boolean for summary connections in JSON object " + String.valueOf(settingReports) + "\n"));
                        this.ourPrefs.setSummaryStats(this.parseBoolean(settingReports.optString("summaryStatistics", "true"), "*** Invalid boolean for summary statistics in JSON object " + String.valueOf(settingReports) + "\n"));
                        this.ourPrefs.setSummaryOmitEmpty(this.parseBoolean(settingReports.optString("summaryOmitEmpty", "true"), "*** Invalid boolean for summary omit empty in JSON object " + String.valueOf(settingReports) + "\n"));
                        this.ourPrefs.setSummaryFilter(this.parseBoolean(settingReports.optString("summaryFilter", "true"), "*** Invalid boolean for summary filter in JSON object " + String.valueOf(settingReports) + "\n"));
                        this.ourPrefs.setXrefColours(this.parseBoolean(settingReports.optString("xRefColours", "true"), "*** Invalid boolean for cross-reference colours in JSON object " + String.valueOf(settingReports) + "\n"));
                        this.ourPrefs.setXrefIcons(this.parseBoolean(settingReports.optString("xRefIcons", "true"), "*** Invalid boolean for cross-reference icons in JSON object " + String.valueOf(settingReports) + "\n"));
                        this.ourPrefs.setMissingDescription(this.parseBoolean(settingReports.optString("missingDescription", "true"), "*** Invalid boolean for missing description in JSON object " + String.valueOf(settingReports) + "\n"));
                        this.ourPrefs.setMissingLinks(this.parseBoolean(settingReports.optString("missingLinks", "true"), "*** Invalid boolean for missing links in JSON object " + String.valueOf(settingReports) + "\n"));
                        this.ourPrefs.setMissingTags(this.parseBoolean(settingReports.optString("missingTags", "true"), "*** Invalid boolean for missing tags in JSON object " + String.valueOf(settingReports) + "\n"));
                        this.ourPrefs.setMissingCnName(this.parseBoolean(settingReports.optString("missingConnectionName", "false"), "*** Invalid boolean for missing connection name in JSON object " + String.valueOf(settingReports) + "\n"));
                        this.ourPrefs.setMissingCnTags(this.parseInteger(settingReports.optString("missingConnectionTags", "1"), "*** Invalid number for missing connection tags in JSON object " + String.valueOf(settingReports) + "\n"));
                        this.ourPrefs.setMissingStats(this.parseBoolean(settingReports.optString("missingStatistics", "true"), "*** Invalid boolean for missing statistics in JSON object " + String.valueOf(settingReports) + "\n"));
                        ++this.prefsCount;
                        tryingObject = "settingRows";
                        JSONObject settingRows = settings.optJSONObject("settingRows");
                        boolean showNumbers = this.parseBoolean(settingRows.optString("showNumbers", "true"), "*** Invalid boolean for show numbers in JSON object " + String.valueOf(settingRows) + "\n");
                        boolean optimiseRows = this.parseBoolean(settingRows.optString("optimiseRows", "true"), "*** Invalid boolean for optimise rows in JSON object " + String.valueOf(settingRows) + "\n");
                        int minimumXGap = this.parseInteger(settingRows.optString("minimumXGap", "5"), "*** Invalid boolean for minimum X gap in JSON object " + String.valueOf(settingRows) + "\n");
                        int minimumYGap = this.parseInteger(settingRows.optString("minimumYGap", "5"), "*** Invalid boolean for minimum Y gap in JSON object " + String.valueOf(settingRows) + "\n");
                        this.ourPrefs.setRowPreferences(showNumbers, optimiseRows, minimumXGap, minimumYGap);
                        ++this.prefsCount;
                        tryingObject = "settingPaletteColour";
                        boolean colorFound = false;
                        JSONArray palette = new JSONArray(settings.optJSONArray("settingPaletteColour"));
                        if (palette != null) {
                            int i = 0;
                            while (i < palette.length()) {
                                JSONObject c = palette.getJSONObject(i);
                                String paletteColorName = c.optString("name");
                                String color = c.optString("colourRGB");
                                Color paletteColor = Utils.colorFromString(color);
                                if (!colorFound) {
                                    this.ourPrefs.createEmptyPalette();
                                    colorFound = true;
                                }
                                this.ourPrefs.getPalette().addColorToPalette(new PaletteColor(paletteColorName, paletteColor));
                                ++i;
                            }
                        }
                    }
                    tryingObject = "intro";
                    JSONObject introObject = cdDataJSONObject.optJSONObject("intro");
                    if (introObject != null) {
                        tryingObject = "introduction";
                        this.ourGUI.setIntroText(Utils.decodeEscapes(introObject.optString("introduction")));
                        tryingObject = "techDetails";
                        this.ourGUI.setTechText(Utils.decodeEscapes(introObject.optString("techDetails")));
                    }
                    tryingObject = "events";
                    JSONArray events = new JSONArray(cdDataJSONObject.optJSONArray("events"));
                    if (events != null) {
                        JSONObject ev;
                        int i = 0;
                        while (i < events.length()) {
                            ev = events.getJSONObject(i);
                            String eTypeString = ev.getString("type");
                            if (eTypeString.toUpperCase(Locale.ENGLISH).equals("TIMELINE")) {
                                this.readJSONEvent(ev);
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < events.length()) {
                            ev = events.getJSONObject(i);
                            if (!ev.get("type").equals("TIMELINE")) {
                                this.readJSONEvent(ev);
                            }
                            ++i;
                        }
                    }
                    tryingObject = "connections";
                    JSONArray connections = new JSONArray(cdDataJSONObject.optJSONArray("connections"));
                    if (connections == null) break block118;
                    int i = 0;
                    while (i < connections.length()) {
                        String dt;
                        String lt;
                        JSONObject cn = connections.getJSONObject(i);
                        String cIndex = String.valueOf(cn.getInt("index"));
                        if (cIndex == null) {
                            this.log(LogScrollPane.lineType.WARNING, "*** Invalid Connection index " + cIndex + "in JSON object " + String.valueOf(cn) + " not found in palette\n");
                        }
                        String cName = cn.getString("name");
                        String cColor = cn.getString("colour");
                        if (!this.ourPrefs.getPalette().paletteColorExists(cColor)) {
                            this.log(LogScrollPane.lineType.WARNING, "*** Connection color " + cColor + "in JSON object " + String.valueOf(cn) + " not found in palette\n");
                            cColor = this.ourPrefs.getPalette().getColorName(0);
                        }
                        Event cSourceEvent = null;
                        String src = cn.getString("sourceEvent");
                        if (src != null && !src.isEmpty() && !src.equals("") && (cSourceEvent = this.ourEventData.getEventByName(src)) == null) {
                            this.log(LogScrollPane.lineType.ERROR, "***  Source Event reference " + src + " in JSON object " + String.valueOf(cn) + " not found\n");
                        }
                        LocalDate cSrcEarlyDate = null;
                        String sED = cn.optString("sourceEarlyDate");
                        if (sED != null && !sED.isEmpty() && !sED.equals("")) {
                            try {
                                cSrcEarlyDate = LocalDate.parse(sED, Utils.dayFormatter);
                            }
                            catch (DateTimeParseException f) {
                                cSrcEarlyDate = null;
                            }
                            if (cSrcEarlyDate == null) {
                                this.log(LogScrollPane.lineType.ERROR, "***  Invalid source early start date " + sED + " in JSON object " + String.valueOf(cn) + "\n");
                            }
                        }
                        LocalDate cSrcLateDate = null;
                        String sLD = cn.optString("sourceLateDate");
                        if (sLD != null && !sLD.isEmpty() && !sLD.equals("")) {
                            try {
                                cSrcLateDate = LocalDate.parse(sLD, Utils.dayFormatter);
                            }
                            catch (DateTimeParseException f) {
                                cSrcLateDate = null;
                            }
                            if (cSrcLateDate == null) {
                                this.log(LogScrollPane.lineType.ERROR, "***  Invalid source late start date " + sLD + " in JSON object " + String.valueOf(cn) + "\n");
                            }
                        }
                        Event cDestEvent = null;
                        String dst = cn.getString("destinationEvent");
                        if (dst != null && !dst.isEmpty() && !dst.equals("") && (cDestEvent = this.ourEventData.getEventByName(dst)) == null) {
                            this.log(LogScrollPane.lineType.ERROR, "***  Destination Event reference " + dst + " in JSON object " + String.valueOf(cn) + " not found\n");
                        }
                        LocalDate cDstEarlyDate = null;
                        String dED = cn.optString("destinationEarlyDate");
                        if (dED != null && !dED.isEmpty() && !dED.equals("")) {
                            try {
                                cDstEarlyDate = LocalDate.parse(dED, Utils.dayFormatter);
                            }
                            catch (DateTimeParseException f) {
                                cDstEarlyDate = null;
                            }
                            if (cDstEarlyDate == null) {
                                this.log(LogScrollPane.lineType.ERROR, "***  Invalid destination early start date " + dED + " in JSON object " + String.valueOf(cn) + "\n");
                            }
                        }
                        LocalDate cDstLateDate = null;
                        String dLD = cn.optString("destinationLateDate");
                        if (dLD != null && !dLD.isEmpty() && !dLD.equals("")) {
                            try {
                                cDstLateDate = LocalDate.parse(dLD, Utils.dayFormatter);
                            }
                            catch (DateTimeParseException f) {
                                cDstLateDate = null;
                            }
                            if (cDstLateDate == null) {
                                this.log(LogScrollPane.lineType.ERROR, "***  Invalid destination late start date " + dLD + " in JSON object " + String.valueOf(cn) + "\n");
                            }
                        }
                        Connection.LineType cLineType = null;
                        switch (lt = cn.getString("lineType")) {
                            case "DIRECT": {
                                cLineType = Connection.LineType.DIRECT;
                                break;
                            }
                            case "WAVY": {
                                cLineType = Connection.LineType.WAVY;
                                break;
                            }
                            case "HELIX": {
                                cLineType = Connection.LineType.HELIX;
                                break;
                            }
                            default: {
                                this.log(LogScrollPane.lineType.ERROR, "***  Invalid line type " + lt + " in JSON object " + String.valueOf(cn) + "\n");
                            }
                        }
                        Connection.DashType cDashType = null;
                        switch (dt = cn.getString("dashType")) {
                            case "PLAIN": {
                                cDashType = Connection.DashType.PLAIN;
                                break;
                            }
                            case "DOT": {
                                cDashType = Connection.DashType.DOT;
                                break;
                            }
                            case "DASH": {
                                cDashType = Connection.DashType.DASH;
                                break;
                            }
                            case "DOT_DASH": {
                                cDashType = Connection.DashType.DOT_DASH;
                                break;
                            }
                            default: {
                                this.log(LogScrollPane.lineType.ERROR, "***  Invalid dash type " + dt + " in JSON object " + String.valueOf(cn) + "\n");
                            }
                        }
                        Boolean cArrowForward = cn.getBoolean("arrowForward");
                        Boolean cArrowBack = cn.getBoolean("arrowBack");
                        Boolean cCurve = cn.getBoolean("curve");
                        double cBezCtrlX = cn.getDouble("bezierCtrlX");
                        double cBezCtrlY = cn.getDouble("bezierCtrlY");
                        Boolean cShowAtSrc = cn.getBoolean("showAtSource");
                        double srcX = cn.getDouble("srcPosX");
                        double srcY = cn.getDouble("srcPosY");
                        Point2D.Double cSrcPos = new Point2D.Double(srcX, srcY);
                        Boolean cShowAtDst = cn.getBoolean("showAtDestination");
                        double dstX = cn.getDouble("dstPosX");
                        double dstY = cn.getDouble("dstPosY");
                        Point2D.Double cDstPos = new Point2D.Double(dstX, dstY);
                        if (cSrcLateDate != null && cSrcLateDate.isBefore(cSrcEarlyDate)) {
                            this.log(LogScrollPane.lineType.ERROR, "***  Connection source late date is before early date in " + String.valueOf(cn) + "\n");
                        }
                        if (cDstLateDate != null && cDstLateDate.isBefore(cDstEarlyDate)) {
                            this.log(LogScrollPane.lineType.ERROR, "***  Connection destination late date is before early date  in" + String.valueOf(cn) + "\n");
                        }
                        Connection newConnection = null;
                        if (this.lineErrors == 0) {
                            if (this.ourConnections.getConnectionByID(Connection.makeID(cSourceEvent.getName(), cIndex, cDestEvent.getName())) != null) {
                                this.log(LogScrollPane.lineType.ERROR, "***  Connection with the same ID already exists from " + cSourceEvent.getName() + " and " + cDestEvent.getName() + "in JSON object " + String.valueOf(newConnection) + "\n");
                            }
                            if (this.lineErrors == 0) {
                                newConnection = new Connection(cIndex, cName, cColor, cSourceEvent, cSrcEarlyDate, cSrcLateDate, cDestEvent, cDstEarlyDate, cDstLateDate, cLineType, cDashType, cArrowForward, cArrowBack, cCurve, cBezCtrlX, cBezCtrlY, cShowAtSrc, cSrcPos, cShowAtDst, cDstPos);
                                this.ourConnections.addConnection(newConnection);
                                String tagsRaw = cn.optString("tags");
                                if (tagsRaw != null && !tagsRaw.isBlank() && !tagsRaw.isEmpty()) {
                                    TagList cnTags = newConnection.getTags();
                                    String[] tags = tagsRaw.split(" ", -1);
                                    if (tags != null) {
                                        int j = 0;
                                        while (j < tags.length) {
                                            cnTags.addTag(tags[j]);
                                            this.masterTagList.addTag(tags[j]);
                                            ++j;
                                        }
                                    }
                                }
                                newConnection.setDescription(cn.optString("Description"));
                                JSONArray linksArray = cn.optJSONArray("links");
                                if (linksArray != null) {
                                    int j = 0;
                                    while (j < linksArray.length()) {
                                        JSONObject linkObject = linksArray.getJSONObject(j);
                                        String text = linkObject.getString("linkText");
                                        String url = linkObject.getString("linkURL");
                                        try {
                                            URI testURI = new URI(url);
                                            URL testURL = testURI.toURL();
                                            testURI = testURL.toURI();
                                        }
                                        catch (URISyntaxException urie) {
                                            this.log(LogScrollPane.lineType.ERROR, "*** Invalid URI " + url + " in JSON object " + String.valueOf(cn) + "\n");
                                        }
                                        catch (MalformedURLException urle) {
                                            this.log(LogScrollPane.lineType.ERROR, "*** Invalid URL " + url + " in JSON object " + String.valueOf(cn) + "\n");
                                        }
                                        newConnection.getLinks().add(new Link(text, url));
                                        ++j;
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                }
                tryingObject = "filters";
                JSONArray filters = new JSONArray(cdDataJSONObject.optJSONArray("filters"));
                int i = 0;
                while (i < filters.length()) {
                    JSONObject filterJ = filters.getJSONObject(i);
                    Filter filter = new Filter();
                    filter.setName(filterJ.getString("name"));
                    filter.setShowNoTags(filterJ.getBoolean("showNoTags"));
                    filter.setShowTimelines(filterJ.getBoolean("showTimelinsOfEvents"));
                    filter.setHideConnections(filterJ.getBoolean("hideConnections"));
                    filter.setHideCnNames(filterJ.getBoolean("hideConnectionNames"));
                    filter.setHideEmptyRows(filterJ.getBoolean("hideEmptyRows"));
                    filter.setDescription(filterJ.getString("description"));
                    JSONArray stages = new JSONArray(filterJ.getJSONArray("stages"));
                    int j = 0;
                    while (j < stages.length()) {
                        JSONObject stage = stages.getJSONObject(j);
                        FilterEditor.Logic lgc = FilterEditor.Logic.valueOf(stage.getString("logic"));
                        FilterEditor.Operation op = FilterEditor.Operation.valueOf(stage.getString("operation"));
                        TagList taglist = new TagList();
                        taglist.setTagListFromString(stage.getString("tags"));
                        filter.addStageSaved(lgc, op, taglist);
                        ++j;
                    }
                    SavedFilterData theData = this.ourGUI.getSavedFilterData();
                    theData.addSavedFilter(filter);
                    ++i;
                }
                tryingObject = "rows";
                JSONArray rows = new JSONArray(cdDataJSONObject.optJSONArray("rows"));
                if (rows.length() > 0) {
                    int newLast = rows.length() - this.ourRowData.getSize();
                    int i2 = 0;
                    while (i2 < newLast) {
                        this.ourRowData.appendRow(new Row());
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < rows.length()) {
                        JSONObject row = rows.getJSONObject(i2);
                        int idx = row.getInt("rowIndex");
                        if (idx > this.ourRowData.getSize()) {
                            this.log(LogScrollPane.lineType.ERROR, "*** Invalid row index " + idx + " in object " + String.valueOf(rows) + " for " + this.ourRowData.getSize() + " existing rows.\n");
                        }
                        boolean ke = row.getBoolean("keepEmpty");
                        this.ourRowData.getRowByIndex(idx).setKeepRowEmpty(ke);
                        ++i2;
                    }
                } else {
                    this.log(LogScrollPane.lineType.ERROR, "*** rows object is empty " + String.valueOf(rows) + "\n");
                }
                tryingObject = "exportHTML";
                JSONObject export = cdDataJSONObject.optJSONObject("exportHTML");
                if (export != null) {
                    String folder = export.getString("folder");
                    this.ourGUI.getHTMLDialog().setHTMLPrimaryPath(folder);
                    Boolean subs = export.getBoolean("subdirs");
                    this.ourGUI.getHTMLDialog().setHTMLSubdirs(subs);
                    Integer width = export.getInt("width");
                    this.ourGUI.getHTMLDialog().setHTMLWidth(width);
                }
                this.ourPrefs.setFontFields();
                if (this.prefsCount == 0) {
                    this.ourPrefs.setSavePrefsChoice(false);
                }
                this.ourPrefs.updatePaletteAfterRead();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.mainFrame, "Input File: IO Exception reading JSON file: " + e.getMessage());
                Boolean bl = false;
                try {
                    if (this.in != null) {
                        this.in.close();
                    }
                }
                catch (IOException f) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Input File: IO Exception closing JSON input file" + f.getMessage());
                    return false;
                }
                return bl;
            }
            catch (JSONException e) {
                JOptionPane.showMessageDialog(this.mainFrame, "Input File: IO Exception reading JSON file: " + e.getMessage() + " JSON-Object " + tryingObject);
                Boolean bl = false;
                try {
                    if (this.in != null) {
                        this.in.close();
                    }
                }
                catch (IOException f) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Input File: IO Exception closing JSON input file" + f.getMessage());
                    return false;
                }
                return bl;
            }
        }
        finally {
            try {
                if (this.in != null) {
                    this.in.close();
                }
            }
            catch (IOException f) {
                JOptionPane.showMessageDialog(this.mainFrame, "Input File: IO Exception closing JSON input file" + f.getMessage());
                return false;
            }
        }
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException f) {
            JOptionPane.showMessageDialog(this.mainFrame, "Input File: IO Exception closing input file" + f.getMessage());
            return false;
        }
        this.log(LogScrollPane.lineType.OK, "Completed with " + this.errorCount + " errors.\n");
        this.loggingScrollPane.endLog();
        if (!this.ourPrefs.getLogChoice() && this.errorCount == 0) {
            this.loggingScrollPane.dispose();
        }
        this.ourEventData.sortEventsByStart();
        int i = 0;
        while (i < this.ourEventData.getTotalNumberOfEvents()) {
            Event event = this.ourEventData.getEventByIndex(i);
            if (event.getEventType() == CommonData.EventType.TIMELINE_EVENT && event.getEventTimeline().getTlEventList() != null) {
                event.getEventTimeline().getTlEventList().sortEventsByStart();
            }
            ++i;
        }
        return true;
    }

    private void readJSONEvent(JSONObject ev) {
        JSONArray segmentsArray;
        CommonData.EventType eType = null;
        String eTypeString = ev.getString("type");
        switch (eTypeString.toUpperCase(Locale.ENGLISH)) {
            case "TIMELINE": {
                eType = CommonData.EventType.TIMELINE;
                break;
            }
            case "TIMELINE_EVENT": {
                eType = CommonData.EventType.TIMELINE_EVENT;
                break;
            }
            case "GENERAL_EVENT": {
                eType = CommonData.EventType.GENERAL_EVENT;
                break;
            }
            case "UNTIMED": {
                eType = CommonData.EventType.UNTIMED;
                break;
            }
            default: {
                this.log(LogScrollPane.lineType.ERROR, "*** Invalid event type in JSON object " + String.valueOf(ev) + "\n");
            }
        }
        String eName = ev.getString("name");
        String eColor = ev.getString("colour");
        if (!this.ourPrefs.getPalette().paletteColorExists(eColor)) {
            this.log(LogScrollPane.lineType.WARNING, "*** Event color " + eColor + " in JSON object " + String.valueOf(ev) + " not found in palette\n");
            eColor = this.ourPrefs.getPalette().getColorName(0);
        }
        LocalDate eStartDate = null;
        if (!eType.equals((Object)CommonData.EventType.UNTIMED)) {
            try {
                eStartDate = LocalDate.parse(ev.getString("earliestStartDate"), Utils.dayFormatter);
            }
            catch (DateTimeParseException f) {
                eStartDate = null;
            }
            if (eStartDate == null) {
                this.log(LogScrollPane.lineType.ERROR, "***  Invalid event early start date in JSON object " + String.valueOf(ev) + "\n");
            }
        }
        String lSD = ev.optString("latestStartDate");
        LocalDate lStartDate = null;
        if (lSD != null && !lSD.isEmpty()) {
            try {
                lStartDate = LocalDate.parse(lSD, Utils.dayFormatter);
            }
            catch (DateTimeParseException f) {
                lStartDate = null;
            }
            if (lStartDate == null) {
                this.log(LogScrollPane.lineType.ERROR, "***  Invalid event late start date in JSON object " + String.valueOf(ev) + "\n");
            }
        }
        String eED = ev.optString("earliestEndDate");
        LocalDate eEndDate = null;
        if (eED != null && !eED.isEmpty()) {
            try {
                eEndDate = LocalDate.parse(eED, Utils.dayFormatter);
            }
            catch (DateTimeParseException f) {
                eEndDate = null;
            }
            if (eEndDate == null) {
                this.log(LogScrollPane.lineType.ERROR, "***  Invalid event early end date in JSON object " + String.valueOf(ev) + "\n");
            }
        }
        String lED = ev.optString("latestEndDate");
        LocalDate lEndDate = null;
        if (lED != null && !lED.isEmpty()) {
            try {
                lEndDate = LocalDate.parse(lED, Utils.dayFormatter);
            }
            catch (DateTimeParseException f) {
                lEndDate = null;
            }
            if (lEndDate == null) {
                this.log(LogScrollPane.lineType.ERROR, "***  Invalid event late end date in JSON object " + String.valueOf(ev) + "\n");
            }
        }
        ImageIcon sIcon = null;
        String iconRaw = ev.optString("startIcon");
        if (iconRaw != null && !iconRaw.isBlank() && !iconRaw.isEmpty() && (sIcon = this.iconFromFile(iconRaw)) == null) {
            this.log(LogScrollPane.lineType.WARNING, "*** Invalid start icon in JSON object " + String.valueOf(ev) + "\n");
        }
        ImageIcon eIcon = null;
        if (eType.equals((Object)CommonData.EventType.TIMELINE) && (iconRaw = ev.optString("endIcon")) != null && !iconRaw.isBlank() && !iconRaw.isEmpty() && (eIcon = this.iconFromFile(iconRaw)) == null) {
            this.log(LogScrollPane.lineType.WARNING, "*** Invalid end icon in JSON object " + String.valueOf(ev) + "\n");
        }
        boolean firstFit = Boolean.parseBoolean(ev.optString("firstFit", "false"));
        if (lStartDate != null && eStartDate != null && lStartDate.isBefore(eStartDate)) {
            this.log(LogScrollPane.lineType.ERROR, "***  Event late start date is before early start in JSON object " + String.valueOf(ev) + "\n");
        }
        if (lEndDate != null && eEndDate != null && eEndDate != null && lEndDate.isBefore(eEndDate)) {
            this.log(LogScrollPane.lineType.ERROR, "***  Event late end date is before early end in JSON object " + String.valueOf(ev) + "\n");
        }
        if (eEndDate != null && eStartDate != null && eEndDate.isBefore(eStartDate)) {
            this.log(LogScrollPane.lineType.ERROR, "***  Event end date is before start in JSON object " + String.valueOf(ev) + "\n");
        }
        if (eEndDate != null && lStartDate != null && lStartDate != null && eEndDate.isBefore(lStartDate)) {
            this.log(LogScrollPane.lineType.ERROR, "***  Event end date is before late start in JSON object " + String.valueOf(ev) + "\n");
        }
        Event tmpEvent = new Event(eType, eName, eColor, 0, eStartDate, lStartDate, eEndDate, lEndDate, sIcon, eIcon, null);
        int sequenceNo = 0;
        if (eType == CommonData.EventType.UNTIMED) {
            sequenceNo = ev.getInt("untimedSequenceNo");
            if (eType.equals((Object)CommonData.EventType.UNTIMED)) {
                tmpEvent.setSequenceNo(sequenceNo);
            }
        }
        tmpEvent.setFirstFit(firstFit);
        if (eType.equals((Object)CommonData.EventType.TIMELINE) || eType.equals((Object)CommonData.EventType.GENERAL_EVENT)) {
            int evRowIdx = this.parseInteger(ev.optString("row"), "*** Invalid row in JSON object " + String.valueOf(ev) + "\n");
            if (evRowIdx == -1) {
                evRowIdx = this.ourRowData.getSize();
            }
            int j = this.ourRowData.getSize();
            while (j <= evRowIdx) {
                this.ourRowData.insertRow(new Row(), j);
                ++j;
            }
            this.ourRowData.addEventToRow(tmpEvent, this.ourPrefs.getRowMinXGap(), evRowIdx);
        }
        TagList evTags = tmpEvent.getTags();
        String[] tags = ev.optString("tags").split(" ", -1);
        if (tags != null) {
            int j = 0;
            while (j < tags.length) {
                evTags.addTag(tags[j]);
                this.masterTagList.addTag(tags[j]);
                ++j;
            }
        }
        tmpEvent.setDescription(ev.optString("description"));
        JSONArray linksArray = ev.optJSONArray("links");
        if (linksArray != null) {
            int j = 0;
            while (j < linksArray.length()) {
                JSONObject linkObject = linksArray.getJSONObject(j);
                String text = linkObject.getString("linkText");
                String url = linkObject.getString("linkURL");
                try {
                    URI testURI = new URI(url);
                    URL testURL = testURI.toURL();
                    testURI = testURL.toURI();
                }
                catch (URISyntaxException urie) {
                    this.log(LogScrollPane.lineType.ERROR, "*** Invalid URI in JSON object " + String.valueOf(linksArray) + "\n");
                }
                catch (MalformedURLException urle) {
                    this.log(LogScrollPane.lineType.ERROR, "*** Invalid URL in JSON object " + String.valueOf(linksArray) + "\n");
                }
                tmpEvent.getLinks().add(new Link(text, url));
                ++j;
            }
        }
        if (eType.equals((Object)CommonData.EventType.TIMELINE) && (segmentsArray = ev.optJSONArray("segments")) != null) {
            int j = 0;
            while (j < segmentsArray.length()) {
                String tmpSegBGinner;
                String tmpSegBGouterEnd;
                String tmpSegBGouterStart;
                JSONObject segmentObject = segmentsArray.getJSONObject(j);
                String tmpSegText = segmentObject.getString("text");
                String tmpSegFG = segmentObject.getString("colour");
                if (!tmpSegFG.equals("") && !this.ourPrefs.getPalette().paletteColorExists(tmpSegFG)) {
                    this.log(LogScrollPane.lineType.WARNING, "*** Segment foreground color " + tmpSegFG + "in JSON object " + String.valueOf(segmentObject) + " not found in palette\n");
                    tmpSegFG = this.ourPrefs.getPalette().getColorName(0);
                }
                if (!(tmpSegBGouterStart = segmentObject.optString("colourBGouterStart")).equals("") && !this.ourPrefs.getPalette().paletteColorExists(tmpSegBGouterStart)) {
                    this.log(LogScrollPane.lineType.WARNING, "*** Segment outer background start color " + tmpSegBGouterStart + "in JSON object " + String.valueOf(segmentObject) + " not found in palette\n");
                    tmpSegBGouterStart = this.ourPrefs.getPalette().getColorName(0);
                }
                if (!(tmpSegBGouterEnd = segmentObject.optString("colourBGouterEnd")).equals("") && !this.ourPrefs.getPalette().paletteColorExists(tmpSegBGouterEnd)) {
                    this.log(LogScrollPane.lineType.WARNING, "*** Segment outer background end color " + tmpSegBGouterEnd + "in JSON object " + String.valueOf(segmentObject) + " not found in palette\n");
                    tmpSegBGouterEnd = this.ourPrefs.getPalette().getColorName(0);
                }
                if (!(tmpSegBGinner = segmentObject.optString("colourBGinner")).equals("") && !this.ourPrefs.getPalette().paletteColorExists(tmpSegBGinner)) {
                    this.log(LogScrollPane.lineType.WARNING, "*** Segment inner background color " + tmpSegBGinner + "in JSON object " + String.valueOf(segmentObject) + " not found in palette\n");
                    tmpSegBGinner = this.ourPrefs.getPalette().getColorName(0);
                }
                LocalDate segEStartDate = null;
                try {
                    segEStartDate = LocalDate.parse(segmentObject.getString("earliestStartDate"), Utils.dayFormatter);
                }
                catch (DateTimeParseException f) {
                    segEStartDate = null;
                }
                if (segEStartDate == null) {
                    this.log(LogScrollPane.lineType.ERROR, "***  Invalid segment earliest start date in JSON object " + String.valueOf(segmentObject) + "\n");
                    segEStartDate = LocalDate.of(1000, 1, 1);
                }
                LocalDate segLStartDate = null;
                String segLSD = segmentObject.optString("latestStartDate");
                if (segLSD != null && !segLSD.isEmpty()) {
                    try {
                        segLStartDate = LocalDate.parse(segLSD, Utils.dayFormatter);
                    }
                    catch (DateTimeParseException f) {
                        segLStartDate = null;
                    }
                    if (segLStartDate == null) {
                        this.log(LogScrollPane.lineType.ERROR, "***  Invalid segment latest start date in JSON object " + String.valueOf(segmentObject) + "\n");
                        segLStartDate = LocalDate.of(1000, 1, 1);
                    }
                }
                String segEED = segmentObject.getString("earliestEndDate");
                LocalDate segEEndDate = null;
                try {
                    segEEndDate = LocalDate.parse(segEED, Utils.dayFormatter);
                }
                catch (DateTimeParseException f) {
                    segEEndDate = null;
                }
                if (segEEndDate == null) {
                    this.log(LogScrollPane.lineType.ERROR, "***  Invalid segment earliest end date in JSON object " + String.valueOf(segmentObject) + "\n");
                    segEEndDate = LocalDate.of(1010, 1, 1);
                }
                LocalDate segLEndDate = null;
                String segLED = segmentObject.optString("latestEndDate");
                if (segLED != null && !segLED.isEmpty()) {
                    try {
                        segLEndDate = LocalDate.parse(segLED, Utils.dayFormatter);
                    }
                    catch (DateTimeParseException f) {
                        segLEndDate = null;
                    }
                    if (segLEndDate == null) {
                        this.log(LogScrollPane.lineType.ERROR, "***  Invalid timeline latest end date in JSON object " + String.valueOf(segmentObject) + "\n");
                        segLEndDate = LocalDate.of(1000, 1, 1);
                    }
                }
                int segLine = 1;
                String tmpLine = segmentObject.optString("line", "1");
                if (!tmpLine.equals("") && !tmpLine.isEmpty()) {
                    segLine = this.parseInteger(tmpLine, "*** Invalid segment line number in JSON object " + String.valueOf(segmentObject) + "\n");
                }
                if (segLStartDate != null && segEStartDate != null && segLStartDate.isBefore(segEStartDate)) {
                    this.log(LogScrollPane.lineType.ERROR, "***  Segment late start date is before early start in JSON object " + String.valueOf(segmentObject) + "\n");
                }
                if (segLEndDate != null && segEEndDate != null && segLEndDate.isBefore(segEEndDate)) {
                    this.log(LogScrollPane.lineType.ERROR, "***  Segment late end date is before early end in JSON object " + String.valueOf(segmentObject) + "\n");
                }
                if (segEEndDate != null && segEStartDate != null && segEEndDate.isBefore(segEStartDate)) {
                    this.log(LogScrollPane.lineType.ERROR, "***  Segment end date is before start in JSON object " + String.valueOf(segmentObject) + "\n");
                }
                if (this.lineErrors == 0) {
                    Segment newSegment = new Segment(this.ourPrefs, tmpEvent, tmpSegText, tmpSegFG, tmpSegBGouterStart, tmpSegBGouterEnd, tmpSegBGinner, segEStartDate, segLStartDate, segEEndDate, segLEndDate, segLine);
                    if (tmpEvent.getTlSegmentList() == null) {
                        SegmentList newSegmentList = new SegmentList(tmpEvent);
                        tmpEvent.setTlSegmentList(newSegmentList);
                    }
                    tmpEvent.getTlSegmentList().addSegment(newSegment);
                }
                ++j;
            }
        }
        this.ourEventData.addEvent(tmpEvent);
        if (eType.equals((Object)CommonData.EventType.TIMELINE_EVENT)) {
            Event eTl = this.ourEventData.getEventByName(ev.getString("timelineOfTimelineEvent"));
            if (eTl == null) {
                this.log(LogScrollPane.lineType.ERROR, "***  Timeline reference in JSON object " + String.valueOf(ev) + " not found\n");
            } else {
                if (eTl.getTlEventList() == null) {
                    eTl.setTlEventList(new EventData());
                }
                eTl.getTlEventList().addEvent(tmpEvent);
                tmpEvent.setEventTimeline(eTl);
            }
        }
    }

    private ImageIcon iconFromFile(String name) {
        ImageIcon icon;
        Object iconPath = this.ourGUI.getPreferences().getIconsPath();
        if (((String)iconPath).equals("")) {
            iconPath = System.getProperty("user.home") + File.separator + "icons";
        }
        if ((icon = InputFileJSON.iconFromPathString((String)(iconPath = (String)iconPath + File.separator + name))) != null) {
            icon.getImage().flush();
        }
        return icon;
    }

    public static ImageIcon iconFromPathString(String path) {
        File f = new File(path);
        ImageIcon result = null;
        if (f.exists() && !f.isDirectory()) {
            ImageIcon icon = new ImageIcon(path);
            icon.setDescription(path);
            result = icon;
        }
        return result;
    }

    private void log(LogScrollPane.lineType error, String msg) {
        int newErrors = this.loggingScrollPane.logLine(error, msg);
        this.lineErrors += newErrors;
        this.errorCount += newErrors;
    }

    private int parseInteger(String in, String errorMsg) {
        try {
            return Integer.parseInt(in);
        }
        catch (NumberFormatException e) {
            this.log(LogScrollPane.lineType.ERROR, errorMsg);
            return 0;
        }
    }

    private double parseDouble(String in, String errorMsg) {
        try {
            return Double.parseDouble(in);
        }
        catch (NullPointerException | NumberFormatException e) {
            this.log(LogScrollPane.lineType.ERROR, errorMsg);
            return 0.0;
        }
    }

    private boolean parseBoolean(String in, String errorMsg) {
        if (!in.toLowerCase().equals("true") && !in.toLowerCase().equals("false")) {
            this.log(LogScrollPane.lineType.ERROR, errorMsg);
            return false;
        }
        Boolean result = Boolean.valueOf(in);
        if (result == null) {
            this.log(LogScrollPane.lineType.ERROR, errorMsg);
            return false;
        }
        return result;
    }
}

