/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.ConnectionData;
import culturalDynamics.Event;
import culturalDynamics.EventData;
import culturalDynamics.Filter;
import culturalDynamics.LogScrollPane;
import culturalDynamics.Preferences;
import culturalDynamics.TagList;
import culturalDynamics.cdGUI;
import java.io.BufferedReader;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

class InputFileCSV
extends JFrame {
    private static final long serialVersionUID = 1L;
    private String fileName;
    private BufferedReader in;
    private Integer inLineNo = 0;
    private int errorCount = 0;
    private int lineErrors = 0;
    private int prefsCount = 0;
    private LogScrollPane loggingScrollPane;
    private boolean colorFound = false;
    private String sep = "|";
    private InputFileCSV currentDataFile;
    private JFrame mainFrame;
    private cdGUI ourGUI;
    private EventData ourEventData = new EventData();
    private ConnectionData connections = new ConnectionData();
    private Filter filter;
    private int expectedNumFilters;
    private int actualNumFilters;
    private Preferences ourPrefs;
    private TagList masterTagList = new TagList();

    public InputFileCSV getOpenInputFile() {
        return this.currentDataFile;
    }

    InputFileCSV(cdGUI mainGUI) {
        this.currentDataFile = this;
        this.mainFrame = mainGUI.getMainWindow();
        this.ourGUI = mainGUI;
        this.ourPrefs = this.ourGUI.getPreferences();
        this.masterTagList = this.ourGUI.getMasterTags();
        this.masterTagList.initialiseList();
    }

    /*
     * Exception decompiling
     */
    public Boolean readDataFile(String inFileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileWoExt() {
        Path filePath = Paths.get(this.fileName, new String[0]);
        String fileWithoutFolder = filePath.getFileName().toString();
        String[] fileNameOnly = fileWithoutFolder.split("\\.");
        return fileNameOnly[0];
    }

    public EventData getEventData() {
        return this.ourEventData;
    }

    public List<Event> getTimelines() {
        return this.ourEventData.getListOfTimelines(false);
    }

    public List<Event> getEvents() {
        return this.ourEventData.getListOfEventsOnly(false);
    }

    public ConnectionData getConnections() {
        return this.connections;
    }

    private ImageIcon iconFromFile(String name) {
        ImageIcon icon;
        Object iconPath = this.ourGUI.getPreferences().getIconsPath();
        if (((String)iconPath).equals("")) {
            iconPath = System.getProperty("user.home") + File.separator + "icons";
        }
        if ((icon = this.iconFromPathString((String)(iconPath = (String)iconPath + File.separator + name))) != null) {
            icon.getImage().flush();
        }
        return icon;
    }

    private ImageIcon iconFromPathString(String path) {
        File f = new File(path);
        ImageIcon result = null;
        if (f.exists() && !f.isDirectory()) {
            ImageIcon icon = new ImageIcon(path);
            icon.setDescription(path);
            result = icon;
        }
        return result;
    }

    private void log(LogScrollPane.lineType error, String msg) {
        int newErrors = this.loggingScrollPane.logLine(error, msg);
        this.lineErrors += newErrors;
        this.errorCount += newErrors;
    }

    private int parseInteger(String in, String errorMsg) {
        try {
            return Integer.parseInt(in);
        }
        catch (NumberFormatException e) {
            this.log(LogScrollPane.lineType.ERROR, errorMsg);
            return 0;
        }
    }

    private double parseDouble(String in, String errorMsg) {
        try {
            return Double.parseDouble(in);
        }
        catch (NullPointerException | NumberFormatException e) {
            this.log(LogScrollPane.lineType.ERROR, errorMsg);
            return 0.0;
        }
    }

    private boolean parseBoolean(String in, String errorMsg) {
        if (!in.toLowerCase().equals("true") && !in.toLowerCase().equals("false")) {
            this.log(LogScrollPane.lineType.ERROR, errorMsg);
            return false;
        }
        Boolean result = Boolean.valueOf(in);
        if (result == null) {
            this.log(LogScrollPane.lineType.ERROR, errorMsg);
            return false;
        }
        return result;
    }
}

