/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.TagList;
import culturalDynamics.TagSelector;
import culturalDynamics.cdGUI;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class FilterStageEditor {
    private JRadioButton allButton;
    private JRadioButton anyButton;
    private JRadioButton noneButton;
    private ButtonGroup allAnyNoneGroup;
    private JRadioButton andButton;
    private JRadioButton orButton;
    private ButtonGroup andOrGroup;
    private JButton addBeforeButton = new JButton("Add Before");
    private JButton addAfterButton = new JButton("Add After");
    private JButton removeButton = new JButton("Remove");
    private TagSelector tagSelector;
    private JPanel stageEditorPanel;
    private FlowLayout flowLayoutCenter = new FlowLayout(1);
    private List<StageEditorListener> listeners = new ArrayList<StageEditorListener>();
    private cdGUI ourGUI;
    private ActionListener stageChangedListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FilterStageEditor.this.notifyStageEditorChanged((Component)e.getSource());
        }
    };

    FilterStageEditor(cdGUI mainGUI, TagList is, StageEditorListener sel) {
        this.ourGUI = mainGUI;
        this.listeners.add(sel);
        this.andButton = new JRadioButton("AND");
        this.andButton.setToolTipText("Show items that satisfy the previous stage AND this stage");
        this.orButton = new JRadioButton("OR");
        this.orButton.setToolTipText("Show items that satisfy the previous stage OR this stage");
        this.andOrGroup = new ButtonGroup();
        this.andOrGroup.add(this.andButton);
        this.andOrGroup.add(this.orButton);
        this.andButton.setSelected(true);
        this.allButton = new JRadioButton("All");
        this.allButton.setToolTipText("Show items that satisfy the previous stage AND this stage");
        this.anyButton = new JRadioButton("Any");
        this.noneButton = new JRadioButton("None");
        this.allAnyNoneGroup = new ButtonGroup();
        this.allAnyNoneGroup.add(this.allButton);
        this.allAnyNoneGroup.add(this.anyButton);
        this.allAnyNoneGroup.add(this.noneButton);
        this.anyButton.setSelected(true);
        this.andButton.addActionListener(this.stageChangedListener);
        this.orButton.addActionListener(this.stageChangedListener);
        this.allButton.addActionListener(this.stageChangedListener);
        this.anyButton.addActionListener(this.stageChangedListener);
        this.noneButton.addActionListener(this.stageChangedListener);
        this.addBeforeButton.addActionListener(this.stageChangedListener);
        this.addAfterButton.addActionListener(this.stageChangedListener);
        this.removeButton.addActionListener(this.stageChangedListener);
        JPanel addRemovePanel = new JPanel(this.flowLayoutCenter);
        addRemovePanel.add(this.addBeforeButton);
        addRemovePanel.add(this.addAfterButton);
        addRemovePanel.add(this.removeButton);
        this.tagSelector = new TagSelector(this.ourGUI, is, TagSelector.AllowDefine.NO_DEFINE);
        this.stageEditorPanel = new JPanel();
        this.stageEditorPanel.setLayout(new BoxLayout(this.stageEditorPanel, 1));
        JPanel logicButtonsPanel = new JPanel(this.flowLayoutCenter);
        logicButtonsPanel.add(this.andButton);
        logicButtonsPanel.add(this.orButton);
        logicButtonsPanel.add(new JLabel(" - "));
        logicButtonsPanel.add(this.allButton);
        logicButtonsPanel.add(this.anyButton);
        logicButtonsPanel.add(this.noneButton);
        logicButtonsPanel.add(new JLabel("of:"));
        this.stageEditorPanel.add(logicButtonsPanel);
        this.stageEditorPanel.add(addRemovePanel);
        this.stageEditorPanel.add(this.tagSelector);
    }

    public JRadioButton getAllButton() {
        return this.allButton;
    }

    public JRadioButton getAnyButton() {
        return this.anyButton;
    }

    public JRadioButton getNoneButton() {
        return this.noneButton;
    }

    public JRadioButton getAndButton() {
        return this.andButton;
    }

    public JRadioButton getOrButton() {
        return this.orButton;
    }

    public JButton getAddBeforeButton() {
        return this.addBeforeButton;
    }

    public JButton getAddAfterButton() {
        return this.addAfterButton;
    }

    public JButton getRemoveButton() {
        return this.removeButton;
    }

    public JPanel getTagLogicPanel() {
        return this.stageEditorPanel;
    }

    public TagSelector getTagSelector() {
        return this.tagSelector;
    }

    public JPanel getStageEditorPanel() {
        return this.stageEditorPanel;
    }

    private void notifyStageEditorChanged(Component src) {
        int i = 0;
        while (i < this.listeners.size()) {
            StageEditorListener hl = this.listeners.get(i);
            hl.stageEditorChanged(src);
            ++i;
        }
    }

    public static interface StageEditorListener {
        public void stageEditorChanged(Component var1);
    }
}

