/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.ActiveFilterStage;
import culturalDynamics.CommonData;
import culturalDynamics.ConnectionData;
import culturalDynamics.Event;
import culturalDynamics.EventData;
import culturalDynamics.Filter;
import culturalDynamics.FilterStageEditor;
import culturalDynamics.Row;
import culturalDynamics.RowData;
import culturalDynamics.SavedFilterData;
import culturalDynamics.TagList;
import culturalDynamics.cdGUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

class FilterEditor
extends JFrame {
    private static final long serialVersionUID = 1L;
    private cdGUI ourGUI;
    private JFrame filterEditorFrame;
    private Dimension buttonSmallSize = new Dimension(60, 20);
    private Dimension buttonMidSize = new Dimension(80, 20);
    private Dimension buttonLargeSize = new Dimension(120, 20);
    private FlowLayout flowLayoutLeft = new FlowLayout(0);
    private FlowLayout flowLayoutCenter = new FlowLayout(1);
    private boolean filterOn = true;
    private JCheckBox hideConnections = new JCheckBox("Hide connections", false);
    private JCheckBox hideCnNames = new JCheckBox("-names", false);
    private JCheckBox showWithNoTags = new JCheckBox("Show items with no tags", true);
    private JCheckBox showTimelinesOfEvents = new JCheckBox("Show timelines of events", true);
    private JCheckBox hideEmptyRows = new JCheckBox("Hide empty rows", true);
    private JButton buttonApply = new JButton("Apply");
    private JButton buttonTurnOff = new JButton("Turn Off");
    private JButton buttonOK = new JButton("OK");
    private JButton buttonClose = new JButton("Close");
    private JButton buttonNew = new JButton("New");
    private String currentLoadedName = "";
    private JList<String> filtersField;
    private JScrollPane filterListScroll;
    private JButton buttonDelete = new JButton("Delete");
    private JButton buttonUse = new JButton("Load and Apply");
    private JButton buttonRename = new JButton("Rename");
    private JTextField nameField = new JTextField(20);
    private JLabel loadedSetLabel = new JLabel("Loaded Filter: ");
    private JLabel loadedSet = new JLabel("(none)");
    private JButton buttonSave = new JButton("Save");
    private JButton buttonSaveAs = new JButton("Save as");
    private JTextField saveAsName = new JTextField(20);
    private String allowedNames = "[A-Za-z0-9_]*";
    private JLabel descriptionLabel = new JLabel("Description");
    private JTextField descriptionField = new JTextField(30);
    private SavedFilterData filters;
    private Filter currentFilter;
    private JPanel stagesEditorPanel = new JPanel();
    private JLabel changedLabel = new JLabel("");
    private String changedText = "Unsaved changes!";
    private ActionListener checkBoxNeedSaveListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FilterEditor.this.changedActions();
        }
    };

    FilterEditor(final cdGUI mainGUI) {
        this.ourGUI = mainGUI;
        this.filterEditorFrame = this;
        this.setPreferredSize(new Dimension(500, 750));
        this.initFilters(false);
        this.setTitle("Filter");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                FilterEditor.this.filterEditorFrame.setVisible(false);
            }

            @Override
            public void windowActivated(WindowEvent wa) {
                FilterEditor.this.filters = mainGUI.getSavedFilterData();
                FilterEditor.this.filters.sortFilters();
                String[] filterArray = FilterEditor.this.filters.getFilterNamesAsArray();
                if (FilterEditor.this.filters.getNumFilters() == 0) {
                    FilterEditor.this.buttonUse.setEnabled(false);
                    FilterEditor.this.buttonDelete.setEnabled(false);
                    FilterEditor.this.buttonRename.setEnabled(false);
                } else {
                    FilterEditor.this.buttonUse.setEnabled(true);
                    FilterEditor.this.buttonDelete.setEnabled(true);
                    FilterEditor.this.buttonRename.setEnabled(true);
                }
                FilterEditor.this.filtersField.setListData((String[])filterArray);
                if (FilterEditor.this.filtersField.getSelectedValue() == null) {
                    FilterEditor.this.nameField.setText("");
                }
                FilterEditor.this.rewriteStagesPanel();
                FilterEditor.this.revalidate();
                FilterEditor.this.repaint();
            }
        });
        LineBorder fPanelsBorder = new LineBorder(Color.lightGray, 3);
        JPanel controlPanel = new JPanel(new GridLayout(2, 2));
        this.hideConnections.setToolTipText("Hide all connections");
        this.hideCnNames.setToolTipText("Hide names of all connections");
        this.showWithNoTags.setToolTipText("Always show items that have no tags");
        this.hideEmptyRows.setToolTipText("Hide rows that have no content after filtering");
        this.showTimelinesOfEvents.setToolTipText("Show the timelines of timeline-events that are shown by filter");
        this.hideConnections.addActionListener(this.checkBoxNeedSaveListener);
        this.hideCnNames.addActionListener(this.checkBoxNeedSaveListener);
        this.showWithNoTags.addActionListener(this.checkBoxNeedSaveListener);
        this.hideEmptyRows.addActionListener(this.checkBoxNeedSaveListener);
        this.showTimelinesOfEvents.addActionListener(this.checkBoxNeedSaveListener);
        this.hideConnections.setSelected(false);
        this.hideCnNames.setSelected(false);
        this.showWithNoTags.setSelected(false);
        this.hideEmptyRows.setSelected(true);
        this.showTimelinesOfEvents.setSelected(false);
        this.hideConnections.setEnabled(false);
        this.hideCnNames.setEnabled(false);
        this.showWithNoTags.setEnabled(false);
        this.hideEmptyRows.setEnabled(false);
        this.showTimelinesOfEvents.setEnabled(false);
        this.buttonApply.setEnabled(false);
        this.buttonTurnOff.setEnabled(false);
        this.buttonOK.setEnabled(false);
        this.buttonClose.setEnabled(false);
        this.buttonNew.setEnabled(true);
        JPanel cnPanel = new JPanel(this.flowLayoutLeft);
        cnPanel.add(this.hideConnections);
        cnPanel.add(this.hideCnNames);
        controlPanel.add(cnPanel);
        controlPanel.add(this.showWithNoTags);
        controlPanel.add(this.hideEmptyRows);
        controlPanel.add(this.showTimelinesOfEvents);
        this.changedLabel.setForeground(Color.RED);
        JPanel mainButtonsPanel = new JPanel(this.flowLayoutCenter);
        this.buttonApply.setToolTipText("Apply the filter and leave the window open");
        this.buttonApply.setPreferredSize(this.buttonMidSize);
        this.buttonApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent apply) {
                FilterEditor.this.setFilterOn(true);
                FilterEditor.this.applyOKActions();
            }
        });
        this.buttonTurnOff.setToolTipText("Turn the filter off");
        this.buttonTurnOff.setPreferredSize(this.buttonLargeSize);
        this.buttonTurnOff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent turnOff) {
                FilterEditor.this.hideConnections.setSelected(false);
                FilterEditor.this.hideCnNames.setSelected(false);
                FilterEditor.this.setFilterOn(false);
                FilterEditor.this.applyOKActions();
            }
        });
        this.buttonOK.setToolTipText("Apply the filter and close the window");
        this.buttonOK.setPreferredSize(this.buttonSmallSize);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ok) {
                FilterEditor.this.setFilterOn(true);
                FilterEditor.this.applyOKActions();
                FilterEditor.this.filterEditorFrame.setVisible(false);
            }
        });
        this.buttonClose.setToolTipText("Close the window");
        this.buttonClose.setPreferredSize(this.buttonMidSize);
        this.buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent can) {
                FilterEditor.this.filterEditorFrame.setVisible(false);
            }
        });
        this.buttonNew.setToolTipText("Make a new filter");
        this.buttonNew.setPreferredSize(this.buttonSmallSize);
        this.buttonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent n) {
                FilterEditor.this.initFilters(false);
                FilterEditor.this.currentFilter.addStageActive(mainGUI, Logic.NOP, Operation.ANY, null, new StageChangeListener());
                FilterEditor.this.rewriteStagesPanel();
                FilterEditor.this.currentLoadedName = "";
                FilterEditor.this.changedLabel.setText("");
                FilterEditor.this.buttonSaveAs.setEnabled(false);
                FilterEditor.this.loadedSet.setText("(none)");
                FilterEditor.this.buttonSave.setEnabled(false);
                FilterEditor.this.setFilterOn(false);
                FilterEditor.this.enableMainWidgets();
                mainGUI.setRange();
                mainGUI.panLimits();
                mainGUI.setViewportTopLeft();
                FilterEditor.this.filterEditorFrame.revalidate();
                FilterEditor.this.filterEditorFrame.repaint();
                FilterEditor.this.applyOKActions();
            }
        });
        mainButtonsPanel.add(this.buttonNew);
        mainButtonsPanel.add(this.buttonApply);
        mainButtonsPanel.add(this.buttonOK);
        mainButtonsPanel.add(this.buttonTurnOff);
        mainButtonsPanel.add(this.buttonClose);
        Box topPanel = Box.createVerticalBox();
        topPanel.add(controlPanel);
        topPanel.add(mainButtonsPanel);
        Box stagesPanel = Box.createVerticalBox();
        TitledBorder stagesTitle = new TitledBorder(fPanelsBorder, "Filter Stages", 1, 2);
        stagesPanel.setBorder(stagesTitle);
        JScrollPane tagsScroll = new JScrollPane(this.stagesEditorPanel);
        tagsScroll.setVerticalScrollBarPolicy(20);
        stagesPanel.add(tagsScroll);
        this.initFilters(true);
        this.stagesEditorPanel.setLayout(new BoxLayout(this.stagesEditorPanel, 1));
        this.rewriteStagesPanel();
        this.filters = mainGUI.getSavedFilterData();
        String[] filterArray = this.filters.getFilterNamesAsArray();
        this.filtersField = new JList<String>(filterArray);
        this.filtersField.setSelectionMode(0);
        this.filterListScroll = new JScrollPane();
        this.filterListScroll.setViewportView(this.filtersField);
        this.filterListScroll.setVerticalScrollBarPolicy(20);
        this.filterListScroll.setHorizontalScrollBarPolicy(30);
        this.filtersField.setLayoutOrientation(0);
        this.filtersField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (FilterEditor.this.filters.getNumFilters() == 0) {
                    return;
                }
                if (me.getClickCount() == 2) {
                    FilterEditor.this.useFilterActions();
                }
                FilterEditor.this.buttonRename.setEnabled(true);
                FilterEditor.this.buttonDelete.setEnabled(true);
                String selectedFilterName = FilterEditor.this.filtersField.getSelectedValue();
                if (selectedFilterName == null) {
                    selectedFilterName = "";
                }
                FilterEditor.this.nameField.setText(selectedFilterName);
                FilterEditor.this.descriptionField.setText(FilterEditor.this.filters.getSavedFilterByName(selectedFilterName).getDescription());
            }
        });
        this.buttonDelete.setToolTipText("Delete the selected saved filter");
        this.buttonDelete.setPreferredSize(this.buttonMidSize);
        this.buttonDelete.setEnabled(false);
        this.buttonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent d) {
                String selectedFilterName = FilterEditor.this.filtersField.getSelectedValue();
                if (selectedFilterName == null) {
                    return;
                }
                FilterEditor.this.filters.removeSavedFilterByName(selectedFilterName);
                if (selectedFilterName.equals(FilterEditor.this.currentLoadedName)) {
                    FilterEditor.this.currentLoadedName = "";
                    FilterEditor.this.loadedSet.setText("(none)");
                    FilterEditor.this.buttonSave.setEnabled(false);
                }
                String[] filterArray = FilterEditor.this.filters.getFilterNamesAsArray();
                FilterEditor.this.filtersField.setListData((String[])filterArray);
                mainGUI.setFileSaved(false);
                if (FilterEditor.this.filters.getNumFilters() == 0) {
                    FilterEditor.this.buttonUse.setEnabled(false);
                    FilterEditor.this.buttonDelete.setEnabled(false);
                    FilterEditor.this.buttonRename.setEnabled(false);
                }
                FilterEditor.this.filterEditorFrame.revalidate();
                FilterEditor.this.filterEditorFrame.repaint();
            }
        });
        this.buttonUse.setToolTipText("Use the selected filter - or you can double-click on its name");
        this.buttonUse.setPreferredSize(this.buttonLargeSize);
        this.buttonUse.setEnabled(false);
        this.buttonUse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent u) {
                if (FilterEditor.this.filtersField.getModel().getSize() == 0) {
                    return;
                }
                FilterEditor.this.useFilterActions();
            }
        });
        this.buttonRename.setToolTipText("Rename the selected saved filter to the name in the field");
        this.buttonRename.setPreferredSize(this.buttonLargeSize);
        this.buttonRename.setEnabled(false);
        this.buttonRename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent r) {
                if (FilterEditor.this.nameField.getText().isEmpty() || FilterEditor.this.nameField.getText() == "") {
                    JOptionPane.showMessageDialog(FilterEditor.this.filterEditorFrame, "Filter Selector: new name cannot be blank");
                    return;
                }
                if (FilterEditor.this.filters.getSavedFilterByName(FilterEditor.this.nameField.getText()) != null) {
                    JOptionPane.showMessageDialog(FilterEditor.this.filterEditorFrame, "Filter Selector: new name is already in use");
                    return;
                }
                if (!FilterEditor.this.nameField.getText().substring(1).matches(FilterEditor.this.allowedNames)) {
                    JOptionPane.showMessageDialog(FilterEditor.this.filterEditorFrame, "Filter Editor: name may only contain letters and numbers and underline");
                    return;
                }
                String tmp = FilterEditor.this.filtersField.getSelectedValue();
                if (tmp == null) {
                    return;
                }
                SavedFilterData ourFilterData = mainGUI.getSavedFilterData();
                Filter ourFilter = ourFilterData.getSavedFilterByName(tmp);
                ourFilter.setName(FilterEditor.this.nameField.getText());
                ourFilterData.sortFilters();
                String[] filterArray = ourFilterData.getFilterNamesAsArray();
                FilterEditor.this.filtersField.setListData((String[])filterArray);
                if (tmp.equals(FilterEditor.this.currentLoadedName)) {
                    FilterEditor.this.currentLoadedName = FilterEditor.this.nameField.getText();
                    FilterEditor.this.loadedSet.setText(FilterEditor.this.nameField.getText());
                }
                FilterEditor.this.nameField.setText("");
                FilterEditor.this.filterEditorFrame.revalidate();
                FilterEditor.this.filterEditorFrame.repaint();
                mainGUI.setFileSaved(false);
            }
        });
        this.buttonSave.setToolTipText("Save the changes to the current filter");
        this.buttonSave.setPreferredSize(this.buttonMidSize);
        this.buttonSave.setEnabled(false);
        this.buttonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent s) {
                if (FilterEditor.this.currentLoadedName == "") {
                    JOptionPane.showMessageDialog(FilterEditor.this.filterEditorFrame, "Filter Editor: no filter is currently loaded - use Save as");
                    return;
                }
                SavedFilterData ourFilterData = mainGUI.getSavedFilterData();
                Filter ourFilter = ourFilterData.getSavedFilterByName(FilterEditor.this.currentLoadedName);
                ourFilter.setDescription(FilterEditor.this.descriptionField.getText());
                ourFilter.setShowNoTags(FilterEditor.this.showWithNoTags.isSelected());
                ourFilter.setShowTimelines(FilterEditor.this.showTimelinesOfEvents.isSelected());
                ourFilter.setHideConnections(FilterEditor.this.hideConnections.isSelected());
                ourFilter.setHideCnNames(FilterEditor.this.hideCnNames.isSelected());
                ourFilter.setHideEmptyRows(FilterEditor.this.hideEmptyRows.isSelected());
                ourFilter.clearStages();
                int i = 0;
                while (i < FilterEditor.this.currentFilter.getNumFilterStages()) {
                    ourFilter.addStageSaved(FilterEditor.this.getLogicEnum(i), FilterEditor.this.getOperationEnum(i), FilterEditor.this.currentFilter.getFilterStageActive(i).getTags());
                    ++i;
                }
                ourFilterData.replaceSavedFilter(ourFilter);
                FilterEditor.this.changedLabel.setText("");
            }
        });
        this.buttonSaveAs.setToolTipText("Save these filter settings under a new name");
        this.buttonSaveAs.setPreferredSize(this.buttonMidSize);
        this.buttonSaveAs.setEnabled(false);
        this.buttonSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ok) {
                if (FilterEditor.this.saveAsName.getText().isEmpty() || FilterEditor.this.saveAsName.getText() == "") {
                    JOptionPane.showMessageDialog(FilterEditor.this.filterEditorFrame, "Filter Editor: enter a new name in the field first");
                    return;
                }
                if (mainGUI.getSavedFilterData().getSavedFilterByName(FilterEditor.this.saveAsName.getText()) != null) {
                    JOptionPane.showMessageDialog(FilterEditor.this.filterEditorFrame, "Filter Editor: that name is already in use");
                    return;
                }
                if (FilterEditor.this.saveAsName.getText().length() < 1 || !FilterEditor.this.saveAsName.getText().substring(1).matches(FilterEditor.this.allowedNames)) {
                    JOptionPane.showMessageDialog(FilterEditor.this.filterEditorFrame, "Filter Editor: name may only contain letters and numbers and underline");
                    return;
                }
                SavedFilterData ourFilterData = mainGUI.getSavedFilterData();
                Filter ourFilter = new Filter();
                ourFilter.setName(FilterEditor.this.saveAsName.getText());
                ourFilter.setDescription(FilterEditor.this.descriptionField.getText());
                ourFilter.setShowNoTags(FilterEditor.this.showWithNoTags.isSelected());
                ourFilter.setShowTimelines(FilterEditor.this.showTimelinesOfEvents.isSelected());
                ourFilter.setHideConnections(FilterEditor.this.hideConnections.isSelected());
                ourFilter.setHideCnNames(FilterEditor.this.hideCnNames.isSelected());
                ourFilter.setHideEmptyRows(FilterEditor.this.hideEmptyRows.isSelected());
                int i = 0;
                while (i < FilterEditor.this.currentFilter.getNumFilterStages()) {
                    TagList tmpTagList = new TagList();
                    tmpTagList = FilterEditor.this.currentFilter.getFilterStageActive(i).getTags().getCopyOfTags();
                    ourFilter.addStageSaved(FilterEditor.this.getLogicEnum(i), FilterEditor.this.getOperationEnum(i), tmpTagList);
                    ++i;
                }
                ourFilterData.addSavedFilter(ourFilter);
                ourFilterData.sortFilters();
                FilterEditor.this.currentLoadedName = FilterEditor.this.saveAsName.getText();
                FilterEditor.this.loadedSet.setText(FilterEditor.this.currentLoadedName);
                String[] filterArray = FilterEditor.this.filters.getFilterNamesAsArray();
                FilterEditor.this.filtersField.setListData((String[])filterArray);
                FilterEditor.this.saveAsName.setText("");
                FilterEditor.this.changedLabel.setText("");
                FilterEditor.this.buttonSave.setEnabled(true);
                FilterEditor.this.buttonUse.setEnabled(true);
                FilterEditor.this.filterEditorFrame.revalidate();
                FilterEditor.this.filterEditorFrame.repaint();
            }
        });
        this.saveAsName.setToolTipText("Enter the name for the Save as");
        this.saveAsName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (FilterEditor.this.saveAsName.getText().isEmpty() || FilterEditor.this.saveAsName.getText().equals("")) {
                    FilterEditor.this.buttonSaveAs.setEnabled(false);
                    FilterEditor.this.buttonSave.setEnabled(true);
                } else {
                    FilterEditor.this.buttonSave.setEnabled(false);
                    FilterEditor.this.buttonSaveAs.setEnabled(true);
                }
            }
        });
        this.descriptionField.setToolTipText("Enter a description of the filter");
        this.descriptionField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent f) {
            }

            @Override
            public void focusLost(FocusEvent f) {
                if (!FilterEditor.this.currentLoadedName.equals("") && !FilterEditor.this.descriptionField.getText().equals(mainGUI.getSavedFilterData().getSavedFilterByName(FilterEditor.this.currentLoadedName).getDescription())) {
                    FilterEditor.this.changedActions();
                }
            }
        });
        JPanel loadedPanel = new JPanel(this.flowLayoutLeft);
        loadedPanel.add(this.loadedSetLabel);
        loadedPanel.add(this.loadedSet);
        loadedPanel.add(this.changedLabel);
        JPanel descriptionPanel = new JPanel(this.flowLayoutLeft);
        descriptionPanel.add(this.descriptionLabel);
        descriptionPanel.add(this.descriptionField);
        JPanel saPanel = new JPanel(this.flowLayoutLeft);
        saPanel.add(this.buttonSaveAs);
        saPanel.add(this.saveAsName);
        saPanel.add(this.buttonSave);
        Box savedPanel = Box.createVerticalBox();
        TitledBorder savedTitle = new TitledBorder(fPanelsBorder, "Save Filter", 1, 2);
        savedPanel.setBorder(savedTitle);
        savedPanel.add(loadedPanel);
        savedPanel.add(descriptionPanel);
        savedPanel.add(saPanel);
        JPanel renamePanel = new JPanel(this.flowLayoutLeft);
        renamePanel.add(this.nameField);
        renamePanel.add(this.buttonRename);
        renamePanel.add(this.buttonDelete);
        Box usePanel = Box.createVerticalBox();
        TitledBorder useTitle = new TitledBorder(fPanelsBorder, "Use/Manage Filters", 1, 2);
        usePanel.setBorder(useTitle);
        usePanel.add(this.filterListScroll);
        usePanel.add(this.buttonUse);
        usePanel.add(renamePanel);
        Box totalPanel = Box.createVerticalBox();
        totalPanel.add(topPanel);
        totalPanel.add(stagesPanel);
        totalPanel.add(savedPanel);
        totalPanel.add(usePanel);
        this.add(totalPanel);
        this.pack();
    }

    private void enableMainWidgets() {
        this.hideConnections.setEnabled(true);
        this.hideCnNames.setEnabled(true);
        this.showWithNoTags.setEnabled(true);
        this.hideEmptyRows.setEnabled(true);
        this.showTimelinesOfEvents.setEnabled(true);
        this.buttonApply.setEnabled(true);
        this.buttonTurnOff.setEnabled(true);
        this.buttonOK.setEnabled(true);
        this.buttonClose.setEnabled(true);
    }

    private void applyOKActions() {
        this.doFilter();
        this.ourGUI.setRange();
        this.ourGUI.panLimits();
        this.ourGUI.setViewportTopLeft();
        this.ourGUI.getTimePanel().setSize(this.getSize());
        this.ourGUI.getTimePanel().revalidate();
        this.ourGUI.getTimePanel().repaint();
    }

    private void useFilterActions() {
        String selectedFilterName = this.filtersField.getSelectedValue();
        if (selectedFilterName == null) {
            return;
        }
        this.replaceFilterStages(this.filters.getSavedFilterByName(selectedFilterName));
        this.changedLabel.setText("");
        this.buttonSave.setEnabled(true);
        this.setFilterOn(true);
        this.doFilter();
        this.enableMainWidgets();
        this.filterEditorFrame.revalidate();
        this.filterEditorFrame.repaint();
        this.filterEditorFrame.pack();
        this.ourGUI.setRange();
        this.ourGUI.panLimits();
        this.ourGUI.setViewportTopLeft();
        this.ourGUI.getTimePanel().setSize(this.getSize());
        this.ourGUI.getTimePanel().revalidate();
        this.ourGUI.getTimePanel().repaint();
    }

    private void changedActions() {
        this.changedLabel.setText(this.changedText);
        this.ourGUI.setFileSaved(false);
        this.buttonSave.setEnabled(true);
    }

    private Operation getOperationEnum(int idx) {
        Operation result = null;
        if (this.currentFilter.getFilterStageActive(idx).getFilterStageEditor().getAllButton().isSelected()) {
            result = Operation.ALL;
        } else if (this.currentFilter.getFilterStageActive(idx).getFilterStageEditor().getAnyButton().isSelected()) {
            result = Operation.ANY;
        } else if (this.currentFilter.getFilterStageActive(idx).getFilterStageEditor().getNoneButton().isSelected()) {
            result = Operation.NONE;
        }
        return result;
    }

    private Logic getLogicEnum(int idx) {
        Logic result = null;
        if (idx == 0) {
            result = Logic.NOP;
        } else if (this.currentFilter.getFilterStageActive(idx).getFilterStageEditor().getAndButton().isSelected()) {
            result = Logic.AND;
        } else if (this.currentFilter.getFilterStageActive(idx).getFilterStageEditor().getOrButton().isSelected()) {
            result = Logic.OR;
        }
        return result;
    }

    private void replaceFilterStages(Filter newFilter) {
        this.initFilters(false);
        this.currentFilter.setName(newFilter.getName());
        this.currentFilter.setDescription(newFilter.getDescription());
        int activeFilterStages = newFilter.getNumFilterStages();
        this.showWithNoTags.setSelected(newFilter.isShowNoTags());
        this.showTimelinesOfEvents.setSelected(newFilter.isShowTimelines());
        this.hideConnections.setSelected(newFilter.isHideConnections());
        this.hideCnNames.setSelected(newFilter.isHideCnNames());
        this.hideEmptyRows.setSelected(newFilter.isHideEmptyRows());
        int i = 0;
        while (i < activeFilterStages) {
            ActiveFilterStage tmpActStage = new ActiveFilterStage(this.ourGUI, newFilter.getFilterStageSaved(i).getLogic(), newFilter.getFilterStageSaved(i).getOperation(), newFilter.getFilterStageSaved(i).getTags(), new StageChangeListener());
            this.currentFilter.addStage(tmpActStage);
            ++i;
        }
        this.rewriteStagesPanel();
        this.loadedSet.setText(newFilter.getName());
        this.currentLoadedName = newFilter.getName();
        this.filterEditorFrame.revalidate();
        this.filterEditorFrame.repaint();
    }

    private void rewriteStagesPanel() {
        this.stagesEditorPanel.removeAll();
        int i = 0;
        while (i < this.currentFilter.getNumFilterStages()) {
            this.stagesEditorPanel.add(this.currentFilter.getFilterStageActive(i).getFilterStageEditorPanel());
            ++i;
        }
    }

    private void initFilters(boolean withSaved) {
        this.currentFilter = new Filter();
        this.showWithNoTags.setSelected(true);
        this.showTimelinesOfEvents.setSelected(true);
        this.hideConnections.setSelected(false);
        this.hideCnNames.setSelected(false);
        this.hideEmptyRows.setSelected(true);
        this.saveAsName.setText("");
        this.changedLabel.setText("");
        this.descriptionField.setText("");
        if (withSaved) {
            this.filters = this.ourGUI.getSavedFilterData();
            this.filters.clearFilterData();
        }
    }

    private boolean filterTags(String[] objectTags) {
        if (this.filterOn && (objectTags.length != 0 || objectTags.length == 0 && !this.showWithNoTags.isSelected())) {
            boolean[] result = new boolean[this.currentFilter.getNumFilterStages()];
            int filterIdx = 0;
            while (filterIdx < this.currentFilter.getNumFilterStages()) {
                String[] filterTagsArray = this.currentFilter.getFilterStageActive(filterIdx).getTags().getTagsAsArray();
                result[filterIdx] = true;
                if (filterTagsArray.length != 0) {
                    if (this.currentFilter.getFilterStageActive(filterIdx).getFilterStageEditor().getAllButton().isSelected()) {
                        result[filterIdx] = true;
                        filterTagIdx = 0;
                        while (filterTagIdx < filterTagsArray.length) {
                            filterTag = filterTagsArray[filterTagIdx];
                            boolean found = false;
                            int k = 0;
                            while (k < objectTags.length) {
                                if (filterTag.equals(objectTags[k])) {
                                    found = true;
                                }
                                ++k;
                            }
                            if (!found) {
                                result[filterIdx] = false;
                                break;
                            }
                            ++filterTagIdx;
                        }
                    } else if (this.currentFilter.getFilterStageActive(filterIdx).getFilterStageEditor().getAnyButton().isSelected()) {
                        result[filterIdx] = false;
                        filterTagIdx = 0;
                        while (filterTagIdx < filterTagsArray.length) {
                            filterTag = filterTagsArray[filterTagIdx];
                            k = 0;
                            while (k < objectTags.length) {
                                if (filterTag.equals(objectTags[k])) {
                                    result[filterIdx] = true;
                                    break;
                                }
                                ++k;
                            }
                            ++filterTagIdx;
                        }
                    } else {
                        result[filterIdx] = true;
                        filterTagIdx = 0;
                        while (filterTagIdx < filterTagsArray.length) {
                            filterTag = filterTagsArray[filterTagIdx];
                            k = 0;
                            while (k < objectTags.length) {
                                if (filterTag.equals(objectTags[k])) {
                                    result[filterIdx] = false;
                                    break;
                                }
                                ++k;
                            }
                            ++filterTagIdx;
                        }
                    }
                }
                ++filterIdx;
            }
            boolean combinedResult = result[0];
            if (this.currentFilter.getNumFilterStages() > 1) {
                int filterIdx2 = 1;
                while (filterIdx2 < this.currentFilter.getNumFilterStages()) {
                    combinedResult = this.currentFilter.getFilterStageActive(filterIdx2).getFilterStageEditor().getAndButton().isSelected() ? (combinedResult &= result[filterIdx2]) : (combinedResult |= result[filterIdx2]);
                    ++filterIdx2;
                }
            }
            return combinedResult;
        }
        return true;
    }

    public void fileNewOpen() {
        this.initFilters(true);
        this.loadedSet.setText("");
        this.descriptionField.setText("");
        this.hideConnections.setEnabled(false);
        this.hideCnNames.setEnabled(false);
        this.showWithNoTags.setEnabled(false);
        this.hideEmptyRows.setEnabled(false);
        this.showTimelinesOfEvents.setEnabled(false);
        this.buttonApply.setEnabled(false);
        this.buttonTurnOff.setEnabled(false);
        this.buttonOK.setEnabled(false);
        this.buttonClose.setEnabled(false);
        this.buttonNew.setEnabled(true);
        this.setFilterOn(false);
    }

    public void applyGivenFilter(Filter inFilter) {
        if (inFilter != null) {
            this.replaceFilterStages(inFilter);
        } else {
            this.initFilters(false);
        }
        this.setFilterOn(true);
        this.doFilter();
        this.ourGUI.setRange();
        this.ourGUI.panLimits();
        this.ourGUI.setViewportTopLeft();
        this.ourGUI.getTimePanel().setSize(this.getSize());
        this.ourGUI.getTimePanel().revalidate();
        this.ourGUI.getTimePanel().repaint();
    }

    public void doFilter() {
        Event tmpTl;
        if (this.currentFilter.getNumFilterStages() == 0) {
            return;
        }
        EventData ourEventData = this.ourGUI.getInput().getEventData();
        int evIdx = 0;
        while (evIdx < ourEventData.getTotalNumberOfEvents()) {
            if (ourEventData.getEventByIndex(evIdx).getTags() != null) {
                String[] evTags = ourEventData.getEventByIndex(evIdx).getTags().getTagsAsArray();
                ourEventData.getEventByIndex(evIdx).setShown(this.filterTags(evTags));
            } else {
                ourEventData.getEventByIndex(evIdx).setShown(true);
            }
            ++evIdx;
        }
        List<Event> tmpTlList = ourEventData.getListOfTimelines(false);
        int tlIdx = 0;
        while (tlIdx < ourEventData.getNumberOfTimelines()) {
            tmpTl = tmpTlList.get(tlIdx);
            if (tmpTl.getTlEventList() != null) {
                boolean showTl = false;
                int tlEvIdx = 0;
                while (tlEvIdx < tmpTl.getTlEventList().getTotalNumberOfEvents()) {
                    Event tmpTlEv = tmpTl.getTlEventList().getEventByIndex(tlEvIdx);
                    if (this.showTimelinesOfEvents.isSelected() && tmpTlEv.isShown()) {
                        showTl = true;
                        break;
                    }
                    ++tlEvIdx;
                }
                if (showTl) {
                    tmpTl.setShown(true);
                }
            }
            ++tlIdx;
        }
        tlIdx = 0;
        while (tlIdx < ourEventData.getNumberOfTimelines()) {
            tmpTl = tmpTlList.get(tlIdx);
            if (!tmpTl.isShown() && tmpTl.getTlEventList() != null) {
                int tlEvIdx = 0;
                while (tlEvIdx < tmpTl.getTlEventList().getTotalNumberOfEvents()) {
                    Event tmpTlEv = tmpTl.getTlEventList().getEventByIndex(tlEvIdx);
                    tmpTlEv.setShown(false);
                    ++tlEvIdx;
                }
            }
            ++tlIdx;
        }
        ConnectionData cnData = this.ourGUI.getInput().getConnections();
        int cnIdx = 0;
        while (cnIdx < cnData.getNumberOfConnections()) {
            boolean endsShown = true;
            if (this.hideConnections.isSelected()) {
                cnData.getConnection(cnIdx).setShown(false);
            } else {
                cnData.getConnection(cnIdx).setShown(true);
                if (!cnData.getConnection(cnIdx).getSourceEvent().isShown() || cnData.getConnection(cnIdx).getSourceEvent().getEventType().equals((Object)CommonData.EventType.TIMELINE_EVENT) && !cnData.getConnection(cnIdx).getSourceEvent().getEventTimeline().isShown()) {
                    endsShown = false;
                }
                if (!cnData.getConnection(cnIdx).getDestEvent().isShown() || cnData.getConnection(cnIdx).getDestEvent().getEventType().equals((Object)CommonData.EventType.TIMELINE_EVENT) && !cnData.getConnection(cnIdx).getDestEvent().getEventTimeline().isShown()) {
                    endsShown = false;
                }
                String[] cnTags = cnData.getConnection(cnIdx).getTags().getTagsAsArray();
                boolean filterShown = this.filterTags(cnTags);
                cnData.getConnection(cnIdx).setShown(endsShown && filterShown);
            }
            ++cnIdx;
        }
        RowData rowData = this.ourGUI.getRowData();
        int currentRowIdx = 0;
        while (currentRowIdx < rowData.getSize()) {
            Row currentRow = rowData.getRowByIndex(currentRowIdx);
            if (this.hideEmptyRows.isSelected() && currentRow.isRowFilteredEmpty()) {
                currentRow.setShown(false);
                currentRow.setNameBounds(null);
            } else {
                currentRow.setShown(true);
            }
            ++currentRowIdx;
        }
    }

    public boolean isFilterOn() {
        return this.filterOn;
    }

    public void setFilterOn(boolean f) {
        this.filterOn = f;
        if (f) {
            this.ourGUI.setFilterStatus(this.currentLoadedName);
        } else {
            this.ourGUI.setFilterStatus(null);
        }
    }

    public boolean isHideConnections() {
        return this.hideConnections.isSelected();
    }

    public boolean isHideCnNames() {
        return this.hideCnNames.isSelected();
    }

    public boolean isHideEmptyRows() {
        return this.hideEmptyRows.isSelected();
    }

    public Filter getActiveFilter() {
        return this.currentFilter;
    }

    public void savedFilterChanged() {
        this.changedLabel.setText(this.changedText);
        this.ourGUI.setFileSaved(false);
        this.buttonSave.setEnabled(true);
    }

    public static enum Logic {
        AND,
        OR,
        NOP;

    }

    public static enum Operation {
        ALL,
        ANY,
        NONE;

    }

    private class StageChangeListener
    implements FilterStageEditor.StageEditorListener {
        private StageChangeListener() {
        }

        @Override
        public void stageEditorChanged(Component src) {
            int stageIndex = -1;
            String action = "";
            int i = 0;
            while (i < FilterEditor.this.currentFilter.getNumFilterStages()) {
                if (src.equals(FilterEditor.this.currentFilter.getFilterStageActive(i).getFilterStageEditor().getAddBeforeButton())) {
                    stageIndex = i;
                    action = "before";
                    break;
                }
                if (src.equals(FilterEditor.this.currentFilter.getFilterStageActive(i).getFilterStageEditor().getAddAfterButton())) {
                    stageIndex = i;
                    action = "after";
                    break;
                }
                if (src.equals(FilterEditor.this.currentFilter.getFilterStageActive(i).getFilterStageEditor().getRemoveButton())) {
                    stageIndex = i;
                    action = "remove";
                    break;
                }
                if (src.equals(FilterEditor.this.currentFilter.getFilterStageActive(i).getFilterStageEditor().getAllButton())) {
                    stageIndex = i;
                    action = "logic";
                } else if (src.equals(FilterEditor.this.currentFilter.getFilterStageActive(i).getFilterStageEditor().getAnyButton())) {
                    stageIndex = i;
                    action = "logic";
                } else if (src.equals(FilterEditor.this.currentFilter.getFilterStageActive(i).getFilterStageEditor().getNoneButton())) {
                    stageIndex = i;
                    action = "logic";
                } else if (src.equals(FilterEditor.this.currentFilter.getFilterStageActive(i).getFilterStageEditor().getAndButton())) {
                    stageIndex = i;
                    action = "logic";
                } else if (src.equals(FilterEditor.this.currentFilter.getFilterStageActive(i).getFilterStageEditor().getOrButton())) {
                    stageIndex = i;
                    action = "logic";
                }
                ++i;
            }
            switch (action) {
                case "before": {
                    Logic l = Logic.AND;
                    if (stageIndex == 0) {
                        l = Logic.NOP;
                        FilterEditor.this.currentFilter.getFilterStageActive(stageIndex).setLogic(Logic.AND);
                        FilterEditor.this.currentFilter.getFilterStageActive(stageIndex).updateLogicButtons();
                    }
                    FilterEditor.this.currentFilter.addStageActive(stageIndex, FilterEditor.this.ourGUI, l, Operation.ANY, null, new StageChangeListener());
                    break;
                }
                case "after": {
                    FilterEditor.this.currentFilter.addStageActive(stageIndex + 1, FilterEditor.this.ourGUI, Logic.AND, Operation.ANY, null, new StageChangeListener());
                    break;
                }
                case "remove": {
                    FilterEditor.this.currentFilter.removeStage(stageIndex);
                    if (stageIndex != 0 || FilterEditor.this.currentFilter.getNumFilterStages() <= 0) break;
                    FilterEditor.this.currentFilter.getFilterStageActive(0).setLogic(Logic.NOP);
                    FilterEditor.this.currentFilter.getFilterStageActive(stageIndex).updateLogicButtons();
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(FilterEditor.this.filterEditorFrame, "Filter Editor: Before/After/Remove button not found");
                }
                case "logic": 
            }
            FilterEditor.this.changedLabel.setText(FilterEditor.this.changedText);
            FilterEditor.this.ourGUI.setFileSaved(false);
            FilterEditor.this.buttonSave.setEnabled(true);
            FilterEditor.this.rewriteStagesPanel();
            FilterEditor.this.filterEditorFrame.revalidate();
            FilterEditor.this.filterEditorFrame.repaint();
        }
    }
}

