/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.FileConverterException;
import culturalDynamics.LogScrollPane;
import culturalDynamics.Preferences;
import culturalDynamics.cdGUI;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.JFrame;

class FileConverter
extends JFrame {
    private static final long serialVersionUID = 1L;
    private String backupDirString;
    private Path backupDirPath;
    private String backupFileString;
    private File inFile;
    private Path inFilePath;
    private String inFileString;
    private String inFileDirString;
    private BufferedReader inReader;
    private int inFileVersion;
    private File tmpFile;
    private Path tmpFilePath;
    private int programFileVersion;
    private static BufferedWriter outBuffer = null;
    private Integer inLineNo = 0;
    private String sep = "|";
    private cdGUI ourGUI;
    private Preferences ourPrefs;
    private LogScrollPane loggingScrollPane;
    private int errorCount = 0;

    FileConverter(cdGUI mainGUI, String rootIn) throws FileConverterException {
        this.ourGUI = mainGUI;
        this.ourPrefs = this.ourGUI.getPreferences();
        this.inFileDirString = rootIn;
        this.loggingScrollPane = new LogScrollPane(this.ourGUI);
        this.loggingScrollPane.setVisible(true);
        this.loggingScrollPane.setSize(600, 600);
        try {
            this.programFileVersion = Integer.parseInt(this.ourGUI.getProgramMajorVersion());
        }
        catch (NumberFormatException e) {
            this.log(LogScrollPane.lineType.ERROR, "Error in program major version\n");
            throw new FileConverterException("Bad major version of program.");
        }
        String timestamp = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        this.backupDirPath = Paths.get(rootIn, "preConvert_" + timestamp);
        this.backupDirString = this.backupDirPath.toString();
        this.log(LogScrollPane.lineType.OK, "Creating backup directory " + this.backupDirString + ".\n");
        try {
            Files.createDirectory(this.backupDirPath, new FileAttribute[0]);
        }
        catch (IOException | UnsupportedOperationException e) {
            this.log(LogScrollPane.lineType.ERROR, "Could not create backup directory " + String.valueOf(this.backupDirPath) + " error: " + String.valueOf(e) + "\n");
            throw new FileConverterException("Error creating backup directory " + String.valueOf(e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean convertAFile(File inFileArg) {
        this.inFile = inFileArg;
        this.inFilePath = this.inFile.toPath();
        this.inFileString = this.inFile.getAbsolutePath();
        this.backupFileString = this.backupDirString + File.separator + String.valueOf(this.inFilePath.getFileName());
        Path backupFilePath = Paths.get(this.backupFileString, new String[0]);
        this.log(LogScrollPane.lineType.OK, "\n<br><br> Converting file " + this.inFileString + "\n");
        this.log(LogScrollPane.lineType.OK, "Copying file " + this.inFileString + " to " + this.backupFileString + "\n");
        try {
            Files.copy(this.inFilePath, backupFilePath, new CopyOption[0]);
        }
        catch (IOException | UnsupportedOperationException e) {
            this.log(LogScrollPane.lineType.ERROR, "Error copying input file " + this.inFile.getAbsolutePath() + " exception " + String.valueOf(e) + "\n");
            this.log(LogScrollPane.lineType.ERROR, "File not processed.\n");
            this.tidyUp();
            this.loggingScrollPane.endLog();
            return false;
        }
        this.log(LogScrollPane.lineType.OK, "Creating tmp file.\n");
        try {
            this.tmpFile = File.createTempFile("out", null, new File(this.inFileDirString));
            this.tmpFilePath = this.tmpFile.toPath();
            this.log(LogScrollPane.lineType.OK, "tmp file " + String.valueOf(this.tmpFile) + " created\n");
        }
        catch (IOException | IllegalArgumentException e) {
            this.log(LogScrollPane.lineType.ERROR, "Output File: IO Exception " + String.valueOf(e) + " creating tmp file for write \n");
            this.log(LogScrollPane.lineType.ERROR, "File not processed.\n");
            this.tidyUp();
            this.loggingScrollPane.endLog();
            return false;
        }
        this.log(LogScrollPane.lineType.OK, "Creating writer for tmp file " + String.valueOf(this.tmpFile) + "\n");
        try {
            BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.tmpFile), StandardCharsets.UTF_8));
            outBuffer = new BufferedWriter(outWriter);
        }
        catch (IOException e) {
            this.log(LogScrollPane.lineType.ERROR, "Output File: IO Exception opening file for write \n");
            this.log(LogScrollPane.lineType.ERROR, "File not processed.\n");
            this.tidyUp();
            this.loggingScrollPane.endLog();
            return false;
        }
        String inLine = " ";
        Object outLine = "";
        this.inLineNo = 0;
        this.errorCount = 0;
        this.log(LogScrollPane.lineType.OK, "Reading separator from " + this.inFile.getAbsolutePath() + "\n");
        try {
            this.inReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.inFile), "UTF8"));
            inLine = this.inReader.readLine();
            if (inLine == null || inLine.isEmpty() || inLine.length() != 10 || !inLine.startsWith("Separator")) {
                this.log(LogScrollPane.lineType.ERROR, "First line of input file must be Separator; or Separator, etc.\n");
                this.log(LogScrollPane.lineType.ERROR, "File not processed.\n");
                this.tidyUp();
                this.loggingScrollPane.endLog();
                return false;
            }
            this.sep = inLine.substring(9, 10);
            this.inLineNo = this.inLineNo + 1;
            this.log(LogScrollPane.lineType.OK, String.valueOf(this.inLineNo) + " " + inLine + "\n");
            if (!this.writeDataLine(inLine)) {
                this.log(LogScrollPane.lineType.ERROR, "Error writing Separator.\n");
                this.log(LogScrollPane.lineType.ERROR, "File not processed.\n");
                this.tidyUp();
                this.loggingScrollPane.endLog();
                return false;
            }
            this.log(LogScrollPane.lineType.OK, "Reading version from " + this.inFile.getAbsolutePath() + "\n");
            inLine = this.inReader.readLine();
            this.inLineNo = this.inLineNo + 1;
            if (inLine == null || inLine.isEmpty() || inLine.length() != 13 || !inLine.startsWith("// Version ")) {
                this.log(LogScrollPane.lineType.ERROR, "Second line must be Version.\n");
                this.log(LogScrollPane.lineType.ERROR, "File not processed.\n");
                this.tidyUp();
                this.loggingScrollPane.endLog();
                return false;
            }
            String inFileVersionString = inLine.substring(12, 13);
            try {
                this.inFileVersion = Integer.parseInt(inFileVersionString);
            }
            catch (NumberFormatException e) {
                this.log(LogScrollPane.lineType.ERROR, "Error in file version number\n");
                this.log(LogScrollPane.lineType.ERROR, "File not processed.\n");
                this.tidyUp();
                this.loggingScrollPane.endLog();
                return false;
            }
            this.log(LogScrollPane.lineType.OK, String.valueOf(this.inLineNo) + " " + inLine + "\n");
            outLine = "// Version " + this.ourGUI.getProgramMajorVersion();
            if (!this.writeDataLine((String)outLine)) {
                return false;
            }
            if (this.inFileVersion > this.programFileVersion) {
                this.log(LogScrollPane.lineType.ERROR, "File version " + inFileVersionString + "is higher that current program version" + this.ourGUI.getProgramMajorVersion() + "\n");
                this.log(LogScrollPane.lineType.ERROR, "File not processed.\n");
                this.tidyUp();
                this.loggingScrollPane.endLog();
                return false;
            }
            String tmpTimestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + " with " + this.ourGUI.getProgramName() + " version " + this.ourGUI.getProgramVersion();
            outLine = "// File converted from version " + this.inFileVersion + " at " + tmpTimestamp;
            if (!this.writeDataLine((String)outLine)) {
                this.tidyUp();
                this.loggingScrollPane.endLog();
                return false;
            }
            while ((inLine = this.inReader.readLine()) != null) {
                this.inLineNo = this.inLineNo + 1;
                String tmp = inLine;
                this.log(LogScrollPane.lineType.OK, String.valueOf(this.inLineNo) + " " + inLine + "\n");
                if (inLine.trim().length() > 0 && !tmp.trim().startsWith("//")) {
                    String cmd;
                    String[] parts = inLine.split(this.sep, -1);
                    if (parts.length < 2) {
                        this.log(LogScrollPane.lineType.ERROR, "No data in line " + this.inLineNo.toString() + "\n");
                        break;
                    }
                    block8 : switch (cmd = parts[0].toLowerCase(Locale.ENGLISH)) {
                        case "connect": {
                            if (parts.length != 18) {
                                this.log(LogScrollPane.lineType.ERROR, "connection line not of length 18.");
                                break;
                            }
                            outLine = parts[0];
                            outLine = (String)outLine + this.sep + parts[1];
                            int cNamePos = this.parseInteger(parts[3], "*** Invalid position value in line " + String.valueOf(this.inLineNo) + "\n");
                            switch (cNamePos) {
                                case 1: {
                                    outLine = (String)outLine + this.sep + "true" + this.sep + "false" + this.sep + "false" + this.sep + "false" + this.sep + "false" + this.sep + "false";
                                    break;
                                }
                                case 2: {
                                    outLine = (String)outLine + this.sep + "false" + this.sep + "true" + this.sep + "false" + this.sep + "false" + this.sep + "false" + this.sep + "false";
                                    break;
                                }
                                case 3: {
                                    outLine = (String)outLine + this.sep + "false" + this.sep + "false" + this.sep + "true" + this.sep + "false" + this.sep + "false" + this.sep + "false";
                                    break;
                                }
                                case 4: {
                                    outLine = (String)outLine + this.sep + "false" + this.sep + "false" + this.sep + "false" + this.sep + "true" + this.sep + "false" + this.sep + "false";
                                    break;
                                }
                                case 5: {
                                    outLine = (String)outLine + this.sep + "false" + this.sep + "false" + this.sep + "false" + this.sep + "false" + this.sep + "true" + this.sep + "false";
                                    break;
                                }
                                case 6: {
                                    outLine = (String)outLine + this.sep + "false" + this.sep + "false" + this.sep + "false" + this.sep + "false" + this.sep + "false" + this.sep + "true";
                                    break;
                                }
                                default: {
                                    this.log(LogScrollPane.lineType.ERROR, "Converter: Invalid Connection Name Position " + cNamePos);
                                }
                            }
                            int j = 4;
                            while (true) {
                                if (j >= 18) {
                                    this.log(LogScrollPane.lineType.CONVERTED, String.valueOf(this.inLineNo) + " " + (String)outLine + "\n");
                                    break block8;
                                }
                                outLine = (String)outLine + this.sep + parts[j];
                                ++j;
                            }
                        }
                        default: {
                            outLine = inLine;
                            break;
                        }
                    }
                } else {
                    outLine = inLine;
                }
                if (this.writeDataLine((String)outLine)) continue;
                this.tidyUp();
                return false;
            }
        }
        catch (IOException e) {
            this.log(LogScrollPane.lineType.ERROR, "Input File: IO Exception reading file: " + e.getMessage() + "\n");
            this.tidyUp();
            this.loggingScrollPane.endLog();
            return false;
        }
        this.tidyUp();
        this.log(LogScrollPane.lineType.OK, "Completed" + this.inFileString + " with " + this.errorCount + " errors.\n");
        if (!this.ourPrefs.getLogChoice() && this.errorCount == 0) {
            this.loggingScrollPane.dispose();
        }
        return true;
    }

    private void tidyUp() {
        try {
            this.log(LogScrollPane.lineType.OK, "Closing input Reader.\n");
            if (this.inReader != null) {
                this.inReader.close();
            }
        }
        catch (IOException f) {
            this.log(LogScrollPane.lineType.ERROR, "Input File: IO Exception closing input file\n");
        }
        this.log(LogScrollPane.lineType.OK, "Closing output Writer\n");
        if (outBuffer != null) {
            try {
                outBuffer.flush();
                outBuffer.close();
            }
            catch (IOException e) {
                this.log(LogScrollPane.lineType.ERROR, "Output File: IO Exception closing output file\n");
            }
        }
        this.log(LogScrollPane.lineType.OK, "Copying file " + this.backupFileString + " to " + this.inFileString + "\n");
        if (this.errorCount == 0) {
            try {
                Files.copy(this.tmpFilePath, this.inFilePath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException | UnsupportedOperationException e) {
                this.log(LogScrollPane.lineType.ERROR, "Error copying tmp file " + this.tmpFile.getAbsolutePath() + " to input file " + this.inFile.getAbsolutePath() + "exception" + String.valueOf(e) + "\n");
            }
        } else {
            this.log(LogScrollPane.lineType.ERROR, "Errors were found, original file unchanged.\n");
        }
        this.log(LogScrollPane.lineType.OK, "Deleting temporary file " + String.valueOf(this.tmpFilePath) + "\n");
        try {
            Files.deleteIfExists(this.tmpFilePath);
        }
        catch (IOException e) {
            this.log(LogScrollPane.lineType.ERROR, "Could not delete tmp file " + String.valueOf(this.tmpFilePath) + ".\n");
        }
    }

    private boolean writeDataLine(String line) {
        try {
            outBuffer.write(line + "\n");
        }
        catch (UnsupportedEncodingException e) {
            System.out.println(e.getMessage());
        }
        catch (IOException e) {
            this.log(LogScrollPane.lineType.ERROR, "Output File: IO Exception writing data file\n");
            this.loggingScrollPane.endLog();
            return false;
        }
        return true;
    }

    private int parseInteger(String in, String errorMsg) {
        try {
            return Integer.parseInt(in);
        }
        catch (NumberFormatException e) {
            this.log(LogScrollPane.lineType.ERROR, errorMsg);
            return 0;
        }
    }

    private void log(LogScrollPane.lineType error, String msg) {
        int newErrors = this.loggingScrollPane.logLine(error, msg);
        this.errorCount += newErrors;
    }

    public LogScrollPane getLogScrollPane() {
        return this.loggingScrollPane;
    }
}

