/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.Event;
import culturalDynamics.EventData;
import culturalDynamics.Filter;
import culturalDynamics.ReportSummary;
import culturalDynamics.SavedFilterData;
import culturalDynamics.TimePanel;
import culturalDynamics.Utils;
import culturalDynamics.cdGUI;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.json.JSONWriter;

class ExportHTML
extends JDialog {
    private static final long serialVersionUID = 1L;
    private cdGUI ourGUI;
    private JDialog exportFrame;
    private JLabel exportToLabel = new JLabel("Export to folder:");
    private JTextField exportFolderField = new JTextField(30);
    private JCheckBox subdirsBox = new JCheckBox("Subdirectory per File");
    private JLabel finalDirLabel = new JLabel("");
    private JLabel widthLabel = new JLabel("Width [pixels]");
    private JTextField widthField = new JTextField(10);
    private JButton browseButton = new JButton("Browse");
    private JButton exportButton = new JButton("Export");
    private JButton closeButton = new JButton("Close");
    private JLabel workingLabel = new JLabel(" ");
    private String exportTip = "Select the folder in which all the html files will be created.";
    private String browseTip = "Click this button to open a file browser to choose the export folder.";
    private String subdirsTip = "Check this box to create the files in a subdirectory with the same name as the currently open input file.";
    private String finalDirTip = "This shows the directory where the files will be saved depending on the Subdirectory checkbox.";
    private String widthTip = "Enter the width in pixels for the generated graphics.";
    private String closeTip = "This button will close the Export to HTML window. The entries will be remembered.";
    private String exportButtonTip = "Use this button to start the export.";
    private File finalFolder;
    private String outFolderPrimaryPath;
    private String outFolderPath;
    private BufferedWriter outBuffer = null;
    private BufferedWriter evBuffer = null;
    private int defaultWidth = 800;
    private int defaultHeight = 600;
    private int newWidth = 800;
    private int dpi = 1;
    private String htmlHeadings = "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n\t<meta charset=\"utf-8\" />\n\t\n<title>Cultural Dynamics</title>\n\t<style>\n\timg {\n\t  max-width: 100%;\n\t  height: auto;\n\t  resize: none;\n\t}\nbody {\n}\n.sidenav {\n  display: none;\n  height: 50vh;\n  width: auto;\n  padding: 1px 10px 1px 1px;\n  position: fixed;\n  z-index: 1;\n  left: 10px;\n  background-color: LightGrey;\n  overflow-x: hidden;\n  overflow-y: auto;\n}\n\n.sidenav a {\n  text-decoration: none;\n  color: Blue;\n  display: block;\n}\n\n.sidenav a:hover {\n  color: Orange;\n}\n\n.sidenav .closebtn {\n  position: absolute;\n  top: 0;\n  right: 25px;\n  font-size: 36px;\n  margin-left: 50px;\n}\n\t</style>\n\t<script language=\"javascript\">\n\t\t// Initialise the element IDs\n\t\tfunction init() {\n\t\t\tvar image = document.getElementById(\"image)\");\n\t\t\tvar title = document.getElementById(\"title\");\n\t\t}\n\n\t\t// Open the information window when event clicked\n\t\tfunction myPopup(url,windowname,w,h){\n\t\t\twindow.open(url,windowname,\"resizable=yes,toolbar=no,scrollbars=yes,menubar=no,status=no,directories=no, width=\"+w+\",height=\"+h+\",left=\"+window.event.clientX+\",top=\"+window.event.clientY+\"\");\n\t\t}\n\n\t\t// Replace the graphic when menu button clicked\n\t\tfunction replaceGraphic(url, text, map) {\n\t\t\timage.src = url;\n\t\t\timage.useMap = map;\n\t\t\tcloseNav();\n\t\t}\n\t\t// Initialise when document loaded\n\t\tdocument.addEventListener('readystatechange', function() {\n\t\t\tif (document.readyState === \"complete\") {\n\t\t\tinit();\n\t\t\t}\n\t\t});\n\t\tfunction openNav() {\n\t\t  document.getElementById(\"navigation\").style.display = \"block\";\n\t\t}\n\n\t\tfunction closeNav() {\n\t\t  document.getElementById(\"navigation\").style.display = \"none\";\n\t\t}\n\t</script>\n\t<script src=\"../scripts/imageMapResizer.js\"></script>\n</head>\n<body style=\"font-size:10pt;\">\n\n";
    private String popUpOnly = "<script>\n// Open the information window when event clicked\nfunction myPopup(url,windowname,w,h){\nwindow.open(url,windowname,\"resizable=yes,toolbar=no,scrollbars=yes,menubar=no,status=no,directories=no, width=\"+w+\",height=\"+h+\",left=\"+window.event.clientX+\",top=\"+window.event.clientY+\"\");\n}\n</script>\n";
    private String htmlNavStart = "\t<div style=\"font-size:30px;cursor:pointer\" onclick=\"openNav()\">&#9776;</div>\n\t<div id=\"navigation\" class = \"sidenav\">\n\t<nav>\n\t\t<span>Filters&nbsp&nbsp&nbsp&nbsp</span> <span style=\"font-size:15px;color:Red;cursor:pointer\" onclick=\"closeNav()\">&#10060</span>\n\t\t<ul id=\"menu\">\n";
    private String htmlNavEnd = "\t\t</ul>\n\t</nav>\n</div>\n";
    private String htmlEnd = "<script>imageMapResize();</script>\n</body>\n</html>\n\n";
    private String htmlMapEnd = "</map>\n";
    private String htmlEventFileStart = "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n\t<meta charset=\"utf-8\" />\n\n";
    private String htmlEventFileEnd = "</body>\n</html>\n";

    ExportHTML(cdGUI mainGUI) {
        this.ourGUI = mainGUI;
        this.exportFrame = this;
        this.outFolderPrimaryPath = System.getProperty("user.home");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                ExportHTML.this.setWorking(" ");
            }
        });
        FlowLayout flowLayoutRight = new FlowLayout(2);
        FlowLayout flowLayoutLeft = new FlowLayout(0);
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent b) {
                try {
                    JFileChooser outFileChooser = new JFileChooser(ExportHTML.this.outFolderPrimaryPath);
                    outFileChooser.setFileSelectionMode(1);
                    outFileChooser.setDialogTitle("Export HTML");
                    outFileChooser.setApproveButtonText("Choose");
                    int outfolderChoice = outFileChooser.showOpenDialog(ExportHTML.this.exportFrame);
                    if (outfolderChoice != 0) {
                        return;
                    }
                    ExportHTML.this.exportButton.setEnabled(true);
                    File chosenFolder = outFileChooser.getSelectedFile();
                    ExportHTML.this.outFolderPrimaryPath = chosenFolder.getAbsolutePath();
                    ExportHTML.this.makeFinalPath();
                    ExportHTML.this.ourGUI.setFileSaved(false);
                }
                catch (Throwable unforeseen) {
                    JOptionPane.showMessageDialog(ExportHTML.this.exportFrame, "Unhandled Error!\n" + ExportHTML.this.ourGUI.displayError(unforeseen));
                    ExportHTML.this.exportButton.setEnabled(false);
                }
            }
        });
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent s) {
                int newOverwriteSelection;
                try {
                    ExportHTML.this.newWidth = Integer.parseInt(ExportHTML.this.widthField.getText());
                }
                catch (NumberFormatException n) {
                    JOptionPane.showMessageDialog(ExportHTML.this.exportFrame, "Invalid number in width field.");
                    return;
                }
                ExportHTML.this.makeFinalPath();
                if (ExportHTML.this.subdirsBox.isSelected()) {
                    try {
                        Files.createDirectories(Paths.get(ExportHTML.this.outFolderPath, new String[0]), new FileAttribute[0]);
                    }
                    catch (IOException io) {
                        JOptionPane.showMessageDialog(ExportHTML.this.ourGUI, "Could not create subdirectory " + ExportHTML.this.outFolderPath + " error: " + io.getMessage());
                    }
                }
                if (ExportHTML.this.finalFolder == null || !ExportHTML.this.finalFolder.isDirectory()) {
                    JOptionPane.showMessageDialog(ExportHTML.this.ourGUI, "The chosen location " + String.valueOf(ExportHTML.this.finalFolder) + " is not a folder");
                    return;
                }
                if (ExportHTML.this.finalFolder.list().length != 0 && (newOverwriteSelection = JOptionPane.showConfirmDialog(ExportHTML.this.exportFrame, "The target directory is not empty! Proceed to overwrite existing files?", "Target directory", 0, 3)) == 1) {
                    return;
                }
                ExportHTML.this.setWorking("Exporting");
                ExportHTML.this.exportButton.setEnabled(false);
                ExportHTML.this.browseButton.setEnabled(false);
                ExportHTML.this.ourGUI.getTimePanel().setScreenEnabled(false);
                Thread exportHTMLThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ExportHTML.this.exportWork();
                    }
                });
                exportHTMLThread.start();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent s) {
                ExportHTML.this.setWorking(" ");
                ExportHTML.this.exportFrame.setVisible(false);
            }
        });
        this.exportToLabel.setToolTipText(this.exportTip);
        this.exportFolderField.setToolTipText(this.exportTip);
        this.finalDirLabel.setToolTipText(this.finalDirTip);
        this.browseButton.setToolTipText(this.browseTip);
        this.subdirsBox.setToolTipText(this.subdirsTip);
        this.widthField.setToolTipText(this.widthTip);
        this.closeButton.setToolTipText(this.closeTip);
        this.exportButton.setToolTipText(this.exportButtonTip);
        JPanel folderPanel = new JPanel(flowLayoutLeft);
        folderPanel.add(this.exportToLabel);
        folderPanel.add(this.exportFolderField);
        folderPanel.add(this.browseButton);
        this.subdirsBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportHTML.this.makeFinalPath();
                ExportHTML.this.ourGUI.setFileSaved(false);
            }
        });
        JPanel subdirsPanel = new JPanel(flowLayoutLeft);
        subdirsPanel.add(this.subdirsBox);
        subdirsPanel.add(this.finalDirLabel);
        this.widthField.setText(String.valueOf(this.defaultWidth));
        this.widthField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent f) {
                ExportHTML.this.widthField.selectAll();
            }

            @Override
            public void focusLost(FocusEvent f) {
                try {
                    ExportHTML.this.newWidth = Integer.parseInt(ExportHTML.this.widthField.getText());
                }
                catch (NumberFormatException n) {
                    JOptionPane.showMessageDialog(ExportHTML.this.exportFrame, "Invalid number in width field.");
                }
                ExportHTML.this.ourGUI.setFileSaved(false);
            }
        });
        JPanel widthPanel = new JPanel(flowLayoutLeft);
        widthPanel.add(this.widthLabel);
        widthPanel.add(this.widthField);
        JPanel buttonsPanel = new JPanel(flowLayoutRight);
        buttonsPanel.add(this.closeButton);
        buttonsPanel.add(this.exportButton);
        JPanel statusPanel = new JPanel(flowLayoutRight);
        statusPanel.add(this.workingLabel);
        Box exportPanel = Box.createVerticalBox();
        exportPanel.add(folderPanel);
        exportPanel.add(subdirsPanel);
        exportPanel.add(widthPanel);
        exportPanel.add(buttonsPanel);
        exportPanel.add(statusPanel);
        this.add(exportPanel);
        this.setTitle("Export to HTML");
        this.pack();
    }

    private void exportWork() {
        Object eventFileName;
        String scriptDir = this.outFolderPrimaryPath + File.separator + "scripts";
        File directory = new File(scriptDir);
        if (!directory.exists()) {
            directory.mkdir();
        }
        String jsPathString = scriptDir + File.separator + "imageMapResizer.js";
        Path jsPath = Paths.get(jsPathString, new String[0]);
        InputStream jsStream = this.getClass().getResourceAsStream("imageMapResizer.js");
        if (jsStream != null) {
            try {
                Files.copy(jsStream, jsPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException exc1) {
                JOptionPane.showMessageDialog(this.ourGUI, "Script file could not be written to " + jsPathString);
            }
        } else {
            JOptionPane.showMessageDialog(this.ourGUI, "Script file not found in jar file");
        }
        File saveFile = new File(this.outFolderPath, "index.html");
        try {
            saveFile.createNewFile();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.ourGUI, "Output File: IO Exception creating file" + saveFile.getAbsolutePath() + " for write. Error: " + ex.getMessage());
            this.finishedActions();
            return;
        }
        String path = saveFile.getAbsolutePath();
        try {
            BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), StandardCharsets.UTF_8));
            this.outBuffer = new BufferedWriter(outWriter);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.ourGUI, "Output File: IO Exception writing file" + path + " for write. Error: " + ex.getMessage());
            this.finishedActions();
            return;
        }
        Object navBuffer = this.htmlNavStart;
        Object mapBuffer = "";
        String introText = this.ourGUI.getIntroText();
        String introHTML = this.htmlEventFileStart + Utils.getHTMLstyles();
        if (!introText.isEmpty() && introText != "") {
            introHTML = introHTML + "<h1>Introduction</h1>\n";
            introHTML = introHTML + introText.replace("\\n", "<br>\n");
            introHTML = introHTML + this.htmlEventFileEnd;
            String introPath = "";
            try {
                File introFile = new File(this.outFolderPath, "introduction.html");
                introFile.createNewFile();
                introPath = introFile.getAbsolutePath();
                BufferedWriter introWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(introPath), StandardCharsets.UTF_8));
                BufferedWriter introBuffer = new BufferedWriter(introWriter);
                introBuffer.write(introHTML);
                introBuffer.flush();
                introBuffer.close();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.ourGUI, "Output File: IO Exception opening introduction file " + introPath + " for write " + ex.getMessage());
                return;
            }
            navBuffer = (String)navBuffer + "\t\t\t<li><a onclick=\"javascript:myPopup('./introduction.html', 'Introduction', '750', '450')\">Introdution</a></li>\n";
        }
        this.writeDataLine(this.htmlHeadings);
        this.writeDataLine("<h1>" + Utils.getFileWoExt(this.ourGUI.getOpenFile()) + "</h1>\n");
        String exportName = Utils.getFileWoExt(this.outFolderPrimaryPath);
        String fileName = this.outFolderPath + System.getProperty("file.separator") + exportName + ".jpg";
        File outFile = new File(fileName);
        this.setWorking("Exporting " + fileName);
        String originalFilterName = this.ourGUI.getFilterEditor().getActiveFilter().getName();
        this.ourGUI.getFilterEditor().setFilterOn(false);
        this.ourGUI.getFilterEditor().doFilter();
        this.ourGUI.setViewportTopLeft();
        TimePanel ourTimePanel = this.ourGUI.getTimePanel();
        ourTimePanel.export(0, false, false, this.dpi, this.newWidth, this.defaultHeight, this.ourGUI.getRangeStart(), this.ourGUI.getRangeDays(), outFile, "jpg", false);
        String mainImgLine = "<img src=\"./" + exportName + ".jpg\" usemap=\"#Mainmap\" id=\"image\" border=\"1\">\n";
        Object mapName = "#Mainmap";
        navBuffer = (String)navBuffer + "\t\t\t<li><a onclick=\"replaceGraphic('./" + exportName + ".jpg', 'This is the main image', '" + (String)mapName + "')\">No Filters</a></li>\n";
        mapBuffer = (String)mapBuffer + "<map name = \"#Mainmap\">\n";
        EventData ourEvents = this.ourGUI.getInput().getEventData();
        int i = 0;
        while (i < ourEvents.getTotalNumberOfEvents()) {
            Event ev = ourEvents.getEventByIndex(i);
            String eventName = Utils.correctFilename(ev.getName());
            String eventFileName2 = eventName + ".html";
            this.setWorking("Exporting " + eventFileName2);
            String x1 = String.valueOf(ev.getNameBounds().getX());
            String y1 = String.valueOf(ev.getNameBounds().getY());
            String x2 = String.valueOf(ev.getNameBounds().getX() + ev.getNameBounds().getWidth());
            String y2 = String.valueOf(ev.getNameBounds().getY() + ev.getNameBounds().getHeight());
            String boundaries = "\"" + x1 + "," + y1 + "," + x2 + "," + y2 + "\"";
            mapBuffer = (String)mapBuffer + "<area shape=\"rect\"  href=\"#\" coords=" + boundaries + " onclick=\"javascript:myPopup('./" + eventFileName2 + "', '" + ev.getName() + "', '750', '450')\">\n";
            try {
                File eventFile = new File(this.outFolderPath, eventFileName2);
                eventFile.createNewFile();
                String eventPath = eventFile.getAbsolutePath();
                try {
                    BufferedWriter evWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(eventPath), StandardCharsets.UTF_8));
                    this.evBuffer = new BufferedWriter(evWriter);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this.ourGUI, "Output File: IO Exception opening event file " + eventPath + " for write " + ex.getMessage());
                    this.finishedActions();
                    return;
                }
                String filebuffer = this.htmlEventFileStart + Utils.getHTMLstyles() + this.popUpOnly;
                filebuffer = filebuffer + "\n<title>" + ev.getName() + "</title>\n";
                filebuffer = filebuffer + "</head>\n<body style=\"font-size:10pt;\">\n";
                filebuffer = filebuffer + ev.getEventHTMLSummary(this.ourGUI);
                filebuffer = filebuffer + this.htmlEventFileEnd;
                this.evBuffer.write(filebuffer);
                this.evBuffer.flush();
                this.evBuffer.close();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.ourGUI, "Output File: IO Exception opening file " + eventFileName2 + " for write " + ex.getMessage());
                this.finishedActions();
                return;
            }
            ++i;
        }
        SavedFilterData filters = this.ourGUI.getSavedFilterData();
        int i2 = 0;
        while (i2 < filters.getNumFilters()) {
            Filter tmpFilter = filters.getSavedFilterByIndex(i2);
            this.ourGUI.getFilterEditor().applyGivenFilter(tmpFilter);
            String filterFileName = tmpFilter.getName();
            String outFilePath = this.outFolderPath + System.getProperty("file.separator") + filterFileName + ".jpg";
            outFile = new File(outFilePath);
            this.setWorking("Exporting " + outFilePath);
            ourTimePanel.export(0, false, true, this.dpi, this.newWidth, this.defaultHeight, this.ourGUI.getRangeStart(), this.ourGUI.getRangeDays(), outFile, "jpg", false);
            String graphicText = "This is filter " + tmpFilter.getName() + ".";
            mapName = "#" + filterFileName + "map";
            navBuffer = (String)navBuffer + "\t\t\t<li><a onclick=\"replaceGraphic('./" + filterFileName + ".jpg', '" + graphicText + "', '" + (String)mapName + "')\">" + tmpFilter.getName() + "</a></li>\n";
            ourEvents = this.ourGUI.getInput().getEventData();
            mapBuffer = (String)mapBuffer + "<map name = \"" + filterFileName + "map\">\n";
            int j = 0;
            while (j < ourEvents.getTotalNumberOfEvents()) {
                Event ev = ourEvents.getEventByIndex(j);
                if (ev.isShown()) {
                    String eventName = Utils.correctFilename(ev.getName());
                    eventFileName = eventName + ".html";
                    String x1 = String.valueOf(ev.getNameBounds().getX());
                    String y1 = String.valueOf(ev.getNameBounds().getY());
                    String x2 = String.valueOf(ev.getNameBounds().getX() + ev.getNameBounds().getWidth());
                    String y2 = String.valueOf(ev.getNameBounds().getY() + ev.getNameBounds().getHeight());
                    String boundaries = "\"" + x1 + "," + y1 + "," + x2 + "," + y2 + "\"";
                    mapBuffer = (String)mapBuffer + "<area shape=\"rect\"  href=\"#\" coords=" + boundaries + " onclick=\"javascript:myPopup('./" + (String)eventFileName + "', '" + ev.getName() + "', '750', '450')\">\n";
                }
                ++j;
            }
            mapBuffer = (String)mapBuffer + this.htmlMapEnd;
            ++i2;
        }
        this.ourGUI.getFilterEditor().setFilterOn(false);
        this.ourGUI.getFilterEditor().doFilter();
        ReportSummary summaryWindow = new ReportSummary(this.ourGUI);
        String summaryHTML = summaryWindow.getSummaryHTML();
        summaryWindow.dispose();
        if (!summaryHTML.isEmpty() && summaryHTML != "") {
            this.setWorking("Exporting Summary");
            String summaryPath = "";
            try {
                File summaryFile = new File(this.outFolderPath, "summary.html");
                summaryFile.createNewFile();
                summaryPath = summaryFile.getAbsolutePath();
                BufferedWriter summaryWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(summaryPath), StandardCharsets.UTF_8));
                BufferedWriter summaryBuffer = new BufferedWriter(summaryWriter);
                summaryBuffer.write(summaryHTML);
                summaryBuffer.flush();
                summaryBuffer.close();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.ourGUI, "Output File: IO Exception opening summary file " + summaryPath + " for write " + ex.getMessage());
                return;
            }
            navBuffer = (String)navBuffer + "\t\t\t<li><a onclick=\"javascript:myPopup('./summary.html', 'Summary', '750', '450')\">Summary Report</a></li>\n";
        }
        navBuffer = (String)navBuffer + this.htmlNavEnd;
        this.writeDataLine((String)navBuffer);
        this.writeDataLine(mainImgLine);
        this.writeDataLine((String)mapBuffer);
        this.writeDataLine(this.htmlEnd);
        if (this.subdirsBox.isSelected()) {
            String[] files;
            this.setWorking("Exporting Table of Contents");
            String toc = this.htmlEventFileStart + Utils.getHTMLstyles();
            toc = toc + "<ul>\n";
            File root = new File(this.outFolderPrimaryPath);
            eventFileName = files = root.list();
            int eventName = files.length;
            int ev = 0;
            while (ev < eventName) {
                String file = eventFileName[ev];
                if (new File(this.outFolderPrimaryPath + File.separator + file).isDirectory() && !file.equals("scripts") && !file.equals("web_images")) {
                    toc = toc + "<li><a href=\"./" + file + "/index.html\">" + file + "</a>\n";
                }
                ++ev;
            }
            toc = toc + "</ul>";
            toc = toc + this.htmlEventFileEnd;
            String tocPath = "";
            try {
                File tocFile = new File(this.outFolderPrimaryPath, "index.html");
                tocFile.createNewFile();
                tocPath = tocFile.getAbsolutePath();
                BufferedWriter tocWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tocPath), StandardCharsets.UTF_8));
                BufferedWriter tocBuffer = new BufferedWriter(tocWriter);
                tocBuffer.write(toc);
                tocBuffer.flush();
                tocBuffer.close();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.ourGUI, "Output File: IO Exception opening summary file " + tocPath + " for write " + ex.getMessage());
                return;
            }
            navBuffer = (String)navBuffer + "\t\t\t<li><a onclick=\"javascript:myPopup('./summary.html', 'Summary', '750', '450')\">Summary Report</a></li>\n";
        }
        if (originalFilterName != null) {
            this.ourGUI.getFilterEditor().applyGivenFilter(this.ourGUI.getSavedFilterData().getSavedFilterByName(originalFilterName));
        } else {
            this.ourGUI.getFilterEditor().applyGivenFilter(null);
        }
        this.setWorking("Export complete.");
        this.finishedActions();
        try {
            this.outBuffer.flush();
            this.outBuffer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void makeFinalPath() {
        this.outFolderPath = this.subdirsBox.isSelected() ? this.outFolderPrimaryPath + System.getProperty("file.separator") + Utils.getFileWoExt(this.ourGUI.getOpenFile()) : this.outFolderPrimaryPath;
        this.finalFolder = new File(this.outFolderPath);
        this.finalDirLabel.setText(this.outFolderPath);
        this.exportFolderField.setText(this.outFolderPrimaryPath);
    }

    private boolean writeDataLine(String line) {
        try {
            this.outBuffer.write(line);
        }
        catch (UnsupportedEncodingException e) {
            System.out.println(e.getMessage());
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.ourGUI, "HTML output File: IO Exception writing data file " + e.getMessage());
            return false;
        }
        return true;
    }

    private void setWorking(String status) {
        this.workingLabel.setText(status);
        this.workingLabel.revalidate();
        this.workingLabel.repaint();
        this.exportFrame.revalidate();
        this.exportFrame.repaint();
    }

    private void finishedActions() {
        this.exportButton.setEnabled(true);
        this.browseButton.setEnabled(true);
        this.ourGUI.getTimePanel().setScreenEnabled(true);
        this.ourGUI.getTimePanel().repaint();
    }

    public void setHTMLPrimaryPath(String p) {
        this.outFolderPrimaryPath = p;
        this.makeFinalPath();
        this.revalidate();
        this.repaint();
    }

    public String getHTMLPrimaryPathString() {
        return this.outFolderPrimaryPath;
    }

    public void setHTMLSubdirs(boolean s) {
        this.subdirsBox.setSelected(s);
        this.makeFinalPath();
    }

    public boolean getHTMLSubdirs() {
        return this.subdirsBox.isSelected();
    }

    public void setHTMLWidth(int w) {
        this.newWidth = w;
        this.widthField.setText(String.valueOf(w));
    }

    public int getHTMLWidth() {
        return this.newWidth;
    }

    public void toJSON(JSONWriter writer) {
        writer.key("exportHTML").object().key("folder").value(this.ourGUI.getHTMLDialog().getHTMLPrimaryPathString()).key("subdirs").value(this.ourGUI.getHTMLDialog().getHTMLSubdirs()).key("width").value(this.ourGUI.getHTMLDialog().getHTMLWidth()).endObject();
    }
}

