/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CommonData;
import culturalDynamics.DateAndWidth;
import culturalDynamics.Event;
import culturalDynamics.Utils;
import culturalDynamics.cdGUI;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.json.JSONWriter;

class EventData {
    private List<Event> allEvents = new ArrayList<Event>();
    private static String compErr1;
    private static String compErr2;

    public void addEvent(Event event) {
        this.allEvents.add(event);
    }

    public int getTotalNumberOfEvents() {
        if (this.allEvents == null) {
            return 0;
        }
        return this.allEvents.size();
    }

    public int getNumberOfEventsOnly() {
        int number = 0;
        if (this.allEvents == null) {
            return 0;
        }
        for (Event event : this.allEvents) {
            if (!event.getEventType().equals((Object)CommonData.EventType.GENERAL_EVENT) && !event.getEventType().equals((Object)CommonData.EventType.TIMELINE_EVENT)) continue;
            ++number;
        }
        return number;
    }

    public int getNumberOfTimelines() {
        int number = 0;
        if (this.allEvents == null) {
            return 0;
        }
        for (Event event : this.allEvents) {
            if (!event.getEventType().equals((Object)CommonData.EventType.TIMELINE)) continue;
            ++number;
        }
        return number;
    }

    public int getNumberOfUntimed() {
        int number = 0;
        if (this.allEvents == null) {
            return 0;
        }
        for (Event event : this.allEvents) {
            if (!event.getEventType().equals((Object)CommonData.EventType.UNTIMED)) continue;
            ++number;
        }
        return number;
    }

    public List<Event> getListOfEventsOnly(boolean sort) {
        ArrayList<Event> result = new ArrayList<Event>();
        for (Event event : this.allEvents) {
            if (!event.getEventType().equals((Object)CommonData.EventType.GENERAL_EVENT) && !event.getEventType().equals((Object)CommonData.EventType.TIMELINE_EVENT)) continue;
            result.add(event);
        }
        if (sort) {
            EventData.sortEventsByName(result);
        }
        return result;
    }

    public List<Event> getListOfAllEvents(boolean sort) {
        if (sort) {
            EventData.sortEventsByName(this.allEvents);
        }
        return this.allEvents;
    }

    public List<Event> getListOfTimelines(boolean sort) {
        ArrayList<Event> result = new ArrayList<Event>();
        for (Event event : this.allEvents) {
            if (!event.getEventType().equals((Object)CommonData.EventType.TIMELINE)) continue;
            result.add(event);
        }
        if (sort) {
            EventData.sortEventsByName(result);
        }
        return result;
    }

    public List<Event> getListOfUntimedEvents(boolean sort) {
        ArrayList<Event> result = new ArrayList<Event>();
        for (Event event : this.allEvents) {
            if (!event.getEventType().equals((Object)CommonData.EventType.UNTIMED)) continue;
            result.add(event);
        }
        if (sort) {
            EventData.sortEventsByName(result);
        }
        return result;
    }

    public List<Event> getListOfShownUntimedEvents(boolean sort) {
        ArrayList<Event> result = new ArrayList<Event>();
        for (Event event : this.allEvents) {
            if (!event.getEventType().equals((Object)CommonData.EventType.UNTIMED) || !event.isShown()) continue;
            result.add(event);
        }
        if (sort) {
            EventData.sortEventsByName(result);
        }
        return result;
    }

    public Event getEventByIndex(int i) {
        return this.allEvents.get(i);
    }

    public Event getEventByName(String name) {
        for (Event event : this.allEvents) {
            if (!event.getName().equals(name)) continue;
            return event;
        }
        return null;
    }

    public static void sortEventsBySequence(List<Event> events) {
        if (events != null && events.size() != 0) {
            events.sort(new SeqSorter());
        }
    }

    private static void sortEventsByName(List<Event> events) {
        if (events != null && events.size() != 0) {
            events.sort(new NameSorter());
        }
    }

    public void sortEventsByStart() {
        if (this.allEvents != null && this.allEvents.size() != 0) {
            try {
                this.allEvents.sort(new StartSorter());
            }
            catch (Exception e) {
                System.out.println("Exception " + e.toString() + "in sorting events by start 1:" + compErr1 + " 2:" + compErr2);
            }
        }
    }

    public DateAndWidth getEarliestStartDate() {
        LocalDate defaultStartDate = Utils.minDate;
        LocalDate minimumStartDate = Utils.maxDate;
        int textWidth = 0;
        int w = 0;
        if (this.allEvents == null || this.allEvents.size() == 0) {
            return new DateAndWidth(defaultStartDate, w);
        }
        for (Event event : this.allEvents) {
            if (!event.isShown() || event.getEventType() == CommonData.EventType.UNTIMED) continue;
            if (event.getDates().getEarlyStartDate().isBefore(minimumStartDate)) {
                minimumStartDate = event.getDates().getEarlyStartDate();
                if (event.getIcon() != null) {
                    w = event.getIcon().getIconWidth() / 2;
                }
                if ((event.getEventType() == CommonData.EventType.GENERAL_EVENT || event.getEventType() == CommonData.EventType.TIMELINE_EVENT) && event.getNameBounds() != null) {
                    textWidth = (int)event.getNameBounds().getWidth();
                }
                w = Math.max(w, textWidth / 2);
                w += 5;
            }
            if (!event.getEventType().equals((Object)CommonData.EventType.TIMELINE) || !event.isShown() || event.getTlSegmentList() == null) continue;
            LocalDate earliestSegment = event.getTlSegmentList().getEarliestStartDate();
            if (minimumStartDate == null || earliestSegment == null || !earliestSegment.isBefore(minimumStartDate)) continue;
            minimumStartDate = earliestSegment;
        }
        DateAndWidth result = new DateAndWidth(minimumStartDate, w);
        return result;
    }

    public DateAndWidth getLatestEndDateWidth() {
        LocalDate defaultEndDate = Utils.maxDate;
        LocalDate maximumEndDate = Utils.minDate;
        int textWidth = 0;
        int w = 0;
        if (this.allEvents == null || this.allEvents.size() == 0) {
            return new DateAndWidth(defaultEndDate, w);
        }
        for (Event event : this.allEvents) {
            LocalDate latestSegment;
            if (!event.isShown() || event.getEventType() == CommonData.EventType.UNTIMED) continue;
            if (event.getDates().getRealEndDate().isAfter(maximumEndDate)) {
                maximumEndDate = event.getDates().getRealEndDate();
                if (event.getEventType() == CommonData.EventType.TIMELINE && event.getEndIcon() != null) {
                    w = event.getEndIcon().getIconWidth();
                } else if ((event.getEventType() == CommonData.EventType.GENERAL_EVENT || event.getEventType() == CommonData.EventType.TIMELINE_EVENT) && event.getIcon() != null) {
                    w = event.getIcon().getIconWidth();
                }
                if ((event.getEventType() == CommonData.EventType.GENERAL_EVENT || event.getEventType() == CommonData.EventType.TIMELINE_EVENT) && event.getNameBounds() != null) {
                    textWidth = (int)event.getNameBounds().getWidth();
                }
                w = Math.max(w, textWidth);
                w += 5;
            }
            if (!event.getEventType().equals((Object)CommonData.EventType.TIMELINE) || event.getTlSegmentList() == null || (latestSegment = event.getTlSegmentList().getLatestEndDate()) == null || !latestSegment.isAfter(maximumEndDate)) continue;
            maximumEndDate = latestSegment;
        }
        DateAndWidth result = new DateAndWidth(maximumEndDate, w);
        return result;
    }

    public Boolean deleteEvent(Event ev) {
        return this.allEvents.remove(ev);
    }

    public void writeEventsToJSON(JSONWriter writer, cdGUI mainGUI) {
        List<Event> events = this.getListOfAllEvents(false);
        if (events == null || events.size() == 0) {
            return;
        }
        writer.key("events").array();
        int i = 0;
        while (i < events.size()) {
            Event ev = events.get(i);
            ev.toJSON(writer, mainGUI);
            ++i;
        }
        writer.endArray();
    }

    private static class NameSorter
    implements Comparator<Event> {
        private NameSorter() {
        }

        @Override
        public int compare(Event o1, Event o2) {
            int tmp = o1.getName().compareToIgnoreCase(o2.getName());
            return tmp;
        }
    }

    private static class SeqSorter
    implements Comparator<Event> {
        private SeqSorter() {
        }

        @Override
        public int compare(Event o1, Event o2) {
            int tmp = o1.getSequenceNo() - o2.getSequenceNo();
            return tmp;
        }
    }

    private static class StartSorter
    implements Comparator<Event> {
        private StartSorter() {
        }

        @Override
        public int compare(Event o1, Event o2) {
            compErr1 = o1.getName();
            compErr2 = o2.getName();
            if (o1.getEventType().equals((Object)CommonData.EventType.UNTIMED) && o2.getEventType().equals((Object)CommonData.EventType.UNTIMED)) {
                return 0;
            }
            if (o1.getEventType().equals((Object)CommonData.EventType.UNTIMED)) {
                return -1;
            }
            if (o2.getEventType().equals((Object)CommonData.EventType.UNTIMED)) {
                return 1;
            }
            return o1.getDates().getEarlyStartDate().compareTo(o2.getDates().getEarlyStartDate());
        }
    }
}

