/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CommonData;
import culturalDynamics.Dates;
import culturalDynamics.Event;
import culturalDynamics.Utils;
import culturalDynamics.cdGUI;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.time.LocalDate;
import org.json.JSONWriter;

class Connection
extends CommonData {
    private Event cSrcEvent;
    private Event cDstEvent;
    private String index;
    private Dates dates;
    private LineType cLineType;
    private DashType cDashType;
    private boolean cArrowForward;
    private boolean cArrowBack;
    private boolean cCurve;
    private Double cBezCtrlX;
    private Double cBezCtrlY;
    private boolean cShowAtSrc;
    private Point2D.Double posNameSource;
    private boolean cShowAtDst;
    private Point2D.Double posNameDestination;
    private Path2D clickPath;
    private Rectangle2D boundsNameSource;
    private Rectangle2D boundsNameDestination;
    private boolean srcNameSelected;
    private boolean dstNameSelected;

    Connection(String index, String name, String color, Event source, LocalDate srcEarlyDate, LocalDate srcLateDate, Event dest, LocalDate dstEarlyDate, LocalDate dstLateDate, LineType linetype, DashType dashtype, boolean arrowForward, boolean arrowBack, boolean curve, Double CtrlX, Double CtrlY, boolean showAtSrc, Point2D.Double posSrc, boolean showAtDst, Point2D.Double posDst) {
        super(name, color);
        this.index = index;
        this.cSrcEvent = source;
        this.cDstEvent = dest;
        this.dates = new Dates(srcEarlyDate, srcLateDate, dstEarlyDate, dstLateDate);
        this.cLineType = linetype;
        this.cDashType = dashtype;
        this.cArrowForward = arrowForward;
        this.cArrowBack = arrowBack;
        this.cCurve = curve;
        this.cBezCtrlX = CtrlX;
        this.cBezCtrlY = CtrlY;
        this.cShowAtSrc = showAtSrc;
        this.posNameSource = posSrc;
        this.cShowAtDst = showAtDst;
        this.posNameDestination = posDst;
    }

    public Event getSourceEvent() {
        return this.cSrcEvent;
    }

    public void setSourceEvent(Event sourceEvent) {
        this.cSrcEvent = sourceEvent;
    }

    public int getSourceTimelinePoint() {
        if (this.dates.getSrcEarlyDate() != null) {
            return 1;
        }
        return 0;
    }

    public int getDestTimelinePoint() {
        if (this.dates.getDstEarlyDate() != null) {
            return 1;
        }
        return 0;
    }

    public Event getDestEvent() {
        return this.cDstEvent;
    }

    public void setDestEvent(Event destEvent) {
        this.cDstEvent = destEvent;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public Dates getDates() {
        return this.dates;
    }

    public String getID() {
        return this.cSrcEvent.getName() + "-" + this.cDstEvent.getName() + "-" + this.getIndex();
    }

    public String getNiceID() {
        return Utils.flatline(this.cSrcEvent.getName() + " -> " + this.cDstEvent.getName() + " :" + this.getIndex());
    }

    public static String makeID(String src, String idx, String dst) {
        return src + "-" + dst + "-" + idx;
    }

    public LineType getLineType() {
        return this.cLineType;
    }

    public void setLineType(LineType lineType2) {
        this.cLineType = lineType2;
    }

    public DashType getDashType() {
        return this.cDashType;
    }

    public void setDashType(DashType dashType) {
        this.cDashType = dashType;
    }

    public boolean getArrowForward() {
        return this.cArrowForward;
    }

    public void setArrowForward(boolean arrowForward) {
        this.cArrowForward = arrowForward;
    }

    public boolean getArrowBack() {
        return this.cArrowBack;
    }

    public void setArrowBack(boolean arrowBack) {
        this.cArrowBack = arrowBack;
    }

    public boolean getCurve() {
        return this.cCurve;
    }

    public void setCurve(boolean curve) {
        this.cCurve = curve;
    }

    public Double getBezCtrlX() {
        return this.cBezCtrlX;
    }

    public void setBezCtrlX(Double bezCtrlX) {
        this.cBezCtrlX = bezCtrlX;
    }

    public Double getBezCtrlY() {
        return this.cBezCtrlY;
    }

    public void setBezCtrlY(Double bezCtrlY) {
        this.cBezCtrlY = bezCtrlY;
    }

    public Path2D getClickPath() {
        return this.clickPath;
    }

    public void setClickPath(Path2D path) {
        this.clickPath = path;
    }

    public boolean isClickedConnection(double mouseX, double mouseY) {
        double mouseW = 5.0;
        Rectangle2D.Double mouseR = new Rectangle2D.Double(mouseX - mouseW / 2.0, mouseY - mouseW / 2.0, mouseW, mouseW);
        return this.getClickPath() != null && this.getClickPath().intersects(mouseR);
    }

    public boolean isClickedSrcName(double mouseX, double mouseY) {
        double mouseW = 5.0;
        Rectangle2D.Double mouseR = new Rectangle2D.Double(mouseX - mouseW / 2.0, mouseY - mouseW / 2.0, mouseW, mouseW);
        return this.getBoundsNameSource() != null && this.getBoundsNameSource().intersects(mouseR);
    }

    public boolean isClickedDstName(double mouseX, double mouseY) {
        double mouseW = 5.0;
        Rectangle2D.Double mouseR = new Rectangle2D.Double(mouseX - mouseW / 2.0, mouseY - mouseW / 2.0, mouseW, mouseW);
        return this.getBoundsNameDestination() != null && this.getBoundsNameDestination().intersects(mouseR);
    }

    public String getSrcEvTlName() {
        return this.cSrcEvent.getName();
    }

    public String getDstEvTlName() {
        return this.cDstEvent.getName();
    }

    public boolean getShowAtSrc() {
        return this.cShowAtSrc;
    }

    public void setShowAtSrc(boolean cShowAtSrc) {
        this.cShowAtSrc = cShowAtSrc;
    }

    public Point2D.Double getPosNameSource() {
        return this.posNameSource;
    }

    public void setPosNameSource(Point2D.Double posNameSource) {
        this.posNameSource = posNameSource;
    }

    public Rectangle2D getBoundsNameSource() {
        return this.boundsNameSource;
    }

    public void setBoundsNameSource(Rectangle2D boundsNameSource) {
        this.boundsNameSource = boundsNameSource;
    }

    public boolean getShowAtDst() {
        return this.cShowAtDst;
    }

    public void setShowAtDst(boolean cShowAtDst) {
        this.cShowAtDst = cShowAtDst;
    }

    public Point2D.Double getPosNameDestination() {
        return this.posNameDestination;
    }

    public void setPosNameDestination(Point2D.Double posNameDestination) {
        this.posNameDestination = posNameDestination;
    }

    public Rectangle2D getBoundsNameDestination() {
        return this.boundsNameDestination;
    }

    public void setBoundsNameDestination(Rectangle2D boundsNameDestination) {
        this.boundsNameDestination = boundsNameDestination;
    }

    public void setSrcNameSelected(boolean n) {
        this.srcNameSelected = n;
    }

    public boolean getSrcNameSelected() {
        return this.srcNameSelected;
    }

    public void setDstNameSelected(boolean n) {
        this.dstNameSelected = n;
    }

    public boolean getDstNameSelected() {
        return this.dstNameSelected;
    }

    public void toJSON(JSONWriter writer, cdGUI mainGUI) {
        writer.object().key("index").value(this.getIndex()).key("name").value(this.getName()).key("colour").value(this.getColor()).key("sourceEvent").value(this.getSourceEvent().getName());
        if (this.getDates().getSrcEarlyDate() != null) {
            writer.key("sourceEarlyDate").value(Utils.dayFormatterOut.format(this.getDates().getSrcEarlyDate()));
        }
        if (this.getDates().getSrcLateDate() != null) {
            writer.key("sourceLateDate").value(Utils.dayFormatterOut.format(this.getDates().getSrcLateDate()));
        }
        writer.key("destinationEvent").value(this.getDestEvent().getName());
        if (this.getDates().getDstEarlyDate() != null) {
            writer.key("destinationEarlyDate").value(Utils.dayFormatterOut.format(this.getDates().getDstEarlyDate()));
        }
        if (this.getDates().getDstLateDate() != null) {
            writer.key("destinationLateDate").value(Utils.dayFormatterOut.format(this.getDates().getDstLateDate()));
        }
        writer.key("lineType").value((Object)this.getLineType()).key("dashType").value((Object)this.getDashType()).key("arrowForward").value(this.getArrowForward()).key("arrowBack").value(this.getArrowBack()).key("curve").value(this.getCurve()).key("bezierCtrlX").value(this.getBezCtrlX()).key("bezierCtrlY").value(this.getBezCtrlY()).key("showAtSource").value(this.getShowAtSrc()).key("srcPosX").value(this.getPosNameSource().getX()).key("srcPosY").value(this.getPosNameSource().getY()).key("showAtDestination").value(this.getShowAtDst()).key("dstPosX").value(this.getPosNameDestination().getX()).key("dstPosY").value(this.getPosNameDestination().getY());
        this.metaDataToJSON(writer, mainGUI);
        writer.endObject();
    }

    static enum DashType {
        PLAIN,
        DOT,
        DASH,
        DOT_DASH;

    }

    static enum LineType {
        DIRECT,
        WAVY,
        HELIX;

    }
}

